/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog.query;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDocumentation;
import thredds.catalog.ServiceType;
import thredds.catalog.query.Choice;
import thredds.catalog.query.DqcFactory;
import thredds.catalog.query.ListChoice;
import thredds.catalog.query.Location;
import thredds.catalog.query.QueryCapability;
import thredds.catalog.query.SelectGeoRegion;
import thredds.catalog.query.SelectList;
import thredds.catalog.query.SelectRange;
import thredds.catalog.query.SelectRangeDate;
import thredds.catalog.query.SelectService;
import thredds.catalog.query.SelectStation;
import thredds.catalog.query.Selector;
import thredds.catalog.query.Station;
import thredds.ui.catalog.CatalogChooser;
import ucar.nc2.ui.point.StationRegionDateChooser;
import ucar.nc2.ui.widget.RangeDateSelector;
import ucar.nc2.ui.widget.RangeSelector;
import ucar.nc2.units.DateRange;
import ucar.nc2.util.IO;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.Format;
import ucar.util.prefs.PersistenceManager;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.ComboBox;
import ucar.util.prefs.ui.Debug;

public class QueryChooser
extends JPanel {
    private static final String HDIVIDER = "HSplit_Divider";
    private PreferencesExt prefs;
    private DqcFactory dqcFactory = new DqcFactory(true);
    private StationRegionDateChooser mapChooser = null;
    private JPanel innerPanel;
    private JPanel buttPanel;
    private JLabel status;
    private CatalogChooser cc;
    private JSplitPane split;
    private ComboBox comboBox = null;
    private ArrayList mapSelectors;
    private ArrayList smallSelectors;
    private ArrayList bigSelectors;
    private EventListenerList listenerList = new EventListenerList();
    private QueryCapability qc;
    private ArrayList choosers = new ArrayList();
    private boolean returnsCatalog = true;
    private ArrayList extraButtons = new ArrayList();
    private boolean debugLayout = false;
    private boolean debugNested = false;

    public QueryChooser(PreferencesExt prefs, boolean showCombo) {
        this.prefs = prefs;
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.innerPanel, "Center");
        if (showCombo) {
            this.comboBox = new ComboBox((PersistenceManager)prefs);
            JButton connectButton = new JButton("Connect");
            connectButton.setToolTipText("connect to this DQC");
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.add((Component)new JLabel("DQC URL:"), "West");
            topPanel.add((Component)this.comboBox, "Center");
            topPanel.add((Component)connectButton, "East");
            this.add((Component)topPanel, "North");
            connectButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent evt) {
                    QueryChooser.this.setCursor(Cursor.getPredefinedCursor(3));
                    String name = (String)QueryChooser.this.comboBox.getSelectedItem();
                    try {
                        QueryChooser.this.setDqcUrl(name);
                        QueryChooser.this.addToCB(name);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        QueryChooser.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
        }
        PreferencesExt node = prefs == null ? null : (PreferencesExt)prefs.node("cc");
        this.cc = new CatalogChooser(node, false, true, false);
        this.cc.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Dataset") || e.getPropertyName().equals("File")) {
                    QueryChooser.this.firePropertyChangeEvent(e);
                }
            }
        });
    }

    public boolean setDataset(InvDataset ds) {
        InvAccess qcAccess = ds.getAccess(ServiceType.QC);
        if (null == qcAccess) {
            throw new IllegalArgumentException("QueryChooser :" + ds.getName() + " not a QC");
        }
        String urlString = qcAccess.getStandardUrlName();
        try {
            this.setDqcUrl(urlString);
            return true;
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this, "Malformed URL= " + urlString);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Error opening DQC URL= " + urlString);
        }
        return false;
    }

    public void setDqcUrl(String urlString) throws MalformedURLException, IOException {
        this.qc = this.dqcFactory.readXML(urlString);
        if (this.qc.hasFatalError()) {
            JOptionPane.showMessageDialog(this, "Fatal dqc errors= \n" + this.qc.getErrorMessages());
            return;
        }
        try {
            this.choosers = new ArrayList();
            this.buildUI();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.addToCB(urlString);
    }

    private void buildUI() {
        this.mapSelectors = new ArrayList();
        this.smallSelectors = new ArrayList();
        this.bigSelectors = new ArrayList();
        this.mapChooser = null;
        ArrayList selectors = this.qc.getAllUniqueSelectors();
        for (int i = 0; i < selectors.size(); ++i) {
            this.addSelector((Selector)selectors.get(i));
        }
        this.buttPanel = new JPanel();
        JButton queryButton = new JButton("QueryAvailable");
        this.buttPanel.add(queryButton);
        queryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryChooser.this.makeQuery();
            }
        });
        for (int i = 0; i < this.extraButtons.size(); ++i) {
            this.buttPanel.add((AbstractButton)this.extraButtons.get(i));
        }
        JPanel dqcPanel = new JPanel(new BorderLayout());
        this.status = new JLabel("");
        JPanel botPanel = new JPanel(new BorderLayout());
        botPanel.add((Component)this.buttPanel, "North");
        botPanel.add((Component)this.status, "South");
        dqcPanel.add((Component)this.layoutSelectors(), "Center");
        dqcPanel.add((Component)botPanel, "South");
        this.returnsCatalog = true;
        this.innerPanel.removeAll();
        if (this.returnsCatalog) {
            this.split = new JSplitPane(0, dqcPanel, this.cc);
            this.innerPanel.add((Component)this.split, "Center");
            if (this.prefs != null) {
                this.split.setDividerLocation(this.prefs.getInt(HDIVIDER, 800));
            }
        } else {
            this.innerPanel.add((Component)dqcPanel, "Center");
        }
        this.revalidate();
    }

    private JComponent layoutSelectors() {
        int nbig = this.bigSelectors.size();
        int nsmall = this.smallSelectors.size();
        int nmaps = this.mapSelectors.size();
        int ncols = nmaps + nbig;
        if (nsmall > 0) {
            ++ncols;
        }
        if (nbig == 0 && nmaps == 0) {
            Box hbox = new Box(0);
            this.addAll(hbox, this.smallSelectors);
            return hbox;
        }
        if (ncols > 3 && nmaps > 1) {
            JTabbedPane tabs = new JTabbedPane();
            for (int i = 0; i < this.mapSelectors.size(); ++i) {
                Component elem = (Component)this.mapSelectors.get(i);
                tabs.addTab("comp" + i, elem);
            }
            this.mapSelectors.clear();
            this.bigSelectors.add(tabs);
        }
        return this.standardLayout();
    }

    private JComponent standardLayout() {
        if (this.debugLayout) {
            System.out.println(" dqc standardLayout; smallSelectors = " + this.smallSelectors.size());
        }
        Box hbox = new Box(0);
        if (this.smallSelectors.size() == 1) {
            this.addAll(hbox, this.smallSelectors);
        } else if (this.smallSelectors.size() > 1) {
            Box vbox = new Box(1);
            this.addAll(vbox, this.smallSelectors);
            vbox.add(Box.createGlue());
            hbox.add(vbox);
        }
        this.addAll(hbox, this.bigSelectors);
        this.addAll(hbox, this.mapSelectors);
        return hbox;
    }

    private void addAll(Container c, ArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            c.add((JComponent)list.get(i));
            if (!this.debugLayout) continue;
            System.out.println(" layout added " + list.get(i));
        }
    }

    private void addSelector(Selector s) {
        if (s instanceof SelectList) {
            SelectList selectList = (SelectList)s;
            ChooserList clist = new ChooserList((Selector)selectList, selectList.getChoices());
            this.choosers.add(clist);
            JScrollPane scrollPane = new JScrollPane(clist.jlist);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add("North", new JLabel(selectList.getTitle()));
            panel.add("Center", scrollPane);
            panel.setBorder(new EtchedBorder());
            if (selectList.getSize() < 5 && !selectList.hasNestedSelectors()) {
                clist.jlist.setVisibleRowCount(selectList.getSize());
                this.smallSelectors.add(panel);
            } else {
                this.bigSelectors.add(panel);
            }
            if (selectList.hasNestedSelectors()) {
                if (this.debugNested) {
                    System.out.println(" QueryChooser selectList.hasNestedSelectors = " + selectList.getId());
                }
                this.addSelector((Selector)selectList.getFirstNestedSelector());
            }
        } else if (s instanceof SelectService) {
            SelectService selectService = (SelectService)s;
            ChooserList clist = new ChooserList((Selector)selectService, selectService.getChoices());
            this.choosers.add(clist);
            if (selectService.getChoices().size() == 1) {
                return;
            }
            clist.jlist.setVisibleRowCount(Math.min(selectService.getChoices().size(), 5));
            JScrollPane scrollPane = new JScrollPane(clist.jlist);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add("North", new JLabel(selectService.getTitle()));
            panel.add("Center", scrollPane);
            panel.setBorder(new EtchedBorder());
            this.smallSelectors.add(panel);
        } else if (s instanceof SelectStation) {
            SelectStation selectStation = (SelectStation)s;
            boolean need2add = this.makeMapChooser();
            ArrayList stations = selectStation.getStations();
            ArrayList<DqcStation> wrappedStations = new ArrayList<DqcStation>(stations.size());
            for (int i = 0; i < stations.size(); ++i) {
                wrappedStations.add(new DqcStation((Station)stations.get(i)));
            }
            this.mapChooser.setStations(wrappedStations);
            this.choosers.add(new ChooserStation(selectStation, this.mapChooser));
            if (need2add) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add("North", new JLabel(s.getTitle() + ":"));
                panel.add("Center", this.mapChooser);
                panel.setBorder(new EtchedBorder());
                this.mapSelectors.add(panel);
            }
        } else if (s instanceof SelectGeoRegion) {
            SelectGeoRegion geoRegion = (SelectGeoRegion)s;
            boolean need2add = this.makeMapChooser();
            Location loc = geoRegion.getLowerLeft();
            LatLonPointImpl left = new LatLonPointImpl(loc.getLatitude(), loc.getLongitude());
            loc = geoRegion.getUpperRight();
            LatLonPointImpl right = new LatLonPointImpl(loc.getLatitude(), loc.getLongitude());
            LatLonRect bounds = new LatLonRect((LatLonPoint)left, (LatLonPoint)right);
            this.mapChooser.setGeoBounds(bounds);
            double centerLon = bounds.getCenterLon();
            double width = bounds.getWidth();
            double centerLat = (right.getLatitude() + left.getLatitude()) / 2.0;
            double height = right.getLatitude() - left.getLatitude();
            right = new LatLonPointImpl(centerLat + height / 4.0, centerLon + width / 4.0);
            left = new LatLonPointImpl(centerLat - height / 4.0, centerLon - width / 4.0);
            LatLonRect selected = new LatLonRect((LatLonPoint)left, (LatLonPoint)right);
            this.mapChooser.setGeoSelection(selected);
            this.choosers.add(new ChooserGeo(geoRegion, this.mapChooser));
            if (need2add) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add("North", new JLabel(s.getTitle() + ":"));
                panel.add("Center", this.mapChooser);
                panel.setBorder(new EtchedBorder());
                this.mapSelectors.add(panel);
            }
        } else if (s instanceof SelectRange) {
            SelectRange sr = (SelectRange)s;
            InvDocumentation desc = sr.getDescription();
            String help = desc == null ? null : desc.getInlineContent();
            RangeSelector range = new RangeSelector(sr.getTitle(), sr.getMin(), sr.getMax(), sr.getResolution(), sr.getUnits(), true, help, sr.getSelectType().equals("point"));
            this.choosers.add(new ChooserRange(sr, range));
            this.smallSelectors.add(range);
        } else if (s instanceof SelectRangeDate) {
            SelectRangeDate srd = (SelectRangeDate)s;
            InvDocumentation desc = srd.getDescription();
            String help = desc == null ? null : desc.getInlineContent();
            try {
                RangeDateSelector range = new RangeDateSelector(srd.getTitle(), srd.getStart(), srd.getEnd(), srd.getDuration(), srd.getResolution(), true, false, help, srd.getSelectType().equals("point"));
                this.choosers.add(new ChooserRangeDate(srd, range));
                this.smallSelectors.add(range);
            }
            catch (Exception e) {
                System.out.println("Error on SelectRangeDate = " + srd.getTitle());
                e.printStackTrace();
            }
        }
    }

    private boolean makeMapChooser() {
        if (null != this.mapChooser) {
            return false;
        }
        this.mapChooser = new StationRegionDateChooser(true, true, false);
        return true;
    }

    private void showStatus() {
    }

    private void makeQuery() {
        StringBuilder buff;
        InvCatalogFactory factory;
        InvCatalogImpl catalog;
        Chooser need = null;
        for (int i = 0; i < this.choosers.size(); ++i) {
            Chooser c = (Chooser)this.choosers.get(i);
            if (c.hasChoice() || !c.isRequired()) continue;
            need = c;
            break;
        }
        if (null != need) {
            JOptionPane.showMessageDialog(this, "You must make selection from " + need.getName());
            return;
        }
        this.status.setText(" ");
        String queryString = this.qc.getQuery().getUriResolved().toString();
        StringBuffer queryb = new StringBuffer();
        queryb.append(queryString);
        for (int i = 0; i < this.choosers.size(); ++i) {
            Chooser c = (Chooser)this.choosers.get(i);
            if (!c.hasChoice()) continue;
            Selector s = c.getSelector();
            s.appendQuery(queryb, c.getChoices());
        }
        queryString = queryb.toString();
        this.status.setText(queryString);
        if (Debug.isSet("dqc/showQuery")) {
            System.out.println("dqc/showQuery= " + queryString);
        }
        if (!(catalog = (factory = InvCatalogFactory.getDefaultFactory((boolean)true)).readXML(queryString)).check(buff = new StringBuilder())) {
            JOptionPane.showMessageDialog(this, "Invalid catalog " + buff.toString());
            System.out.println("Invalid catalog " + buff.toString());
            return;
        }
        if (Debug.isSet("dqc/showQueryResult")) {
            System.out.println("dqc/showQueryResult catalog check msgs= " + buff.toString());
            System.out.println("  query result =\n" + IO.readURLcontents((String)queryString));
        }
        this.cc.setCatalog(catalog);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.add(PropertyChangeListener.class, l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.remove(PropertyChangeListener.class, l);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
        }
    }

    private void addToCB(String name) {
        if (this.comboBox == null) {
            return;
        }
        this.comboBox.addItem(name);
    }

    public void save() {
        if (this.comboBox != null) {
            this.comboBox.save();
        }
        if (this.prefs != null && this.split != null) {
            this.prefs.putInt(HDIVIDER, this.split.getDividerLocation());
        }
        if (this.cc != null) {
            this.cc.save();
        }
    }

    public String getCurrentURL() {
        return this.comboBox == null ? null : (String)this.comboBox.getSelectedItem();
    }

    public CatalogChooser getCatalogChooser() {
        return this.cc;
    }

    public void addButton(AbstractButton b) {
        this.extraButtons.add(b);
    }

    public JDialog makeDialog(RootPaneContainer parent, String title, boolean modal) {
        return new MyDialog(parent, title == null ? this.qc.getName() : title, modal);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test QueryChooser");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        QueryChooser qcs = new QueryChooser(new PreferencesExt(null, ""), true);
        qcs.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                System.out.println("qcs.PropertyChange = " + e.getPropertyName() + " " + e.getNewValue().getClass().getName());
            }
        });
        try {
            qcs.setDqcUrl("file:///C:/dev/thredds/catalog/test/data/dqc/exampleDqc.xml");
        }
        catch (Exception e) {
            try {
                JOptionPane.showMessageDialog(null, null, e.getMessage(), 0);
            }
            catch (HeadlessException ee) {
                // empty catch block
            }
        }
        frame.getContentPane().add(qcs);
        frame.pack();
        frame.setLocation(300, 300);
        frame.setVisible(true);
    }

    private class MyDialog
    extends JDialog {
        private MyDialog(RootPaneContainer parent, String title, boolean modal) {
            super(parent instanceof Frame ? (Frame)((Object)parent) : null, title, modal);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("lookAndFeel")) {
                        SwingUtilities.updateComponentTreeUI(MyDialog.this);
                    }
                }
            });
            JButton dismissButton = new JButton("Dismiss");
            QueryChooser.this.buttPanel.add((Component)dismissButton, null);
            dismissButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MyDialog.this.setVisible(false);
                }
            });
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)QueryChooser.this, "Center");
            this.pack();
        }
    }

    private class DqcStation
    implements ucar.unidata.geoloc.Station {
        Station s;

        DqcStation(Station s) {
            this.s = s;
        }

        public String getID() {
            return this.s.getValue();
        }

        public String getName() {
            return this.s.getValue();
        }

        public String getDescription() {
            InvDocumentation doc = this.s.getDescription();
            return doc == null ? this.s.getName() : doc.getInlineContent();
        }

        public String getWmoId() {
            return null;
        }

        public double getLatitude() {
            return this.s.getLocation().getLatitude();
        }

        public double getLongitude() {
            return this.s.getLocation().getLongitude();
        }

        public double getAltitude() {
            return this.s.getLocation().getElevation();
        }

        public LatLonPoint getLatLon() {
            return new LatLonPointImpl(this.getLatitude(), this.getLongitude());
        }

        public boolean isMissing() {
            return Double.isNaN(this.getLatitude()) || Double.isNaN(this.getLongitude());
        }

        public int compareTo(ucar.unidata.geoloc.Station so) {
            return this.getName().compareTo(so.getName());
        }
    }

    private class ChooserRangeDate
    extends Chooser {
        RangeDateSelector rds;
        boolean isPoint;

        ChooserRangeDate(SelectRangeDate sel, RangeDateSelector range) {
            super((Selector)sel);
            this.rds = range;
            this.isPoint = "point".equals(sel.getSelectType());
        }

        @Override
        boolean hasChoice() {
            return this.rds.isEnabled();
        }

        @Override
        ArrayList getChoices() {
            DateRange selected = this.rds.getDateRange();
            if (selected == null) {
                selected = this.rds.getDateRange();
            }
            ArrayList<String> choices = new ArrayList<String>();
            if (this.isPoint) {
                choices.add("{point}");
                choices.add(selected.getStart().toString());
            } else {
                choices.add("{start}");
                choices.add(selected.getStart().toDateTimeStringISO());
                choices.add("{end}");
                choices.add(selected.getEnd().toDateTimeStringISO());
                choices.add("{duration}");
                choices.add(selected.getDuration().toString());
            }
            return choices;
        }
    }

    private class ChooserRange
    extends Chooser {
        RangeSelector range;
        boolean isPoint;

        ChooserRange(SelectRange sel, RangeSelector range) {
            super((Selector)sel);
            this.range = range;
            this.isPoint = "point".equals(sel.getSelectType());
        }

        @Override
        boolean hasChoice() {
            return true;
        }

        @Override
        ArrayList getChoices() {
            ArrayList<String> choices = new ArrayList<String>();
            if (this.isPoint) {
                choices.add("{point}");
                choices.add(this.range.getMinSelectedString());
            } else {
                choices.add("{min}");
                choices.add(this.range.getMinSelectedString());
                choices.add("{max}");
                choices.add(this.range.getMaxSelectedString());
            }
            return choices;
        }
    }

    private class ChooserGeo
    extends Chooser {
        StationRegionDateChooser geoChooser;

        ChooserGeo(SelectGeoRegion sel, StationRegionDateChooser geoChooser) {
            super((Selector)sel);
            this.geoChooser = geoChooser;
        }

        @Override
        boolean hasChoice() {
            return this.geoChooser.getGeoSelection() != null;
        }

        @Override
        ArrayList getChoices() {
            LatLonRect llbb = this.geoChooser.getGeoSelectionLL();
            ArrayList<String> choices = new ArrayList<String>();
            if (llbb != null) {
                LatLonPointImpl llpoint = llbb.getLowerLeftPoint();
                choices.add("{minLat}");
                choices.add(Format.d((double)llpoint.getLatitude(), (int)5));
                choices.add("{minLon}");
                choices.add(Format.d((double)llpoint.getLongitude(), (int)5));
                LatLonPointImpl urPoint = llbb.getUpperRightPoint();
                choices.add("{maxLat}");
                choices.add(Format.d((double)urPoint.getLatitude(), (int)5));
                choices.add("{maxLon}");
                choices.add(Format.d((double)urPoint.getLongitude(), (int)5));
            }
            return choices;
        }
    }

    private class ChooserStation
    extends Chooser {
        StationRegionDateChooser mapChooser;
        DqcStation currentChoice;

        ChooserStation(SelectStation sel, StationRegionDateChooser mapChooser) {
            super((Selector)sel);
            this.mapChooser = mapChooser;
            mapChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("Station")) {
                        ChooserStation.this.currentChoice = (DqcStation)e.getNewValue();
                        QueryChooser.this.showStatus();
                    }
                }
            });
        }

        @Override
        boolean hasChoice() {
            return this.currentChoice != null;
        }

        @Override
        ArrayList getChoices() {
            ArrayList<String> choices = new ArrayList<String>();
            if (this.currentChoice != null) {
                choices.add("{value}");
                choices.add(this.currentChoice.s.getValue());
            }
            return choices;
        }
    }

    private class ChooserList
    extends Chooser {
        JList jlist;
        boolean loaded;

        ChooserList(Selector sel, ArrayList choices) {
            super(sel);
            this.loaded = false;
            this.jlist = new JList(new ListModel(choices));
            if (sel.isMultiple()) {
                this.jlist.setSelectionMode(2);
            } else {
                this.jlist.setSelectionMode(0);
            }
            this.jlist.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    if (null == ChooserList.this.jlist.getSelectedValue()) {
                        return;
                    }
                    Choice currentChoice = (Choice)ChooserList.this.jlist.getSelectedValue();
                    if (null == currentChoice) {
                        return;
                    }
                    if (currentChoice instanceof ListChoice && ((ListChoice)currentChoice).hasNestedSelectors()) {
                        ListChoice listChoice = (ListChoice)currentChoice;
                        ArrayList selectors = listChoice.getNestedSelectors();
                        for (int i = 0; i < selectors.size(); ++i) {
                            SelectList sl = (SelectList)selectors.get(i);
                            ChooserList.this.loadNested(sl);
                        }
                    }
                }
            });
        }

        private void setList(ArrayList choices) {
            this.jlist.setModel(new ListModel(choices));
        }

        private void loadNested(SelectList nestedList) {
            if (nestedList == null) {
                return;
            }
            ChooserList nestedChooser = (ChooserList)this.findChooser(nestedList.getId());
            if (nestedChooser == null) {
                return;
            }
            ArrayList choices = nestedList.getChoices();
            nestedChooser.setList(choices);
            nestedChooser.jlist.setSelectedIndex(0);
            nestedChooser.jlist.repaint();
        }

        Chooser findChooser(String id) {
            for (int i = 0; i < QueryChooser.this.choosers.size(); ++i) {
                Chooser c = (Chooser)QueryChooser.this.choosers.get(i);
                if (!id.equals(c.getId())) continue;
                return c;
            }
            return null;
        }

        @Override
        boolean hasChoice() {
            return !this.jlist.isSelectionEmpty();
        }

        @Override
        ArrayList getChoices() {
            ArrayList<String> choices = new ArrayList<String>();
            Object[] values = this.jlist.getSelectedValues();
            for (int i = 0; i < values.length; ++i) {
                Choice c = (Choice)values[i];
                choices.add("{value}");
                choices.add(c.getValue());
            }
            return choices;
        }
    }

    private abstract class Chooser {
        Selector selector;

        Chooser(Selector s) {
            this.selector = s;
        }

        String getName() {
            return this.selector.getTitle();
        }

        String getId() {
            return this.selector.getId();
        }

        Selector getSelector() {
            return this.selector;
        }

        boolean isRequired() {
            return this.selector.isRequired();
        }

        abstract boolean hasChoice();

        abstract ArrayList getChoices();
    }

    private class ListModel
    extends AbstractListModel {
        private ArrayList list;

        ListModel(ArrayList list) {
            this.list = list;
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.list.get(index);
        }
    }
}

