/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib1.Grib1CollectionBuilder;
import ucar.nc2.grib.grib1.Grib1TimePartitionBuilder;
import ucar.nc2.grib.grib2.Grib2CollectionBuilder;
import ucar.nc2.grib.grib2.Grib2TimePartitionBuilder;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class GribCollectionIndexPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted groupTable;
    private BeanTableSorted varTable;
    private BeanTableSorted vertCoordTable;
    private BeanTableSorted timeCoordTable;
    private JSplitPane split;
    private JSplitPane split2;
    private JSplitPane split3;
    private TextHistoryPane infoPopup;
    private TextHistoryPane detailTA;
    private IndependentWindow infoWindow;
    private IndependentWindow detailWindow;
    GribCollection gc;

    public GribCollectionIndexPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        AbstractButton infoButton = BAMutil.makeButtcon("Information", "Show Info", false);
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                GribCollectionIndexPanel.this.gc.showIndex(f);
                GribCollectionIndexPanel.this.detailTA.setText(f.toString());
                GribCollectionIndexPanel.this.detailTA.gotoTop();
                GribCollectionIndexPanel.this.detailWindow.show();
            }
        });
        buttPanel.add(infoButton);
        AbstractButton filesButton = BAMutil.makeButtcon("Information", "Show Files", false);
        filesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                GribCollectionIndexPanel.this.showFiles(f);
                GribCollectionIndexPanel.this.detailTA.setText(f.toString());
                GribCollectionIndexPanel.this.detailTA.gotoTop();
                GribCollectionIndexPanel.this.detailWindow.show();
            }
        });
        buttPanel.add(filesButton);
        this.groupTable = new BeanTableSorted(GroupBean.class, (PreferencesExt)prefs.node("GroupBean"), false);
        this.groupTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GroupBean bean = (GroupBean)GribCollectionIndexPanel.this.groupTable.getSelectedBean();
                if (bean != null) {
                    GribCollectionIndexPanel.this.setGroup(bean.group);
                }
            }
        });
        PopupMenu varPopup = new PopupMenu(this.groupTable.getJTable(), "Options");
        varPopup.addAction("Show Files Used", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupBean bean = (GroupBean)GribCollectionIndexPanel.this.groupTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.showFilesUsed(f);
                    GribCollectionIndexPanel.this.infoPopup.setText(f.toString());
                    GribCollectionIndexPanel.this.infoPopup.gotoTop();
                    GribCollectionIndexPanel.this.infoWindow.show();
                }
            }
        });
        this.varTable = new BeanTableSorted(VarBean.class, (PreferencesExt)prefs.node("Grib2Bean"), false);
        varPopup = new PopupMenu(this.varTable.getJTable(), "Options");
        varPopup.addAction("Show Variable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarBean bean = (VarBean)GribCollectionIndexPanel.this.varTable.getSelectedBean();
                if (bean != null) {
                    GribCollectionIndexPanel.this.infoPopup.setText(bean.v.toStringComplete());
                    GribCollectionIndexPanel.this.infoPopup.gotoTop();
                    GribCollectionIndexPanel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Show Record Table", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarBean bean = (VarBean)GribCollectionIndexPanel.this.varTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.showRecords(f);
                    GribCollectionIndexPanel.this.infoPopup.setText(f.toString());
                    GribCollectionIndexPanel.this.infoPopup.gotoTop();
                    GribCollectionIndexPanel.this.infoWindow.show();
                }
            }
        });
        this.vertCoordTable = new BeanTableSorted(CoordBean.class, (PreferencesExt)prefs.node("CoordBean"), false);
        varPopup = new PopupMenu(this.vertCoordTable.getJTable(), "Options");
        varPopup.addAction("Show", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordBean bean = (CoordBean)GribCollectionIndexPanel.this.vertCoordTable.getSelectedBean();
                if (bean != null) {
                    GribCollectionIndexPanel.this.infoPopup.setText(bean.vc.toString());
                    GribCollectionIndexPanel.this.infoPopup.gotoTop();
                    GribCollectionIndexPanel.this.infoWindow.show();
                }
            }
        });
        this.timeCoordTable = new BeanTableSorted(TimeCoordBean.class, (PreferencesExt)prefs.node("TimeCoordBean"), false);
        varPopup = new PopupMenu(this.timeCoordTable.getJTable(), "Options");
        varPopup.addAction("Show", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeCoordBean bean = (TimeCoordBean)GribCollectionIndexPanel.this.timeCoordTable.getSelectedBean();
                if (bean != null) {
                    GribCollectionIndexPanel.this.infoPopup.setText(bean.tc.toString());
                    GribCollectionIndexPanel.this.infoPopup.gotoTop();
                    GribCollectionIndexPanel.this.infoWindow.show();
                }
            }
        });
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.detailTA = new TextHistoryPane();
        this.detailWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.detailTA);
        this.detailWindow.setBounds((Rectangle)prefs.getBean("DetailWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split3 = new JSplitPane(0, false, this.groupTable, this.varTable);
        this.split3.setDividerLocation(prefs.getInt("splitPos3", 800));
        this.split2 = new JSplitPane(0, false, this.split3, this.vertCoordTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.split2, this.timeCoordTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.groupTable.saveState(false);
        this.varTable.saveState(false);
        this.vertCoordTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putBeanObject("DetailWindowBounds", (Object)this.detailWindow.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
        if (this.split3 != null) {
            this.prefs.putInt("splitPos3", this.split3.getDividerLocation());
        }
    }

    public void closeOpenFiles() throws IOException {
        if (this.gc != null) {
            this.gc.close();
        }
        this.gc = null;
    }

    private void compareFiles(Formatter f) throws IOException {
        if (this.gc == null) {
            return;
        }
        ArrayList canon = new ArrayList(this.gc.getFilenames());
        Collections.sort(canon);
        File idxFile = this.gc.getIndexFile();
        File dir = idxFile.getParentFile();
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".ncx");
            }
        });
        int total = 0;
        for (File file : files) {
            RandomAccessFile raf = new RandomAccessFile(file.getPath(), "r");
            GribCollection cgc = Grib2CollectionBuilder.createFromIndex((String)file.getPath(), (File)file.getParentFile(), (RandomAccessFile)raf, null);
            ArrayList cfiles = new ArrayList(cgc.getFilenames());
            Collections.sort(cfiles);
            f.format("Compare files in %s to canonical files in %s%n", file.getPath(), idxFile.getPath());
            this.compareSortedList(f, canon.iterator(), cfiles.iterator());
            f.format("  Compared %d files to %d files%n%n", cfiles.size(), canon.size());
            raf.close();
            total += cfiles.size();
        }
        f.format("Total files = %d%n%n", total);
    }

    private void compareSortedList(Formatter f, Iterator<String> i1, Iterator<String> i2) {
        String s1 = null;
        String s2 = null;
        boolean need1 = true;
        boolean need2 = true;
        while (true) {
            if (need1) {
                String string = s1 = i1.hasNext() ? i1.next() : null;
            }
            if (need2) {
                s2 = i2.hasNext() ? i2.next() : null;
            }
            need1 = true;
            need2 = true;
            if (s1 == null && s2 == null) break;
            if (s1 == null) {
                f.format(" extra file = %s%n", s2);
                continue;
            }
            if (s2 == null) {
                f.format(" missing file = %s%n", s1);
                continue;
            }
            int pos = s1.lastIndexOf("/");
            String name1 = s1.substring(pos);
            name1 = name1.substring(1, name1.indexOf("gdas"));
            String name2 = s2.substring(pos);
            int val = name1.compareTo(name2 = name2.substring(1, name2.indexOf("gdas")));
            if (val < 0) {
                f.format(" missing file = %s%n", s1);
                need2 = false;
                continue;
            }
            if (val <= 0) continue;
            f.format(" extra file = %s%n", s2);
            need1 = false;
        }
    }

    public void setIndexFile(String indexFile) throws IOException {
        if (this.gc != null) {
            this.gc.close();
        }
        RandomAccessFile raf = new RandomAccessFile(indexFile, "r");
        raf.seek(0L);
        byte[] b = new byte["Grib2CollectionIndex".getBytes().length];
        raf.read(b);
        String magic = new String(b);
        if (magic.equals("Grib2CollectionIndex")) {
            this.gc = Grib2CollectionBuilder.createFromIndex((String)indexFile, null, (RandomAccessFile)raf, null);
        } else if (magic.equals("Grib1CollectionIndex")) {
            this.gc = Grib1CollectionBuilder.createFromIndex((String)indexFile, null, (RandomAccessFile)raf, null);
        } else if (magic.equals("Grib2Partition0Index")) {
            this.gc = Grib2TimePartitionBuilder.createFromIndex((String)indexFile, null, (RandomAccessFile)raf);
        } else if (magic.equals("Grib1Partition0Index")) {
            this.gc = Grib1TimePartitionBuilder.createFromIndex((String)indexFile, null, (RandomAccessFile)raf);
        } else {
            throw new IOException("Not a grib collection index file =" + magic);
        }
        ArrayList<GroupBean> groups = new ArrayList<GroupBean>();
        for (GribCollection.GroupHcs g : this.gc.getGroups()) {
            groups.add(new GroupBean(g));
        }
        this.groupTable.setBeans(groups);
    }

    private void setGroup(GribCollection.GroupHcs group) {
        ArrayList<VarBean> vars = new ArrayList<VarBean>();
        for (GribCollection.VariableIndex v : group.varIndex) {
            vars.add(new VarBean(v, group));
        }
        this.varTable.setBeans(vars);
        int count = 0;
        ArrayList<CoordBean> coords = new ArrayList<CoordBean>();
        for (VertCoord vc : group.vertCoords) {
            coords.add(new CoordBean(vc, count++));
        }
        this.vertCoordTable.setBeans(coords);
        count = 0;
        ArrayList<TimeCoordBean> tcoords = new ArrayList<TimeCoordBean>();
        for (TimeCoord tc : group.timeCoords) {
            tcoords.add(new TimeCoordBean(tc, count++));
        }
        this.timeCoordTable.setBeans(tcoords);
    }

    private void showFiles(Formatter f) {
        if (this.gc == null) {
            return;
        }
        int count = 0;
        f.format("In order:%n", new Object[0]);
        for (String file : this.gc.getFilenames()) {
            f.format("%5d %s%n", count++, file);
        }
        f.format("%nsorted:%n", new Object[0]);
        ArrayList fs = new ArrayList(this.gc.getFilenames());
        Collections.sort(fs);
        for (String file : fs) {
            f.format("%5d %s%n", count++, file);
        }
        f.format("============%n%s%n", this.gc);
    }

    public class TimeCoordBean {
        TimeCoord tc;
        int index;

        public TimeCoordBean() {
        }

        public TimeCoordBean(TimeCoord tc, int index) {
            this.tc = tc;
            this.index = index;
        }

        public int getNCoords() {
            return this.tc.getSize();
        }

        public String getCalendarRange() {
            return this.tc.getCalendarRange().toString();
        }

        public String getTimeUnit() {
            return this.tc.getTimeUnit().toString();
        }

        public String getTimeIntervalName() {
            return this.tc.getTimeIntervalName();
        }

        public int getIndex() {
            return this.index;
        }
    }

    public class CoordBean {
        VertCoord vc;
        int index;

        public CoordBean() {
        }

        public CoordBean(VertCoord vc, int index) {
            this.vc = vc;
            this.index = index;
        }

        public boolean isLayer() {
            return this.vc.isLayer();
        }

        public int getSize() {
            return this.vc.getSize();
        }

        public int getCode() {
            return this.vc.getCode();
        }

        public String getVertCoords() {
            return this.vc.showCoords();
        }

        public String getVertCoordName() {
            return this.vc.getName();
        }

        public String getUnits() {
            return this.vc.getUnits();
        }

        public int getIndex() {
            return this.index;
        }
    }

    public class VarBean {
        GribCollection.VariableIndex v;
        GribCollection.GroupHcs group;

        public VarBean() {
        }

        public VarBean(GribCollection.VariableIndex v, GribCollection.GroupHcs group) {
            this.v = v;
            this.group = group;
        }

        public int getTimeCoord() {
            return this.v.timeIdx;
        }

        public boolean getTimeIntv() {
            return this.v.getTimeCoord() == null ? false : this.v.getTimeCoord().isInterval();
        }

        public boolean getVertLayer() {
            return this.v.getVertCoord() == null ? false : this.v.getVertCoord().isLayer();
        }

        public int getVertCoord() {
            return this.v.vertIdx;
        }

        public int getEnsCoord() {
            return this.v.ensIdx;
        }

        public int getLevelType() {
            return this.v.levelType;
        }

        public int getIntvType() {
            return this.v.intvType;
        }

        public int getProbType() {
            return this.v.probType;
        }

        public int getEnsType() {
            return this.v.ensDerivedType;
        }

        public int getGenType() {
            return this.v.genProcessType;
        }

        public String getIntvName() {
            return this.v.intvName;
        }

        public String getProbName() {
            return this.v.probabilityName;
        }

        public int getHash() {
            return this.v.cdmHash;
        }

        public String getGroupId() {
            return this.group.getId();
        }

        public String getVariableId() {
            return this.v.discipline + "-" + this.v.category + "-" + this.v.parameter;
        }

        private void showRecords(Formatter f) {
            TimeCoord tcoord = this.v.getTimeCoord();
            VertCoord vcoord = this.v.getVertCoord();
            EnsCoord ecoord = this.v.getEnsCoord();
            try {
                if (tcoord.isInterval()) {
                    if (vcoord == null) {
                        this.showRecords2Dintv(f, tcoord.getIntervals());
                    } else {
                        this.showRecords2Dintv(f, vcoord, tcoord.getIntervals());
                    }
                } else if (vcoord == null) {
                    this.showRecords(f, tcoord.getCoords());
                } else {
                    this.showRecords(f, vcoord, tcoord.getCoords());
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private void showRecords(Formatter f, List<Integer> values) throws IOException {
            f.format("Variable %s%n", this.v.toStringComplete());
            f.format(" Show records (file,pos)%n", new Object[0]);
            f.format(" time (down)%n", new Object[0]);
            GribCollection.Record[] records = this.v.getRecords();
            for (int timeIdx = 0; timeIdx < this.v.ntimes; ++timeIdx) {
                f.format("%10s = ", values.get(timeIdx));
                int idx = GribCollection.calcIndex((int)timeIdx, (int)0, (int)0, (int)this.v.nens, (int)this.v.nverts);
                GribCollection.Record r = records[idx];
                if (r == null) {
                    f.format("null", new Object[0]);
                } else {
                    f.format("(%d,%8d) ", r.fileno, r.pos);
                }
                f.format("%n", new Object[0]);
            }
            f.format("%n Show records in order%n", new Object[0]);
            int count = 0;
            for (GribCollection.Record r : records) {
                if (r == null) {
                    f.format("null%n", new Object[0]);
                } else {
                    f.format("%5d = (%d,%8d)%n", count, r.fileno, r.pos);
                }
                ++count;
            }
            f.format("%n", new Object[0]);
        }

        private void showRecords(Formatter f, VertCoord vcoord, List<Integer> values) throws IOException {
            f.format("Variable %s%n", this.v.toStringComplete());
            f.format(" Show records (file,pos)%n", new Object[0]);
            f.format(" time (down) x vert (across) %n", new Object[0]);
            f.format("%12s ", " ");
            List levels = vcoord.getCoords();
            boolean isLayer = vcoord.isLayer();
            for (int j = 0; j < levels.size(); ++j) {
                f.format("%6s ", ((VertCoord.Level)levels.get(j)).toString(isLayer));
            }
            f.format("%n", new Object[0]);
            GribCollection.Record[] records = this.v.getRecords();
            for (int timeIdx = 0; timeIdx < this.v.ntimes; ++timeIdx) {
                f.format("%10s = ", values.get(timeIdx));
                for (int vertIdx = 0; vertIdx < vcoord.getSize(); ++vertIdx) {
                    int idx = GribCollection.calcIndex((int)timeIdx, (int)0, (int)vertIdx, (int)this.v.nens, (int)this.v.nverts);
                    GribCollection.Record r = records[idx];
                    if (r == null) {
                        f.format("null", new Object[0]);
                        continue;
                    }
                    f.format("(%d,%8d) ", r.fileno, r.pos);
                }
                f.format("%n", new Object[0]);
            }
            int count = 0;
            for (GribCollection.Record r : records) {
                if (r == null) {
                    f.format("null%n", new Object[0]);
                } else {
                    f.format("%5d = (%d,%8d)%n", count, r.fileno, r.pos);
                }
                ++count;
            }
            f.format("%n", new Object[0]);
        }

        void showRecords2Dintv(Formatter f, VertCoord vcoord, List<TimeCoord.Tinv> tinvs) throws IOException {
            f.format("%12s ", " ");
            List levels = vcoord.getCoords();
            boolean isLayer = vcoord.isLayer();
            for (int j = 0; j < levels.size(); ++j) {
                f.format("%6s ", ((VertCoord.Level)levels.get(j)).toString(isLayer));
            }
            f.format("%n", new Object[0]);
            GribCollection.Record[] records = this.v.getRecords();
            for (int timeIdx = 0; timeIdx < this.v.ntimes; ++timeIdx) {
                f.format("%10s = ", tinvs.get(timeIdx));
                for (int vertIdx = 0; vertIdx < vcoord.getSize(); ++vertIdx) {
                    int idx = GribCollection.calcIndex((int)timeIdx, (int)0, (int)vertIdx, (int)this.v.nens, (int)this.v.nverts);
                    GribCollection.Record r = records[idx];
                    f.format("%6d ", r == null ? -1 : r.fileno);
                }
                f.format("%n", new Object[0]);
            }
        }

        void showRecords2Dintv(Formatter f, List<TimeCoord.Tinv> tinvs) throws IOException {
            GribCollection.Record[] records = this.v.getRecords();
            for (int timeIdx = 0; timeIdx < this.v.ntimes; ++timeIdx) {
                f.format("%10s = ", tinvs.get(timeIdx));
                int idx = GribCollection.calcIndex((int)timeIdx, (int)0, (int)0, (int)this.v.nens, (int)this.v.nverts);
                GribCollection.Record r = records[idx];
                f.format("%6d ", r == null ? -1 : r.fileno);
                f.format("%n", new Object[0]);
            }
        }
    }

    public class GroupBean {
        GribCollection.GroupHcs group;

        public GroupBean() {
        }

        public GroupBean(GribCollection.GroupHcs g) {
            this.group = g;
        }

        public String getGroupId() {
            return this.group.getId();
        }

        public int getGdsHash() {
            return this.group.gdsHash;
        }

        public String getDescription() {
            return this.group.getDescription();
        }

        void showFilesUsed(Formatter f) {
            for (int i : this.group.filenose) {
                f.format(" %d:%s%n", i, GribCollectionIndexPanel.this.gc.filenames.get(i));
            }
        }
    }
}

