/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.TrajectoryObsDatatype;
import ucar.nc2.ui.StructureTable;
import ucar.nc2.ui.point.TrajectoryRegionDateChooser;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class TrajectoryObsViewer
extends JPanel {
    private PreferencesExt prefs;
    private TrajectoryRegionDateChooser chooser;
    private BeanTableSorted trajTable;
    private StructureTable obsTable;
    private JSplitPane splitV;
    private JSplitPane splitH;
    private IndependentWindow infoWindow;
    private boolean debugStationRegionSelect = false;
    private boolean debugStationDatsets = false;

    public TrajectoryObsViewer(PreferencesExt prefs) {
        this.prefs = prefs;
        this.chooser = new TrajectoryRegionDateChooser();
        this.chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Pick")) {
                    // empty if block
                }
            }
        });
        this.trajTable = new BeanTableSorted(TrajBean.class, (PreferencesExt)prefs.node("TrajBeans"), false);
        this.trajTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TrajBean sb = (TrajBean)TrajectoryObsViewer.this.trajTable.getSelectedBean();
                TrajectoryObsViewer.this.setTrajectory(sb);
                if (TrajectoryObsViewer.this.debugStationRegionSelect) {
                    System.out.println("trajTable selected= " + sb.getId());
                }
            }
        });
        this.splitH = new JSplitPane(1, false, this.trajTable, this.chooser);
        this.splitH.setDividerLocation(prefs.getInt("splitPosH", 500));
        this.obsTable = new StructureTable((PreferencesExt)prefs.node("ObsBean"));
        this.obsTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PointObsDatatype sb = (PointObsDatatype)TrajectoryObsViewer.this.obsTable.getSelectedRow();
                TrajectoryObsViewer.this.chooser.setSelected(sb);
            }
        });
        TextHistoryPane infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Station Information", BAMutil.getImage("netcdfUI"), infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.splitV = new JSplitPane(0, false, this.splitH, this.obsTable);
        this.splitV.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitV, "Center");
    }

    public void setDataset(TrajectoryObsDataset trajDataset) {
        if (this.debugStationDatsets) {
            System.out.println("StationObsViewer open type " + trajDataset.getClass().getName());
        }
        List trajList = trajDataset.getTrajectories();
        ArrayList<TrajBean> trajBeans = new ArrayList<TrajBean>();
        for (int i = 0; i < trajList.size(); ++i) {
            TrajectoryObsDatatype traj = (TrajectoryObsDatatype)trajList.get(i);
            trajBeans.add(new TrajBean(traj));
        }
        this.trajTable.setBeans(trajBeans);
    }

    public void setTrajectory(TrajBean sb) {
        TrajectoryObsDatatype tdt = sb.traj;
        try {
            this.obsTable.setTrajectory(tdt);
            this.chooser.setTrajectory(tdt);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        sb.setCount(tdt.getNumberPoints());
        this.trajTable.getJTable().repaint();
        if (tdt.getNumberPoints() == 0) {
            this.obsTable.clear();
            return;
        }
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.trajTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.splitV.getDividerLocation());
        this.prefs.putInt("splitPosH", this.splitH.getDividerLocation());
        this.obsTable.saveState();
    }

    public class TrajBean {
        TrajectoryObsDatatype traj;
        private int count;

        public TrajBean() {
        }

        public TrajBean(TrajectoryObsDatatype traj) {
            this.traj = traj;
            this.count = traj.getNumberPoints();
        }

        public String getId() {
            return this.traj.getId();
        }

        public String getDescription() {
            return this.traj.getDescription();
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public Date getStartDate() {
            return this.traj.getStartDate();
        }

        public Date getEndDate() {
            return this.traj.getEndDate();
        }
    }
}

