/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grid;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.Dimension;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.ui.event.ActionSourceListener;
import ucar.nc2.ui.event.ActionValueEvent;
import ucar.nc2.ui.table.JTableSorted;
import ucar.nc2.ui.table.TableRowAbstract;

public class GridTable {
    private JTableSorted table = new JTableSorted(colName, this.list);
    private ArrayList<Row> list = null;
    private ActionSourceListener actionSource;
    private boolean eventOK = true;
    private boolean debug = false;
    private static String[] colName = new String[]{"Name", "Dimensions", "Units", "Long Name"};

    public GridTable(String actionName) {
        this.actionSource = new ActionSourceListener(actionName){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                if (GridTable.this.list == null) {
                    return;
                }
                String want = e.getValue().toString();
                int count = 0;
                for (Row row : GridTable.this.list) {
                    if (want.equals(row.gg.getFullName())) {
                        GridTable.this.eventOK = false;
                        GridTable.this.table.setSelected(count);
                        GridTable.this.eventOK = true;
                        break;
                    }
                    ++count;
                }
            }
        };
        this.table.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Row row;
                if (GridTable.this.eventOK && !e.getValueIsAdjusting() && (row = (Row)GridTable.this.table.getSelected()) != null) {
                    if (GridTable.this.debug) {
                        System.out.println(" GridTable new gg = " + row.gg.getFullName());
                    }
                    GridTable.this.actionSource.fireActionValueEvent("selected", row.gg.getFullName());
                }
            }
        });
    }

    public void setDataset(List<GridDatatype> fields) {
        if (fields == null) {
            return;
        }
        this.list = new ArrayList(fields.size());
        for (GridDatatype gg : fields) {
            this.list.add(new Row(gg));
        }
        this.table.setList(this.list);
    }

    public JPanel getPanel() {
        return this.table;
    }

    public ActionSourceListener getActionSourceListener() {
        return this.actionSource;
    }

    private class Row
    extends TableRowAbstract {
        GridDatatype gg;
        String dims;

        Row(GridDatatype gg) {
            this.gg = gg;
            Formatter f = new Formatter();
            for (Dimension dim : gg.getDimensions()) {
                f.format("%s ", dim.getName());
            }
            this.dims = f.toString();
        }

        @Override
        public Object getUserObject() {
            return this.gg;
        }

        @Override
        public Object getValueAt(int col) {
            switch (col) {
                case 0: {
                    return this.gg.getFullName();
                }
                case 1: {
                    return this.dims;
                }
                case 2: {
                    return this.gg.getUnitsString();
                }
                case 3: {
                    return this.gg.getDescription();
                }
            }
            return "error";
        }
    }
}

