/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grid;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.ui.event.ActionSourceListener;
import ucar.nc2.ui.event.ActionValueEvent;

public class VertScaleSlider
extends JPanel {
    private JSlider slider;
    private ActionSourceListener actionSource;
    private String actionName = "level";
    private boolean eventOK = true;
    private int incrY = 1;
    private int currentIdx = -1;
    private double min;
    private double max;
    private double scale = 1.0;
    private CoordinateAxis1D zAxis;
    private static boolean debugEvent = false;
    private static boolean debugLevels = false;
    private int pos = -1;

    public VertScaleSlider() {
        this.setLayout(new BoxLayout(this, 0));
        this.slider = new JSlider(1, 0, 100, 0);
        this.slider.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (VertScaleSlider.this.eventOK && VertScaleSlider.this.zAxis != null && !VertScaleSlider.this.slider.getValueIsAdjusting()) {
                    int pos = VertScaleSlider.this.slider.getValue();
                    int idx = VertScaleSlider.this.slider2index(pos);
                    if (idx == VertScaleSlider.this.currentIdx) {
                        return;
                    }
                    VertScaleSlider.this.currentIdx = idx;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VertScaleSlider.this.setSelectedIndex(VertScaleSlider.this.currentIdx);
                            VertScaleSlider.this.actionSource.fireActionValueEvent(VertScaleSlider.this.actionName, VertScaleSlider.this.zAxis.getCoordName(VertScaleSlider.this.currentIdx));
                        }
                    });
                }
            }
        });
        this.actionSource = new ActionSourceListener(this.actionName){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                if (debugEvent) {
                    System.out.println(" actionSource event " + e);
                }
                VertScaleSlider.this.setSelectedByName(e.getValue().toString());
            }
        };
        this.slider.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                VertScaleSlider.this.setLabels();
            }
        });
        this.add(this.slider);
    }

    public ActionSourceListener getActionSourceListener() {
        return this.actionSource;
    }

    public void setLevels(GridCoordSystem gcs, int current) {
        this.zAxis = gcs.getVerticalAxis();
        if (this.zAxis == null) {
            this.slider.setEnabled(false);
            return;
        }
        this.slider.setEnabled(true);
        this.slider.setInverted(!gcs.isZPositive());
        this.slider.setToolTipText(this.zAxis.getUnitsString());
        this.setSelectedIndex(current);
        int n = (int)this.zAxis.getSize();
        if (this.zAxis.isContiguous()) {
            this.min = Math.min(this.zAxis.getCoordEdge(0), this.zAxis.getCoordEdge(n));
            this.max = Math.max(this.zAxis.getCoordEdge(0), this.zAxis.getCoordEdge(n));
        } else {
            this.min = this.zAxis.getMinValue();
            this.max = this.zAxis.getMaxValue();
        }
        this.setLabels();
        this.slider.setPaintLabels(true);
    }

    private void setLabels() {
        Rectangle bounds = this.slider.getBounds();
        if (debugEvent) {
            System.out.println(" setLevels Bounds= " + bounds);
        }
        double h = bounds.getHeight() > 0.0 ? bounds.getHeight() : 100.0;
        double wh = this.max - this.min > 0.0 ? this.max - this.min : 1.0;
        this.scale = 100.0 / wh;
        double slider2pixel = h / 100.0;
        Font font = this.slider.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        if (fontMetrics != null) {
            this.incrY = fontMetrics.getAscent();
        }
        if (debugEvent) {
            System.out.println(" scale= " + this.scale + " incrY = " + this.incrY);
        }
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        if (this.zAxis == null) {
            return;
        }
        int n = (int)this.zAxis.getSize();
        int last = this.world2slider(this.zAxis.getCoordValue(n - 1));
        labelTable.put(new Integer(last), new JLabel(this.zAxis.getCoordName(n - 1)));
        int next = this.world2slider(this.zAxis.getCoordValue(0));
        labelTable.put(new Integer(next), new JLabel(this.zAxis.getCoordName(0)));
        if (debugLevels) {
            System.out.println("level = " + slider2pixel * (double)next + " " + this.zAxis.getCoordName(0) + " added ");
        }
        for (int i = 1; i < n - 1; ++i) {
            int ival = this.world2slider(this.zAxis.getCoordValue(i));
            if (debugLevels) {
                System.out.println("level = " + slider2pixel * (double)ival + " " + this.zAxis.getCoordName(i));
            }
            if (!(slider2pixel * (double)Math.abs(ival - last) > (double)this.incrY) || !(slider2pixel * (double)Math.abs(ival - next) > (double)this.incrY)) continue;
            labelTable.put(new Integer(ival), new JLabel(this.zAxis.getCoordName(i)));
            next = ival;
            if (!debugLevels) continue;
            System.out.println("  added ");
        }
        if (debugLevels) {
            System.out.println("level = " + slider2pixel * (double)last + " " + this.zAxis.getCoordName(n - 1) + " added ");
        }
        this.slider.setLabelTable(labelTable);
    }

    private int world2slider(double val) {
        return (int)(this.scale * (val - this.min));
    }

    private double slider2world(int pval) {
        return (double)pval / this.scale + this.min;
    }

    private int slider2index(int pval) {
        this.pos = this.zAxis.findCoordElement(this.slider2world(pval), this.pos);
        return this.pos;
    }

    private void setSelectedByName(String name) {
        if (this.zAxis == null) {
            return;
        }
        int i = 0;
        while ((long)i < this.zAxis.getSize()) {
            if (name.equals(this.zAxis.getCoordName(i))) {
                this.setSelectedIndex(i);
                return;
            }
            ++i;
        }
        System.out.println("ERROR VertScaleSlider cant find = " + name);
    }

    private void setSelectedIndex(int idx) {
        if (this.zAxis == null) {
            return;
        }
        this.eventOK = false;
        this.currentIdx = idx;
        this.slider.setValue(this.world2slider(this.zAxis.getCoordValue(this.currentIdx)));
        this.eventOK = true;
    }
}

