/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.point;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ucar.nc2.ui.gis.SpatialGrid;
import ucar.nc2.ui.util.Renderer;
import ucar.nc2.ui.widget.FontUtil;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.Station;

class StationRenderer
implements Renderer {
    private List<StationUI> stations = new ArrayList<StationUI>();
    private HashMap<String, StationUI> stationHash = new HashMap();
    private SpatialGrid stationGrid;
    private ProjectionImpl project = null;
    private AffineTransform world2Normal;
    private Color color = Color.black;
    private int circleRadius = 5;
    private Rectangle2D circleBB;
    private Rectangle2D typicalBB = this.circleBB = new Rectangle2D.Double(-this.circleRadius, -this.circleRadius, 2 * this.circleRadius, 2 * this.circleRadius);
    private FontUtil.StandardFont textFont;
    private StationUI selected = null;
    private Point2D.Double ptN = new Point2D.Double();
    private boolean declutter = true;
    private boolean posWasCalc = false;
    private boolean debug = false;

    public StationRenderer() {
        this.stationGrid = new SpatialGrid(50, 30);
        this.stationGrid.setOverlap(10);
        this.textFont = FontUtil.getStandardFont(10);
    }

    public void incrFontSize() {
        this.textFont.incrFontSize();
    }

    public void decrFontSize() {
        this.textFont.decrFontSize();
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public LatLonRect getPreferredArea() {
        return null;
    }

    public void setStations(List<Station> stns) {
        this.stations = new ArrayList<StationUI>(stns.size());
        this.stationHash.clear();
        for (int i = 0; i < stns.size(); ++i) {
            Station s = stns.get(i);
            StationUI sui = new StationUI(s);
            this.stations.add(sui);
            this.stationHash.put(s.getName(), sui);
        }
        this.posWasCalc = false;
        this.calcWorldPos();
    }

    public void setSelectedStation(String name) {
        StationUI sui = this.stationHash.get(name);
        if (sui != null) {
            this.setSelectedStation(sui);
        }
    }

    private void setSelectedStation(StationUI sui) {
        if (this.selected != null) {
            this.selected.selected = false;
            this.selected = null;
        }
        if (sui != null) {
            this.selected = sui;
            this.selected.selected = true;
        }
    }

    public void setDeclutter(boolean declut) {
        this.declutter = declut;
    }

    public boolean getDeclutter() {
        return this.declutter;
    }

    @Override
    public void setProjection(ProjectionImpl project) {
        this.project = project;
        this.calcWorldPos();
    }

    private void calcWorldPos() {
        if (this.project == null) {
            return;
        }
        for (int i = 0; i < this.stations.size(); ++i) {
            StationUI s = this.stations.get(i);
            s.worldPos.setLocation(this.project.latLonToProj((LatLonPoint)s.latlonPos));
        }
        this.posWasCalc = true;
    }

    public Station pick(Point2D pickPt) {
        if (this.world2Normal == null || pickPt == null || this.stations.isEmpty()) {
            return null;
        }
        this.world2Normal.transform(pickPt, this.ptN);
        StationUI closest = (StationUI)this.stationGrid.findIntersection(this.ptN);
        this.setSelectedStation(closest);
        return this.getSelectedStation();
    }

    public Station pickClosest(Point2D pickPt) {
        if (this.world2Normal == null || pickPt == null || this.stations.isEmpty()) {
            return null;
        }
        this.world2Normal.transform(pickPt, this.ptN);
        StationUI closest = (StationUI)this.stationGrid.findClosest(this.ptN);
        if (this.debug) {
            System.out.println("closest= " + closest);
        }
        this.setSelectedStation(closest);
        return this.getSelectedStation();
    }

    public Station getSelectedStation() {
        return this.selected != null ? this.selected.ddStation : null;
    }

    public StationUI isOnStation(Point p) {
        return (StationUI)this.stationGrid.findIntersection(p);
    }

    @Override
    public void draw(Graphics2D g, AffineTransform normal2Device) {
        if (this.project == null || !this.posWasCalc) {
            return;
        }
        AffineTransform world2Device = g.getTransform();
        g.setTransform(normal2Device);
        try {
            this.world2Normal = normal2Device.createInverse();
            this.world2Normal.concatenate(world2Device);
        }
        catch (NoninvertibleTransformException e) {
            System.out.println(" RendSurfObs: NoninvertibleTransformException on " + normal2Device);
            return;
        }
        Object saveHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(1.0f));
        Rectangle2D bbox = (Rectangle2D)g.getClip();
        this.stationGrid.clear();
        this.stationGrid.setGrid(bbox, this.typicalBB.getWidth(), this.typicalBB.getHeight());
        g.setFont(this.textFont.getFont());
        g.setColor(this.color);
        if (this.selected != null) {
            this.selected.calcPos(this.world2Normal);
            this.stationGrid.markIfClear(this.selected.getBB(), this.selected);
            this.selected.draw(g);
        }
        for (int i = 0; i < this.stations.size(); ++i) {
            StationUI s = this.stations.get(i);
            s.calcPos(this.world2Normal);
            if (!this.stationGrid.markIfClear(s.getBB(), s) && this.declutter) continue;
            s.draw(g);
        }
        g.setTransform(world2Device);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, saveHint);
    }

    public class StationUI {
        private Station ddStation;
        private String id;
        private LatLonPointImpl latlonPos = new LatLonPointImpl();
        private ProjectionPointImpl worldPos = new ProjectionPointImpl();
        private Point2D.Double screenPos = new Point2D.Double();
        private Rectangle2D bb;
        private Rectangle2D bbPos = new Rectangle2D.Double();
        private boolean selected = false;

        StationUI(Station stn) {
            this.ddStation = stn;
            this.latlonPos.setLatitude(stn.getLatitude());
            this.latlonPos.setLongitude(stn.getLongitude());
            this.id = stn.getName();
            Dimension t = StationRenderer.this.textFont.getBoundingBox(this.id);
            this.bb = new Rectangle2D.Double(-StationRenderer.this.circleRadius, (double)(-StationRenderer.this.circleRadius) - t.getHeight(), t.getWidth(), t.getHeight());
            this.bb.add(StationRenderer.this.circleBB);
            StationRenderer.this.typicalBB = this.bb;
        }

        public String getID() {
            return this.id;
        }

        public Station getStation() {
            return this.ddStation;
        }

        public LatLonPoint getLatLon() {
            return this.latlonPos;
        }

        public ProjectionPointImpl getLocation() {
            return this.worldPos;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setIsSelected(boolean selected) {
            this.selected = selected;
        }

        public Rectangle2D getBB() {
            return this.bbPos;
        }

        boolean contains(Point p) {
            return this.bbPos.contains(p);
        }

        void calcPos(AffineTransform w2n) {
            w2n.transform((Point2D)this.worldPos, this.screenPos);
            this.bbPos.setRect(this.screenPos.getX() + this.bb.getX(), this.screenPos.getY() + this.bb.getY(), this.bb.getWidth(), this.bb.getHeight());
        }

        void draw(Graphics2D g) {
            g.setColor(this.selected ? Color.red : Color.black);
            this.drawCircle(g, this.screenPos);
            this.drawText(g, this.screenPos, this.id);
        }

        private void drawCircle(Graphics2D g, Point2D loc) {
            int x = (int)(loc.getX() - (double)StationRenderer.this.circleRadius);
            int y = (int)(loc.getY() - (double)StationRenderer.this.circleRadius);
            g.drawOval(x, y, 2 * StationRenderer.this.circleRadius, 2 * StationRenderer.this.circleRadius);
        }

        private void drawText(Graphics2D g, Point2D loc, String text) {
            int x = (int)(loc.getX() - (double)StationRenderer.this.circleRadius);
            int y = (int)(loc.getY() - (double)StationRenderer.this.circleRadius);
            g.drawString(text, x, y);
        }

        public String toString() {
            return this.id + ": " + this.ddStation.getName();
        }
    }
}

