/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.point;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TrajectoryObsDatatype;
import ucar.nc2.ui.util.Renderer;
import ucar.nc2.ui.widget.FontUtil;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;

public class TrajectoryRenderer
implements Renderer {
    private List<ObservationUI> obsUIlist = new ArrayList<ObservationUI>();
    private ProjectionImpl project = null;
    private Color color = Color.black;
    private Color selectedColor = Color.magenta;
    private int circleRadius = 3;
    private Rectangle2D circleBB = new Rectangle2D.Double(-this.circleRadius, -this.circleRadius, 2 * this.circleRadius, 2 * this.circleRadius);
    private FontUtil.StandardFont textFont = FontUtil.getStandardFont(10);
    private ObservationUI selected = null;
    private boolean declutter = true;
    private boolean posWasCalc = false;

    public void incrFontSize() {
        this.textFont.incrFontSize();
    }

    public void decrFontSize() {
        this.textFont.decrFontSize();
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public LatLonRect getPreferredArea() {
        return null;
    }

    public void setTrajectory(TrajectoryObsDatatype trajectory) throws IOException {
        int n = trajectory.getNumberPoints();
        this.obsUIlist = new ArrayList<ObservationUI>(n);
        for (int i = 0; i < n; ++i) {
            PointObsDatatype obs = trajectory.getPointObsData(i);
            ObservationUI sui = new ObservationUI(obs);
            this.obsUIlist.add(sui);
        }
        this.posWasCalc = false;
        this.calcWorldPos();
        this.selected = null;
    }

    public void setSelected(PointObsDatatype obs) {
        this.selected = null;
        for (int i = 0; i < this.obsUIlist.size(); ++i) {
            ObservationUI s = this.obsUIlist.get(i);
            if (!this.testPointObsDatatype(s.obs, obs)) continue;
            this.selected = s;
            break;
        }
    }

    private boolean testPointObsDatatype(PointObsDatatype obs1, PointObsDatatype obs2) {
        if (obs1.getObservationTime() != obs2.getObservationTime()) {
            return false;
        }
        EarthLocation loc1 = obs1.getLocation();
        EarthLocation loc2 = obs2.getLocation();
        if (loc1.getLatitude() != loc2.getLatitude()) {
            return false;
        }
        return loc1.getLongitude() == loc2.getLongitude();
    }

    public void setDeclutter(boolean declut) {
        this.declutter = declut;
    }

    public boolean getDeclutter() {
        return this.declutter;
    }

    @Override
    public void setProjection(ProjectionImpl project) {
        this.project = project;
        this.calcWorldPos();
    }

    private void calcWorldPos() {
        if (this.project == null) {
            return;
        }
        for (int i = 0; i < this.obsUIlist.size(); ++i) {
            ObservationUI s = this.obsUIlist.get(i);
            s.worldPos.setLocation(this.project.latLonToProj((LatLonPoint)s.latlonPos));
        }
        this.posWasCalc = true;
    }

    @Override
    public void draw(Graphics2D g, AffineTransform normal2Device) {
        AffineTransform world2Normal;
        if (this.project == null || !this.posWasCalc) {
            return;
        }
        AffineTransform world2Device = g.getTransform();
        g.setTransform(normal2Device);
        try {
            world2Normal = normal2Device.createInverse();
            world2Normal.concatenate(world2Device);
        }
        catch (NoninvertibleTransformException e) {
            System.out.println(" RendSurfObs: NoninvertibleTransformException on " + normal2Device);
            return;
        }
        Object saveHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setStroke(new BasicStroke(1.0f));
        g.setFont(this.textFont.getFont());
        g.setColor(this.color);
        int count = 0;
        int npts = this.obsUIlist.size();
        GeneralPath path = new GeneralPath(0, npts);
        for (int i = 0; i < npts; ++i) {
            ObservationUI s = this.obsUIlist.get(i);
            s.calcPos(world2Normal);
            s.draw(g);
            if (Double.isNaN(s.screenPos.getX())) {
                System.out.println("screenPos=" + s.screenPos + " world = " + s.worldPos);
                continue;
            }
            if (count == 0) {
                path.moveTo((float)s.screenPos.getX(), (float)s.screenPos.getY());
            } else {
                path.lineTo((float)s.screenPos.getX(), (float)s.screenPos.getY());
            }
            ++count;
        }
        g.setColor(this.color);
        g.draw(path);
        if (this.selected != null) {
            this.selected.draw(g);
        }
        g.setTransform(world2Device);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, saveHint);
    }

    public class ObservationUI {
        private PointObsDatatype obs;
        private LatLonPointImpl latlonPos = new LatLonPointImpl();
        private ProjectionPointImpl worldPos = new ProjectionPointImpl();
        private Point2D.Double screenPos = new Point2D.Double();
        private Rectangle2D bb;
        private Rectangle2D bbPos = new Rectangle2D.Double();

        ObservationUI(PointObsDatatype obs) {
            this.obs = obs;
            this.latlonPos.setLatitude(obs.getLocation().getLatitude());
            this.latlonPos.setLongitude(obs.getLocation().getLongitude());
            Dimension t = TrajectoryRenderer.this.textFont.getBoundingBox("O");
            this.bb = new Rectangle2D.Double(-TrajectoryRenderer.this.circleRadius, (double)(-TrajectoryRenderer.this.circleRadius) - t.getHeight(), t.getWidth(), t.getHeight());
            this.bb.add(TrajectoryRenderer.this.circleBB);
        }

        public PointObsDatatype getObservation() {
            return this.obs;
        }

        public LatLonPoint getLatLon() {
            return this.latlonPos;
        }

        public ProjectionPointImpl getLocation() {
            return this.worldPos;
        }

        public Rectangle2D getBB() {
            return this.bbPos;
        }

        boolean contains(Point p) {
            return this.bbPos.contains(p);
        }

        void calcPos(AffineTransform w2n) {
            w2n.transform((Point2D)this.worldPos, this.screenPos);
            this.bbPos.setRect(this.screenPos.getX() + this.bb.getX(), this.screenPos.getY() + this.bb.getY(), this.bb.getWidth(), this.bb.getHeight());
        }

        void draw(Graphics2D g) {
            if (this == TrajectoryRenderer.this.selected) {
                g.setColor(TrajectoryRenderer.this.selectedColor);
                this.fillCircle(g, this.screenPos);
                g.setColor(TrajectoryRenderer.this.color);
            } else {
                this.drawCircle(g, this.screenPos);
            }
        }

        private void drawCircle(Graphics2D g, Point2D loc) {
            int x = (int)(loc.getX() - (double)TrajectoryRenderer.this.circleRadius);
            int y = (int)(loc.getY() - (double)TrajectoryRenderer.this.circleRadius);
            g.drawOval(x, y, 2 * TrajectoryRenderer.this.circleRadius, 2 * TrajectoryRenderer.this.circleRadius);
        }

        private void fillCircle(Graphics2D g, Point2D loc) {
            int x = (int)(loc.getX() - (double)TrajectoryRenderer.this.circleRadius);
            int y = (int)(loc.getY() - (double)TrajectoryRenderer.this.circleRadius);
            g.fillOval(x, y, 2 * TrajectoryRenderer.this.circleRadius, 2 * TrajectoryRenderer.this.circleRadius);
        }
    }
}

