/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs.ui;

import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import ucar.util.prefs.PersistenceManager;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;
import ucar.util.prefs.ui.ComboBox;
import ucar.util.prefs.ui.FieldValidator;
import ucar.util.prefs.ui.FldInputVerifier;

public abstract class Field {
    protected String name;
    protected PersistenceManager storeData;
    protected EventListenerList listenerList = null;
    protected String label;
    protected Object validValue;
    protected Object previousValue;
    protected boolean showFormat = true;
    protected static final boolean debugPersistence = false;
    private ArrayList validators = new ArrayList();
    protected JPopupMenu popupMenu;

    protected Field(String name, String label, PersistenceManager storeData) {
        this.name = name;
        this.label = label;
        this.storeData = storeData;
        if (storeData != null) {
            storeData.addPreferenceChangeListener(new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    if (evt.getKey().equals(Field.this.getName())) {
                        Field.this.setNewValueFromStore();
                    }
                }
            });
        }
    }

    protected void finish() {
        this.addStandardPopups();
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public PersistenceManager getPersistenceManager() {
        return this.storeData;
    }

    public boolean isEnabled() {
        return this.getEditComponent().isEnabled();
    }

    public void setEnabled(boolean enable) {
        this.getEditComponent().setEnabled(enable);
    }

    public boolean isEditable() {
        return this.isEnabled();
    }

    public void setEditable(boolean editable) {
        this.setEnabled(editable);
    }

    public void setToolTipText(String tip) {
        this.getEditComponent().setToolTipText(tip);
    }

    public String getToolTipText() {
        return this.getEditComponent().getToolTipText();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(PropertyChangeListener.class, pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listenerList.remove(PropertyChangeListener.class, pcl);
    }

    public abstract JComponent getEditComponent();

    protected abstract boolean _validate(StringBuffer var1);

    protected abstract Object getEditValue();

    protected abstract void setEditValue(Object var1);

    protected abstract Object getStoreValue(Object var1);

    protected abstract void setStoreValue(Object var1);

    public JComponent getDeepEditComponent() {
        return this.getEditComponent();
    }

    public Object getValue() {
        return this.validValue;
    }

    public void setValue(Object newValue) {
        this.previousValue = this.getValue();
        this.validValue = newValue;
        this.setEditValue(newValue);
    }

    public void addValidator(FieldValidator v) {
        this.validators.add(v);
    }

    protected boolean validate(StringBuffer buff) {
        if (!this._validate(buff)) {
            return false;
        }
        Object editValue = this.getEditValue();
        for (FieldValidator v : this.validators) {
            if (v.validate(this, editValue, buff)) continue;
            return false;
        }
        if (this.acceptIfDifferent(editValue)) {
            this.setEditValue(this.validValue);
            this.sendEvent();
        }
        return true;
    }

    protected boolean accept(StringBuffer buff) {
        if (!this.validate(buff)) {
            return false;
        }
        if (this.acceptIfDifferent(this.getEditValue())) {
            this.setStoreValue(this.validValue);
            this.sendEvent();
        }
        return true;
    }

    protected boolean acceptIfDifferent(Object newValue) {
        if (newValue == null && this.validValue == null) {
            return false;
        }
        if (this.validValue != null && this.validValue.equals(newValue)) {
            return false;
        }
        this.previousValue = this.getValue();
        this.validValue = newValue;
        return true;
    }

    protected void restoreValue(Object defValue) {
        if (this.storeData != null) {
            this.validValue = this.getStoreValue(defValue);
            this.setEditValue(this.validValue);
        }
    }

    protected void setNewValueFromStore() {
        Object newValue = this.getStoreValue(this.validValue);
        if (this.acceptIfDifferent(newValue)) {
            this.setEditValue(newValue);
            this.sendEvent();
        }
    }

    protected void sendEvent() {
        if (this.listenerList != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, this.name, this.previousValue, this.getValue());
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
            }
        }
    }

    protected void next() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.getEditComponent());
    }

    protected void addStandardPopups() {
        this.addPopupMenuAction("restore", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Field fld = (Field)e.getSource();
                fld.setEditValue(Field.this.validValue);
            }
        });
    }

    public void addPopupMenuAction(String name, AbstractAction action) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.getDeepEditComponent().addMouseListener(new PopupTriggerListener(){

                @Override
                public void showPopup(MouseEvent e) {
                    Field.this.popupMenu.show(Field.this.getEditComponent(), e.getX(), e.getY());
                }
            });
        }
        this.popupMenu.add(new ActionWrapper(name, action));
    }

    private static void showFormatInfo(JFormattedTextField tf) {
        JFormattedTextField.AbstractFormatter ff = tf.getFormatter();
        System.out.println("AbstractFormatter  " + ff.getClass().getName());
        if (ff instanceof NumberFormatter) {
            NumberFormatter nf = (NumberFormatter)ff;
            Format f = nf.getFormat();
            System.out.println(" Format  = " + f.getClass().getName());
            if (f instanceof NumberFormat) {
                NumberFormat nfat = (NumberFormat)f;
                System.out.println(" getMinimumIntegerDigits=" + nfat.getMinimumIntegerDigits());
                System.out.println(" getMaximumIntegerDigits=" + nfat.getMaximumIntegerDigits());
                System.out.println(" getMinimumFractionDigits=" + nfat.getMinimumFractionDigits());
                System.out.println(" getMaximumFractionDigits=" + nfat.getMaximumFractionDigits());
            }
            if (f instanceof DecimalFormat) {
                DecimalFormat df = (DecimalFormat)f;
                System.out.println(" Pattern  = " + df.toPattern());
            }
        }
    }

    public static String dfrac(double d, int fixed_decimals) {
        return Field.formatDouble(d, 100, fixed_decimals).trim();
    }

    private static String formatDouble(double d, int min_sigFigs, int fixed_decimals) {
        StringBuffer fraction;
        StringBuffer number;
        String exponent;
        String mantissa;
        String unsigned;
        String sign;
        String s = java.lang.Double.toString(d);
        if (java.lang.Double.isNaN(d)) {
            return s;
        }
        if (s.startsWith("-") || s.startsWith("+")) {
            sign = s.substring(0, 1);
            unsigned = s.substring(1);
        } else {
            sign = "";
            unsigned = s;
        }
        int eInd = unsigned.indexOf(69);
        if (eInd == -1) {
            eInd = unsigned.indexOf(101);
        }
        if (eInd == -1) {
            mantissa = unsigned;
            exponent = "";
        } else {
            mantissa = unsigned.substring(0, eInd);
            exponent = unsigned.substring(eInd);
        }
        int dotInd = mantissa.indexOf(46);
        if (dotInd == -1) {
            number = new StringBuffer(mantissa);
            fraction = new StringBuffer("");
        } else {
            number = new StringBuffer(mantissa.substring(0, dotInd));
            fraction = new StringBuffer(mantissa.substring(dotInd + 1));
        }
        int numFigs = number.length();
        int fracFigs = fraction.length();
        if (fixed_decimals != -1) {
            if (fixed_decimals == 0) {
                fraction.setLength(0);
            } else if (fixed_decimals > fracFigs) {
                int want = fixed_decimals - fracFigs;
                for (int i = 0; i < want; ++i) {
                    fraction.append("0");
                }
            } else if (fixed_decimals < fracFigs) {
                int chop = fracFigs - fixed_decimals;
                fraction.setLength(fraction.length() - chop);
            }
            fracFigs = fixed_decimals;
        } else {
            int sigFigs;
            int i;
            if ((numFigs == 0 || number.toString().equals("0")) && fracFigs > 0) {
                numFigs = 0;
                number = new StringBuffer("");
                for (i = 0; i < fraction.length() && fraction.charAt(i) == '0'; ++i) {
                    --fracFigs;
                }
            }
            if (fracFigs == 0 && numFigs > 0) {
                for (i = number.length() - 1; i > 0 && number.charAt(i) == '0'; --i) {
                    --numFigs;
                }
            }
            if ((sigFigs = numFigs + fracFigs) > min_sigFigs) {
                int chop = Math.min(sigFigs - min_sigFigs, fracFigs);
                fraction.setLength(fraction.length() - chop);
                fracFigs -= chop;
            }
        }
        if (fraction.length() == 0) {
            return sign + number + exponent;
        }
        return sign + number + "." + fraction + exponent;
    }

    public static class BeanTable
    extends Field {
        protected BeanTableSorted table;

        public BeanTable(String fldName, String label, ArrayList defBeans, Class beanClass, PreferencesExt prefs, PersistenceManager storeData) {
            super(fldName, label, storeData);
            this.table = new BeanTableSorted(beanClass, prefs, true);
            if (storeData != null) {
                this.setEditValue(this.getStoreValue(defBeans));
            }
            this.finish();
        }

        @Override
        protected boolean _validate(StringBuffer buff) {
            return true;
        }

        @Override
        public JComponent getEditComponent() {
            return this.table;
        }

        @Override
        public JComponent getDeepEditComponent() {
            return this.table.getJTable();
        }

        @Override
        protected Object getEditValue() {
            return this.table.getBeans();
        }

        @Override
        protected void setEditValue(Object value) {
            if (value == null) {
                return;
            }
            this.table.setBeans((ArrayList)value);
        }

        @Override
        protected Object getStoreValue(Object defValue) {
            if (this.storeData == null) {
                return defValue;
            }
            return this.storeData.getList(this.name, (List)defValue);
        }

        @Override
        protected void setStoreValue(Object newValue) {
            if (this.storeData != null) {
                this.storeData.putList(this.name, (List)newValue);
            }
        }
    }

    public static class EnumCombo
    extends Field {
        protected ComboBox combo = new ComboBox(null, 0);

        public EnumCombo(String fldName, String label, Collection choices, PersistenceManager storeData) {
            super(fldName, label, storeData);
            this.combo.setItemList(choices);
            this.setEditValue(this.getStoreValue(null));
            this.finish();
            this.combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EnumCombo.this.validate(null);
                }
            });
        }

        @Override
        protected boolean _validate(StringBuffer buff) {
            return true;
        }

        @Override
        public JComponent getEditComponent() {
            return this.combo;
        }

        @Override
        public JComponent getDeepEditComponent() {
            return this.combo.getDeepEditComponent();
        }

        @Override
        protected Object getEditValue() {
            Object item = this.combo.getSelectedItem();
            if (item.equals("")) {
                return null;
            }
            return item;
        }

        @Override
        protected void setEditValue(Object value) {
            if (value == null) {
                this.combo.setSelectedItem("");
            } else {
                this.combo.setSelectedItem(value);
            }
        }

        @Override
        protected Object getStoreValue(Object defValue) {
            Object val = null;
            if (this.storeData != null) {
                val = this.storeData.getObject(this.name);
            }
            return val == null ? defValue : val;
        }

        @Override
        protected void setStoreValue(Object newValue) {
            if (this.storeData != null) {
                this.storeData.putObject(this.name, newValue);
            }
        }

        @Override
        public boolean isEditable() {
            return this.combo.isEditable();
        }

        @Override
        public void setEditable(boolean isEditable) {
            this.combo.setEditable(isEditable);
        }
    }

    public static class TextCombo
    extends Field {
        protected ComboBox combo;
        private boolean eventsOK = true;
        private boolean debugCombo = false;

        public TextCombo(String fldName, String label, Collection defValues, int n, PersistenceManager storeData) {
            super(fldName, label, storeData);
            this.combo = new ComboBox(storeData, n);
            ArrayList prevChoices = this.combo.getItemList();
            if (defValues != null) {
                for (Object o : defValues) {
                    if (prevChoices.contains(o)) continue;
                    prevChoices.add(o);
                }
                this.combo.setItemList(prevChoices);
            }
            if (this.combo.getItemCount() > 0) {
                this.combo.setSelectedIndex(0);
                this.validValue = this.combo.getItemAt(0);
            }
            this.finish();
        }

        @Override
        protected boolean _validate(StringBuffer buff) {
            return true;
        }

        @Override
        public JComponent getEditComponent() {
            return this.combo;
        }

        @Override
        protected Object getEditValue() {
            return this.combo.getItemList();
        }

        @Override
        public JComponent getDeepEditComponent() {
            return this.combo.getDeepEditComponent();
        }

        @Override
        protected void setEditValue(Object value) {
            if (value == null) {
                return;
            }
            this.eventsOK = false;
            this.combo.setItemList((List)value);
            this.eventsOK = true;
        }

        @Override
        protected Object getStoreValue(Object defValue) {
            return this.combo.getStoreValue(defValue);
        }

        @Override
        protected void setStoreValue(Object newValue) {
            this.combo.setStoreValue((List)newValue);
        }

        public String getText() {
            Object current = this.combo.getSelectedItem();
            return current.toString();
        }

        public void setText(String newValue) {
            newValue = newValue.trim();
            this.combo.addItem(newValue);
            this.accept(null);
        }

        @Override
        public void setValue(Object value) {
            this.combo.addItem(value);
            this.accept(null);
        }

        @Override
        public boolean isEditable() {
            return this.combo.isEditable();
        }

        @Override
        public void setEditable(boolean isEditable) {
            this.combo.setEditable(isEditable);
        }
    }

    public static class CheckBox
    extends Field {
        private JCheckBox checkbox;

        public CheckBox(String fldName, String label, boolean defValue, PersistenceManager storeData) {
            super(fldName, label, storeData);
            this.validValue = this.getStoreValue(new Boolean(defValue));
            this.checkbox = new JCheckBox();
            this.checkbox.setSelected(this.isSelected());
            this.finish();
        }

        @Override
        protected boolean _validate(StringBuffer buff) {
            return true;
        }

        @Override
        public JComponent getEditComponent() {
            return this.checkbox;
        }

        @Override
        protected Object getEditValue() {
            return new Boolean(this.checkbox.isSelected());
        }

        @Override
        protected void setEditValue(Object value) {
            boolean bv = value == null ? false : (Boolean)value;
            this.checkbox.setSelected(bv);
        }

        @Override
        protected void setStoreValue(Object value) {
            if (this.storeData != null) {
                this.storeData.putBoolean(this.name, ((Boolean)value).booleanValue());
            }
        }

        @Override
        protected Object getStoreValue(Object defValue) {
            if (this.storeData == null) {
                return defValue;
            }
            boolean def = defValue == null ? false : (Boolean)defValue;
            boolean bv = this.storeData.getBoolean(this.name, def);
            return new Boolean(bv);
        }

        public boolean isSelected() {
            return (Boolean)this.validValue;
        }

        public void setSelected(boolean v) {
            this.setValue(new Boolean(v));
        }
    }

    public static class Date
    extends Field {
        protected JFormattedTextField tf = new JFormattedTextField();

        public Date(String name, String label, java.util.Date defValue, PersistenceManager storeData) {
            super(name, label, storeData);
            this.validValue = this.getStoreValue(defValue);
            if (null == this.validValue) {
                this.validValue = new java.util.Date();
            }
            this.tf.setValue(this.validValue);
            this.tf.setInputVerifier(new FldInputVerifier(this.tf, this));
            try {
                JFormattedTextField.AbstractFormatter format = this.tf.getFormatter();
                this.setToolTipText("eg " + format.valueToString(new java.util.Date(234098876L)));
            }
            catch (ParseException e) {
                // empty catch block
            }
            this.finish();
        }

        @Override
        public JComponent getEditComponent() {
            return this.tf;
        }

        @Override
        protected boolean _validate(StringBuffer buff) {
            try {
                this.tf.commitEdit();
            }
            catch (ParseException e) {
                buff.append(this.label).append(" has invalid format: should be a date\n");
                return false;
            }
            return true;
        }

        @Override
        protected Object getEditValue() {
            String editValue = this.tf.getText().trim();
            if (editValue.length() == 0) {
                return null;
            }
            return this.tf.getValue();
        }

        @Override
        protected void setEditValue(Object value) {
            if (value == null) {
                this.tf.setValue("");
            } else {
                this.tf.setValue(value);
            }
        }

        @Override
        public boolean isEditable() {
            return this.tf.isEditable();
        }

        @Override
        public void setEditable(boolean isEditable) {
            this.tf.setEditable(isEditable);
        }

        @Override
        protected void setStoreValue(Object value) {
            if (this.storeData != null) {
                java.util.Date valueAsDate = (java.util.Date)value;
                this.storeData.putObject(this.name, (Object)new java.util.Date(valueAsDate.getTime()));
            }
        }

        @Override
        protected Object getStoreValue(Object defValue) {
            Object value2;
            Object value = defValue;
            if (this.storeData != null && (value2 = this.storeData.getObject(this.name)) != null) {
                value = value2;
            }
            if (value == null || !(value instanceof Date)) {
                return null;
            }
            java.util.Date valueAsDate = (java.util.Date)value;
            return new java.util.Date(valueAsDate.getTime());
        }

        public java.util.Date getDate() {
            return (java.util.Date)this.getValue();
        }

        public void setDate(java.util.Date newValue) {
            this.setValue(newValue);
        }
    }

    public static class Int
    extends Field {
        private JTextField tf;

        public Int(String name, String label, int defValue, PersistenceManager storeData) {
            super(name, label, storeData);
            this.validValue = this.getStoreValue(new Integer(defValue));
            this.tf = new JTextField();
            this.setEditValue(this.validValue);
            this.tf.setInputVerifier(new FldInputVerifier(this.tf, this));
            this.tf.setHorizontalAlignment(4);
            this.finish();
        }

        @Override
        protected boolean _validate(StringBuffer buff) {
            String editValue = this.tf.getText().trim();
            if (editValue.length() == 0) {
                return true;
            }
            try {
                Integer.parseInt(this.tf.getText());
            }
            catch (NumberFormatException e) {
                buff.append(this.label).append(" has invalid format: must be an integer number\n");
                return false;
            }
            return true;
        }

        @Override
        public JComponent getEditComponent() {
            return this.tf;
        }

        @Override
        protected Object getEditValue() {
            String editValue = this.tf.getText().trim();
            if (editValue.length() == 0) {
                return null;
            }
            try {
                return new Integer(this.tf.getText());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        protected void setEditValue(Object value) {
            if (value == null) {
                this.tf.setText("");
            } else {
                this.tf.setText(value.toString());
            }
        }

        @Override
        protected void setStoreValue(Object value) {
            if (this.storeData != null) {
                this.storeData.putInt(this.name, ((Integer)value).intValue());
            }
        }

        @Override
        protected Object getStoreValue(Object defValue) {
            int def;
            int value;
            if (this.storeData != null && (value = this.storeData.getInt(this.name, def = Integer.MAX_VALUE)) != def) {
                return new Integer(value);
            }
            return new Integer((Integer)defValue);
        }

        public int getInt() {
            return (Integer)this.getValue();
        }

        public void setInt(int value) {
            this.setValue(new Integer(value));
        }
    }

    public static class Double
    extends Field {
        private JTextField tf;
        private int nfracDig = 3;

        public Double(String name, String label, double defValue, int nfracDig, PersistenceManager storeData) {
            super(name, label, storeData);
            if (nfracDig >= 0) {
                this.nfracDig = nfracDig;
            }
            this.validValue = this.getStoreValue(new java.lang.Double(defValue));
            this.tf = new JTextField();
            this.setEditValue(this.validValue);
            this.tf.setInputVerifier(new FldInputVerifier(this.tf, this));
            this.tf.setHorizontalAlignment(4);
            this.finish();
        }

        @Override
        protected boolean _validate(StringBuffer buff) {
            String editValue = this.tf.getText().trim();
            if (editValue.length() == 0) {
                return true;
            }
            try {
                new java.lang.Double(editValue);
            }
            catch (NumberFormatException e) {
                if (buff != null) {
                    buff.append(this.label).append(" has invalid format: must be floating point number\n");
                }
                return false;
            }
            return true;
        }

        @Override
        public JComponent getEditComponent() {
            return this.tf;
        }

        @Override
        protected Object getEditValue() {
            String editValue = this.tf.getText().trim();
            if (editValue.length() == 0) {
                return null;
            }
            try {
                return new java.lang.Double(editValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        protected void setEditValue(Object value) {
            if (value == null) {
                this.tf.setText("");
            } else {
                double dv = (java.lang.Double)value;
                this.tf.setText(Double.dfrac(dv, this.nfracDig));
            }
        }

        @Override
        protected void setStoreValue(Object value) {
            if (this.storeData != null) {
                this.storeData.putDouble(this.name, ((java.lang.Double)value).doubleValue());
            }
        }

        @Override
        protected Object getStoreValue(Object defValue) {
            double def;
            double value;
            if (this.storeData != null && !java.lang.Double.isNaN(value = this.storeData.getDouble(this.name, def = java.lang.Double.NaN))) {
                return new java.lang.Double(value);
            }
            return new java.lang.Double((java.lang.Double)defValue);
        }

        public double getDouble() {
            return (java.lang.Double)this.getValue();
        }

        public void setDouble(double value) {
            this.setValue(new java.lang.Double(value));
        }
    }

    public static class Password
    extends Text {
        public Password(String name, String label, String defValue, PersistenceManager storeData) {
            super(name, label, storeData);
            this.validValue = this.getStoreValue(defValue);
            this.tf = new JPasswordField((String)this.validValue);
            this.finish();
        }

        public char[] getPassword() {
            return ((JPasswordField)this.tf).getPassword();
        }
    }

    public static class TextArea
    extends Text {
        public TextArea(String name, String label, String defValue, int nrows, PersistenceManager storeData) {
            super(name, label, storeData);
            this.validValue = this.getStoreValue(defValue);
            JTextArea ta = new JTextArea((String)this.validValue);
            ta.setLineWrap(true);
            ta.setWrapStyleWord(true);
            ta.setRows(nrows);
            this.tf = ta;
            this.finish();
        }
    }

    public static class Text
    extends Field {
        protected JTextComponent tf;

        protected Text(String name, String label, PersistenceManager storeData) {
            super(name, label, storeData);
        }

        public Text(String name, String label, String defValue, PersistenceManager storeData) {
            this(name, label, storeData);
            this.validValue = this.getStoreValue(defValue);
            this.tf = new JTextField((String)this.validValue);
            this.finish();
        }

        @Override
        public JComponent getEditComponent() {
            return this.tf;
        }

        @Override
        public boolean isEditable() {
            return this.tf.isEditable();
        }

        @Override
        public void setEditable(boolean isEditable) {
            this.tf.setEditable(isEditable);
        }

        @Override
        protected boolean _validate(StringBuffer buff) {
            return true;
        }

        @Override
        protected Object getEditValue() {
            String editValue = this.tf.getText().trim();
            if (editValue.length() == 0) {
                return null;
            }
            return this.normalize(editValue);
        }

        @Override
        protected void setEditValue(Object value) {
            if (value == null) {
                this.tf.setText("");
            } else {
                this.tf.setText((String)value);
            }
        }

        @Override
        protected void setStoreValue(Object value) {
            if (this.storeData != null) {
                this.storeData.put(this.name, (String)value);
            }
        }

        @Override
        protected Object getStoreValue(Object defValue) {
            if (this.storeData != null) {
                return this.storeData.get(this.name, (String)defValue);
            }
            return defValue;
        }

        public String getText() {
            return this.normalize((String)this.getValue());
        }

        public void setText(String newValue) {
            this.setValue(newValue);
        }

        protected String normalize(String s) {
            if (s == null) {
                return null;
            }
            String trimValue = s.trim();
            return trimValue.length() > 0 ? trimValue : s;
        }
    }

    private static abstract class PopupTriggerListener
    extends MouseAdapter {
        private PopupTriggerListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public abstract void showPopup(MouseEvent var1);
    }

    private class ActionWrapper
    extends AbstractAction {
        private AbstractAction orgAct;

        ActionWrapper(String name, AbstractAction act) {
            this.orgAct = act;
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionEvent me = new ActionEvent(Field.this, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
            this.orgAct.actionPerformed(me);
        }
    }
}

