/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import thredds.inventory.CollectionManager;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class ReportPanel
extends JPanel {
    protected PreferencesExt prefs;
    protected TextHistoryPane reportPane;
    protected JPanel buttPanel;

    protected ReportPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.buttPanel = buttPanel;
        this.reportPane = new TextHistoryPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.reportPane, "Center");
    }

    public void save() {
    }

    public void showInfo(Formatter f) {
    }

    protected boolean setCollection(String spec) {
        Formatter f = new Formatter();
        f.format("collection = %s%n", spec);
        boolean hasFiles = false;
        CollectionManager dcm = this.getCollection(spec, f);
        if (dcm == null) {
            return false;
        }
        for (MFile mfile : dcm.getFiles()) {
            f.format(" %s%n", mfile.getPath());
            hasFiles = true;
        }
        this.reportPane.setText(f.toString());
        this.reportPane.gotoTop();
        return hasFiles;
    }

    CollectionManager getCollection(String spec, Formatter f) {
        MFileCollectionManager dc = null;
        try {
            dc = MFileCollectionManager.open((String)spec, null, (Formatter)f);
            dc.scan(false);
        }
        catch (Exception e) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            e.printStackTrace(new PrintStream(bos));
            this.reportPane.setText(bos.toString());
            return null;
        }
        return dc;
    }

    protected class CounterS {
        Map<String, Integer> set = new HashMap<String, Integer>();
        String name;

        CounterS(String name) {
            this.name = name;
        }

        void count(String value) {
            Integer count = this.set.get(value);
            if (count == null) {
                this.set.put(value, 1);
            } else {
                this.set.put(value, count + 1);
            }
        }

        void show(Formatter f) {
            f.format("%n%s%n", this.name);
            ArrayList<String> list = new ArrayList<String>(this.set.keySet());
            Collections.sort(list);
            for (String key : list) {
                int count = this.set.get(key);
                f.format("   %10s: count = %d%n", key, count);
            }
        }
    }

    protected class Counter {
        Map<Integer, Integer> set = new HashMap<Integer, Integer>();
        String name;

        Counter(String name) {
            this.name = name;
        }

        void reset() {
            this.set = new HashMap<Integer, Integer>();
        }

        void count(int value) {
            Integer count = this.set.get(value);
            if (count == null) {
                this.set.put(value, 1);
            } else {
                this.set.put(value, count + 1);
            }
        }

        void show(Formatter f) {
            f.format("%n%s%n", this.name);
            ArrayList<Integer> list = new ArrayList<Integer>(this.set.keySet());
            Collections.sort(list);
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                int template = (Integer)i$.next();
                int count = this.set.get(template);
                f.format("   %3d: count = %d%n", template, count);
            }
        }
    }
}

