/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.image;

import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JOptionPane;
import org.imgscalr.Scalr;
import ucar.nc2.ui.image.PictureCache;
import ucar.nc2.ui.image.ScalablePictureListener;
import ucar.nc2.ui.image.ScaleThread;
import ucar.nc2.ui.image.SourcePicture;
import ucar.nc2.ui.image.SourcePictureListener;
import ucar.nc2.ui.image.Tools;

public class ScalablePicture
implements SourcePictureListener {
    public SourcePicture sourcePicture;
    public BufferedImage scaledPicture = null;
    private double ScaleFactor;
    public URL imageUrl = null;
    private int pictureStatusCode;
    private String pictureStatusMessage;
    private boolean scaleToSize;
    private Dimension TargetSize;
    public static final int UNINITIALISED = 8;
    public static final int GARBAGE_COLLECTION = 9;
    public static final int LOADING = 10;
    public static final int LOADED = 11;
    public static final int SCALING = 12;
    public static final int READY = 13;
    public static final int ERROR = 14;
    private Vector scalablePictureStatusListeners = new Vector();
    public float jpgQuality = 0.8f;
    public boolean fastScale = false;
    private static RenderingHints rh_quality = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    private static RenderingHints rh_bicubic = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    public boolean scaleAfterLoad = false;

    public ScalablePicture() {
        this.setStatus(8, "Creating uninitialised ScalablePicture object.");
        this.setScaleFactor(1.0);
    }

    public void loadAndScalePictureInThread(URL imageUrl, int priority, double rotation) {
        this.imageUrl = imageUrl;
        boolean alreadyLoading = false;
        Tools.log("ScalablePicture.loadAndScalePictureInThread: checking if picture " + imageUrl + " is already being loaded.");
        if (this.sourcePicture != null && this.sourcePicture.getUrl().equals(imageUrl)) {
            Tools.log("ScalablePicture.loadAndScalePictureInThread: the SourcePicture is already loading the sourcePictureimage");
            alreadyLoading = true;
        } else if (PictureCache.isInCache(imageUrl)) {
            if (this.sourcePicture != null) {
                this.sourcePicture.removeListener(this);
            }
            this.sourcePicture = PictureCache.getSourcePicture(imageUrl);
            String status = this.sourcePicture.getStatusMessage();
            if (status == null) {
                status = "";
            }
            Tools.log("ScalablePicture.loadAndScalePictureInThread: Picture in cache! Status: " + status);
            if (this.sourcePicture.getRotation() == rotation) {
                alreadyLoading = true;
                Tools.log("ScalablePicture.loadAndScalePictureInThread: Picture was even rotated to the correct angle!");
            } else {
                alreadyLoading = false;
                Tools.log("ScalablePicture.loadAndScalePictureInThread: Picture was in cache but with wrong rotation. Forcing reload.");
            }
        }
        if (alreadyLoading) {
            switch (this.sourcePicture.getStatusCode()) {
                case 0: {
                    alreadyLoading = false;
                    Tools.log("ScalablePicture.loadAndScalePictureInThread: pictureStatus was: UNINITIALISED");
                    break;
                }
                case 4: {
                    alreadyLoading = false;
                    Tools.log("ScalablePicture.loadAndScalePictureInThread: pictureStatus was: ERROR");
                    break;
                }
                case 1: {
                    Tools.log("ScalablePicture.loadAndScalePictureInThread: pictureStatus was: LOADING");
                    this.sourcePicture.addListener(this);
                    this.setStatus(10, "Loading: " + imageUrl.toString());
                    this.sourceLoadProgressNotification(6, this.sourcePicture.getPercentLoaded());
                    this.scaleAfterLoad = true;
                    break;
                }
                case 2: {
                    Tools.log("ScalablePicture.loadAndScalePictureInThread: pictureStatus was: ROTATING");
                    this.setStatus(10, "Rotating: " + imageUrl.toString());
                    this.sourceLoadProgressNotification(6, this.sourcePicture.getPercentLoaded());
                    this.scaleAfterLoad = true;
                    break;
                }
                case 3: {
                    Tools.log("ScalablePicture.loadAndScalePictureInThread: pictureStatus was: READY. Sending SCALING status.");
                    this.setStatus(12, "Scaling: " + imageUrl.toString());
                    this.createScaledPictureInThread(priority);
                    break;
                }
                default: {
                    Tools.log("ScalablePicture.loadAndScalePictureInThread: Don't know what status this is:" + Integer.toString(this.sourcePicture.getStatusCode()));
                }
            }
        }
        if (!alreadyLoading) {
            if (this.sourcePicture != null) {
                this.sourcePicture.removeListener(this);
            }
            this.sourcePicture = new SourcePicture();
            this.sourcePicture.addListener(this);
            this.setStatus(10, "Loading: " + imageUrl.toString());
            this.scaleAfterLoad = true;
            this.sourcePicture.loadPictureInThread(imageUrl, priority, rotation);
        }
    }

    public void loadPictureImd(URL imageUrl, double rotation) {
        Tools.log("loadPictureImd invoked with URL: " + imageUrl.toString());
        if (this.sourcePicture != null) {
            this.sourcePicture.removeListener(this);
        }
        this.sourcePicture = new SourcePicture();
        this.sourcePicture.addListener(this);
        this.setStatus(10, "Loading: " + imageUrl.toString());
        this.scaleAfterLoad = true;
        this.sourcePicture.loadPicture(imageUrl, rotation);
    }

    public void stopLoadingExcept(URL url) {
        if (this.sourcePicture != null) {
            boolean isCurrentlyLoading = this.sourcePicture.stopLoadingExcept(url);
            if (!isCurrentlyLoading) {
                // empty if block
            }
            PictureCache.stopBackgroundLoadingExcept(url);
        }
    }

    @Override
    public void sourceStatusChange(int statusCode, String statusMessage, SourcePicture sp) {
        switch (statusCode) {
            case 0: {
                Tools.log("ScalablePicture.sourceStatusChange: pictureStatus was: UNINITIALISED message: " + statusMessage);
                this.setStatus(8, statusMessage);
                break;
            }
            case 4: {
                Tools.log("ScalablePicture.sourceStatusChange: pictureStatus was: ERROR message: " + statusMessage);
                this.setStatus(14, statusMessage);
                this.sourcePicture.removeListener(this);
                break;
            }
            case 1: {
                Tools.log("ScalablePicture.sourceStatusChange: pictureStatus was: LOADING message: " + statusMessage);
                this.setStatus(10, statusMessage);
                break;
            }
            case 2: {
                Tools.log("ScalablePicture.sourceStatusChange: pictureStatus was: ROTATING message: " + statusMessage);
                this.setStatus(10, statusMessage);
                break;
            }
            case 3: {
                Tools.log("ScalablePicture.sourceStatusChange: pictureStatus was: READY message: " + statusMessage);
                this.setStatus(11, statusMessage);
                this.sourcePicture.removeListener(this);
                if (!this.scaleAfterLoad) break;
                this.createScaledPictureInThread(10);
                this.scaleAfterLoad = false;
                break;
            }
            default: {
                Tools.log("ScalablePicture.sourceStatusChange: Don't recognize this status: " + statusMessage);
            }
        }
    }

    @Override
    public void sourceLoadProgressNotification(int statusCode, int percentage) {
        Enumeration e = this.scalablePictureStatusListeners.elements();
        while (e.hasMoreElements()) {
            ((ScalablePictureListener)e.nextElement()).sourceLoadProgressNotification(statusCode, percentage);
        }
    }

    public void createScaledPictureInThread(int priority) {
        this.setStatus(12, "Scaling picture.");
        ScaleThread t = new ScaleThread(this);
        t.setPriority(priority);
        t.start();
    }

    public void scalePicture() {
        if (this.sourcePicture == null || this.sourcePicture.getSourceBufferedImage() == null) {
            this.ScaleFactor = 1.0;
            return;
        }
        this.setStatus(12, "Scaling picture.");
        BufferedImage org = this.sourcePicture.getSourceBufferedImage();
        int w = this.sourcePicture.getWidth();
        int h = this.sourcePicture.getHeight();
        this.calcScale();
        this.scaledPicture = Scalr.resize((BufferedImage)org, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)((int)(this.ScaleFactor * (double)w)), (int)((int)(this.ScaleFactor * (double)h)), (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        this.setStatus(13, "Scaled Picture is ready.");
    }

    private void calcScale() {
        if (this.TargetSize == null) {
            return;
        }
        int WindowWidth = this.TargetSize.width;
        int WindowHeight = this.TargetSize.height;
        int PictureWidth = this.sourcePicture.getWidth();
        int PictureHeight = this.sourcePicture.getHeight();
        this.ScaleFactor = WindowWidth == 0 || WindowHeight == 0 ? 1.0 : ((double)PictureHeight / (double)WindowHeight > (double)PictureWidth / (double)WindowWidth ? (double)WindowHeight / (double)PictureHeight : (double)WindowWidth / (double)PictureWidth);
    }

    public void scalePictureOld() {
        Tools.log("ScalablePicture.scalePicture invoked");
        try {
            this.setStatus(12, "Scaling picture.");
            if (this.sourcePicture != null && this.sourcePicture.getSourceBufferedImage() != null) {
                int PictureHeight;
                int PictureWidth;
                if (this.scaleToSize) {
                    int WindowWidth = this.TargetSize.width;
                    int WindowHeight = this.TargetSize.height;
                    Tools.log("ScalablePicture.scalePicture: scaleToSize: Windowsize: " + Integer.toString(WindowWidth) + "x" + Integer.toString(WindowHeight));
                    PictureWidth = this.sourcePicture.getWidth();
                    PictureHeight = this.sourcePicture.getHeight();
                    this.ScaleFactor = WindowWidth == 0 || WindowHeight == 0 ? 1.0 : ((double)PictureHeight / (double)WindowHeight > (double)PictureWidth / (double)WindowWidth ? (double)WindowHeight / (double)PictureHeight : (double)WindowWidth / (double)PictureWidth);
                }
                Tools.log("ScalablePicture.scalePicture: doing an AffineTransform with Factor: " + Double.toString(this.ScaleFactor));
                AffineTransform af = AffineTransform.getScaleInstance(this.ScaleFactor, this.ScaleFactor);
                AffineTransformOp op = this.fastScale ? new AffineTransformOp(af, 1) : new AffineTransformOp(af, 2);
                this.scaledPicture = op.filter(this.sourcePicture.getSourceBufferedImage(), null);
                PictureWidth = this.scaledPicture.getWidth();
                PictureHeight = this.scaledPicture.getHeight();
                this.setStatus(13, "Scaled Picture is ready.");
            } else {
                if (this.getStatusCode() == 10) {
                    Tools.log("ScalablePicture.scalePicture invoked while image is still loading. I wonder why?");
                    return;
                }
                this.setStatus(14, "Could not scale image as SourceImage is null.");
            }
        }
        catch (OutOfMemoryError e) {
            Tools.log("ScalablePicture.scalePicture caught an OutOfMemoryError while scaling an image.\n" + e.getMessage());
            this.setStatus(14, "Out of Memory Error while scaling " + this.imageUrl.toString());
            this.scaledPicture = null;
            PictureCache.clear();
            JOptionPane.showMessageDialog(null, "outOfMemoryError", "genericError", 0);
            System.gc();
            System.runFinalization();
            Tools.log("ScalablePicture.scalePicture: JPO has now run a garbage collection and finalization.");
        }
        catch (Exception e) {
            System.out.println("Exception in ScalablePicture.scalePicture" + e);
        }
    }

    public void setScaleFactor(double newFactor) {
        this.scaleToSize = false;
        this.TargetSize = null;
        this.ScaleFactor = newFactor;
    }

    public void setScaleSize(Dimension newSize) {
        this.scaleToSize = true;
        this.TargetSize = newSize;
    }

    public double getScaleFactor() {
        return this.ScaleFactor;
    }

    public Dimension getScaleSize() {
        return this.TargetSize;
    }

    public BufferedImage getScaledPicture() {
        return this.scaledPicture;
    }

    public Dimension getScaledSize() {
        if (this.scaledPicture != null) {
            return new Dimension(this.scaledPicture.getWidth(), this.scaledPicture.getHeight());
        }
        return new Dimension(0, 0);
    }

    public String getScaledSizeString() {
        if (this.scaledPicture != null) {
            return Integer.toString(this.scaledPicture.getWidth()) + " x " + Integer.toString(this.scaledPicture.getHeight());
        }
        return "0 x 0";
    }

    public int getScaledHeight() {
        if (this.scaledPicture != null) {
            return this.scaledPicture.getHeight();
        }
        return 0;
    }

    public int getScaledWidth() {
        if (this.scaledPicture != null) {
            return this.scaledPicture.getWidth();
        }
        return 0;
    }

    public BufferedImage getOriginalImage() {
        return this.sourcePicture.getSourceBufferedImage();
    }

    public SourcePicture getSourcePicture() {
        return this.sourcePicture.getSourcePicture();
    }

    public SourcePicture setSourcePicture(SourcePicture source) {
        this.sourcePicture = source;
        return this.sourcePicture;
    }

    public Dimension getOriginalSize() {
        return this.sourcePicture.getSize();
    }

    public int getOriginalHeight() {
        return this.sourcePicture.getHeight();
    }

    public int getOriginalWidth() {
        return this.sourcePicture.getWidth();
    }

    public String getFilename() {
        return this.imageUrl == null ? "" : this.imageUrl.toString();
    }

    public void writeScaledJpg(File writeFile) {
        ScalablePicture.writeJpg(writeFile, this.scaledPicture, this.jpgQuality);
    }

    public static void writeJpg(File writeFile, RenderedImage renderedImage, float jpgQuality) {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpg");
        ImageWriter writer = writers.next();
        JPEGImageWriteParam params = new JPEGImageWriteParam(null);
        params.setCompressionMode(2);
        params.setCompressionQuality(jpgQuality);
        params.setProgressiveMode(0);
        params.setDestinationType(new ImageTypeSpecifier(IndexColorModel.getRGBdefault(), IndexColorModel.getRGBdefault().createCompatibleSampleModel(16, 16)));
        try {
            ImageOutputStream ios = ImageIO.createImageOutputStream(new FileOutputStream(writeFile));
            writer.setOutput(ios);
            writer.write(null, new IIOImage(renderedImage, null, null), params);
            ios.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        writer.dispose();
    }

    public void addStatusListener(ScalablePictureListener listener) {
        this.scalablePictureStatusListeners.add(listener);
    }

    public void removeStatusListener(ScalablePictureListener listener) {
        this.scalablePictureStatusListeners.remove(listener);
    }

    private void setStatus(int statusCode, String statusMessage) {
        String filename = this.imageUrl == null ? "" : this.imageUrl.toString();
        Tools.log("ScalablePicture.setStatus: sending: " + statusMessage + " to all Listeners from Image: " + filename);
        this.pictureStatusCode = statusCode;
        this.pictureStatusMessage = statusMessage;
        Enumeration e = this.scalablePictureStatusListeners.elements();
        while (e.hasMoreElements()) {
            ((ScalablePictureListener)e.nextElement()).scalableStatusChange(this.pictureStatusCode, this.pictureStatusMessage);
        }
    }

    public int getStatusCode() {
        return this.pictureStatusCode;
    }

    public String getStatusMessage() {
        return this.pictureStatusMessage;
    }

    public void setJpgQuality(float quality) {
        if (quality >= 0.0f && quality <= 1.0f) {
            this.jpgQuality = quality;
        }
    }

    public void setFastScale() {
        this.fastScale = true;
    }

    public void setQualityScale() {
        this.fastScale = false;
    }
}

