/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Authenticator;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import org.apache.http.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.writer.DataFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManagerAbstract;
import thredds.inventory.StoreKeyValue;
import thredds.inventory.bdb.MetadataManager;
import thredds.ui.catalog.ThreddsUI;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPSession;
import ucar.ma2.Array;
import ucar.nc2.FileWriter2;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.constants.CDM;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetInfo;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.cover.CoverageDataset;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.standard.PointConfigXML;
import ucar.nc2.ft.point.standard.PointDatasetStandardFactory;
import ucar.nc2.ft.point.writer.FeatureDatasetPointXML;
import ucar.nc2.geotiff.GeoTiff;
import ucar.nc2.geotiff.GeotiffWriter;
import ucar.nc2.grib.GribData;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.grib.grib2.table.WmoTemplateTable;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.jni.netcdf.Nc4Iosp;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.ui.AggTable;
import ucar.nc2.ui.BufrMessageViewer;
import ucar.nc2.ui.BufrReportPanel;
import ucar.nc2.ui.BufrTableBViewer;
import ucar.nc2.ui.BufrTableDViewer;
import ucar.nc2.ui.BufrWmoCodesPanel;
import ucar.nc2.ui.CdmIndex3Panel;
import ucar.nc2.ui.CdmIndexReportPanel;
import ucar.nc2.ui.CdmrFeaturePanel;
import ucar.nc2.ui.CollectionSpecTable;
import ucar.nc2.ui.CoordSysTable;
import ucar.nc2.ui.DatasetViewer;
import ucar.nc2.ui.DatasetWriter;
import ucar.nc2.ui.DirectoryPartitionViewer;
import ucar.nc2.ui.Fmrc2Panel;
import ucar.nc2.ui.FmrcCollectionTable;
import ucar.nc2.ui.Hdf4Table;
import ucar.nc2.ui.Hdf5DataTable;
import ucar.nc2.ui.Hdf5ObjectTable;
import ucar.nc2.ui.NcmlEditor;
import ucar.nc2.ui.PointFeatureDatasetViewer;
import ucar.nc2.ui.RadialDatasetTable;
import ucar.nc2.ui.ReportPanel;
import ucar.nc2.ui.StationRadialViewer;
import ucar.nc2.ui.WmoCommonCodesPanel;
import ucar.nc2.ui.WmsViewer;
import ucar.nc2.ui.coverage.CoverageDisplay;
import ucar.nc2.ui.coverage.CoverageTable;
import ucar.nc2.ui.dialog.DiskCache2Form;
import ucar.nc2.ui.gis.shapefile.ShapeFileBean;
import ucar.nc2.ui.gis.worldmap.WorldMapBean;
import ucar.nc2.ui.grib.Grib1DataTable;
import ucar.nc2.ui.grib.Grib1ReportPanel;
import ucar.nc2.ui.grib.Grib1TablesViewer;
import ucar.nc2.ui.grib.Grib2ReportPanel;
import ucar.nc2.ui.grib.Grib2TableViewer2;
import ucar.nc2.ui.grib.GribWmoCodesPanel;
import ucar.nc2.ui.grib.GribWmoTemplatesPanel;
import ucar.nc2.ui.grid.GeoGridTable;
import ucar.nc2.ui.grid.GridUI;
import ucar.nc2.ui.image.ImageViewPanel;
import ucar.nc2.ui.util.Resource;
import ucar.nc2.ui.util.SocketMessage;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PLAF;
import ucar.nc2.ui.widget.ProgressMonitor;
import ucar.nc2.ui.widget.ProgressMonitorTask;
import ucar.nc2.ui.widget.StopButton;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.ui.widget.URLDumpPane;
import ucar.nc2.ui.widget.UrlAuthenticatorDialog;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateFromString;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.IO;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.xml.RuntimeConfigParser;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;
import ucar.util.prefs.ui.ComboBox;
import ucar.util.prefs.ui.Debug;

public class ToolsUI
extends JPanel {
    private static Logger log = LoggerFactory.getLogger(ToolsUI.class);
    private static final String WorldDetailMap = "/resources/nj22/ui/maps/Countries.shp";
    private static final String USMap = "/resources/nj22/ui/maps/us_state.shp";
    private static final String FRAME_SIZE = "FrameSize";
    private static final String GRIDVIEW_FRAME_SIZE = "GridUIWindowSize";
    private static final String GRIDIMAGE_FRAME_SIZE = "GridImageWindowSize";
    private static boolean debugListen = false;
    private PreferencesExt mainPrefs;
    private AggPanel aggPanel;
    private BufrPanel bufrPanel;
    private BufrTableBPanel bufrTableBPanel;
    private BufrTableDPanel bufrTableDPanel;
    private ReportOpPanel bufrReportPanel;
    private BufrCdmIndexPanel bufrCdmIndexPanel;
    private BufrCodePanel bufrCodePanel;
    private CdmrFeature cdmremotePanel;
    private CdmIndexPanel cdmIndex2Panel;
    private ReportOpPanel cdmIndexReportPanel;
    private CollectionSpecPanel fcPanel;
    private CoordSysPanel coordSysPanel;
    private CoveragePanel coveragePanel;
    private DatasetViewerPanel viewerPanel;
    private DatasetViewerPanel nc4viewer;
    private DatasetWriterPanel writerPanel;
    private DirectoryPartitionPanel dirPartPanel;
    private FeatureScanPanel ftPanel;
    private FmrcPanel fmrcPanel;
    private FmrcCollectionPanel fmrcCollectionPanel;
    private GeoGridPanel gridPanel;
    private GeotiffPanel geotiffPanel;
    private GribCodePanel gribCodePanel;
    private GribFilesPanel gribFilesPanel;
    private GribIndexPanel gribIdxPanel;
    private GribRenamePanel gribVariableRenamePanel;
    private GribRewritePanel gribRewritePanel;
    private GribTemplatePanel gribTemplatePanel;
    private Grib1CollectionPanel grib1CollectionPanel;
    private ReportOpPanel grib1ReportPanel;
    private Grib1TablePanel grib1TablePanel;
    private Grib2CollectionPanel grib2CollectionPanel;
    private Grib2TablePanel grib2TablePanel;
    private ReportOpPanel grib2ReportPanel;
    private Grib1DataPanel grib1DataPanel;
    private Grib2DataPanel grib2DataPanel;
    private Hdf5ObjectPanel hdf5ObjectPanel;
    private Hdf5DataPanel hdf5DataPanel;
    private Hdf4Panel hdf4Panel;
    private ImagePanel imagePanel;
    private NcStreamPanel ncStreamPanel;
    private NCdumpPanel ncdumpPanel;
    private NcmlEditorPanel ncmlEditorPanel;
    private PointFeaturePanel pointFeaturePanel;
    private StationRadialPanel stationRadialPanel;
    private RadialPanel radialPanel;
    private ThreddsUI threddsUI;
    private UnitsPanel unitsPanel;
    private URLDumpPane urlPanel;
    private WmoCCPanel wmoCommonCodePanel;
    private WmsPanel wmsPanel;
    private JTabbedPane tabbedPane;
    private JTabbedPane iospTabPane;
    private JTabbedPane bufrTabPane;
    private JTabbedPane gribTabPane;
    private JTabbedPane grib2TabPane;
    private JTabbedPane grib1TabPane;
    private JTabbedPane hdf5TabPane;
    private JTabbedPane ftTabPane;
    private JTabbedPane fcTabPane;
    private JTabbedPane fmrcTabPane;
    private JTabbedPane ncmlTabPane;
    private JFrame parentFrame;
    private FileManager fileChooser;
    private AboutWindow aboutWindow = null;
    private DataFactory threddsDataFactory = new DataFactory();
    private DateFormatter formatter = new DateFormatter();
    private boolean setUseRecordStructure = false;
    private JMenu debugFlagMenu;
    private DebugFlags debugFlags;
    private boolean debug = false;
    private boolean debugTab = false;
    private boolean debugCB = false;
    private static final String osName = System.getProperty("os.name").toLowerCase();
    private static final boolean isMacOs = osName.startsWith("mac os x");
    DiskCache2Form diskCache2Form = null;
    private String downloadStatus = null;
    private FileManager bufrFileChooser = null;
    private static ToolsUI ui;
    private static JFrame frame;
    private static PreferencesExt prefs;
    private static XMLStore store;
    private static boolean done;
    private static String wantDataset;
    static boolean isCacheInit;

    public ToolsUI(PreferencesExt prefs, JFrame parentFrame) {
        this.mainPrefs = prefs;
        this.parentFrame = parentFrame;
        FileFilter[] filters = new FileFilter[]{new FileManager.HDF5ExtFilter(), new FileManager.NetcdfExtFilter()};
        this.fileChooser = new FileManager(parentFrame, null, filters, (PreferencesExt)prefs.node("FileManager"));
        this.tabbedPane = new JTabbedPane(1);
        this.iospTabPane = new JTabbedPane(1);
        this.gribTabPane = new JTabbedPane(1);
        this.grib2TabPane = new JTabbedPane(1);
        this.grib1TabPane = new JTabbedPane(1);
        this.bufrTabPane = new JTabbedPane(1);
        this.ftTabPane = new JTabbedPane(1);
        this.fcTabPane = new JTabbedPane(1);
        this.fmrcTabPane = new JTabbedPane(1);
        this.hdf5TabPane = new JTabbedPane(1);
        this.ncmlTabPane = new JTabbedPane(1);
        this.viewerPanel = new DatasetViewerPanel((PreferencesExt)this.mainPrefs.node("varTable"), false);
        this.tabbedPane.addTab("Viewer", this.viewerPanel);
        this.tabbedPane.addTab("Writer", new JLabel("Writer"));
        this.tabbedPane.addTab("NCDump", new JLabel("NCDump"));
        this.tabbedPane.addTab("Iosp", this.iospTabPane);
        this.tabbedPane.addTab("CoordSys", new JLabel("CoordSys"));
        this.tabbedPane.addTab("FeatureTypes", this.ftTabPane);
        this.tabbedPane.addTab("THREDDS", new JLabel("THREDDS"));
        this.tabbedPane.addTab("Fmrc", this.fmrcTabPane);
        this.tabbedPane.addTab("GeoTiff", new JLabel("GeoTiff"));
        this.tabbedPane.addTab("Units", new JLabel("Units"));
        this.tabbedPane.addTab("NcML", this.ncmlTabPane);
        this.tabbedPane.addTab("URLdump", new JLabel("URLdump"));
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.tabbedPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.tabbedPane.getSelectedIndex();
                    String title = ToolsUI.this.tabbedPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.tabbedPane, title);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.iospTabPane.addTab("BUFR", this.bufrTabPane);
        this.iospTabPane.addTab("GRIB", this.gribTabPane);
        this.iospTabPane.addTab("GRIB2", this.grib2TabPane);
        this.iospTabPane.addTab("GRIB1", this.grib1TabPane);
        this.iospTabPane.addTab("HDF5", this.hdf5TabPane);
        this.iospTabPane.addTab("HDF4", new JLabel("HDF4"));
        this.iospTabPane.addTab("NcStream", new JLabel("NcStream"));
        this.iospTabPane.addTab("CdmrFeature", new JLabel("CdmrFeature"));
        this.addListeners(this.iospTabPane);
        this.bufrTabPane.addTab("BUFR", new JLabel("BUFR"));
        this.bufrTabPane.addTab("BufrCdmIndex", new JLabel("BufrCdmIndex"));
        this.bufrTabPane.addTab("BUFRTableB", new JLabel("BUFRTableB"));
        this.bufrTabPane.addTab("BUFRTableD", new JLabel("BUFRTableD"));
        this.bufrTabPane.addTab("BUFR-CODES", new JLabel("BUFR-CODES"));
        this.bufrTabPane.addTab("BufrReports", new JLabel("BufrReports"));
        this.addListeners(this.bufrTabPane);
        this.gribTabPane.addTab("CdmIndex3", new JLabel("CdmIndex3"));
        this.gribTabPane.addTab("CdmIndexReport", new JLabel("CdmIndexReport"));
        this.gribTabPane.addTab("GribIndex", new JLabel("GribIndex"));
        this.gribTabPane.addTab("WMO-COMMON", new JLabel("WMO-COMMON"));
        this.gribTabPane.addTab("WMO-CODES", new JLabel("WMO-CODES"));
        this.gribTabPane.addTab("WMO-TEMPLATES", new JLabel("WMO-TEMPLATES"));
        this.gribTabPane.addTab("GRIB-Rename", new JLabel("GRIB-Rename"));
        this.gribTabPane.addTab("GRIB-Rewrite", new JLabel("GRIB-Rewrite"));
        this.addListeners(this.gribTabPane);
        this.grib2TabPane.addTab("GRIB2collection", new JLabel("GRIB2collection"));
        this.grib2TabPane.addTab("GRIB2rectilyze", new JLabel("GRIB2rectilyze"));
        this.grib2TabPane.addTab("GRIB2-REPORT", new JLabel("GRIB2-REPORT"));
        this.grib2TabPane.addTab("GRIB2data", new JLabel("GRIB2data"));
        this.grib2TabPane.addTab("GRIB2-TABLES", new JLabel("GRIB2-TABLES"));
        this.addListeners(this.grib2TabPane);
        this.grib1TabPane.addTab("GRIB1collection", new JLabel("GRIB1collection"));
        this.grib1TabPane.addTab("GRIB-FILES", new JLabel("GRIB-FILES"));
        this.grib1TabPane.addTab("GRIB1-REPORT", new JLabel("GRIB1-REPORT"));
        this.grib1TabPane.addTab("GRIB1data", new JLabel("GRIB1data"));
        this.grib1TabPane.addTab("GRIB1-TABLES", new JLabel("GRIB1-TABLES"));
        this.addListeners(this.grib1TabPane);
        this.hdf5TabPane.addTab("HDF5-Objects", new JLabel("HDF5-Objects"));
        this.hdf5TabPane.addTab("HDF5-Data", new JLabel("HDF5-Data"));
        this.hdf5TabPane.addTab("Netcdf4-JNI", new JLabel("Netcdf4-JNI"));
        this.addListeners(this.hdf5TabPane);
        this.ftTabPane.addTab("Grids", new JLabel("Grids"));
        this.ftTabPane.addTab("Coverages", new JLabel("Coverages"));
        this.ftTabPane.addTab("WMS", new JLabel("WMS"));
        this.ftTabPane.addTab("PointFeature", new JLabel("PointFeature"));
        this.ftTabPane.addTab("Images", new JLabel("Images"));
        this.ftTabPane.addTab("Radial", new JLabel("Radial"));
        this.ftTabPane.addTab("FeatureScan", new JLabel("FeatureScan"));
        this.ftTabPane.addTab("FeatureCollection", this.fcTabPane);
        this.addListeners(this.ftTabPane);
        this.fcTabPane.addTab("DirectoryPartition", new JLabel("DirectoryPartition"));
        this.fcTabPane.addTab("CollectionSpec", new JLabel("CollectionSpec"));
        this.addListeners(this.fcTabPane);
        this.fmrcTabPane.addTab("Fmrc", new JLabel("Fmrc"));
        this.fmrcTabPane.addTab("Collections", new JLabel("Collections"));
        this.addListeners(this.fmrcTabPane);
        this.ncmlTabPane.addTab("NcmlEditor", new JLabel("NcmlEditor"));
        this.ncmlTabPane.addTab("Aggregation", new JLabel("Aggregation"));
        this.addListeners(this.ncmlTabPane);
        this.debugFlags = (DebugFlags)Proxy.newProxyInstance(DebugFlags.class.getClassLoader(), new Class[]{DebugFlags.class}, (InvocationHandler)new DebugProxyHandler());
        this.makeMenuBar();
        this.setDebugFlags();
    }

    private void addListeners(final JTabbedPane tabPane) {
        tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = tabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = tabPane.getSelectedIndex();
                    String title = tabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(tabPane, title);
                }
            }
        });
        tabPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Component c = tabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = tabPane.getSelectedIndex();
                    String title = tabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(tabPane, title);
                }
            }
        });
    }

    private void makeComponent(JTabbedPane parent, String title) {
        JPanel c;
        String cTitle;
        int idx;
        if (parent == null) {
            parent = this.tabbedPane;
        }
        int n = parent.getTabCount();
        for (idx = 0; idx < n && !(cTitle = parent.getTitleAt(idx)).equals(title); ++idx) {
        }
        if (idx >= n) {
            if (this.debugTab) {
                System.out.println("Cant find " + title + " in " + parent);
            }
            return;
        }
        switch (title) {
            case "Aggregation": {
                this.aggPanel = new AggPanel((PreferencesExt)this.mainPrefs.node("NcMLAggregation"));
                c = this.aggPanel;
                break;
            }
            case "BUFR": {
                this.bufrPanel = new BufrPanel((PreferencesExt)this.mainPrefs.node("bufr"));
                c = this.bufrPanel;
                break;
            }
            case "BUFRTableB": {
                this.bufrTableBPanel = new BufrTableBPanel((PreferencesExt)this.mainPrefs.node("bufr2"));
                c = this.bufrTableBPanel;
                break;
            }
            case "BUFRTableD": {
                this.bufrTableDPanel = new BufrTableDPanel((PreferencesExt)this.mainPrefs.node("bufrD"));
                c = this.bufrTableDPanel;
                break;
            }
            case "BufrReports": {
                PreferencesExt prefs = (PreferencesExt)this.mainPrefs.node("bufrReports");
                BufrReportPanel rp = new BufrReportPanel(prefs);
                this.bufrReportPanel = new ReportOpPanel(prefs, rp);
                c = this.bufrReportPanel;
                break;
            }
            case "BUFR-CODES": {
                this.bufrCodePanel = new BufrCodePanel((PreferencesExt)this.mainPrefs.node("bufr-codes"));
                c = this.bufrCodePanel;
                break;
            }
            case "CdmrFeature": {
                this.cdmremotePanel = new CdmrFeature((PreferencesExt)this.mainPrefs.node("CdmrFeature"));
                c = this.cdmremotePanel;
                break;
            }
            case "CollectionSpec": {
                this.fcPanel = new CollectionSpecPanel((PreferencesExt)this.mainPrefs.node("collSpec"));
                c = this.fcPanel;
                break;
            }
            case "DirectoryPartition": {
                this.dirPartPanel = new DirectoryPartitionPanel((PreferencesExt)this.mainPrefs.node("dirPartition"));
                c = this.dirPartPanel;
                break;
            }
            case "NcStream": {
                this.ncStreamPanel = new NcStreamPanel((PreferencesExt)this.mainPrefs.node("NcStream"));
                c = this.ncStreamPanel;
                break;
            }
            case "GRIB1collection": {
                this.grib1CollectionPanel = new Grib1CollectionPanel((PreferencesExt)this.mainPrefs.node("grib1raw"));
                c = this.grib1CollectionPanel;
                break;
            }
            case "GRIB1data": {
                this.grib1DataPanel = new Grib1DataPanel((PreferencesExt)this.mainPrefs.node("grib1Data"));
                c = this.grib1DataPanel;
                break;
            }
            case "GRIB-FILES": {
                this.gribFilesPanel = new GribFilesPanel((PreferencesExt)this.mainPrefs.node("gribFiles"));
                c = this.gribFilesPanel;
                break;
            }
            case "GRIB2collection": {
                this.grib2CollectionPanel = new Grib2CollectionPanel((PreferencesExt)this.mainPrefs.node("gribNew"));
                c = this.grib2CollectionPanel;
                break;
            }
            case "GRIB2data": {
                this.grib2DataPanel = new Grib2DataPanel((PreferencesExt)this.mainPrefs.node("grib2Data"));
                c = this.grib2DataPanel;
                break;
            }
            case "BufrCdmIndex": {
                this.bufrCdmIndexPanel = new BufrCdmIndexPanel((PreferencesExt)this.mainPrefs.node("bufrCdmIdx"));
                c = this.bufrCdmIndexPanel;
                break;
            }
            case "CdmIndex3": {
                this.cdmIndex2Panel = new CdmIndexPanel((PreferencesExt)this.mainPrefs.node("cdmIdx3"));
                c = this.cdmIndex2Panel;
                break;
            }
            case "CdmIndexReport": {
                PreferencesExt prefs = (PreferencesExt)this.mainPrefs.node("CdmIndexReport");
                CdmIndexReportPanel rp = new CdmIndexReportPanel(prefs);
                this.cdmIndexReportPanel = new ReportOpPanel(prefs, rp);
                c = this.cdmIndexReportPanel;
                break;
            }
            case "GribIndex": {
                this.gribIdxPanel = new GribIndexPanel((PreferencesExt)this.mainPrefs.node("gribIdx"));
                c = this.gribIdxPanel;
                break;
            }
            case "GRIB1-REPORT": {
                PreferencesExt prefs = (PreferencesExt)this.mainPrefs.node("grib1Report");
                Grib1ReportPanel rp = new Grib1ReportPanel(prefs);
                this.grib1ReportPanel = new ReportOpPanel(prefs, rp);
                c = this.grib1ReportPanel;
                break;
            }
            case "GRIB2-REPORT": {
                PreferencesExt prefs = (PreferencesExt)this.mainPrefs.node("gribReport");
                Grib2ReportPanel rp = new Grib2ReportPanel(prefs);
                this.grib2ReportPanel = new ReportOpPanel(prefs, rp);
                c = this.grib2ReportPanel;
                break;
            }
            case "WMO-COMMON": {
                this.wmoCommonCodePanel = new WmoCCPanel((PreferencesExt)this.mainPrefs.node("wmo-common"));
                c = this.wmoCommonCodePanel;
                break;
            }
            case "WMO-CODES": {
                this.gribCodePanel = new GribCodePanel((PreferencesExt)this.mainPrefs.node("wmo-codes"));
                c = this.gribCodePanel;
                break;
            }
            case "WMO-TEMPLATES": {
                this.gribTemplatePanel = new GribTemplatePanel((PreferencesExt)this.mainPrefs.node("wmo-templates"));
                c = this.gribTemplatePanel;
                break;
            }
            case "GRIB1-TABLES": {
                this.grib1TablePanel = new Grib1TablePanel((PreferencesExt)this.mainPrefs.node("grib1-tables"));
                c = this.grib1TablePanel;
                break;
            }
            case "GRIB2-TABLES": {
                this.grib2TablePanel = new Grib2TablePanel((PreferencesExt)this.mainPrefs.node("grib2-tables"));
                c = this.grib2TablePanel;
                break;
            }
            case "GRIB-Rename": {
                this.gribVariableRenamePanel = new GribRenamePanel((PreferencesExt)this.mainPrefs.node("grib-rename"));
                c = this.gribVariableRenamePanel;
                break;
            }
            case "GRIB-Rewrite": {
                this.gribRewritePanel = new GribRewritePanel((PreferencesExt)this.mainPrefs.node("grib-rewrite"));
                c = this.gribRewritePanel;
                break;
            }
            case "CoordSys": {
                this.coordSysPanel = new CoordSysPanel((PreferencesExt)this.mainPrefs.node("CoordSys"));
                c = this.coordSysPanel;
                break;
            }
            case "FeatureScan": {
                this.ftPanel = new FeatureScanPanel((PreferencesExt)this.mainPrefs.node("ftPanel"));
                c = this.ftPanel;
                break;
            }
            case "GeoTiff": {
                this.geotiffPanel = new GeotiffPanel((PreferencesExt)this.mainPrefs.node("WCS"));
                c = this.geotiffPanel;
                break;
            }
            case "Grids": {
                this.gridPanel = new GeoGridPanel((PreferencesExt)this.mainPrefs.node("grid"));
                c = this.gridPanel;
                break;
            }
            case "Coverages": {
                this.coveragePanel = new CoveragePanel((PreferencesExt)this.mainPrefs.node("coverage"));
                c = this.coveragePanel;
                break;
            }
            case "HDF5-Objects": {
                this.hdf5ObjectPanel = new Hdf5ObjectPanel((PreferencesExt)this.mainPrefs.node("hdf5"));
                c = this.hdf5ObjectPanel;
                break;
            }
            case "HDF5-Data": {
                this.hdf5DataPanel = new Hdf5DataPanel((PreferencesExt)this.mainPrefs.node("hdf5data"));
                c = this.hdf5DataPanel;
                break;
            }
            case "Netcdf4-JNI": {
                c = this.nc4viewer = new DatasetViewerPanel((PreferencesExt)this.mainPrefs.node("nc4viewer"), true);
                break;
            }
            case "HDF4": {
                this.hdf4Panel = new Hdf4Panel((PreferencesExt)this.mainPrefs.node("hdf4"));
                c = this.hdf4Panel;
                break;
            }
            case "Images": {
                this.imagePanel = new ImagePanel((PreferencesExt)this.mainPrefs.node("images"));
                c = this.imagePanel;
                break;
            }
            case "Fmrc": {
                this.fmrcPanel = new FmrcPanel((PreferencesExt)this.mainPrefs.node("fmrc2"));
                c = this.fmrcPanel;
                break;
            }
            case "Collections": {
                this.fmrcCollectionPanel = new FmrcCollectionPanel((PreferencesExt)this.mainPrefs.node("collections"));
                c = this.fmrcCollectionPanel;
                break;
            }
            case "NCDump": {
                this.ncdumpPanel = new NCdumpPanel((PreferencesExt)this.mainPrefs.node("NCDump"));
                c = this.ncdumpPanel;
                break;
            }
            case "NcmlEditor": {
                this.ncmlEditorPanel = new NcmlEditorPanel((PreferencesExt)this.mainPrefs.node("NcmlEditor"));
                c = this.ncmlEditorPanel;
                break;
            }
            case "PointFeature": {
                this.pointFeaturePanel = new PointFeaturePanel((PreferencesExt)this.mainPrefs.node("pointFeature"));
                c = this.pointFeaturePanel;
                break;
            }
            case "Radial": {
                this.radialPanel = new RadialPanel((PreferencesExt)this.mainPrefs.node("radial"));
                c = this.radialPanel;
                break;
            }
            case "StationRadial": {
                this.stationRadialPanel = new StationRadialPanel((PreferencesExt)this.mainPrefs.node("stationRadar"));
                c = this.stationRadialPanel;
                break;
            }
            case "THREDDS": {
                this.threddsUI = new ThreddsUI(this.parentFrame, (PreferencesExt)this.mainPrefs.node("thredds"));
                this.threddsUI.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        if (e.getPropertyName().equals("InvAccess")) {
                            Access access = (Access)e.getNewValue();
                            ToolsUI.this.jumptoThreddsDatatype(access);
                        }
                        if (e.getPropertyName().equals("Dataset") || e.getPropertyName().equals("CoordSys") || e.getPropertyName().equals("File")) {
                            Dataset ds = (Dataset)e.getNewValue();
                            ToolsUI.this.setThreddsDatatype(ds, e.getPropertyName());
                        }
                    }
                });
                c = this.threddsUI;
                break;
            }
            case "Units": {
                this.unitsPanel = new UnitsPanel((PreferencesExt)this.mainPrefs.node("units"));
                c = this.unitsPanel;
                break;
            }
            case "URLdump": {
                this.urlPanel = new URLDumpPane((PreferencesExt)this.mainPrefs.node("urlDump"));
                c = this.urlPanel;
                break;
            }
            case "Viewer": {
                c = this.viewerPanel;
                break;
            }
            case "Writer": {
                this.writerPanel = new DatasetWriterPanel((PreferencesExt)this.mainPrefs.node("writer"));
                c = this.writerPanel;
                break;
            }
            case "WMS": {
                this.wmsPanel = new WmsPanel((PreferencesExt)this.mainPrefs.node("wms"));
                c = this.wmsPanel;
                break;
            }
            default: {
                System.out.println("tabbedPane unknown component " + title);
                return;
            }
        }
        parent.setComponentAt(idx, c);
        if (this.debugTab) {
            System.out.println("tabbedPane changed " + title + " added ");
        }
    }

    private void makeMenuBar() {
        JMenuBar mb = new JMenuBar();
        JRootPane rootPane = this.parentFrame.getRootPane();
        rootPane.setJMenuBar(mb);
        JMenu sysMenu = new JMenu("System");
        sysMenu.setMnemonic('S');
        mb.add(sysMenu);
        AbstractAction act = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetadataManager.closeAll();
            }
        };
        BAMutil.setActionProperties(act, null, "Close BDB database", false, 83, -1);
        BAMutil.addActionToMenu(sysMenu, act);
        AbstractAction clearHttpStateAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        BAMutil.setActionProperties(clearHttpStateAction, null, "Clear Http State", false, 83, -1);
        BAMutil.addActionToMenu(sysMenu, clearHttpStateAction);
        AbstractAction showCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                f.format("RandomAccessFileCache contents%n", new Object[0]);
                FileCacheIF rafCache = RandomAccessFile.getGlobalFileCache();
                if (null != rafCache) {
                    rafCache.showCache(f);
                }
                f.format("%nNetcdfFileCache contents%n", new Object[0]);
                FileCacheIF cache = NetcdfDataset.getNetcdfFileCache();
                if (null != cache) {
                    cache.showCache(f);
                }
                ((ToolsUI)ToolsUI.this).viewerPanel.detailTA.setText(f.toString());
                ((ToolsUI)ToolsUI.this).viewerPanel.detailWindow.show();
            }
        };
        BAMutil.setActionProperties(showCacheAction, null, "Show Caches", false, 83, -1);
        BAMutil.addActionToMenu(sysMenu, showCacheAction);
        AbstractAction clearRafCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCacheIF rafCache = RandomAccessFile.getGlobalFileCache();
                if (rafCache != null) {
                    rafCache.clearCache(true);
                }
            }
        };
        BAMutil.setActionProperties(clearRafCacheAction, null, "Clear RandomAccessFileCache", false, 67, -1);
        BAMutil.addActionToMenu(sysMenu, clearRafCacheAction);
        AbstractAction clearCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCacheIF cache = NetcdfDataset.getNetcdfFileCache();
                if (cache != null) {
                    cache.clearCache(true);
                }
            }
        };
        BAMutil.setActionProperties(clearCacheAction, null, "Clear NetcdfDatasetCache", false, 67, -1);
        BAMutil.addActionToMenu(sysMenu, clearCacheAction);
        AbstractAction enableCache = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state == isCacheInit) {
                    return;
                }
                isCacheInit = state;
                if (isCacheInit) {
                    FileCacheIF cache = NetcdfDataset.getNetcdfFileCache();
                    if (cache != null) {
                        cache.enable();
                    } else {
                        NetcdfDataset.initNetcdfFileCache((int)10, (int)20, (int)600);
                    }
                } else {
                    FileCacheIF cache = NetcdfDataset.getNetcdfFileCache();
                    if (cache != null) {
                        cache.disable();
                    }
                }
            }
        };
        BAMutil.setActionPropertiesToggle(enableCache, null, "enable NetcdfDatasetCache", isCacheInit, 78, -1);
        BAMutil.addActionToMenu(sysMenu, enableCache);
        AbstractAction showPropertiesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ToolsUI)ToolsUI.this).viewerPanel.detailTA.setText("System Properties\n");
                Properties sysp = System.getProperties();
                Enumeration<?> eprops = sysp.propertyNames();
                ArrayList<?> list = Collections.list(eprops);
                Collections.sort(list);
                for (Object aList : list) {
                    String name = (String)aList;
                    String value = System.getProperty(name);
                    ((ToolsUI)ToolsUI.this).viewerPanel.detailTA.appendLine("  " + name + " = " + value);
                }
                ((ToolsUI)ToolsUI.this).viewerPanel.detailWindow.show();
            }
        };
        BAMutil.setActionProperties(showPropertiesAction, null, "System Properties", false, 80, -1);
        BAMutil.addActionToMenu(sysMenu, showPropertiesAction);
        JMenu plafMenu = new JMenu("Look and Feel");
        plafMenu.setMnemonic('L');
        sysMenu.add(plafMenu);
        PLAF plaf = new PLAF(rootPane);
        plaf.addToMenu(plafMenu);
        AbstractAction exitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolsUI.exit();
            }
        };
        BAMutil.setActionProperties(exitAction, "Exit", "Exit", false, 88, -1);
        BAMutil.addActionToMenu(sysMenu, exitAction);
        JMenu modeMenu = new JMenu("Modes");
        modeMenu.setMnemonic('M');
        mb.add(modeMenu);
        this.makeModesMenu(modeMenu);
        JMenu debugMenu = new JMenu("Debug");
        debugMenu.setMnemonic('D');
        mb.add(debugMenu);
        this.debugFlagMenu = (JMenu)debugMenu.add(new JMenu("Debug Flags"));
        this.debugFlagMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                ToolsUI.this.setDebugFlags();
                Debug.constructMenu(ToolsUI.this.debugFlagMenu);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                ToolsUI.this.setDebugFlags();
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        AbstractAction clearDebugFlagsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Debug.removeAll();
            }
        };
        BAMutil.setActionProperties(clearDebugFlagsAction, null, "Delete All Debug Flags", false, 67, -1);
        BAMutil.addActionToMenu(debugMenu, clearDebugFlagsAction);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        mb.add(helpMenu);
        AbstractAction aboutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ToolsUI.this.aboutWindow == null) {
                    ToolsUI.this.aboutWindow = new AboutWindow();
                }
                ToolsUI.this.aboutWindow.setVisible(true);
            }
        };
        BAMutil.setActionProperties(aboutAction, null, "About", false, 65, 0);
        BAMutil.addActionToMenu(helpMenu, aboutAction);
        AbstractAction logoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new MySplashScreen();
            }
        };
        BAMutil.setActionProperties(logoAction, null, "Logo", false, 76, 0);
        BAMutil.addActionToMenu(helpMenu, logoAction);
    }

    public void setDebugFlags() {
        if (this.debug) {
            System.out.println("checkDebugFlags ");
        }
        NetcdfFile.setDebugFlags((DebugFlags)this.debugFlags);
        H5iosp.setDebugFlags((DebugFlags)this.debugFlags);
        NcMLReader.setDebugFlags((DebugFlags)this.debugFlags);
        DODSNetcdfFile.setDebugFlags((DebugFlags)this.debugFlags);
        CdmRemote.setDebugFlags((DebugFlags)this.debugFlags);
        Nc4Iosp.setDebugFlags((DebugFlags)this.debugFlags);
        DataFactory.setDebugFlags((DebugFlags)this.debugFlags);
        FileWriter2.setDebugFlags((DebugFlags)this.debugFlags);
        PointDatasetStandardFactory.setDebugFlags((DebugFlags)this.debugFlags);
        GribIosp.setDebugFlags((DebugFlags)this.debugFlags);
    }

    private void makeModesMenu(JMenu modeMenu) {
        JMenu ncMenu = new JMenu("NetcdfFile");
        modeMenu.add(ncMenu);
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolsUI.this.setUseRecordStructure = (Boolean)this.getValue("state");
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "nc3UseRecords", this.setUseRecordStructure, 86, -1);
        BAMutil.addActionToMenu(ncMenu, a);
        JMenu dsMenu = new JMenu("NetcdfDataset");
        modeMenu.add(dsMenu);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                CoordSysBuilder.setUseMaximalCoordSys((boolean)state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "set Use Maximal CoordSystem", CoordSysBuilder.getUseMaximalCoordSys(), 78, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setUseNaNs((boolean)state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "set NaNs for missing values", NetcdfDataset.getUseNaNs(), 78, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setFillValueIsMissing((boolean)state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "use _FillValue attribute for missing values", NetcdfDataset.getFillValueIsMissing(), 70, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setInvalidDataIsMissing((boolean)state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "use valid_range attribute for missing values", NetcdfDataset.getInvalidDataIsMissing(), 86, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setMissingDataIsMissing((boolean)state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "use missing_value attribute for missing values", NetcdfDataset.getMissingDataIsMissing(), 77, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        JMenu subMenu = new JMenu("GRIB");
        modeMenu.add(subMenu);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolsUI.this.setGribDiskCache();
            }
        };
        BAMutil.setActionProperties(a, null, "set Grib disk cache...", false, 71, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                Grib1ParamTables.setStrict((boolean)state);
            }
        };
        boolean strictMode = Grib1ParamTables.isStrict();
        a.putValue("state", strictMode);
        BAMutil.setActionPropertiesToggle(a, null, "GRIB1 strict", strictMode, 83, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                GribData.setInterpolationMethod((GribData.InterpolationMethod)(state != false ? GribData.InterpolationMethod.cubic : GribData.InterpolationMethod.linear));
            }
        };
        boolean useCubic = GribData.getInterpolationMethod() == GribData.InterpolationMethod.cubic;
        a.putValue("state", useCubic);
        BAMutil.setActionPropertiesToggle(a, null, "Use Cubic Interpolation on Thin Grids", useCubic, 73, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureCollectionConfig.useGenTypeDef = (Boolean)this.getValue("state");
            }
        };
        a.putValue("state", FeatureCollectionConfig.useGenTypeDef);
        BAMutil.setActionPropertiesToggle(a, null, "useGenType", FeatureCollectionConfig.useGenTypeDef, 83, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureCollectionConfig.useTableVersionDef = (Boolean)this.getValue("state");
            }
        };
        a.putValue("state", FeatureCollectionConfig.useTableVersionDef);
        BAMutil.setActionPropertiesToggle(a, null, "useTableVersion", FeatureCollectionConfig.useTableVersionDef, 83, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureCollectionConfig.intvMergeDef = (Boolean)this.getValue("state");
            }
        };
        a.putValue("state", FeatureCollectionConfig.intvMergeDef);
        BAMutil.setActionPropertiesToggle(a, null, "intvMerge", FeatureCollectionConfig.intvMergeDef, 83, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureCollectionConfig.useCenterDef = (Boolean)this.getValue("state");
            }
        };
        a.putValue("state", FeatureCollectionConfig.useCenterDef);
        BAMutil.setActionPropertiesToggle(a, null, "useCenter", FeatureCollectionConfig.useCenterDef, 83, -1);
        BAMutil.addActionToMenu(subMenu, a);
        subMenu = new JMenu("FMRC");
        modeMenu.add(subMenu);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                FeatureCollectionConfig.setRegularizeDefault((boolean)state);
            }
        };
        FeatureCollectionConfig.setRegularizeDefault((boolean)true);
        a.putValue("state", true);
        BAMutil.setActionPropertiesToggle(a, null, "regularize", true, 82, -1);
        BAMutil.addActionToMenu(subMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                DataFactory.setPreferCdm((boolean)state);
            }
        };
        DataFactory.setPreferCdm((boolean)true);
        a.putValue("state", true);
        BAMutil.setActionPropertiesToggle(a, null, "preferCdm", true, 80, -1);
        BAMutil.addActionToMenu(subMenu, a);
    }

    private void setGribDiskCache() {
        if (this.diskCache2Form == null) {
            this.diskCache2Form = new DiskCache2Form((Frame)this.parentFrame, GribIndexCache.getDiskCache2());
        }
        this.diskCache2Form.setVisible(true);
    }

    public void save() {
        this.fileChooser.save();
        if (this.aggPanel != null) {
            this.aggPanel.save();
        }
        if (this.bufrFileChooser != null) {
            this.bufrFileChooser.save();
        }
        if (this.bufrPanel != null) {
            this.bufrPanel.save();
        }
        if (this.bufrTableBPanel != null) {
            this.bufrTableBPanel.save();
        }
        if (this.bufrTableDPanel != null) {
            this.bufrTableDPanel.save();
        }
        if (this.bufrReportPanel != null) {
            this.bufrReportPanel.save();
        }
        if (this.bufrCodePanel != null) {
            this.bufrCodePanel.save();
        }
        if (this.coordSysPanel != null) {
            this.coordSysPanel.save();
        }
        if (this.coveragePanel != null) {
            this.coveragePanel.save();
        }
        if (this.cdmIndex2Panel != null) {
            this.cdmIndex2Panel.save();
        }
        if (this.cdmIndexReportPanel != null) {
            this.cdmIndexReportPanel.save();
        }
        if (this.cdmremotePanel != null) {
            this.cdmremotePanel.save();
        }
        if (this.dirPartPanel != null) {
            this.dirPartPanel.save();
        }
        if (this.bufrCdmIndexPanel != null) {
            this.bufrCdmIndexPanel.save();
        }
        if (this.fmrcCollectionPanel != null) {
            this.fmrcCollectionPanel.save();
        }
        if (this.fcPanel != null) {
            this.fcPanel.save();
        }
        if (this.ftPanel != null) {
            this.ftPanel.save();
        }
        if (this.fmrcPanel != null) {
            this.fmrcPanel.save();
        }
        if (this.geotiffPanel != null) {
            this.geotiffPanel.save();
        }
        if (this.gribFilesPanel != null) {
            this.gribFilesPanel.save();
        }
        if (this.grib2CollectionPanel != null) {
            this.grib2CollectionPanel.save();
        }
        if (this.grib2DataPanel != null) {
            this.grib2DataPanel.save();
        }
        if (this.grib1DataPanel != null) {
            this.grib1DataPanel.save();
        }
        if (this.gribCodePanel != null) {
            this.gribCodePanel.save();
        }
        if (this.gribIdxPanel != null) {
            this.gribIdxPanel.save();
        }
        if (this.gribTemplatePanel != null) {
            this.gribTemplatePanel.save();
        }
        if (this.grib1CollectionPanel != null) {
            this.grib1CollectionPanel.save();
        }
        if (this.grib1ReportPanel != null) {
            this.grib1ReportPanel.save();
        }
        if (this.grib2ReportPanel != null) {
            this.grib2ReportPanel.save();
        }
        if (this.grib1TablePanel != null) {
            this.grib1TablePanel.save();
        }
        if (this.grib2TablePanel != null) {
            this.grib2TablePanel.save();
        }
        if (this.gribVariableRenamePanel != null) {
            this.gribVariableRenamePanel.save();
        }
        if (this.gribRewritePanel != null) {
            this.gribRewritePanel.save();
        }
        if (this.gridPanel != null) {
            this.gridPanel.save();
        }
        if (this.hdf5ObjectPanel != null) {
            this.hdf5ObjectPanel.save();
        }
        if (this.hdf5DataPanel != null) {
            this.hdf5DataPanel.save();
        }
        if (this.hdf4Panel != null) {
            this.hdf4Panel.save();
        }
        if (this.imagePanel != null) {
            this.imagePanel.save();
        }
        if (this.ncdumpPanel != null) {
            this.ncdumpPanel.save();
        }
        if (this.ncStreamPanel != null) {
            this.ncStreamPanel.save();
        }
        if (this.nc4viewer != null) {
            this.nc4viewer.save();
        }
        if (this.ncmlEditorPanel != null) {
            this.ncmlEditorPanel.save();
        }
        if (this.pointFeaturePanel != null) {
            this.pointFeaturePanel.save();
        }
        if (this.radialPanel != null) {
            this.radialPanel.save();
        }
        if (this.stationRadialPanel != null) {
            this.stationRadialPanel.save();
        }
        if (this.threddsUI != null) {
            this.threddsUI.storePersistentData();
        }
        if (this.unitsPanel != null) {
            this.unitsPanel.save();
        }
        if (this.urlPanel != null) {
            this.urlPanel.save();
        }
        if (this.viewerPanel != null) {
            this.viewerPanel.save();
        }
        if (this.writerPanel != null) {
            this.writerPanel.save();
        }
        if (this.wmoCommonCodePanel != null) {
            this.wmoCommonCodePanel.save();
        }
        if (this.wmsPanel != null) {
            this.wmsPanel.save();
        }
    }

    private void openNetcdfFile(String datasetName) {
        this.makeComponent(this.tabbedPane, "Viewer");
        this.viewerPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.viewerPanel);
    }

    private void openNetcdfFile(NetcdfFile ncfile) {
        this.makeComponent(this.tabbedPane, "Viewer");
        this.viewerPanel.setDataset(ncfile);
        this.tabbedPane.setSelectedComponent(this.viewerPanel);
    }

    private void openCoordSystems(String datasetName) {
        this.makeComponent(this.tabbedPane, "CoordSys");
        this.coordSysPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.coordSysPanel);
    }

    private void openCoordSystems(NetcdfDataset dataset) {
        this.makeComponent(this.tabbedPane, "CoordSys");
        this.coordSysPanel.setDataset(dataset);
        this.tabbedPane.setSelectedComponent(this.coordSysPanel);
    }

    private void openNcML(String datasetName) {
        this.makeComponent(this.ncmlTabPane, "NcmlEditor");
        this.ncmlEditorPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ncmlTabPane);
        this.ncmlTabPane.setSelectedComponent(this.ncmlEditorPanel);
    }

    private void openPointFeatureDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "PointFeature");
        this.pointFeaturePanel.setPointFeatureDataset(FeatureType.ANY_POINT, datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.pointFeaturePanel);
    }

    private void openGrib1Collection(String collection) {
        this.makeComponent(this.grib1TabPane, "GRIB1collection");
        this.grib1CollectionPanel.setCollection(collection);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib1TabPane);
        this.grib1TabPane.setSelectedComponent(this.grib1CollectionPanel);
    }

    private void openGrib2Collection(String collection) {
        this.makeComponent(this.grib2TabPane, "GRIB2collection");
        this.grib2CollectionPanel.setCollection(collection);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib2TabPane);
        this.grib2TabPane.setSelectedComponent(this.grib2CollectionPanel);
    }

    private void openGrib2Data(String datasetName) {
        this.makeComponent(this.grib2TabPane, "GRIB2data");
        this.grib2DataPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib2TabPane);
        this.grib2TabPane.setSelectedComponent(this.grib2DataPanel);
    }

    private void openGrib1Data(String datasetName) {
        this.makeComponent(this.grib1TabPane, "GRIB1data");
        this.grib1DataPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib1TabPane);
        this.grib1TabPane.setSelectedComponent(this.grib1DataPanel);
    }

    private void openGridDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "Grids");
        this.gridPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.gridPanel);
    }

    private void openCoverageDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "Coverages");
        this.coveragePanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.coveragePanel);
    }

    private void openGridDataset(NetcdfDataset dataset) {
        this.makeComponent(this.ftTabPane, "Grids");
        this.gridPanel.setDataset(dataset);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.gridPanel);
    }

    private void openGridDataset(ucar.nc2.dt.GridDataset dataset) {
        this.makeComponent(this.ftTabPane, "Grids");
        this.gridPanel.setDataset(dataset);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.gridPanel);
    }

    private void openRadialDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "Radial");
        this.radialPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.radialPanel);
    }

    private void openWMSDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "WMS");
        this.wmsPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.wmsPanel);
    }

    private void setThreddsDatatype(Dataset invDataset, String wants) {
        if (invDataset == null) {
            return;
        }
        boolean wantsViewer = wants.equals("File");
        boolean wantsCoordSys = wants.equals("CoordSys");
        try {
            if (wantsViewer) {
                this.openNetcdfFile((NetcdfFile)this.threddsDataFactory.openDataset(invDataset, true, null, null));
                return;
            }
            if (wantsCoordSys) {
                NetcdfDataset ncd = this.threddsDataFactory.openDataset(invDataset, true, null, null);
                ncd.enhance();
                this.openCoordSystems(ncd);
                return;
            }
            DataFactory.Result threddsData = this.threddsDataFactory.openFeatureDataset(invDataset, null);
            if (threddsData == null) {
                JOptionPane.showMessageDialog(null, "Unknown datatype");
                return;
            }
            this.jumptoThreddsDatatype(threddsData);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Error on setThreddsDatatype = " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    private void jumptoThreddsDatatype(Access invAccess) {
        if (invAccess == null) {
            return;
        }
        Service s = invAccess.getService();
        if (s.getType() == ServiceType.HTTPServer) {
            this.downloadFile(invAccess.getStandardUrlName());
            return;
        }
        if (s.getType() == ServiceType.WMS) {
            this.openWMSDataset(invAccess.getStandardUrlName());
            return;
        }
        Dataset ds = invAccess.getDataset();
        if (ds.getFeatureType() == null) {
            try {
                this.openNetcdfFile((NetcdfFile)this.threddsDataFactory.openDataset(invAccess, true, null, null));
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, "Error on setThreddsDatatype = " + ioe.getMessage());
            }
            return;
        }
        try {
            DataFactory.Result threddsData = this.threddsDataFactory.openFeatureDataset(invAccess, null);
            this.jumptoThreddsDatatype(threddsData);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error on setThreddsDatatype = " + ioe.getMessage());
        }
    }

    private void jumptoThreddsDatatype(DataFactory.Result threddsData) {
        if (threddsData.fatalError) {
            JOptionPane.showMessageDialog(this, "Cant open dataset=" + threddsData.errLog);
            return;
        }
        if (threddsData.featureType == FeatureType.GRID) {
            this.makeComponent(this.ftTabPane, "Grids");
            this.gridPanel.setDataset((NetcdfDataset)threddsData.featureDataset.getNetcdfFile());
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.gridPanel);
        } else if (threddsData.featureType == FeatureType.IMAGE) {
            this.makeComponent(this.ftTabPane, "Images");
            this.imagePanel.setImageLocation(threddsData.imageURL);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.imagePanel);
        } else if (threddsData.featureType == FeatureType.RADIAL) {
            this.makeComponent(this.ftTabPane, "Radial");
            this.radialPanel.setDataset((RadialDatasetSweep)threddsData.featureDataset);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.radialPanel);
        } else if (threddsData.featureType.isPointFeatureType()) {
            this.makeComponent(this.ftTabPane, "PointFeature");
            this.pointFeaturePanel.setPointFeatureDataset((FeatureDatasetPoint)((PointDatasetImpl)threddsData.featureDataset));
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.pointFeaturePanel);
        } else if (threddsData.featureType == FeatureType.STATION_RADIAL) {
            this.makeComponent(this.ftTabPane, "StationRadial");
            this.stationRadialPanel.setStationRadialDataset(threddsData.featureDataset);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.stationRadialPanel);
        }
    }

    private NetcdfFile openFile(String location, boolean addCoords, CancelTask task) {
        Object ncfile = null;
        try {
            ncfile = addCoords ? NetcdfDataset.acquireDataset((String)location, (CancelTask)task) : NetcdfDataset.acquireFile((String)location, (CancelTask)task);
            if (ncfile == null) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + location);
            } else if (this.setUseRecordStructure) {
                ncfile.sendIospMessage((Object)"AddRecordStructure");
            }
        }
        catch (IOException ioe) {
            String message = ioe.getMessage();
            if (null == message && ioe instanceof EOFException) {
                message = "Premature End of File";
            }
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + location + "\n" + message);
            if (!(ioe instanceof FileNotFoundException)) {
                ioe.printStackTrace();
            }
            ncfile = null;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + location + "\n" + e.getMessage());
            log.error("NetcdfDataset.open cant open " + location, (Throwable)e);
            e.printStackTrace();
            try {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
            catch (IOException ee) {
                System.out.printf("close failed%n", new Object[0]);
            }
            ncfile = null;
        }
        return ncfile;
    }

    private void downloadFile(String urlString) {
        int pos = urlString.lastIndexOf(47);
        String defFilename = pos >= 0 ? urlString.substring(pos) : urlString;
        String fileOutName = this.fileChooser.chooseFilename(defFilename);
        if (fileOutName == null) {
            return;
        }
        String[] values = new String[]{fileOutName, urlString};
        GetDataRunnable runner = new GetDataRunnable(){

            @Override
            public void run(Object o) {
                String[] values = (String[])o;
                try (FileOutputStream fos = new FileOutputStream(values[0]);){
                    BufferedOutputStream out = new BufferedOutputStream(fos, 60000);
                    IO.copyUrlB((String)values[1], (OutputStream)out, (int)60000);
                    ToolsUI.this.downloadStatus = values[1] + " written to " + values[0];
                }
                catch (IOException ioe) {
                    ToolsUI.this.downloadStatus = "Error opening " + values[0] + " and reading " + values[1] + "\n" + ioe.getMessage();
                }
            }
        };
        GetDataTask task = new GetDataTask(runner, urlString, values);
        ProgressMonitor pm = new ProgressMonitor(task);
        pm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, e.getActionCommand() + "\n" + ToolsUI.this.downloadStatus);
                ToolsUI.this.downloadStatus = null;
            }
        });
        pm.start(this, "Download", 30);
    }

    private void initBufrFileChooser() {
        this.bufrFileChooser = new FileManager(this.parentFrame, null, null, (PreferencesExt)prefs.node("bufrFileManager"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getVersion() {
        try (InputStream is = Resource.getFileResource("/README");){
            if (is == null) {
                String string = "4.6";
                return string;
            }
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(is, CDM.utf8Charset));
            StringBuilder sbuff = new StringBuilder();
            for (int i = 0; i < 3; ++i) {
                sbuff.append(dataIS.readLine());
                sbuff.append("<br>");
            }
            String version = sbuff.toString();
            return version;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "version unknown";
        }
    }

    private static void exit() {
        ToolsUI.doSavePrefsAndUI();
        System.exit(0);
    }

    private static void doSavePrefsAndUI() {
        ui.save();
        Rectangle bounds = frame.getBounds();
        prefs.putBeanObject(FRAME_SIZE, bounds);
        try {
            store.save();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        done = true;
        RandomAccessFile.shutdown();
        NetcdfDataset.shutdown();
        GribCdmIndex.shutdown();
        MetadataManager.closeAll();
    }

    private static void setDataset() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int pos = wantDataset.indexOf(35);
                if (pos > 0) {
                    String catName = wantDataset.substring(0, pos);
                    if (catName.endsWith(".xml")) {
                        ui.makeComponent(null, "THREDDS");
                        ui.threddsUI.setDataset(wantDataset);
                        ui.tabbedPane.setSelectedComponent(ui.threddsUI);
                    }
                    return;
                }
                ui.openNetcdfFile(wantDataset);
            }
        });
    }

    private static void createGui() {
        if (isMacOs) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ToolsUI.doSavePrefsAndUI();
                }
            });
        } else {
            try {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Nimbus".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                log.warn("Found Nimbus Look and Feel, but couldn't install it.", (Throwable)e);
            }
        }
        final MySplashScreen splash = new MySplashScreen();
        BAMutil.setResourcePath("/resources/nj22/ui/icons/");
        frame = new JFrame("NetCDF (4.6) Tools");
        ui = new ToolsUI(prefs, frame);
        frame.setIconImage(BAMutil.getImage("netcdfUI"));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                splash.setVisible(false);
                splash.dispose();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (!done) {
                    ToolsUI.exit();
                }
            }
        });
        frame.getContentPane().add(ui);
        Rectangle bounds = (Rectangle)prefs.getBean(FRAME_SIZE, new Rectangle(50, 50, 800, 450));
        frame.setBounds(bounds);
        frame.pack();
        frame.setBounds(bounds);
        frame.setVisible(true);
        if (wantDataset != null) {
            ToolsUI.setDataset();
        }
    }

    public static void main(String[] args) {
        CommandLine cmdLine;
        if (debugListen) {
            System.out.println("Arguments:");
            for (String arg : args) {
                System.out.println(" " + arg);
            }
            HTTPSession.debugHeaders((boolean)true);
        }
        String progName = ToolsUI.class.getName();
        try {
            cmdLine = new CommandLine(progName, args);
            if (cmdLine.help) {
                cmdLine.printUsage();
                return;
            }
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            System.err.printf("Try \"%s --help\" for more information.%n", progName);
            return;
        }
        if (!cmdLine.datasets.isEmpty()) {
            wantDataset = cmdLine.datasets.get(0);
            SocketMessage sm = new SocketMessage(14444, wantDataset);
            if (sm.isAlreadyRunning()) {
                System.out.println("ToolsUI already running - pass argument= '" + wantDataset + "' to it and exit");
                System.exit(0);
            }
        } else {
            SocketMessage sm = new SocketMessage(14444, null);
            if (sm.isAlreadyRunning()) {
                System.out.println("ToolsUI already running - start up another copy");
            } else {
                sm.addEventListener(new SocketMessage.EventListener(){

                    @Override
                    public void setMessage(SocketMessage.Event event) {
                        wantDataset = event.getMessage();
                        if (debugListen) {
                            System.out.println(" got message= '" + wantDataset);
                        }
                        ToolsUI.setDataset();
                    }
                });
            }
        }
        try (ClassPathXmlApplicationContext springContext = new ClassPathXmlApplicationContext("classpath:resources/nj22/ui/spring/application-config.xml");){
            String filename;
            File f;
            StringBuilder errlog;
            boolean configRead = false;
            if (cmdLine.nj22ConfigFile != null) {
                try (FileInputStream fis = new FileInputStream(cmdLine.nj22ConfigFile);){
                    errlog = new StringBuilder();
                    RuntimeConfigParser.read((InputStream)fis, (StringBuilder)errlog);
                    configRead = true;
                    System.out.println(errlog);
                }
                catch (IOException ioe) {
                    System.out.println("Error reading " + cmdLine.nj22ConfigFile + "=" + ioe.getMessage());
                }
            }
            if (!configRead && (f = new File(filename = XMLStore.makeStandardFilename(".unidata", "nj22Config.xml"))).exists()) {
                try {
                    errlog = new StringBuilder();
                    FileInputStream fis = new FileInputStream(filename);
                    RuntimeConfigParser.read((InputStream)fis, (StringBuilder)errlog);
                    System.out.println(errlog);
                }
                catch (IOException ioe) {
                    System.out.println("Error reading " + filename + "=" + ioe.getMessage());
                }
            }
            try {
                String prefStoreBack;
                File prefs43;
                String prefStore = XMLStore.makeStandardFilename(".unidata", "ToolsUI.xml");
                File prefs44 = new File(prefStore);
                if (!prefs44.exists() && (prefs43 = new File(prefStoreBack = XMLStore.makeStandardFilename(".unidata", "NetcdfUI22.xml"))).exists()) {
                    IO.copyFile((File)prefs43, (File)prefs44);
                }
                store = XMLStore.createFromFile(prefStore, null);
                prefs = store.getPreferences();
                Debug.setStore(prefs.node("Debug"));
            }
            catch (IOException e) {
                System.out.println("XMLStore Creation failed " + e);
            }
            Aggregation.setPersistenceCache((DiskCache2)new DiskCache2("/.unidata/aggCache", true, 43200, 60));
            try {
                CollectionManagerAbstract.setMetadataStore((StoreKeyValue.Factory)MetadataManager.getFactory());
            }
            catch (Exception e) {
                log.error("CdmInit: Failed to open CollectionManagerAbstract.setMetadataStore", (Throwable)e);
            }
            UrlAuthenticatorDialog provider = new UrlAuthenticatorDialog(frame);
            try {
                HTTPSession.setGlobalCredentialsProvider((CredentialsProvider)provider);
            }
            catch (HTTPException e) {
                log.error("Failed to set global credentials");
            }
            HTTPSession.setGlobalUserAgent((String)"ToolsUI v4.6");
            Authenticator.setDefault(provider);
            DODSNetcdfFile.setAllowCompression((boolean)true);
            DODSNetcdfFile.setAllowSessions((boolean)true);
            RandomAccessFile.enableDefaultGlobalFileCache();
            GribCdmIndex.initDefaultCollectionCache((int)100, (int)200, (int)-1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolsUI.createGui();
                }
            });
        }
    }

    static {
        done = false;
        wantDataset = null;
        isCacheInit = false;
    }

    private static class CommandLine {
        @Parameter(names={"-nj22Config"}, description="Runtime configuration file.", required=false)
        public File nj22ConfigFile;
        @Parameter(description="Dataset")
        public List<String> datasets = new ArrayList<String>();
        @Parameter(names={"-h", "--help"}, description="Display this help and exit", help=true)
        public boolean help = false;
        private final JCommander jc;

        public CommandLine(String progName, String[] args) throws ParameterException {
            this.jc = new JCommander((Object)this, args);
            this.jc.setProgramName(progName);
        }

        public void printUsage() {
            this.jc.usage();
        }
    }

    private static class MySplashScreen
    extends JWindow {
        public MySplashScreen() {
            Image image = Resource.getImage("/resources/nj22/ui/pix/ring2.jpg");
            if (image != null) {
                ImageIcon icon = new ImageIcon(image);
                JLabel lab = new JLabel(icon);
                this.getContentPane().add(lab);
                this.pack();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int width = image.getWidth(null);
                int height = image.getHeight(null);
                this.setLocation(screenSize.width / 2 - width / 2, screenSize.height / 2 - height / 2);
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        MySplashScreen.this.setVisible(false);
                    }
                });
                this.setVisible(true);
            }
        }
    }

    private class AboutWindow
    extends JWindow {
        public AboutWindow() {
            super(ToolsUI.this.parentFrame);
            JLabel lab1 = new JLabel("<html> <body bgcolor=\"#FFECEC\"> <center><h1>Netcdf Tools User Interface (ToolsUI)</h1><b>" + ToolsUI.this.getVersion() + "</b><br><i>https://www.unidata.ucar.edu/software/netcdf-java/</i><br><b><i>Developers:</b>John Caron, Ethan Davis, Sean Arms, Dennis Heimbinger, Lansing Madry, Ryan May, Christian Ward-Garrison</i></b></center><br><br>With thanks to these <b>Open Source</b> contributors:<ul><li><b>ADDE/VisAD</b>: Bill Hibbard, Don Murray, Tom Whittaker, et al (http://www.ssec.wisc.edu/~billh/visad.html)</li><li><b>Apache HTTP Components</b> libraries: (http://hc.apache.org/)</li><li><b>Apache Jakarta Commons</b> libraries: (http://http://jakarta.apache.org/commons/)</li><li><b>IDV:</b> Yuan Ho, Julien Chastang, Don Murray, Jeff McWhirter, Yuan H (https://www.unidata.ucar.edu/software/IDV/)</li><li><b>Joda Time</b> library: Stephen Colebourne (http://www.joda.org/joda-time/)</li><li><b>JDOM</b> library: Jason Hunter, Brett McLaughlin et al (www.jdom.org)</li><li><b>JGoodies</b> library: Karsten Lentzsch (www.jgoodies.com)</li><li><b>JPEG-2000</b> Java library: (http://www.jpeg.org/jpeg2000/)</li><li><b>JUnit</b> library: Erich Gamma, Kent Beck, Erik Meade, et al (http://sourceforge.net/projects/junit/)</li><li><b>NetCDF C Library</b> library: Russ Rew, Ward Fisher, Dennis Heimbinger</li><li><b>OPeNDAP Java</b> library: Dennis Heimbinger, James Gallagher, Nathan Potter, Don Denbo, et. al.(http://opendap.org)</li><li><b>Protobuf serialization</b> library: Google (http://code.google.com/p/protobuf/)</li><li><b>Simple Logging Facade for Java</b> library: Ceki Gulcu (http://www.slf4j.org/)</li><li><b>Spring lightweight framework</b> library: Rod Johnson, et. al.(http://www.springsource.org/)</li><li><b>Imaging utilities:</b>: Richard Eigenmann</li><li><b>Udunits:</b>: Steve Emmerson</li></ul><center>Special thanks to <b>Sun/Oracle</b> (java.oracle.com) for the platform on which we stand.</center></body></html> ");
            JPanel main = new JPanel(new BorderLayout());
            main.setBorder(new LineBorder(Color.BLACK));
            main.setBackground(new Color(0xFFECEC));
            JLabel icon = new JLabel(new ImageIcon(BAMutil.getImage("netcdfUI")));
            icon.setOpaque(true);
            icon.setBackground(new Color(0xFFECEC));
            JLabel threddsLogo = new JLabel(Resource.getIcon(BAMutil.getResourcePath() + "threddsLogo.png", false));
            threddsLogo.setBackground(new Color(0xFFECEC));
            threddsLogo.setOpaque(true);
            main.add((Component)icon, "North");
            main.add((Component)lab1, "Center");
            main.add((Component)threddsLogo, "South");
            this.getContentPane().add(main);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = this.getPreferredSize();
            this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    AboutWindow.this.setVisible(false);
                }
            });
            this.setVisible(true);
        }
    }

    private static class DebugProxyHandler
    implements InvocationHandler {
        private DebugProxyHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                return super.toString();
            }
            if (method.getName().equals("isSet")) {
                return Debug.isSet((String)args[0]);
            }
            if (method.getName().equals("set")) {
                Debug.set((String)args[0], (Boolean)args[1]);
                return null;
            }
            return Boolean.FALSE;
        }
    }

    private static class GetDataTask
    extends ProgressMonitorTask
    implements CancelTask {
        GetDataRunnable getData;
        Object o;
        String name;
        String errMsg = null;

        GetDataTask(GetDataRunnable getData, String name, Object o) {
            this.getData = getData;
            this.name = name;
            this.o = o;
        }

        @Override
        public void run() {
            try {
                this.getData.run(this.o);
            }
            catch (FileNotFoundException ioe) {
                this.errMsg = "Cant open " + this.name + " " + ioe.getMessage();
                this.success = false;
                this.done = true;
                return;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.errMsg = sw.toString();
                this.success = false;
                this.done = true;
                return;
            }
            this.success = true;
            this.done = true;
        }
    }

    private static interface GetDataRunnable {
        public void run(Object var1) throws IOException;
    }

    private class GeotiffPanel
    extends OpPanel {
        TextHistoryPane ta;

        GeotiffPanel(PreferencesExt p) {
            super(p, "netcdf:", true, false);
            this.ta = new TextHistoryPane(true);
            this.add((Component)this.ta, "Center");
            JButton readButton = new JButton("read geotiff");
            readButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String item = GeotiffPanel.this.cb.getSelectedItem().toString();
                    String fname = item.trim();
                    GeotiffPanel.this.read(fname);
                }
            });
            this.buttPanel.add(readButton);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean process(Object o) {
            String filename = (String)o;
            GridDataset gridDs = null;
            try {
                gridDs = GridDataset.open((String)filename);
                List grids = gridDs.getGrids();
                if (grids.size() == 0) {
                    System.out.println("No grids found.");
                    boolean bl = false;
                    return bl;
                }
                GridDatatype grid = (GridDatatype)grids.get(0);
                Array data = grid.readDataSlice(0, 0, -1, -1);
                String fileOut = ToolsUI.this.fileChooser.chooseFilenameToSave(filename + ".tif");
                if (fileOut == null) {
                    boolean bl = false;
                    return bl;
                }
                GeotiffWriter writer = new GeotiffWriter(fileOut);
                writer.writeGrid((ucar.nc2.dt.GridDataset)gridDs, grid, data, false);
                this.read(fileOut);
                JOptionPane.showMessageDialog(null, "File written to " + fileOut);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (gridDs != null) {
                        gridDs.close();
                    }
                }
                catch (IOException ioe) {
                    System.out.printf("close failed %n", new Object[0]);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void read(String filename) {
            GeoTiff geotiff = null;
            try {
                geotiff = new GeoTiff(filename);
                geotiff.read();
                this.ta.setText(geotiff.showInfo());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                try {
                    if (geotiff != null) {
                        geotiff.close();
                    }
                }
                catch (IOException ioe) {
                    System.out.printf("close failed %n", new Object[0]);
                }
            }
        }

        @Override
        void closeOpenFiles() throws IOException {
        }
    }

    private class ImagePanel
    extends OpPanel {
        ImageViewPanel imagePanel;
        JSplitPane split;

        ImagePanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.imagePanel = new ImageViewPanel(this.buttPanel);
            this.add((Component)this.imagePanel, "Center");
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            try {
                if (null != command) {
                    this.imagePanel.setImageFromUrl(command);
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                return false;
            }
            return true;
        }

        void setImageLocation(String location) {
            this.imagePanel.setImageFromUrl(location);
            this.setSelectedItem(location);
        }

        @Override
        void closeOpenFiles() throws IOException {
        }
    }

    private class StationRadialPanel
    extends OpPanel {
        StationRadialViewer radialViewer;
        JSplitPane split;
        FeatureDataset radarCollectionDataset;

        StationRadialPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.radarCollectionDataset = null;
            this.radialViewer = new StationRadialViewer(dbPrefs);
            this.add((Component)this.radialViewer, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Dataset Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (StationRadialPanel.this.radarCollectionDataset != null) {
                        Formatter info = new Formatter();
                        StationRadialPanel.this.radarCollectionDataset.getDetailInfo(info);
                        StationRadialPanel.this.detailTA.setText(info.toString());
                        StationRadialPanel.this.detailTA.gotoTop();
                        StationRadialPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
        }

        @Override
        boolean process(Object o) {
            String location = (String)o;
            return this.setStationRadialDataset(location);
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.radarCollectionDataset != null) {
                this.radarCollectionDataset.close();
            }
            this.radarCollectionDataset = null;
        }

        @Override
        void save() {
            super.save();
            this.radialViewer.save();
        }

        boolean setStationRadialDataset(String location) {
            if (location == null) {
                return false;
            }
            try {
                if (this.radarCollectionDataset != null) {
                    this.radarCollectionDataset.close();
                }
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            try {
                DataFactory.Result result = ToolsUI.this.threddsDataFactory.openFeatureDataset(FeatureType.STATION_RADIAL, location, null);
                if (result.fatalError) {
                    JOptionPane.showMessageDialog(null, "Can't open " + location + ": " + result.errLog.toString());
                    return false;
                }
                this.setStationRadialDataset(result.featureDataset);
                return true;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(log.toString());
                this.detailTA.appendLine(sw.toString());
                this.detailWindow.show();
                JOptionPane.showMessageDialog(this, e.getMessage());
                return false;
            }
        }

        boolean setStationRadialDataset(FeatureDataset dataset) {
            if (dataset == null) {
                return false;
            }
            try {
                if (this.radarCollectionDataset != null) {
                    this.radarCollectionDataset.close();
                }
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            this.radarCollectionDataset = dataset;
            this.radialViewer.setDataset(this.radarCollectionDataset);
            this.setSelectedItem(this.radarCollectionDataset.getLocation());
            return true;
        }
    }

    private class WmsPanel
    extends OpPanel {
        WmsViewer wmsViewer;
        JSplitPane split;
        JComboBox<String> types;

        WmsPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.wmsViewer = new WmsViewer(dbPrefs, frame);
            this.add((Component)this.wmsViewer, "Center");
            this.buttPanel.add(new JLabel("version:"));
            this.types = new JComboBox();
            this.types.addItem("1.3.0");
            this.types.addItem("1.1.1");
            this.types.addItem("1.0.0");
            this.buttPanel.add(this.types);
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WmsPanel.this.detailTA.setText(WmsPanel.this.wmsViewer.getDetailInfo());
                    WmsPanel.this.detailTA.gotoTop();
                    WmsPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
        }

        @Override
        boolean process(Object o) {
            String location = (String)o;
            return this.wmsViewer.setDataset((String)this.types.getSelectedItem(), location);
        }

        @Override
        void closeOpenFiles() {
        }

        @Override
        void save() {
            super.save();
            this.wmsViewer.save();
        }
    }

    private class PointFeaturePanel
    extends OpPanel {
        PointFeatureDatasetViewer pfViewer;
        JSplitPane split;
        FeatureDatasetPoint pfDataset;
        JComboBox<FeatureType> types;

        PointFeaturePanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.pfDataset = null;
            this.pfViewer = new PointFeatureDatasetViewer(dbPrefs, this.buttPanel);
            this.add((Component)this.pfViewer, "Center");
            this.types = new JComboBox();
            for (FeatureType ft : FeatureType.values()) {
                this.types.addItem(ft);
            }
            this.types.getModel().setSelectedItem(FeatureType.ANY_POINT);
            this.buttPanel.add(this.types);
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Dataset Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PointFeaturePanel.this.pfDataset == null) {
                        return;
                    }
                    Formatter f = new Formatter();
                    PointFeaturePanel.this.pfDataset.getDetailInfo(f);
                    PointFeaturePanel.this.detailTA.setText(f.toString());
                    PointFeaturePanel.this.detailTA.appendLine("-----------------------------");
                    PointFeaturePanel.this.detailTA.appendLine(PointFeaturePanel.this.getCapabilities(PointFeaturePanel.this.pfDataset));
                    PointFeaturePanel.this.detailTA.gotoTop();
                    PointFeaturePanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
            AbstractButton xmlButton = BAMutil.makeButtcon("XML", "pointConfig.xml", false);
            xmlButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PointFeaturePanel.this.pfDataset == null) {
                        return;
                    }
                    Formatter f = new Formatter();
                    PointConfigXML.writeConfigXML((FeatureDatasetPoint)PointFeaturePanel.this.pfDataset, (Formatter)f);
                    PointFeaturePanel.this.detailTA.setText(f.toString());
                    PointFeaturePanel.this.detailTA.gotoTop();
                    PointFeaturePanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(xmlButton);
            AbstractButton calcButton = BAMutil.makeButtcon("V3", "CalcBounds", false);
            calcButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PointFeaturePanel.this.pfDataset == null) {
                        return;
                    }
                    Formatter f = new Formatter();
                    try {
                        PointFeaturePanel.this.pfDataset.calcBounds();
                        PointFeaturePanel.this.pfDataset.getDetailInfo(f);
                        PointFeaturePanel.this.detailTA.setText(f.toString());
                    }
                    catch (IOException ioe) {
                        StringWriter sw = new StringWriter(5000);
                        ioe.printStackTrace(new PrintWriter(sw));
                        PointFeaturePanel.this.detailTA.setText(sw.toString());
                    }
                    PointFeaturePanel.this.detailTA.gotoTop();
                    PointFeaturePanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(calcButton);
        }

        @Override
        boolean process(Object o) {
            String location = (String)o;
            return this.setPointFeatureDataset((FeatureType)this.types.getSelectedItem(), location);
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.pfDataset != null) {
                this.pfDataset.close();
            }
            this.pfDataset = null;
            this.pfViewer.clear();
        }

        @Override
        void save() {
            super.save();
            this.pfViewer.save();
        }

        private boolean setPointFeatureDataset(FeatureType type, String location) {
            if (location == null) {
                return false;
            }
            try {
                if (this.pfDataset != null) {
                    this.pfDataset.close();
                }
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            this.detailTA.clear();
            Formatter log = new Formatter();
            try {
                FeatureDataset featureDataset = FeatureDatasetFactoryManager.open((FeatureType)type, (String)location, null, (Formatter)log);
                if (featureDataset == null) {
                    JOptionPane.showMessageDialog(null, "Can't open " + location + ": " + log);
                    return false;
                }
                if (!(featureDataset instanceof FeatureDatasetPoint)) {
                    JOptionPane.showMessageDialog(null, location + " could not be opened as a PointFeatureDataset");
                    return false;
                }
                this.pfDataset = (FeatureDatasetPoint)featureDataset;
                this.pfViewer.setDataset(this.pfDataset);
                this.setSelectedItem(location);
                return true;
            }
            catch (IOException e) {
                String message = e.getClass().getName() + ": " + e.getMessage();
                JOptionPane.showMessageDialog(this, message);
                return false;
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(log.toString());
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                JOptionPane.showMessageDialog(this, e.getMessage());
                return false;
            }
        }

        private boolean setPointFeatureDataset(FeatureDatasetPoint pfd) {
            try {
                if (this.pfDataset != null) {
                    this.pfDataset.close();
                }
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            this.detailTA.clear();
            try {
                this.pfDataset = pfd;
                this.pfViewer.setDataset(this.pfDataset);
                this.setSelectedItem(this.pfDataset.getLocation());
                return true;
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                JOptionPane.showMessageDialog(this, e.getMessage());
                return false;
            }
        }

        private String getCapabilities(FeatureDatasetPoint fdp) {
            FeatureDatasetPointXML xmlWriter = new FeatureDatasetPointXML(fdp, null);
            return xmlWriter.getCapabilities();
        }
    }

    private class DirectoryPartitionPanel
    extends OpPanel {
        DirectoryPartitionViewer table;

        DirectoryPartitionPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "collection:", false, false, false);
            this.table = new DirectoryPartitionViewer(this.prefs, this.topPanel, this.buttPanel);
            this.add((Component)this.table, "Center");
            this.table.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openGrib2Collection")) {
                        String collectionName = (String)e.getNewValue();
                        ToolsUI.this.openGrib2Collection(collectionName);
                    }
                }
            });
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            if (command == null) {
                return false;
            }
            try {
                return true;
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
                return false;
            }
        }

        @Override
        void closeOpenFiles() {
        }

        @Override
        void save() {
            this.table.save();
            super.save();
            this.table.clear();
        }
    }

    private class CollectionSpecPanel
    extends OpPanel {
        CollectionSpecTable table;

        CollectionSpecPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "collection spec:", true, false);
            this.table = new CollectionSpecTable(this.prefs);
            this.add((Component)this.table, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        CollectionSpecPanel.this.table.showCollection(f);
                    }
                    catch (Exception e1) {
                        StringWriter sw = new StringWriter(5000);
                        e1.printStackTrace(new PrintWriter(sw));
                        f.format("%s", sw.toString());
                    }
                    CollectionSpecPanel.this.detailTA.setText(f.toString());
                    CollectionSpecPanel.this.detailTA.gotoTop();
                    CollectionSpecPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            if (command == null) {
                return false;
            }
            try {
                this.table.setCollection(command);
                return true;
            }
            catch (Exception ioe) {
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
                return false;
            }
        }

        @Override
        void closeOpenFiles() {
        }

        @Override
        void save() {
            this.table.save();
            super.save();
        }
    }

    private class FeatureScanPanel
    extends OpPanel {
        ucar.nc2.ui.FeatureScanPanel ftTable;
        final FileManager dirChooser;

        FeatureScanPanel(PreferencesExt prefs) {
            super(prefs, "dir:", false, false);
            this.dirChooser = new FileManager(ToolsUI.this.parentFrame, null, null, (PreferencesExt)prefs.node("FeatureScanFileManager"));
            this.ftTable = new ucar.nc2.ui.FeatureScanPanel(prefs);
            this.add((Component)this.ftTable, "Center");
            this.ftTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openPointFeatureDataset")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openPointFeatureDataset(datasetName);
                    } else if (e.getPropertyName().equals("openNetcdfFile")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openNetcdfFile(datasetName);
                    } else if (e.getPropertyName().equals("openCoordSystems")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openCoordSystems(datasetName);
                    } else if (e.getPropertyName().equals("openNcML")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openNcML(datasetName);
                    } else if (e.getPropertyName().equals("openGridDataset")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openGridDataset(datasetName);
                    } else if (e.getPropertyName().equals("openCoverageDataset")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openCoverageDataset(datasetName);
                    } else if (e.getPropertyName().equals("openRadialDataset")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openRadialDataset(datasetName);
                    }
                }
            });
            this.dirChooser.getFileChooser().setFileSelectionMode(2);
            this.dirChooser.setCurrentDirectory(prefs.get("currDir", "."));
            AbstractAction fileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename = FeatureScanPanel.this.dirChooser.chooseFilename();
                    if (filename == null) {
                        return;
                    }
                    FeatureScanPanel.this.cb.setSelectedItem(filename);
                }
            };
            BAMutil.setActionProperties(fileAction, "FileChooser", "open Local dataset...", false, 76, -1);
            BAMutil.addActionToContainer(this.buttPanel, fileAction);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            return this.ftTable.setScanDirectory(command);
        }

        @Override
        void closeOpenFiles() {
            this.ftTable.clear();
        }

        @Override
        void save() {
            this.dirChooser.save();
            this.ftTable.save();
            this.prefs.put("currDir", this.dirChooser.getCurrentDirectory());
            super.save();
        }
    }

    private class DatasetWriterPanel
    extends OpPanel {
        DatasetWriter dsWriter;
        JSplitPane split;
        NetcdfFile ncfile;

        DatasetWriterPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:");
            this.ncfile = null;
            this.dsWriter = new DatasetWriter(dbPrefs, ToolsUI.this.fileChooser);
            this.add((Component)this.dsWriter, "Center");
            this.dsWriter.addActions(this.buttPanel);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                if (this.ncfile != null) {
                    this.ncfile.close();
                }
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            try {
                NetcdfFile ncnew = ToolsUI.this.openFile(command, this.addCoords, null);
                if (ncnew != null) {
                    this.setDataset(ncnew);
                }
            }
            catch (Exception ioe) {
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ncfile != null) {
                this.ncfile.close();
            }
            this.ncfile = null;
        }

        void setDataset(NetcdfFile nc) {
            try {
                if (this.ncfile != null) {
                    this.ncfile.close();
                }
                this.ncfile = null;
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            this.ncfile = nc;
            if (this.ncfile != null) {
                this.dsWriter.setDataset(nc);
                this.setSelectedItem(nc.getLocation());
            }
        }

        @Override
        void save() {
            super.save();
            this.dsWriter.save();
        }
    }

    private class DatasetViewerPanel
    extends OpPanel {
        DatasetViewer dsViewer;
        JSplitPane split;
        NetcdfFile ncfile;
        boolean jni;

        DatasetViewerPanel(PreferencesExt dbPrefs, boolean jni) {
            super(dbPrefs, "dataset:");
            this.ncfile = null;
            this.jni = jni;
            this.dsViewer = new DatasetViewer(dbPrefs, ToolsUI.this.fileChooser);
            this.add((Component)this.dsViewer, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DatasetViewerPanel.this.ncfile != null) {
                        DatasetViewerPanel.this.detailTA.setText(DatasetViewerPanel.this.ncfile.getDetailInfo());
                        DatasetViewerPanel.this.detailTA.gotoTop();
                        DatasetViewerPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
            AbstractAction dumpAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetcdfFile ds = DatasetViewerPanel.this.dsViewer.getDataset();
                    if (ds != null) {
                        if (ToolsUI.this.ncdumpPanel == null) {
                            ToolsUI.this.makeComponent(ToolsUI.this.tabbedPane, "NCDump");
                        }
                        ToolsUI.this.ncdumpPanel.setNetcdfFile(ds);
                        ToolsUI.this.tabbedPane.setSelectedComponent(ToolsUI.this.ncdumpPanel);
                    }
                }
            };
            BAMutil.setActionProperties(dumpAction, "Dump", "NCDump", false, 68, -1);
            BAMutil.addActionToContainer(this.buttPanel, dumpAction);
            this.dsViewer.addActions(this.buttPanel);
        }

        @Override
        boolean process(Object o) {
            String location = (String)o;
            boolean err = false;
            try {
                if (this.ncfile != null) {
                    this.ncfile.close();
                }
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            try {
                NetcdfFile ncnew;
                if (this.jni) {
                    Nc4Iosp iosp = new Nc4Iosp(NetcdfFileWriter.Version.netcdf4);
                    ncnew = new NetcdfFileSubclass((IOServiceProvider)iosp, location);
                    RandomAccessFile raf = new RandomAccessFile(location, "r");
                    iosp.open(raf, ncnew, null);
                } else {
                    ncnew = ToolsUI.this.openFile(location, this.addCoords, null);
                }
                if (ncnew != null) {
                    this.setDataset(ncnew);
                }
            }
            catch (Exception ioe) {
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ncfile != null) {
                this.ncfile.close();
            }
            this.ncfile = null;
            this.dsViewer.clear();
        }

        void setDataset(NetcdfFile nc) {
            try {
                if (this.ncfile != null) {
                    this.ncfile.close();
                }
                this.ncfile = null;
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            this.ncfile = nc;
            if (this.ncfile != null) {
                this.dsViewer.setDataset(nc);
                this.setSelectedItem(nc.getLocation());
            }
        }

        @Override
        void save() {
            super.save();
            this.dsViewer.save();
        }
    }

    private class RadialPanel
    extends OpPanel {
        RadialDatasetTable dsTable;
        JSplitPane split;
        RadialDatasetSweep ds;

        RadialPanel(PreferencesExt prefs) {
            super(prefs, "dataset:", true, false);
            this.ds = null;
            this.dsTable = new RadialDatasetTable(prefs);
            this.add((Component)this.dsTable, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Parse Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String info;
                    RadialDatasetSweep radialDataset = RadialPanel.this.dsTable.getRadialDataset();
                    if (radialDataset != null && (info = radialDataset.getDetailInfo()) != null) {
                        RadialPanel.this.detailTA.setText(info);
                        RadialPanel.this.detailTA.gotoTop();
                        RadialPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                NetcdfDataset newds = NetcdfDataset.openDataset((String)command, (boolean)true, null);
                if (newds == null) {
                    JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command);
                    return false;
                }
                Formatter errlog = new Formatter();
                RadialDatasetSweep rds = (RadialDatasetSweep)FeatureDatasetFactoryManager.wrap((FeatureType)FeatureType.RADIAL, (NetcdfDataset)newds, null, (Formatter)errlog);
                if (rds == null) {
                    JOptionPane.showMessageDialog(null, "FeatureDatasetFactoryManager cant open " + command + "as RADIAL dataset\n" + errlog.toString());
                    err = true;
                } else {
                    this.setDataset(rds);
                }
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command + "\n" + ioe.getMessage());
                ioe.printStackTrace();
                err = true;
            }
            catch (IOException ioe) {
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        void setDataset(RadialDatasetSweep newds) {
            if (newds == null) {
                return;
            }
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            this.ds = newds;
            this.dsTable.setDataset(newds);
            this.setSelectedItem(newds.getLocationURI());
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ds != null) {
                this.ds.close();
            }
            this.ds = null;
        }

        @Override
        void save() {
            super.save();
            this.dsTable.save();
        }
    }

    private class CoveragePanel
    extends OpPanel {
        CoverageTable dsTable;
        CoverageDisplay display;
        JSplitPane split;
        IndependentWindow viewerWindow;
        NetcdfDataset ds;

        CoveragePanel(PreferencesExt prefs) {
            super(prefs, "dataset:", true, false);
            this.ds = null;
            this.dsTable = new CoverageTable(prefs);
            this.add((Component)this.dsTable, "Center");
            AbstractButton viewButton = BAMutil.makeButtcon("alien", "Grid Viewer", false);
            viewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CoveragePanel.this.ds != null) {
                        CoverageDataset gridDataset = CoveragePanel.this.dsTable.getCoverageDataset();
                        if (gridDataset == null) {
                            return;
                        }
                        if (CoveragePanel.this.display == null) {
                            CoveragePanel.this.makeDisplay();
                        }
                        CoveragePanel.this.display.setDataset(gridDataset);
                        CoveragePanel.this.viewerWindow.show();
                    }
                }
            });
            this.buttPanel.add(viewButton);
            this.dsTable.addExtra(this.buttPanel, ToolsUI.this.fileChooser);
        }

        private void makeDisplay() {
            this.viewerWindow = new IndependentWindow("Coverage Viewer", BAMutil.getImage("netcdfUI"));
            this.display = new CoverageDisplay((PreferencesExt)this.prefs.node("CoverageDisplay"), this.viewerWindow, ToolsUI.this.fileChooser, 800);
            this.display.addMapBean(new WorldMapBean());
            this.display.addMapBean(new ShapeFileBean("WorldDetailMap", "Global Detailed Map", "WorldDetailMap", ToolsUI.WorldDetailMap));
            this.display.addMapBean(new ShapeFileBean("USDetailMap", "US Detailed Map", "USMap", ToolsUI.USMap));
            this.viewerWindow.setComponent(this.display);
            Rectangle bounds = (Rectangle)ToolsUI.this.mainPrefs.getBean(ToolsUI.GRIDVIEW_FRAME_SIZE, new Rectangle(77, 22, 700, 900));
            if (bounds.x < 0) {
                bounds.x = 0;
            }
            if (bounds.y < 0) {
                bounds.x = 0;
            }
            this.viewerWindow.setBounds(bounds);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                NetcdfDataset newds = NetcdfDataset.openDataset((String)command, (boolean)true, null);
                if (newds == null) {
                    JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command);
                    return false;
                }
                this.setDataset(newds);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Throwable ioe) {
                ioe.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ds != null) {
                this.ds.close();
            }
            this.ds = null;
        }

        void setDataset(NetcdfDataset newds) {
            if (newds == null) {
                return;
            }
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            Formatter parseInfo = new Formatter();
            this.ds = newds;
            try {
                this.dsTable.setDataset(newds, parseInfo);
            }
            catch (IOException e) {
                String info = parseInfo.toString();
                if (info.length() > 0) {
                    this.detailTA.setText(info);
                    this.detailWindow.show();
                }
                e.printStackTrace();
                return;
            }
            this.setSelectedItem(newds.getLocation());
        }

        void setDataset(CoverageDataset gds) {
            if (gds == null) {
                return;
            }
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            try {
                this.dsTable.setDataset(gds);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            this.setSelectedItem(gds.getLocation());
        }

        @Override
        void save() {
            super.save();
            this.dsTable.save();
            if (this.viewerWindow != null) {
                ToolsUI.this.mainPrefs.putBeanObject(ToolsUI.GRIDVIEW_FRAME_SIZE, this.viewerWindow.getBounds());
            }
        }
    }

    private class GeoGridPanel
    extends OpPanel {
        GeoGridTable dsTable;
        JSplitPane split;
        IndependentWindow viewerWindow;
        IndependentWindow imageWindow;
        GridUI gridUI;
        ImageViewPanel imageViewer;
        NetcdfDataset ds;

        GeoGridPanel(PreferencesExt prefs) {
            super(prefs, "dataset:", true, false);
            this.gridUI = null;
            this.ds = null;
            this.dsTable = new GeoGridTable(prefs, true);
            this.add((Component)this.dsTable, "Center");
            AbstractButton viewButton = BAMutil.makeButtcon("alien", "Grid Viewer", false);
            viewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GeoGridPanel.this.ds != null) {
                        ucar.nc2.dt.GridDataset gridDataset = GeoGridPanel.this.dsTable.getGridDataset();
                        if (GeoGridPanel.this.gridUI == null) {
                            GeoGridPanel.this.makeGridUI();
                        }
                        GeoGridPanel.this.gridUI.setDataset(gridDataset);
                        GeoGridPanel.this.viewerWindow.show();
                    }
                }
            });
            this.buttPanel.add(viewButton);
            AbstractButton imageButton = BAMutil.makeButtcon("VCRMovieLoop", "Image Viewer", false);
            imageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GeoGridPanel.this.ds != null) {
                        GridDatatype grid = GeoGridPanel.this.dsTable.getGrid();
                        if (grid == null) {
                            return;
                        }
                        if (GeoGridPanel.this.imageWindow == null) {
                            GeoGridPanel.this.makeImageWindow();
                        }
                        GeoGridPanel.this.imageViewer.setImageFromGrid(grid);
                        GeoGridPanel.this.imageWindow.show();
                    }
                }
            });
            this.buttPanel.add(imageButton);
            this.dsTable.addExtra(this.buttPanel, ToolsUI.this.fileChooser);
        }

        private void makeGridUI() {
            this.viewerWindow = new IndependentWindow("Grid Viewer", BAMutil.getImage("netcdfUI"));
            this.gridUI = new GridUI((PreferencesExt)this.prefs.node("GridUI"), this.viewerWindow, ToolsUI.this.fileChooser, 800);
            this.gridUI.addMapBean(new WorldMapBean());
            this.gridUI.addMapBean(new ShapeFileBean("WorldDetailMap", "Global Detailed Map", "WorldDetailMap", ToolsUI.WorldDetailMap));
            this.gridUI.addMapBean(new ShapeFileBean("USDetailMap", "US Detailed Map", "USMap", ToolsUI.USMap));
            this.viewerWindow.setComponent(this.gridUI);
            Rectangle bounds = (Rectangle)ToolsUI.this.mainPrefs.getBean(ToolsUI.GRIDVIEW_FRAME_SIZE, new Rectangle(77, 22, 700, 900));
            if (bounds.x < 0) {
                bounds.x = 0;
            }
            if (bounds.y < 0) {
                bounds.x = 0;
            }
            this.viewerWindow.setBounds(bounds);
        }

        private void makeImageWindow() {
            this.imageWindow = new IndependentWindow("Grid Image Viewer", BAMutil.getImage("netcdfUI"));
            this.imageViewer = new ImageViewPanel(null);
            this.imageWindow.setComponent(this.imageViewer);
            this.imageWindow.setBounds((Rectangle)ToolsUI.this.mainPrefs.getBean(ToolsUI.GRIDIMAGE_FRAME_SIZE, new Rectangle(77, 22, 700, 900)));
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                NetcdfDataset newds = NetcdfDataset.openDataset((String)command, (boolean)true, null);
                if (newds == null) {
                    JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command);
                    return false;
                }
                this.setDataset(newds);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Throwable ioe) {
                ioe.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ds != null) {
                this.ds.close();
            }
            this.ds = null;
            this.dsTable.clear();
            if (this.gridUI != null) {
                this.gridUI.clear();
            }
        }

        void setDataset(NetcdfDataset newds) {
            if (newds == null) {
                return;
            }
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            Formatter parseInfo = new Formatter();
            this.ds = newds;
            try {
                this.dsTable.setDataset(newds, parseInfo);
            }
            catch (IOException e) {
                String info = parseInfo.toString();
                if (info.length() > 0) {
                    this.detailTA.setText(info);
                    this.detailWindow.show();
                }
                e.printStackTrace();
                return;
            }
            this.setSelectedItem(newds.getLocation());
        }

        void setDataset(ucar.nc2.dt.GridDataset gds) {
            if (gds == null) {
                return;
            }
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            this.ds = (NetcdfDataset)gds.getNetcdfFile();
            try {
                this.dsTable.setDataset(gds);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            this.setSelectedItem(gds.getLocationURI());
        }

        @Override
        void save() {
            super.save();
            this.dsTable.save();
            if (this.gridUI != null) {
                this.gridUI.storePersistentData();
            }
            if (this.viewerWindow != null) {
                ToolsUI.this.mainPrefs.putBeanObject(ToolsUI.GRIDVIEW_FRAME_SIZE, this.viewerWindow.getBounds());
            }
            if (this.imageWindow != null) {
                ToolsUI.this.mainPrefs.putBeanObject(ToolsUI.GRIDIMAGE_FRAME_SIZE, this.imageWindow.getBounds());
            }
        }
    }

    private class FmrcCollectionPanel
    extends OpPanel {
        FmrcCollectionTable table;

        FmrcCollectionPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "collection:", true, false);
            this.table = new FmrcCollectionTable(this.prefs);
            this.add((Component)this.table, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        FmrcCollectionPanel.this.table.showInfo(f);
                    }
                    catch (IOException e1) {
                        StringWriter sw = new StringWriter(5000);
                        e1.printStackTrace(new PrintWriter(sw));
                        f.format("%s", sw.toString());
                    }
                    FmrcCollectionPanel.this.detailTA.setText(f.toString());
                    FmrcCollectionPanel.this.detailTA.gotoTop();
                    FmrcCollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
            AbstractButton refreshButton = BAMutil.makeButtcon("Undo", "Refresh", false);
            refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FmrcCollectionPanel.this.table.refresh();
                    }
                    catch (Exception e1) {
                        Formatter f = new Formatter();
                        StringWriter sw = new StringWriter(5000);
                        e1.printStackTrace(new PrintWriter(sw));
                        f.format("%s", sw.toString());
                        FmrcCollectionPanel.this.detailTA.setText(f.toString());
                        FmrcCollectionPanel.this.detailTA.gotoTop();
                        FmrcCollectionPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(refreshButton);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            if (command == null) {
                return false;
            }
            try {
                return true;
            }
            catch (Exception ioe) {
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
                return false;
            }
        }

        @Override
        void closeOpenFiles() {
        }

        @Override
        void save() {
            this.table.save();
            super.save();
        }
    }

    private class FmrcPanel
    extends OpPanel {
        Fmrc2Panel table;

        FmrcPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "collection:", true, false);
            this.table = new Fmrc2Panel(this.prefs);
            this.table.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openNetcdfFile")) {
                        if (e.getNewValue() instanceof String) {
                            ToolsUI.this.openNetcdfFile((String)e.getNewValue());
                        } else {
                            ToolsUI.this.openNetcdfFile((NetcdfFile)e.getNewValue());
                        }
                    } else if (e.getPropertyName().equals("openCoordSys")) {
                        if (e.getNewValue() instanceof String) {
                            ToolsUI.this.openCoordSystems((String)e.getNewValue());
                        } else {
                            ToolsUI.this.openCoordSystems((NetcdfDataset)e.getNewValue());
                        }
                    } else if (e.getPropertyName().equals("openGridDataset")) {
                        if (e.getNewValue() instanceof String) {
                            ToolsUI.this.openGridDataset((String)e.getNewValue());
                        } else {
                            ToolsUI.this.openGridDataset((ucar.nc2.dt.GridDataset)e.getNewValue());
                        }
                    }
                }
            });
            this.add((Component)this.table, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        FmrcPanel.this.table.showInfo(f);
                    }
                    catch (IOException e1) {
                        StringWriter sw = new StringWriter(5000);
                        e1.printStackTrace(new PrintWriter(sw));
                        f.format("%s", sw.toString());
                    }
                    FmrcPanel.this.detailTA.setText(f.toString());
                    FmrcPanel.this.detailTA.gotoTop();
                    FmrcPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
            AbstractButton collectionButton = BAMutil.makeButtcon("Information", "Collection Parsing Info", false);
            collectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FmrcPanel.this.table.showCollectionInfo(true);
                }
            });
            this.buttPanel.add(collectionButton);
            AbstractButton viewButton = BAMutil.makeButtcon("Dump", "Show Dataset", false);
            viewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FmrcPanel.this.table.showDataset();
                    }
                    catch (IOException e1) {
                        StringWriter sw = new StringWriter(5000);
                        e1.printStackTrace(new PrintWriter(sw));
                        FmrcPanel.this.detailTA.setText(sw.toString());
                        FmrcPanel.this.detailTA.gotoTop();
                        FmrcPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(viewButton);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            if (command == null) {
                return false;
            }
            try {
                this.table.setFmrc(command);
                return true;
            }
            catch (Exception ioe) {
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
                return false;
            }
        }

        @Override
        void save() {
            this.table.save();
            super.save();
        }

        @Override
        void closeOpenFiles() throws IOException {
            this.table.closeOpenFiles();
        }
    }

    private class NcStreamPanel
    extends OpPanel {
        ucar.nc2.ui.NcStreamPanel panel;

        NcStreamPanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.panel = new ucar.nc2.ui.NcStreamPanel(this.prefs);
            this.add((Component)this.panel, "Center");
            AbstractAction infoAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        NcStreamPanel.this.panel.showInfo(f);
                    }
                    catch (Exception ioe) {
                        StringWriter sw = new StringWriter(5000);
                        ioe.printStackTrace(new PrintWriter(sw));
                        NcStreamPanel.this.detailTA.setText(sw.toString());
                        NcStreamPanel.this.detailWindow.show();
                        return;
                    }
                    NcStreamPanel.this.detailTA.setText(f.toString());
                    NcStreamPanel.this.detailTA.gotoTop();
                    NcStreamPanel.this.detailWindow.show();
                }
            };
            BAMutil.setActionProperties(infoAction, "Information", "show Info", false, 73, -1);
            BAMutil.addActionToContainer(this.buttPanel, infoAction);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                this.panel.setNcStreamFile(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "CdmremotePanel cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.panel.save();
            super.save();
        }

        @Override
        void closeOpenFiles() throws IOException {
            this.panel.closeOpenFiles();
        }
    }

    private class CdmrFeature
    extends OpPanel {
        CdmrFeaturePanel panel;

        CdmrFeature(PreferencesExt p) {
            super(p, "file:", true, false);
            this.panel = new CdmrFeaturePanel(this.prefs);
            this.add((Component)this.panel, "Center");
            AbstractAction infoAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        CdmrFeature.this.panel.showInfo(f);
                    }
                    catch (Exception ioe) {
                        StringWriter sw = new StringWriter(5000);
                        ioe.printStackTrace(new PrintWriter(sw));
                        CdmrFeature.this.detailTA.setText(sw.toString());
                        CdmrFeature.this.detailWindow.show();
                        return;
                    }
                    CdmrFeature.this.detailTA.setText(f.toString());
                    CdmrFeature.this.detailTA.gotoTop();
                    CdmrFeature.this.detailWindow.show();
                }
            };
            BAMutil.setActionProperties(infoAction, "Information", "show Info", false, 73, -1);
            BAMutil.addActionToContainer(this.buttPanel, infoAction);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                this.panel.setNcStream(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "CdmremotePanel cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.panel.save();
            super.save();
        }

        @Override
        void closeOpenFiles() throws IOException {
            this.panel.closeOpenFiles();
        }
    }

    private class NcmlEditorPanel
    extends OpPanel {
        NcmlEditor editor;

        @Override
        void closeOpenFiles() throws IOException {
            this.editor.closeOpenFiles();
        }

        NcmlEditorPanel(PreferencesExt p) {
            super(p, "dataset:", true, false);
            this.editor = new NcmlEditor(this.buttPanel, this.prefs);
            this.add((Component)this.editor, "Center");
        }

        @Override
        boolean process(Object o) {
            return this.editor.setNcml((String)o);
        }

        @Override
        void save() {
            super.save();
            this.editor.save();
        }
    }

    private class Hdf4Panel
    extends OpPanel {
        RandomAccessFile raf;
        Hdf4Table hdf4Table;

        @Override
        void closeOpenFiles() throws IOException {
            this.hdf4Table.closeOpenFiles();
        }

        Hdf4Panel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.raf = null;
            this.hdf4Table = new Hdf4Table(this.prefs);
            this.add((Component)this.hdf4Table, "Center");
            AbstractButton eosdump = BAMutil.makeButtcon("alien", "Show EOS processing", false);
            eosdump.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Formatter f = new Formatter();
                        Hdf4Panel.this.hdf4Table.getEosInfo(f);
                        Hdf4Panel.this.detailTA.setText(f.toString());
                        Hdf4Panel.this.detailWindow.show();
                    }
                    catch (IOException ioe) {
                        StringWriter sw = new StringWriter(5000);
                        ioe.printStackTrace(new PrintWriter(sw));
                        Hdf4Panel.this.detailTA.setText(sw.toString());
                        Hdf4Panel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(eosdump);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
                this.raf = new RandomAccessFile(command, "r");
                this.hdf4Table.setHdf4File(this.raf);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.hdf4Table.save();
            super.save();
        }
    }

    private class Hdf5DataPanel
    extends OpPanel {
        RandomAccessFile raf;
        Hdf5DataTable hdf5Table;

        @Override
        void closeOpenFiles() throws IOException {
            this.hdf5Table.closeOpenFiles();
        }

        Hdf5DataPanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.raf = null;
            this.hdf5Table = new Hdf5DataTable(this.prefs, this.buttPanel);
            this.add((Component)this.hdf5Table, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        Hdf5DataPanel.this.hdf5Table.showInfo(f);
                    }
                    catch (IOException ioe) {
                        StringWriter sw = new StringWriter(5000);
                        ioe.printStackTrace(new PrintWriter(sw));
                        Hdf5DataPanel.this.detailTA.setText(sw.toString());
                        Hdf5DataPanel.this.detailWindow.show();
                        return;
                    }
                    Hdf5DataPanel.this.detailTA.setText(f.toString());
                    Hdf5DataPanel.this.detailTA.gotoTop();
                    Hdf5DataPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
                this.raf = new RandomAccessFile(command, "r");
                this.hdf5Table.setHdf5File(this.raf);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "Hdf5DataTable cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.hdf5Table.save();
            super.save();
        }
    }

    private class Hdf5ObjectPanel
    extends OpPanel {
        RandomAccessFile raf;
        Hdf5ObjectTable hdf5Table;

        @Override
        void closeOpenFiles() throws IOException {
            this.hdf5Table.closeOpenFiles();
        }

        Hdf5ObjectPanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.raf = null;
            this.hdf5Table = new Hdf5ObjectTable(this.prefs);
            this.add((Component)this.hdf5Table, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Compact Representation", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        Hdf5ObjectPanel.this.hdf5Table.showInfo(f);
                    }
                    catch (IOException ioe) {
                        StringWriter sw = new StringWriter(5000);
                        ioe.printStackTrace(new PrintWriter(sw));
                        Hdf5ObjectPanel.this.detailTA.setText(sw.toString());
                        Hdf5ObjectPanel.this.detailWindow.show();
                        return;
                    }
                    Hdf5ObjectPanel.this.detailTA.setText(f.toString());
                    Hdf5ObjectPanel.this.detailTA.gotoTop();
                    Hdf5ObjectPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
            AbstractButton infoButton2 = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        Hdf5ObjectPanel.this.hdf5Table.showInfo2(f);
                    }
                    catch (IOException ioe) {
                        StringWriter sw = new StringWriter(5000);
                        ioe.printStackTrace(new PrintWriter(sw));
                        Hdf5ObjectPanel.this.detailTA.setText(sw.toString());
                        Hdf5ObjectPanel.this.detailWindow.show();
                        return;
                    }
                    Hdf5ObjectPanel.this.detailTA.setText(f.toString());
                    Hdf5ObjectPanel.this.detailTA.gotoTop();
                    Hdf5ObjectPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton2);
            AbstractButton eosdump = BAMutil.makeButtcon("alien", "Show EOS processing", false);
            eosdump.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Formatter f = new Formatter();
                        Hdf5ObjectPanel.this.hdf5Table.getEosInfo(f);
                        Hdf5ObjectPanel.this.detailTA.setText(f.toString());
                        Hdf5ObjectPanel.this.detailWindow.show();
                    }
                    catch (IOException ioe) {
                        StringWriter sw = new StringWriter(5000);
                        ioe.printStackTrace(new PrintWriter(sw));
                        Hdf5ObjectPanel.this.detailTA.setText(sw.toString());
                        Hdf5ObjectPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(eosdump);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
                this.raf = new RandomAccessFile(command, "r");
                this.hdf5Table.setHdf5File(this.raf);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "Hdf5ObjectTable cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.hdf5Table.save();
            super.save();
        }
    }

    private class GribRewritePanel
    extends OpPanel {
        ucar.nc2.ui.grib.GribRewritePanel ftTable;
        final FileManager dirChooser;

        GribRewritePanel(PreferencesExt prefs) {
            super(prefs, "dir:", false, false);
            this.dirChooser = new FileManager(ToolsUI.this.parentFrame, null, null, (PreferencesExt)prefs.node("FeatureScanFileManager"));
            this.ftTable = new ucar.nc2.ui.grib.GribRewritePanel(prefs, this.buttPanel);
            this.add((Component)this.ftTable, "Center");
            this.ftTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openNetcdfFile")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openNetcdfFile(datasetName);
                    } else if (e.getPropertyName().equals("openGridDataset")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openGridDataset(datasetName);
                    } else if (e.getPropertyName().equals("openGrib1Data")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openGrib1Data(datasetName);
                    } else if (e.getPropertyName().equals("openGrib2Data")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openGrib2Data(datasetName);
                    }
                }
            });
            this.dirChooser.getFileChooser().setFileSelectionMode(2);
            this.dirChooser.setCurrentDirectory(prefs.get("currDir", "."));
            AbstractAction fileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename = GribRewritePanel.this.dirChooser.chooseFilename();
                    if (filename == null) {
                        return;
                    }
                    GribRewritePanel.this.cb.setSelectedItem(filename);
                }
            };
            BAMutil.setActionProperties(fileAction, "FileChooser", "open Local dataset...", false, 76, -1);
            BAMutil.addActionToContainer(this.buttPanel, fileAction);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            return this.ftTable.setScanDirectory(command);
        }

        @Override
        void closeOpenFiles() {
            this.ftTable.clear();
        }

        @Override
        void save() {
            this.dirChooser.save();
            this.ftTable.save();
            this.prefs.put("currDir", this.dirChooser.getCurrentDirectory());
            super.save();
        }
    }

    private class GribRenamePanel
    extends OpPanel {
        ucar.nc2.ui.grib.GribRenamePanel panel;

        GribRenamePanel(PreferencesExt p) {
            super(p, "matchNcepName: ", true, false, false);
            this.panel = new ucar.nc2.ui.grib.GribRenamePanel(this.prefs, this.buttPanel);
            this.add((Component)this.panel, "Center");
        }

        @Override
        boolean process(Object o) {
            return this.panel.matchNcepName((String)o);
        }

        @Override
        void save() {
            this.panel.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class Grib2TablePanel
    extends OpPanel {
        Grib2TableViewer2 codeTable;

        Grib2TablePanel(PreferencesExt p) {
            super(p, "table:", false, false);
            this.codeTable = new Grib2TableViewer2(this.prefs, this.buttPanel);
            this.add((Component)this.codeTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void save() {
            this.codeTable.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class Grib1TablePanel
    extends OpPanel {
        Grib1TablesViewer codeTable;

        Grib1TablePanel(PreferencesExt p) {
            super(p, "table:", true, false);
            this.codeTable = new Grib1TablesViewer(this.prefs, this.buttPanel);
            this.add((Component)this.codeTable, "Center");
        }

        @Override
        boolean process(Object command) {
            try {
                this.codeTable.setTable((String)command);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        void save() {
            this.codeTable.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class WmoCCPanel
    extends OpPanel {
        WmoCommonCodesPanel codeTable;

        WmoCCPanel(PreferencesExt p) {
            super(p, "table:", false, false);
            this.codeTable = new WmoCommonCodesPanel(this.prefs, this.buttPanel);
            this.add((Component)this.codeTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void save() {
            this.codeTable.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class BufrCodePanel
    extends OpPanel {
        BufrWmoCodesPanel codeTable;

        BufrCodePanel(PreferencesExt p) {
            super(p, "table:", false, false, false);
            this.codeTable = new BufrWmoCodesPanel(this.prefs, this.buttPanel);
            this.add((Component)this.codeTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void save() {
            this.codeTable.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class GribCodePanel
    extends OpPanel {
        GribWmoCodesPanel codeTable;

        GribCodePanel(PreferencesExt p) {
            super(p, "table:", false, false, false);
            final JComboBox<WmoCodeTable.Version> modes = new JComboBox<WmoCodeTable.Version>(WmoCodeTable.Version.values());
            modes.setSelectedItem(WmoCodeTable.standard);
            this.topPanel.add(modes, "Center");
            modes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GribCodePanel.this.codeTable.setTable((WmoCodeTable.Version)modes.getSelectedItem());
                }
            });
            this.codeTable = new GribWmoCodesPanel(this.prefs, this.buttPanel);
            this.add((Component)this.codeTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void save() {
            this.codeTable.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class GribTemplatePanel
    extends OpPanel {
        GribWmoTemplatesPanel codeTable;

        GribTemplatePanel(PreferencesExt p) {
            super(p, "table:", false, false, false);
            final JComboBox<WmoTemplateTable.Version> modes = new JComboBox<WmoTemplateTable.Version>(WmoTemplateTable.Version.values());
            modes.setSelectedItem(WmoTemplateTable.standard);
            this.topPanel.add(modes, "Center");
            modes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GribTemplatePanel.this.codeTable.setTable((WmoTemplateTable.Version)modes.getSelectedItem());
                }
            });
            this.codeTable = new GribWmoTemplatesPanel(this.prefs, this.buttPanel);
            this.add((Component)this.codeTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void save() {
            this.codeTable.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class ReportOpPanel
    extends OpPanel {
        ReportPanel reportPanel;
        boolean useIndex;
        boolean eachFile;
        boolean extra;
        JComboBox reports;

        ReportOpPanel(PreferencesExt p, ReportPanel reportPanel) {
            super(p, "collection:", true, false);
            this.useIndex = true;
            this.eachFile = false;
            this.extra = false;
            this.reportPanel = reportPanel;
            this.add((Component)reportPanel, "Center");
            reportPanel.addOptions(this.buttPanel);
            this.reports = new JComboBox<Object>(reportPanel.getOptions());
            this.buttPanel.add(this.reports);
            AbstractAction useIndexButt = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Boolean state = (Boolean)this.getValue("state");
                    ReportOpPanel.this.useIndex = state;
                }
            };
            useIndexButt.putValue("state", this.useIndex);
            BAMutil.setActionProperties(useIndexButt, "Doit", "use Index", true, 67, -1);
            BAMutil.addActionToContainer(this.buttPanel, useIndexButt);
            AbstractAction eachFileButt = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Boolean state = (Boolean)this.getValue("state");
                    ReportOpPanel.this.eachFile = state;
                }
            };
            eachFileButt.putValue("state", this.eachFile);
            BAMutil.setActionProperties(eachFileButt, "Doit", "report on each file", true, 69, -1);
            BAMutil.addActionToContainer(this.buttPanel, eachFileButt);
            AbstractAction extraButt = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Boolean state = (Boolean)this.getValue("state");
                    ReportOpPanel.this.extra = state;
                }
            };
            extraButt.putValue("state", this.extra);
            BAMutil.setActionProperties(extraButt, "Doit", "extra info", true, 88, -1);
            BAMutil.addActionToContainer(this.buttPanel, extraButt);
            AbstractAction doitButt = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportOpPanel.this.process();
                }
            };
            BAMutil.setActionProperties(doitButt, "alien", "make report", false, 67, -1);
            BAMutil.addActionToContainer(this.buttPanel, doitButt);
        }

        @Override
        void closeOpenFiles() {
        }

        @Override
        boolean process(Object o) {
            return this.reportPanel.showCollection((String)o);
        }

        boolean process() {
            boolean err = false;
            String command = (String)this.cb.getSelectedItem();
            try {
                this.reportPanel.doReport(command, this.useIndex, this.eachFile, this.extra, this.reports.getSelectedItem());
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, "Grib2ReportPanel cant open " + command + "\n" + ioe.getMessage());
                ioe.printStackTrace();
                err = true;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            super.save();
        }
    }

    private class Grib1CollectionPanel
    extends OpPanel {
        ucar.nc2.ui.grib.Grib1CollectionPanel gribTable;

        @Override
        void closeOpenFiles() throws IOException {
            this.gribTable.closeOpenFiles();
        }

        Grib1CollectionPanel(PreferencesExt p) {
            super(p, "collection:", true, false);
            this.gribTable = new ucar.nc2.ui.grib.Grib1CollectionPanel(this.buttPanel, this.prefs);
            this.add((Component)this.gribTable, "Center");
            AbstractButton showButt = BAMutil.makeButtcon("Information", "Show Collection", false);
            showButt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    Grib1CollectionPanel.this.gribTable.showCollection(f);
                    Grib1CollectionPanel.this.detailTA.setText(f.toString());
                    Grib1CollectionPanel.this.detailTA.gotoTop();
                    Grib1CollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(showButt);
            AbstractButton writeButton = BAMutil.makeButtcon("netcdf", "Write index", false);
            writeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        if (!Grib1CollectionPanel.this.gribTable.writeIndex(f)) {
                            return;
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    Grib1CollectionPanel.this.detailTA.setText(f.toString());
                    Grib1CollectionPanel.this.detailTA.gotoTop();
                    Grib1CollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(writeButton);
        }

        void setCollection(String collection) {
            if (this.process(collection) && !this.defer) {
                this.cb.addItem(collection);
            }
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                this.gribTable.setCollection(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.gribTable.save();
            super.save();
        }
    }

    private class GribIndexPanel
    extends OpPanel {
        ucar.nc2.ui.grib.GribIndexPanel gribTable;

        @Override
        void closeOpenFiles() throws IOException {
            this.gribTable.closeOpenFiles();
        }

        GribIndexPanel(PreferencesExt p) {
            super(p, "index file:", true, false);
            this.gribTable = new ucar.nc2.ui.grib.GribIndexPanel(this.prefs, this.buttPanel);
            this.add((Component)this.gribTable, "Center");
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                this.gribTable.setIndexFile(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.gribTable.save();
            super.save();
        }
    }

    private class CdmIndexPanel
    extends OpPanel {
        CdmIndex3Panel indexPanel;

        @Override
        void closeOpenFiles() throws IOException {
            this.indexPanel.clear();
        }

        CdmIndexPanel(PreferencesExt p) {
            super(p, "index file:", true, false);
            this.indexPanel = new CdmIndex3Panel(this.prefs, this.buttPanel);
            this.indexPanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openGrib2Collection")) {
                        String collectionName = (String)e.getNewValue();
                        ToolsUI.this.openGrib2Collection(collectionName);
                    }
                }
            });
            this.add((Component)this.indexPanel, "Center");
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                this.indexPanel.setIndexFile(Paths.get(command, new String[0]), new FeatureCollectionConfig());
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "GribCdmIndexPanel cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.indexPanel.save();
            super.save();
        }
    }

    private class BufrCdmIndexPanel
    extends OpPanel {
        ucar.nc2.ui.BufrCdmIndexPanel table;

        @Override
        void closeOpenFiles() throws IOException {
        }

        BufrCdmIndexPanel(PreferencesExt p) {
            super(p, "index file:", true, false);
            this.table = new ucar.nc2.ui.BufrCdmIndexPanel(this.prefs, this.buttPanel);
            this.add((Component)this.table, "Center");
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                this.table.setIndexFile(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "BufrCdmIndexPanel cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.table.save();
            super.save();
        }
    }

    private class Grib1DataPanel
    extends OpPanel {
        Grib1DataTable gribTable;

        @Override
        void closeOpenFiles() throws IOException {
        }

        Grib1DataPanel(PreferencesExt p) {
            super(p, "collection:", true, false);
            this.gribTable = new Grib1DataTable(this.prefs);
            this.add((Component)this.gribTable, "Center");
            this.gribTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openGrib1Collection")) {
                        String collectionName = (String)e.getNewValue();
                        ToolsUI.this.openGrib1Collection(collectionName);
                    }
                }
            });
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Check Problems", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    Grib1DataPanel.this.gribTable.checkProblems(f);
                    Grib1DataPanel.this.detailTA.setText(f.toString());
                    Grib1DataPanel.this.detailTA.gotoTop();
                    Grib1DataPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
        }

        void setCollection(String collection) {
            if (this.process(collection) && !this.defer) {
                this.cb.addItem(collection);
            }
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                this.gribTable.setCollection(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.gribTable.save();
            super.save();
        }
    }

    private class Grib2DataPanel
    extends OpPanel {
        ucar.nc2.ui.grib.Grib2DataPanel gribTable;

        @Override
        void closeOpenFiles() throws IOException {
        }

        Grib2DataPanel(PreferencesExt p) {
            super(p, "collection:", true, false);
            this.gribTable = new ucar.nc2.ui.grib.Grib2DataPanel(this.prefs);
            this.add((Component)this.gribTable, "Center");
            this.gribTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openGrib2Collection")) {
                        String collectionName = (String)e.getNewValue();
                        ToolsUI.this.openGrib2Collection(collectionName);
                    }
                }
            });
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Show Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    Grib2DataPanel.this.gribTable.showInfo(f);
                    Grib2DataPanel.this.detailTA.setText(f.toString());
                    Grib2DataPanel.this.detailTA.gotoTop();
                    Grib2DataPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
            AbstractButton checkButton = BAMutil.makeButtcon("Information", "Check Problems", false);
            checkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    Grib2DataPanel.this.gribTable.checkProblems(f);
                    Grib2DataPanel.this.detailTA.setText(f.toString());
                    Grib2DataPanel.this.detailTA.gotoTop();
                    Grib2DataPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(checkButton);
        }

        void setCollection(String collection) {
            if (this.process(collection) && !this.defer) {
                this.cb.addItem(collection);
            }
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                this.gribTable.setCollection(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.gribTable.save();
            super.save();
        }
    }

    private class Grib2CollectionPanel
    extends OpPanel {
        ucar.nc2.ui.grib.Grib2CollectionPanel gribTable;

        @Override
        void closeOpenFiles() throws IOException {
            this.gribTable.closeOpenFiles();
        }

        Grib2CollectionPanel(PreferencesExt p) {
            super(p, "collection:", true, false);
            this.gribTable = new ucar.nc2.ui.grib.Grib2CollectionPanel(this.prefs, this.buttPanel);
            this.add((Component)this.gribTable, "Center");
            this.gribTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openGrib2Collection")) {
                        String collectionName = (String)e.getNewValue();
                        ToolsUI.this.openGrib2Collection(collectionName);
                    }
                }
            });
            AbstractButton showButt = BAMutil.makeButtcon("Information", "Show Collection", false);
            showButt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    Grib2CollectionPanel.this.gribTable.showCollection(f);
                    Grib2CollectionPanel.this.detailTA.setText(f.toString());
                    Grib2CollectionPanel.this.detailTA.gotoTop();
                    Grib2CollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(showButt);
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Check Problems", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    Grib2CollectionPanel.this.gribTable.checkProblems(f);
                    Grib2CollectionPanel.this.detailTA.setText(f.toString());
                    Grib2CollectionPanel.this.detailTA.gotoTop();
                    Grib2CollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
            AbstractButton gdsButton = BAMutil.makeButtcon("Information", "Show GDS use", false);
            gdsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    Grib2CollectionPanel.this.gribTable.showGDSuse(f);
                    Grib2CollectionPanel.this.detailTA.setText(f.toString());
                    Grib2CollectionPanel.this.detailTA.gotoTop();
                    Grib2CollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(gdsButton);
            AbstractButton writeButton = BAMutil.makeButtcon("netcdf", "Write index", false);
            writeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        if (!Grib2CollectionPanel.this.gribTable.writeIndex(f)) {
                            return;
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    Grib2CollectionPanel.this.detailTA.setText(f.toString());
                    Grib2CollectionPanel.this.detailTA.gotoTop();
                    Grib2CollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(writeButton);
        }

        void setCollection(String collection) {
            if (this.process(collection) && !this.defer) {
                this.cb.addItem(collection);
            }
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                this.gribTable.setCollection(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.gribTable.save();
            super.save();
        }
    }

    private class GribFilesPanel
    extends OpPanel {
        ucar.nc2.ui.grib.GribFilesPanel gribTable;

        @Override
        void closeOpenFiles() throws IOException {
        }

        GribFilesPanel(PreferencesExt p) {
            super(p, "collection:", true, false);
            this.gribTable = new ucar.nc2.ui.grib.GribFilesPanel(this.prefs);
            this.add((Component)this.gribTable, "Center");
            this.gribTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openGrib1Collection")) {
                        String filename = (String)e.getNewValue();
                        ToolsUI.this.openGrib1Collection(filename);
                    }
                }
            });
            AbstractButton showButt = BAMutil.makeButtcon("Information", "Show Collection", false);
            showButt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    GribFilesPanel.this.gribTable.showCollection(f);
                    GribFilesPanel.this.detailTA.setText(f.toString());
                    GribFilesPanel.this.detailTA.gotoTop();
                    GribFilesPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(showButt);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                this.gribTable.setCollection(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.gribTable.save();
            super.save();
        }
    }

    private class BufrTableDPanel
    extends OpPanel {
        BufrTableDViewer bufrTable;
        JComboBox<BufrTables.Format> modes;
        JComboBox<BufrTables.TableConfig> tables;

        BufrTableDPanel(PreferencesExt p) {
            super(p, "tableD:", false, false);
            AbstractAction fileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename;
                    if (ToolsUI.this.bufrFileChooser == null) {
                        ToolsUI.this.initBufrFileChooser();
                    }
                    if ((filename = ToolsUI.this.bufrFileChooser.chooseFilename()) == null) {
                        return;
                    }
                    BufrTableDPanel.this.cb.setSelectedItem(filename);
                }
            };
            BAMutil.setActionProperties(fileAction, "FileChooser", "open Local table...", false, 76, -1);
            BAMutil.addActionToContainer(this.buttPanel, fileAction);
            this.modes = new JComboBox<BufrTables.Format>(BufrTables.Format.values());
            this.buttPanel.add(this.modes);
            JButton accept = new JButton("Accept");
            this.buttPanel.add(accept);
            accept.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BufrTableDPanel.this.accept();
                }
            });
            this.tables = new JComboBox<BufrTables.TableConfig>(BufrTables.getTableConfigsAsArray());
            this.buttPanel.add(this.tables);
            this.tables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BufrTableDPanel.this.acceptTable((BufrTables.TableConfig)BufrTableDPanel.this.tables.getSelectedItem());
                }
            });
            this.bufrTable = new BufrTableDViewer(this.prefs, this.buttPanel);
            this.add((Component)this.bufrTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void closeOpenFiles() {
        }

        void accept() {
            String command = (String)this.cb.getSelectedItem();
            if (command == null) {
                return;
            }
            try {
                Object mode = this.modes.getSelectedItem();
                this.bufrTable.setBufrTableD(command, (BufrTables.Format)mode);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "BufrTableViewer cant open " + command + "\n" + ioe.getMessage());
                this.detailTA.setText("Failed to open <" + command + ">\n" + ioe.getMessage());
                this.detailTA.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailTA.setVisible(true);
            }
        }

        void acceptTable(BufrTables.TableConfig tc) {
            try {
                this.bufrTable.setBufrTableD(tc.getTableDname(), tc.getTableDformat());
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "BufrTableViewer cant open " + tc + "\n" + ioe.getMessage());
                this.detailTA.setText("Failed to open <" + tc + ">\n" + ioe.getMessage());
                this.detailTA.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailTA.setVisible(true);
            }
        }

        @Override
        void save() {
            this.bufrTable.save();
            super.save();
        }
    }

    private class BufrTableBPanel
    extends OpPanel {
        BufrTableBViewer bufrTable;
        JComboBox<BufrTables.Format> modes;
        JComboBox<BufrTables.TableConfig> tables;

        BufrTableBPanel(PreferencesExt p) {
            super(p, "tableB:", false, false);
            AbstractAction fileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename;
                    if (ToolsUI.this.bufrFileChooser == null) {
                        ToolsUI.this.initBufrFileChooser();
                    }
                    if ((filename = ToolsUI.this.bufrFileChooser.chooseFilename()) == null) {
                        return;
                    }
                    BufrTableBPanel.this.cb.setSelectedItem(filename);
                }
            };
            BAMutil.setActionProperties(fileAction, "FileChooser", "open Local table...", false, 76, -1);
            BAMutil.addActionToContainer(this.buttPanel, fileAction);
            this.modes = new JComboBox<BufrTables.Format>(BufrTables.Format.values());
            this.buttPanel.add(this.modes);
            JButton accept = new JButton("Accept");
            this.buttPanel.add(accept);
            accept.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BufrTableBPanel.this.accept();
                }
            });
            this.tables = new JComboBox<BufrTables.TableConfig>(BufrTables.getTableConfigsAsArray());
            this.buttPanel.add(this.tables);
            this.tables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BufrTableBPanel.this.acceptTable((BufrTables.TableConfig)BufrTableBPanel.this.tables.getSelectedItem());
                }
            });
            this.bufrTable = new BufrTableBViewer(this.prefs, this.buttPanel);
            this.add((Component)this.bufrTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void closeOpenFiles() {
        }

        void accept() {
            String command = (String)this.cb.getSelectedItem();
            try {
                Object format = this.modes.getSelectedItem();
                this.bufrTable.setBufrTableB(command, (BufrTables.Format)format);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "BufrTableViewer cant open " + command + "\n" + ioe.getMessage());
                this.detailTA.setText("Failed to open <" + command + ">\n" + ioe.getMessage());
                this.detailTA.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailTA.setVisible(true);
            }
        }

        void acceptTable(BufrTables.TableConfig tc) {
            try {
                this.bufrTable.setBufrTableB(tc.getTableBname(), tc.getTableBformat());
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "BufrTableViewer cant open " + tc + "\n" + ioe.getMessage());
                this.detailTA.setText("Failed to open <" + tc + ">\n" + ioe.getMessage());
                this.detailTA.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailTA.setVisible(true);
            }
        }

        @Override
        void save() {
            this.bufrTable.save();
            super.save();
        }
    }

    private class BufrPanel
    extends OpPanel {
        RandomAccessFile raf;
        BufrMessageViewer bufrTable;

        @Override
        void closeOpenFiles() throws IOException {
            if (this.raf != null) {
                this.raf.close();
            }
            this.raf = null;
        }

        BufrPanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.raf = null;
            this.bufrTable = new BufrMessageViewer(this.prefs, this.buttPanel);
            this.add((Component)this.bufrTable, "Center");
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
                this.raf = new RandomAccessFile(command, "r");
                this.bufrTable.setBufrFile(this.raf);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.bufrTable.save();
            super.save();
        }
    }

    private class AggPanel
    extends OpPanel {
        AggTable aggTable;
        NetcdfDataset ncd;

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ncd != null) {
                this.ncd.close();
            }
            this.ncd = null;
            this.aggTable.clear();
        }

        AggPanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.aggTable = new AggTable(this.prefs, this.buttPanel);
            this.aggTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openNetcdfFile")) {
                        NetcdfFile ncfile = (NetcdfFile)e.getNewValue();
                        if (ncfile != null) {
                            ToolsUI.this.openNetcdfFile(ncfile);
                        }
                    } else if (e.getPropertyName().equals("openCoordSystems")) {
                        NetcdfFile ncfile = (NetcdfFile)e.getNewValue();
                        if (ncfile == null) {
                            return;
                        }
                        try {
                            NetcdfDataset ncd = NetcdfDataset.wrap((NetcdfFile)ncfile, (Set)NetcdfDataset.getDefaultEnhanceMode());
                            ToolsUI.this.openCoordSystems(ncd);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    } else if (e.getPropertyName().equals("openGridDataset")) {
                        NetcdfFile ncfile = (NetcdfFile)e.getNewValue();
                        if (ncfile == null) {
                            return;
                        }
                        try {
                            NetcdfDataset ncd = NetcdfDataset.wrap((NetcdfFile)ncfile, (Set)NetcdfDataset.getDefaultEnhanceMode());
                            ToolsUI.this.openGridDataset(ncd);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            this.add((Component)this.aggTable, "Center");
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                if (this.ncd != null) {
                    try {
                        this.ncd.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                this.ncd = NetcdfDataset.openDataset((String)command);
                this.aggTable.setAggDataset(this.ncd);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.aggTable.save();
            super.save();
        }
    }

    private class CoordSysPanel
    extends OpPanel {
        NetcdfDataset ds;
        CoordSysTable coordSysTable;

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ds != null) {
                this.ds.close();
            }
            this.ds = null;
            this.coordSysTable.clear();
        }

        CoordSysPanel(PreferencesExt p) {
            super(p, "dataset:", true, false);
            this.ds = null;
            this.coordSysTable = new CoordSysTable(this.prefs, this.buttPanel);
            this.add((Component)this.coordSysTable, "Center");
            AbstractButton summaryButton = BAMutil.makeButtcon("Information", "Summary Info", false);
            summaryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    CoordSysPanel.this.coordSysTable.summaryInfo(f);
                    CoordSysPanel.this.detailTA.setText(f.toString());
                    CoordSysPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(summaryButton);
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Parse Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CoordSysPanel.this.ds != null) {
                        try (NetcdfDatasetInfo info = new NetcdfDatasetInfo(CoordSysPanel.this.ds);){
                            CoordSysPanel.this.detailTA.setText(info.writeXML());
                            CoordSysPanel.this.detailTA.appendLine("----------------------");
                            CoordSysPanel.this.detailTA.appendLine(info.getParseInfo());
                            CoordSysPanel.this.detailTA.gotoTop();
                        }
                        catch (IOException e1) {
                            StringWriter sw = new StringWriter(5000);
                            e1.printStackTrace(new PrintWriter(sw));
                            CoordSysPanel.this.detailTA.setText(sw.toString());
                        }
                        CoordSysPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
            JButton dsButton = new JButton("Object dump");
            dsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CoordSysPanel.this.ds != null) {
                        StringWriter sw = new StringWriter(5000);
                        NetcdfDataset.debugDump((PrintWriter)new PrintWriter(sw), (NetcdfDataset)CoordSysPanel.this.ds);
                        CoordSysPanel.this.detailTA.setText(sw.toString());
                        CoordSysPanel.this.detailTA.gotoTop();
                        CoordSysPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(dsButton);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            Object spiObject = null;
            try {
                this.ds = NetcdfDataset.openDataset((String)command, (boolean)true, (int)-1, null, spiObject);
                if (this.ds == null) {
                    JOptionPane.showMessageDialog(null, "Failed to open <" + command + ">");
                } else {
                    this.coordSysTable.setDataset(this.ds);
                }
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        void setDataset(NetcdfDataset ncd) {
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
                this.ds = null;
            }
            catch (IOException ioe) {
                System.out.printf("close failed %n", new Object[0]);
            }
            this.ds = ncd;
            this.coordSysTable.setDataset(this.ds);
            this.setSelectedItem(this.ds.getLocation());
        }

        @Override
        void save() {
            this.coordSysTable.save();
            super.save();
        }
    }

    private class DateFormatMark
    extends OpPanel {
        ComboBox testCB;
        DateFormatter dateFormatter;
        TextHistoryPane ta;

        DateFormatMark(PreferencesExt prefs) {
            super(prefs, "dateFormatMark:", false, false);
            this.dateFormatter = new DateFormatter();
            this.ta = new TextHistoryPane(true);
            this.add((Component)this.ta, "Center");
            this.testCB = new ComboBox(prefs);
            this.buttPanel.add(this.testCB);
            JButton compareButton = new JButton("Apply");
            compareButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DateFormatMark.this.apply(DateFormatMark.this.cb.getSelectedItem(), DateFormatMark.this.testCB.getSelectedItem());
                }
            });
            this.buttPanel.add(compareButton);
        }

        @Override
        boolean process(Object o) {
            return false;
        }

        @Override
        void closeOpenFiles() {
        }

        void apply(Object mark, Object testo) {
            String dateFormatMark = (String)mark;
            String filename = (String)testo;
            try {
                Date coordValueDate = DateFromString.getDateUsingDemarkatedCount((String)filename, (String)dateFormatMark, (char)'#');
                String coordValue = this.dateFormatter.toDateTimeStringISO(coordValueDate);
                this.ta.setText("got date= " + coordValue);
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.ta.setText(sw.toString());
            }
        }
    }

    private class UnitConvert
    extends OpPanel {
        TextHistoryPane ta;

        UnitConvert(PreferencesExt prefs) {
            super(prefs, "unit:", false, false);
            this.ta = new TextHistoryPane(true);
            this.add((Component)this.ta, "Center");
            JButton compareButton = new JButton("Compare");
            compareButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UnitConvert.this.compare(UnitConvert.this.cb.getSelectedItem());
                }
            });
            this.buttPanel.add(compareButton);
            JButton dateButton = new JButton("UdunitDate");
            dateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UnitConvert.this.checkUdunits(UnitConvert.this.cb.getSelectedItem());
                }
            });
            this.buttPanel.add(dateButton);
            JButton cdateButton = new JButton("CalendarDate");
            cdateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UnitConvert.this.checkCalendarDate(UnitConvert.this.cb.getSelectedItem());
                }
            });
            this.buttPanel.add(cdateButton);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            try {
                SimpleUnit su = SimpleUnit.factoryWithExceptions((String)command);
                this.ta.setText("parse=" + command + "\n");
                this.ta.appendLine("SimpleUnit.toString()          =" + su.toString() + "\n");
                this.ta.appendLine("SimpleUnit.getCanonicalString  =" + su.getCanonicalString());
                this.ta.appendLine("SimpleUnit.getImplementingClass= " + su.getImplementingClass());
                this.ta.appendLine("SimpleUnit.isUnknownUnit       = " + su.isUnknownUnit());
                return true;
            }
            catch (Exception e) {
                if (Debug.isSet("Xdeveloper")) {
                    StringWriter sw = new StringWriter(10000);
                    e.printStackTrace(new PrintWriter(sw));
                    this.ta.setText(sw.toString());
                } else {
                    this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
                }
                return false;
            }
        }

        @Override
        void closeOpenFiles() {
        }

        void compare(Object o) {
            String command = (String)o;
            StringTokenizer stoke = new StringTokenizer(command);
            ArrayList<String> list = new ArrayList<String>();
            while (stoke.hasMoreTokens()) {
                list.add(stoke.nextToken());
            }
            try {
                String unitS1 = (String)list.get(0);
                String unitS2 = (String)list.get(1);
                SimpleUnit su1 = SimpleUnit.factoryWithExceptions((String)unitS1);
                SimpleUnit su2 = SimpleUnit.factoryWithExceptions((String)unitS2);
                this.ta.setText("<" + su1.toString() + "> isConvertable to <" + su2.toString() + ">=" + SimpleUnit.isCompatibleWithExceptions((String)unitS1, (String)unitS2));
            }
            catch (Exception e) {
                if (Debug.isSet("Xdeveloper")) {
                    StringWriter sw = new StringWriter(10000);
                    e.printStackTrace(new PrintWriter(sw));
                    this.ta.setText(sw.toString());
                }
                this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
            }
        }

        void checkUdunits(Object o) {
            String command = (String)o;
            boolean isDate = false;
            try {
                DateUnit du = new DateUnit(command);
                this.ta.appendLine("\nFrom udunits:\n <" + command + "> isDateUnit = " + du);
                Date d = du.getDate();
                this.ta.appendLine("getStandardDateString = " + ToolsUI.this.formatter.toDateTimeString(d));
                this.ta.appendLine("getDateOrigin = " + ToolsUI.this.formatter.toDateTimeString(du.getDateOrigin()));
                isDate = true;
                Date d2 = DateUnit.getStandardOrISO((String)command);
                if (d2 == null) {
                    this.ta.appendLine("\nDateUnit.getStandardOrISO = false");
                } else {
                    this.ta.appendLine("\nDateUnit.getStandardOrISO = " + ToolsUI.this.formatter.toDateTimeString(d2));
                }
            }
            catch (Exception du) {
                // empty catch block
            }
            this.ta.appendLine("isDate = " + isDate);
            if (!isDate) {
                try {
                    SimpleUnit su = SimpleUnit.factory((String)command);
                    boolean isTime = su instanceof TimeUnit;
                    this.ta.setText("<" + command + "> isTimeUnit= " + isTime);
                    if (isTime) {
                        TimeUnit du = (TimeUnit)su;
                        this.ta.appendLine("\nTimeUnit = " + du);
                    }
                }
                catch (Exception e) {
                    if (Debug.isSet("Xdeveloper")) {
                        StringWriter sw = new StringWriter(10000);
                        e.printStackTrace(new PrintWriter(sw));
                        this.ta.setText(sw.toString());
                    }
                    this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
                }
            }
        }

        void checkCalendarDate(Object o) {
            String command = (String)o;
            try {
                this.ta.setText("\nParse CalendarDate: <" + command + ">\n");
                CalendarDate cd = CalendarDate.parseUdunits(null, (String)command);
                this.ta.appendLine("CalendarDate = " + cd);
            }
            catch (Throwable t) {
                this.ta.appendLine("not a CalendarDateUnit= " + t.getMessage());
            }
            try {
                this.ta.appendLine("\nParse CalendarDateUnit: <" + command + ">\n");
                CalendarDateUnit cdu = CalendarDateUnit.of(null, (String)command);
                this.ta.appendLine("CalendarDateUnit = " + cdu);
                this.ta.appendLine(" Calendar        = " + cdu.getCalendar());
                this.ta.appendLine(" PeriodField     = " + cdu.getTimeUnit().getField());
                this.ta.appendLine(" PeriodValue     = " + cdu.getTimeUnit().getValue());
                this.ta.appendLine(" Base            = " + cdu.getBaseCalendarDate());
                this.ta.appendLine(" isCalendarField = " + cdu.isCalendarField());
            }
            catch (Exception e) {
                this.ta.appendLine("not a CalendarDateUnit= " + e.getMessage());
                try {
                    String[] s = command.split("%");
                    if (s.length == 2) {
                        Double val = Double.parseDouble(s[0].trim());
                        this.ta.appendLine("\nval= " + val + " unit=" + s[1]);
                        CalendarDateUnit cdu = CalendarDateUnit.of(null, (String)s[1].trim());
                        this.ta.appendLine("CalendarDateUnit= " + cdu);
                        CalendarDate cd = cdu.makeCalendarDate(val.doubleValue());
                        this.ta.appendLine(" CalendarDate = " + cd);
                        Date d = cd.toDate();
                        this.ta.appendLine(" Date.toString() = " + d);
                        DateFormatter format = new DateFormatter();
                        this.ta.appendLine(" DateFormatter= " + format.toDateTimeString(cd.toDate()));
                    }
                }
                catch (Exception ee) {
                    this.ta.appendLine("Failed on CalendarDateUnit " + ee.getMessage());
                }
            }
        }
    }

    private class UnitDatasetCheck
    extends OpPanel {
        TextHistoryPane ta;

        UnitDatasetCheck(PreferencesExt p) {
            super(p, "dataset:");
            this.ta = new TextHistoryPane(true);
            this.add((Component)this.ta, "Center");
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try (NetcdfDataset ncfile = NetcdfDataset.openDataset((String)command, (boolean)this.addCoords, null);){
                this.ta.setText("Variables for " + command + ":");
                for (Variable o1 : ncfile.getVariables()) {
                    VariableEnhanced vs = (VariableEnhanced)o1;
                    String units = vs.getUnitsString();
                    StringBuilder sb = new StringBuilder();
                    sb.append("   ").append(vs.getShortName()).append(" has unit= <").append(units).append(">");
                    if (units != null) {
                        try {
                            SimpleUnit su = SimpleUnit.factoryWithExceptions((String)units);
                            sb.append(" unit convert = ").append(su.toString());
                            if (su.isUnknownUnit()) {
                                sb.append(" UNKNOWN UNIT");
                            }
                        }
                        catch (Exception ioe) {
                            sb.append(" unit convert failed ");
                            sb.insert(0, "**** Fail ");
                        }
                    }
                    this.ta.appendLine(sb.toString());
                }
            }
            catch (FileNotFoundException ioe) {
                this.ta.setText("Failed to open <" + command + ">");
                err = true;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                err = true;
            }
            return !err;
        }

        @Override
        void closeOpenFiles() throws IOException {
            this.ta.clear();
        }
    }

    private class UnitsPanel
    extends JPanel {
        PreferencesExt prefs;
        JSplitPane split;
        JSplitPane split2;
        UnitDatasetCheck unitDataset;
        UnitConvert unitConvert;
        DateFormatMark dateFormatMark;

        UnitsPanel(PreferencesExt prefs) {
            this.prefs = prefs;
            this.unitDataset = new UnitDatasetCheck((PreferencesExt)prefs.node("unitDataset"));
            this.unitConvert = new UnitConvert((PreferencesExt)prefs.node("unitConvert"));
            this.dateFormatMark = new DateFormatMark((PreferencesExt)prefs.node("dateFormatMark"));
            this.split2 = new JSplitPane(0, this.unitConvert, this.dateFormatMark);
            this.split2.setDividerLocation(prefs.getInt("splitPos2", 500));
            this.split = new JSplitPane(1, new JScrollPane(this.unitDataset), this.split2);
            this.split.setDividerLocation(prefs.getInt("splitPos", 500));
            this.setLayout(new BorderLayout());
            this.add((Component)this.split, "Center");
        }

        void save() {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
            this.unitConvert.save();
            this.unitDataset.save();
        }
    }

    private class NCdumpPanel
    extends OpPanel
    implements GetDataRunnable {
        private GetDataTask task;
        NetcdfFile ncfile;
        String filename;
        String command;
        String result;
        TextHistoryPane ta;

        NCdumpPanel(PreferencesExt prefs) {
            super(prefs, "command:");
            this.ncfile = null;
            this.filename = null;
            this.command = null;
            this.ta = new TextHistoryPane(true);
            this.add((Component)this.ta, "Center");
            this.stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NCdumpPanel.this.task.isSuccess()) {
                        NCdumpPanel.this.ta.setText(NCdumpPanel.this.result);
                    } else {
                        NCdumpPanel.this.ta.setText(((NCdumpPanel)NCdumpPanel.this).task.errMsg);
                    }
                    if (NCdumpPanel.this.task.isCancel()) {
                        NCdumpPanel.this.ta.appendLine("\n***Cancelled by User");
                    }
                    NCdumpPanel.this.ta.gotoTop();
                    if (NCdumpPanel.this.task.isSuccess() && !NCdumpPanel.this.task.isCancel()) {
                        NCdumpPanel.this.cb.setSelectedItem(NCdumpPanel.this.filename);
                    }
                }
            });
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ncfile != null) {
                this.ncfile.close();
            }
            this.ncfile = null;
        }

        @Override
        boolean process(Object o) {
            int pos;
            String input = ((String)o).trim();
            if (input.indexOf(34) == 0 && (pos = input.indexOf(34, 1)) > 0) {
                this.filename = input.substring(1, pos);
                this.command = input.substring(pos + 1);
            } else if (input.indexOf(39) == 0 && (pos = input.indexOf(39, 1)) > 0) {
                this.filename = input.substring(1, pos);
                this.command = input.substring(pos + 1);
            } else {
                pos = input.indexOf(32);
                if (pos > 0) {
                    this.filename = input.substring(0, pos);
                    this.command = input.substring(pos);
                } else {
                    this.filename = input;
                    this.command = null;
                }
            }
            this.task = new GetDataTask(this, this.filename, null);
            this.stopButton.startProgressMonitorTask(this.task);
            return true;
        }

        @Override
        public void run(Object o) throws IOException {
            try {
                this.ncfile = this.addCoords ? NetcdfDataset.openDataset((String)this.filename, (boolean)true, null) : NetcdfDataset.openFile((String)this.filename, null);
                StringWriter writer = new StringWriter(50000);
                NCdumpW.print((NetcdfFile)this.ncfile, (String)this.command, (Writer)writer, (CancelTask)this.task);
                this.result = writer.toString();
            }
            finally {
                try {
                    if (this.ncfile != null) {
                        this.ncfile.close();
                    }
                    this.ncfile = null;
                }
                catch (IOException ioe) {
                    System.out.printf("Error closing %n", new Object[0]);
                }
            }
        }

        void setNetcdfFile(NetcdfFile ncf) {
            this.ncfile = ncf;
            this.filename = ncf.getLocation();
            GetDataRunnable runner = new GetDataRunnable(){

                @Override
                public void run(Object o) throws IOException {
                    StringWriter writer = new StringWriter(50000);
                    NCdumpW.print((NetcdfFile)NCdumpPanel.this.ncfile, (String)NCdumpPanel.this.command, (Writer)writer, (CancelTask)NCdumpPanel.this.task);
                    NCdumpPanel.this.result = writer.toString();
                }
            };
            this.task = new GetDataTask(runner, this.filename, null);
            this.stopButton.startProgressMonitorTask(this.task);
        }
    }

    private abstract class OpPanel
    extends JPanel {
        PreferencesExt prefs;
        ComboBox cb;
        JPanel buttPanel;
        JPanel topPanel;
        AbstractButton coordButt = null;
        StopButton stopButton;
        boolean addCoords;
        boolean defer;
        boolean busy;
        long lastEvent = -1L;
        boolean eventOK = true;
        IndependentWindow detailWindow;
        TextHistoryPane detailTA;

        OpPanel(PreferencesExt prefs, String command) {
            this(prefs, command, true, true);
        }

        OpPanel(PreferencesExt prefs, String command, boolean addFileButton, boolean addCoordButton) {
            this(prefs, command, true, addFileButton, addCoordButton);
        }

        OpPanel(PreferencesExt prefs, String command, boolean addComboBox, boolean addFileButton, boolean addCoordButton) {
            this.prefs = prefs;
            this.buttPanel = new JPanel(new FlowLayout(0, 5, 0));
            this.cb = new ComboBox(prefs);
            this.cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ToolsUI.this.debugCB) {
                        System.out.println(" doit " + OpPanel.this.cb.getSelectedItem() + " cmd=" + e.getActionCommand() + " when=" + e.getWhen() + " class=" + OpPanel.this.getClass().getName());
                    }
                    if (OpPanel.this.eventOK) {
                        OpPanel.this.doit(OpPanel.this.cb.getSelectedItem());
                        OpPanel.this.lastEvent = e.getWhen();
                    }
                }
            });
            AbstractAction closeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        OpPanel.this.closeOpenFiles();
                    }
                    catch (IOException e1) {
                        System.out.printf("close failed", new Object[0]);
                    }
                }
            };
            BAMutil.setActionProperties(closeAction, "Close", "release files", false, 76, -1);
            BAMutil.addActionToContainer(this.buttPanel, closeAction);
            if (addFileButton) {
                AbstractAction fileAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String filename = ToolsUI.this.fileChooser.chooseFilename();
                        if (filename == null) {
                            return;
                        }
                        OpPanel.this.cb.setSelectedItem(filename);
                    }
                };
                BAMutil.setActionProperties(fileAction, "FileChooser", "open Local dataset...", false, 76, -1);
                BAMutil.addActionToContainer(this.buttPanel, fileAction);
            }
            if (addCoordButton) {
                AbstractAction coordAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OpPanel.this.addCoords = (Boolean)this.getValue("state");
                        String tooltip = OpPanel.this.addCoords ? "add Coordinates is ON" : "add Coordinates is OFF";
                        OpPanel.this.coordButt.setToolTipText(tooltip);
                    }
                };
                this.addCoords = prefs.getBoolean("coordState", false);
                String tooltip2 = this.addCoords ? "add Coordinates is ON" : "add Coordinates is OFF";
                BAMutil.setActionProperties(coordAction, "addCoords", tooltip2, true, 67, -1);
                coordAction.putValue("state", this.addCoords);
                this.coordButt = BAMutil.addActionToContainer(this.buttPanel, coordAction);
            }
            if (this instanceof GetDataRunnable) {
                this.stopButton = new StopButton("Stop");
                this.buttPanel.add(this.stopButton);
            }
            this.topPanel = new JPanel(new BorderLayout());
            if (addComboBox) {
                this.topPanel.add((Component)new JLabel(command), "West");
                this.topPanel.add((Component)this.cb, "Center");
                this.topPanel.add((Component)this.buttPanel, "East");
            } else {
                this.topPanel.add((Component)this.buttPanel, "East");
            }
            this.setLayout(new BorderLayout());
            this.add((Component)this.topPanel, "North");
            this.detailTA = new TextHistoryPane();
            this.detailTA.setFont(new Font("Monospaced", 0, 12));
            this.detailWindow = new IndependentWindow("Details", BAMutil.getImage("netcdfUI"), new JScrollPane(this.detailTA));
            Rectangle bounds = (Rectangle)prefs.getBean(ToolsUI.FRAME_SIZE, new Rectangle(200, 50, 500, 700));
            this.detailWindow.setBounds(bounds);
        }

        void doit(Object command) {
            if (this.busy) {
                return;
            }
            if (command == null) {
                return;
            }
            if (command instanceof String) {
                command = ((String)command).trim();
            }
            if (ToolsUI.this.debug) {
                System.out.println(this.getClass().getName() + " process=" + command);
            }
            this.busy = true;
            if (this.process(command) && !this.defer) {
                this.cb.addItem(command);
            }
            this.busy = false;
        }

        abstract boolean process(Object var1);

        void closeOpenFiles() throws IOException {
        }

        void save() {
            this.cb.save();
            if (this.coordButt != null) {
                this.prefs.putBoolean("coordState", this.coordButt.getModel().isSelected());
            }
            if (this.detailWindow != null) {
                this.prefs.putBeanObject(ToolsUI.FRAME_SIZE, this.detailWindow.getBounds());
            }
        }

        void setSelectedItem(Object item) {
            this.eventOK = false;
            this.cb.addItem(item);
            this.eventOK = true;
        }
    }
}

