/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import ucar.nc2.constants.CDM;
import ucar.nc2.util.IO;

public class URLExtracter {
    private HTMLEditorKit.Parser parser;
    private ArrayList urlList;
    private URL baseURL;
    private boolean wantURLS = false;
    private boolean debug = false;
    private boolean debugIMG = false;
    static String startURL = "";
    static String dirpath = "c:/tmp/test/";
    static int recursionDepth = 3;

    public URLExtracter() {
        ParserGetter kit = new ParserGetter();
        this.parser = kit.getParser();
    }

    public ArrayList extract(String url) throws IOException {
        if (this.debug) {
            System.out.println(" URLextract from " + url);
        }
        this.urlList = new ArrayList();
        this.baseURL = new URL(url);
        InputStream in = this.baseURL.openStream();
        InputStreamReader r = new InputStreamReader(in, CDM.utf8Charset);
        CallerBacker callback = new CallerBacker();
        this.wantURLS = true;
        this.parser.parse(r, callback, false);
        return this.urlList;
    }

    void extractJPG(String urlString, int depth) {
        System.out.println("extractJPG from " + urlString);
        try {
            ArrayList urls = this.extract(urlString);
            for (int i = 0; i < urls.size(); ++i) {
                String url = (String)urls.get(i);
                System.out.println(" " + url);
                if (url.endsWith("jpg")) {
                    int h = url.hashCode();
                    String hs = h < 0 ? "M" + Integer.toString(-h) : Integer.toString(h);
                    String filename = dirpath + "/" + hs + ".jpg";
                    System.out.println("---Extract= " + IO.readURLtoFile((String)url, (File)new File(filename)));
                }
                if (depth >= recursionDepth || !url.endsWith("html") && !url.endsWith("htm")) continue;
                this.extractJPG(url, depth + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("failed to download " + urlString + "\n" + e.getMessage());
        }
    }

    public static void main(String[] args) {
        File dir = new File(dirpath);
        if (!dir.exists() && !dir.mkdirs()) {
            System.out.printf("mkdirs failed on %s%n", dir);
        }
        URLExtracter ue = new URLExtracter();
        ue.extractJPG(startURL, 1);
    }

    private static class ParserGetter
    extends HTMLEditorKit {
        private ParserGetter() {
        }

        @Override
        public HTMLEditorKit.Parser getParser() {
            return super.getParser();
        }
    }

    private class CallerBacker
    extends HTMLEditorKit.ParserCallback {
        private CallerBacker() {
        }

        private boolean wantTag(HTML.Tag tag) {
            return tag == HTML.Tag.H1 || tag == HTML.Tag.H2 || tag == HTML.Tag.H3 || tag == HTML.Tag.H4 || tag == HTML.Tag.H5 || tag == HTML.Tag.H6;
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attributes, int position) {
            if (URLExtracter.this.debug) {
                System.out.println(" handleStartTag=" + tag);
            }
            if (URLExtracter.this.wantURLS && tag == HTML.Tag.A) {
                this.extractHREF(attributes);
            }
            if (tag == HTML.Tag.IMG) {
                this.extractIMG(attributes);
            }
        }

        @Override
        public void handleEndTag(HTML.Tag tag, int position) {
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attributes, int position) {
            if (URLExtracter.this.debug) {
                System.out.println(" handleSimpleTag=" + tag);
            }
            if (URLExtracter.this.wantURLS && tag == HTML.Tag.A) {
                this.extractHREF(attributes);
            }
            if (tag == HTML.Tag.IMG) {
                this.extractIMG(attributes);
            }
        }

        private void extractHREF(AttributeSet attributes) {
            Enumeration<?> e = attributes.getAttributeNames();
            while (e.hasMoreElements()) {
                Object name = e.nextElement();
                String value = (String)attributes.getAttribute(name);
                if (URLExtracter.this.debug) {
                    System.out.println(" HREF att: name= <" + name + "> value= <" + value + ">");
                }
                try {
                    if (name != HTML.Attribute.HREF) continue;
                    URL u = new URL(URLExtracter.this.baseURL, value);
                    String urlName = u.toString();
                    if (URLExtracter.this.urlList != null) {
                        URLExtracter.this.urlList.add(u.toString());
                    }
                    if (!URLExtracter.this.debug) continue;
                    System.out.println(" extracted URL= <" + urlName + ">");
                }
                catch (MalformedURLException ex) {
                    System.err.println(ex);
                    System.err.println(URLExtracter.this.baseURL);
                    System.err.println(value);
                }
            }
        }

        private void extractIMG(AttributeSet attributes) {
            String src = null;
            int w = 0;
            int h = 0;
            Enumeration<?> e = attributes.getAttributeNames();
            while (e.hasMoreElements()) {
                Object name = e.nextElement();
                String value = (String)attributes.getAttribute(name);
                if (URLExtracter.this.debugIMG) {
                    System.out.println(" extractIMG " + name + " value= " + value);
                }
                if (name == HTML.Attribute.SRC && 0 < value.indexOf("jpg")) {
                    src = value;
                    if (URLExtracter.this.debugIMG) {
                        System.out.println(" IMG SRC= <" + src + ">");
                    }
                }
                if (name == HTML.Attribute.WIDTH) {
                    try {
                        w = Integer.parseInt(value);
                        if (URLExtracter.this.debugIMG) {
                            System.out.println(" IMG WIDTH= <" + w + ">");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (name != HTML.Attribute.HEIGHT) continue;
                try {
                    h = Integer.parseInt(value);
                    if (!URLExtracter.this.debugIMG) continue;
                    System.out.println(" IMG HEIGHT= <" + h + ">");
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (src != null && w * h > 30000) {
                try {
                    URL u = new URL(URLExtracter.this.baseURL, src);
                    String urlName = u.toString();
                    URLExtracter.this.urlList.add(u.toString());
                    if (URLExtracter.this.debugIMG) {
                        System.out.println(" extracted IMG URL= <" + urlName + ">");
                    }
                }
                catch (MalformedURLException ex) {
                    System.err.println(ex);
                }
            }
        }

        @Override
        public void handleText(char[] text, int position) {
            if (URLExtracter.this.debug) {
                System.out.println(" handleText=" + new String(text));
            }
        }

        @Override
        public void handleError(String errorMsg, int pos) {
            System.out.println(" error=" + errorMsg + " at " + pos);
        }
    }
}

