/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs.ui;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Debug {
    private static Preferences store = null;
    private static boolean debug = false;
    private static boolean debugEvents = false;

    public static void setStore(Preferences debugStore) {
        store = debugStore;
    }

    public static boolean isSet(String flagName) {
        if (store == null) {
            return false;
        }
        NamePart np = Debug.partit(flagName);
        if (debug) {
            try {
                if (np.storeName.length() > 0 && !store.nodeExists(np.storeName)) {
                    System.out.println("Debug.isSet create node = " + flagName + " " + np);
                } else if (null == store.node(np.storeName).get(np.keyName, null)) {
                    System.out.println("Debug.isSet create flag = " + flagName + " " + np);
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        boolean value = store.node(np.storeName).getBoolean(np.keyName, false);
        store.node(np.storeName).putBoolean(np.keyName, value);
        return value;
    }

    public static void set(String flagName, boolean value) {
        NamePart np = Debug.partit(flagName);
        if (debug) {
            try {
                if (np.storeName.length() > 0 && !store.nodeExists(np.storeName)) {
                    System.out.println("Debug.set create node = " + flagName + " " + np);
                } else if (null == store.node(np.storeName).get(np.keyName, null)) {
                    System.out.println("Debug.set create flag = " + flagName + " " + np);
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        store.node(np.storeName).putBoolean(np.keyName, value);
    }

    public static void removeAll() {
        try {
            Debug.removeAll(store, false);
        }
        catch (BackingStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void removeAll(Preferences prefs, boolean delete) throws BackingStoreException {
        String[] kidName;
        for (String aKidName : kidName = prefs.childrenNames()) {
            Preferences pkid = prefs.node(aKidName);
            Debug.removeAll(pkid, true);
        }
        if (delete) {
            prefs.removeNode();
        } else {
            prefs.clear();
        }
    }

    public static void constructMenu(JMenu topMenu) {
        if (debug) {
            System.out.println("Debug.constructMenu ");
        }
        if (topMenu.getItemCount() > 0) {
            topMenu.removeAll();
        }
        try {
            Debug.addToMenu(topMenu, store);
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        topMenu.revalidate();
    }

    private static void addToMenu(JMenu menu, Preferences prefs) throws BackingStoreException {
        String[] kidName;
        String[] keys;
        if (debug) {
            System.out.println(" addMenu " + prefs.name());
        }
        for (String key : keys = prefs.keys()) {
            boolean bval = prefs.getBoolean(key, false);
            String fullname = prefs.absolutePath() + "/" + key;
            menu.add(new DebugMenuItem(fullname, key, bval));
            if (!debug) continue;
            System.out.println("   leaf= <" + key + "><" + fullname + ">");
        }
        for (String aKidName : kidName = prefs.childrenNames()) {
            Preferences pkid = prefs.node(aKidName);
            JMenu subMenu = new JMenu(pkid.name());
            menu.add(subMenu);
            Debug.addToMenu(subMenu, pkid);
        }
    }

    private static NamePart partit(String name) {
        NamePart np = new NamePart();
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            np.storeName = name.substring(0, pos);
            np.keyName = name.substring(pos + 1);
            if (np.storeName.startsWith("/")) {
                np.storeName = np.storeName.substring(1);
            }
        } else {
            np.keyName = name;
        }
        return np;
    }

    private static class DebugMenuItem
    extends JCheckBoxMenuItem {
        private String fullname;

        DebugMenuItem(String foolName, String menuName, boolean val) {
            super(menuName, val);
            this.fullname = foolName;
            if (this.fullname.startsWith("/Debug/")) {
                this.fullname = this.fullname.substring(7);
            }
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    if (debugEvents) {
                        System.out.println("DebugMenuItem " + DebugMenuItem.this.getText() + " " + DebugMenuItem.this.getState());
                    }
                    Debug.set(DebugMenuItem.this.fullname, DebugMenuItem.this.getState());
                }
            });
        }
    }

    private static class NamePart {
        String storeName = "";
        String keyName = "";

        private NamePart() {
        }

        public String toString() {
            return "<" + this.storeName + "> <" + this.keyName + ">";
        }
    }
}

