/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.ui.widget.IndependentDialog;
import ucar.util.prefs.PersistenceManager;
import ucar.util.prefs.PreferencesExt;

public class ComboBox
extends JComboBox {
    private static final String LIST = "ComboBoxList";
    private boolean deleting = false;
    private PersistenceManager prefs;
    private int nkeep = 20;
    private JPopupMenu popupMenu;
    private static long lastEvent;

    public ComboBox() {
        this(null, 20);
    }

    public ComboBox(PersistenceManager prefs) {
        this(prefs, 20);
    }

    public ComboBox(PersistenceManager prefs, int nkeep) {
        this.prefs = prefs;
        this.nkeep = nkeep;
        this.setEditable(true);
        this.setPreferences(prefs);
        this.addContextMenu();
    }

    public void setPreferences(PersistenceManager prefs) {
        this.prefs = prefs;
        if (prefs != null) {
            ArrayList list = (ArrayList)prefs.getList(LIST, null);
            this.setItemList(list);
        }
    }

    public JComponent getDeepEditComponent() {
        return (JComponent)this.getEditor().getEditorComponent();
    }

    public void addContextMenu() {
        Component editComp = this.getEditor().getEditorComponent();
        this.popupMenu = new JPopupMenu();
        editComp.addMouseListener(new PopupTriggerListener(){

            @Override
            public void showPopup(MouseEvent e) {
                ComboBox.this.popupMenu.show(ComboBox.this, e.getX(), e.getY());
            }
        });
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JList delComp = new JList();
                delComp.setModel(ComboBox.this.getModel());
                delComp.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        int index = delComp.getSelectedIndex();
                        ComboBox.this.deleting = true;
                        if (index >= 0) {
                            ComboBox.this.removeItemAt(index);
                        }
                        ComboBox.this.deleting = false;
                    }
                });
                IndependentDialog iw = new IndependentDialog(null, true, "delete items", delComp);
                iw.show();
            }
        };
        deleteAction.putValue("Name", "Delete");
        this.popupMenu.add(deleteAction);
        AbstractAction deleteAllAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboBox.this.setItemList(new ArrayList<Object>());
            }
        };
        deleteAllAction.putValue("Name", "Delete All");
        this.popupMenu.add(deleteAllAction);
    }

    @Override
    protected void fireActionEvent() {
        if (this.deleting) {
            return;
        }
        super.fireActionEvent();
    }

    public void addItem(Object item) {
        if (item == null) {
            return;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!item.equals(this.getItemAt(i))) continue;
            if (i == 0) {
                this.setSelectedIndex(0);
                return;
            }
            this.removeItemAt(i);
        }
        this.insertItemAt(item, 0);
        this.setSelectedIndex(0);
    }

    public void save() {
        if (this.prefs != null) {
            this.prefs.putList(LIST, this.getItemList());
        }
    }

    public List<Object> getItemList() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.getItemCount() && i < this.nkeep; ++i) {
            list.add(this.getItemAt(i));
        }
        return list;
    }

    public void setItemList(Collection<Object> list) {
        if (list == null) {
            return;
        }
        this.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        if (list.size() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setNkeep(int nkeep) {
        this.nkeep = nkeep;
    }

    public int getNkeep() {
        return this.nkeep;
    }

    protected Object getStoreValue(Object defValue) {
        if (this.prefs == null) {
            return defValue;
        }
        return ((PreferencesExt)this.prefs).getBean(LIST, defValue);
    }

    protected void setStoreValue(List newValue) {
        if (this.prefs != null) {
            this.prefs.putList(LIST, newValue);
        }
    }

    public static void main(String[] args) throws IOException {
        JFrame frame = new JFrame("Test");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        final ComboBox cb = new ComboBox(null);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("**** cb event=" + e);
                if (e.getActionCommand().equals("comboBoxChanged")) {
                    cb.addItem(cb.getSelectedItem());
                }
            }
        });
        cb.getEditor().getEditorComponent().setForeground(Color.red);
        JPanel main = new JPanel();
        main.add(cb);
        frame.getContentPane().add(main);
        frame.pack();
        frame.setLocation(300, 300);
        frame.setVisible(true);
    }

    private static abstract class PopupTriggerListener
    extends MouseAdapter {
        private PopupTriggerListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public abstract void showPopup(MouseEvent var1);
    }
}

