/*
 * Decompiled with CFR 0.152.
 */
package thredds.logs;

import thredds.logs.PathMatcher;
import ucar.unidata.util.StringUtil2;

public class LogCategorizer {
    static boolean showRoots = false;
    private static String roots;
    private static PathMatcher pathMatcher;
    public static String[] services;

    public static void setRoots(String raw) {
        if (null != raw) {
            roots = raw;
        }
    }

    public static PathMatcher readRoots() {
        PathMatcher pathMatcher = new PathMatcher();
        String rootString = StringUtil2.replace((String)roots, (String)"\n", (String)",");
        String[] roots = rootString.split(",");
        for (int i = 0; i < roots.length; i += 2) {
            if (showRoots) {
                System.out.printf("  %-40s %-40s%n", roots[i], roots[i + 1]);
            }
            pathMatcher.put(roots[i]);
        }
        return pathMatcher;
    }

    public static String getDataroot(String path, int status) {
        PathMatcher.Match match;
        String ss;
        if (pathMatcher == null) {
            pathMatcher = LogCategorizer.readRoots();
        }
        if ((ss = LogCategorizer.getServiceSpecial(path)) != null) {
            return "service-" + ss;
        }
        if (path.startsWith("//thredds/")) {
            path = path.substring(1);
        }
        if (!path.startsWith("/thredds/")) {
            return "zervice-root";
        }
        String dataRoot = null;
        String spath = path.substring(9);
        String service = LogCategorizer.findService(spath);
        if (service != null && spath.length() > service.length() && (match = pathMatcher.match(spath = spath.substring(service.length() + 1))) != null) {
            dataRoot = match.root;
        }
        if (dataRoot == null && status >= 400) {
            dataRoot = "zBad";
        }
        if (dataRoot == null) {
            service = LogCategorizer.getService(path);
            dataRoot = service != null ? "zervice-" + service : "unknown";
        }
        return dataRoot;
    }

    public static String getServiceSpecial(String path) {
        String ss = null;
        if (path.startsWith("/dqcServlet")) {
            ss = "dqcServlet";
        } else if (path.startsWith("/cdmvalidator")) {
            ss = "cdmvalidator";
        }
        return ss;
    }

    public static String getService(String path) {
        String service = LogCategorizer.getServiceSpecial(path);
        if (service != null) {
            return service;
        }
        if (path.startsWith("/dts")) {
            return "dts";
        }
        if (path.startsWith("/dqcServlet")) {
            return "dqcServlet";
        }
        if (path.startsWith("/thredds/")) {
            String req;
            int pos;
            String spath = path.substring(9);
            service = LogCategorizer.findService(spath);
            if (service == null && (spath.startsWith("ncml") || spath.startsWith("uddc") || spath.startsWith("iso"))) {
                service = "ncIso";
            }
            if (service == null && (spath.endsWith("xml") || spath.endsWith("html"))) {
                service = "catalog";
            }
            if (service == null && (pos = spath.indexOf(63)) > 0 && ((req = spath.substring(0, pos)).endsWith("xml") || req.endsWith("html"))) {
                service = "catalog";
            }
        }
        if (service == null) {
            service = "other";
        }
        return service;
    }

    public static String findService(String path) {
        for (String service : services) {
            if (!path.startsWith(service)) continue;
            return service;
        }
        return null;
    }

    static {
        pathMatcher = null;
        services = new String[]{"admin", "cataloggen", "catalog", "cdmremote", "cdmrfeature", "dodsC", "dqc", "fileServer", "godiva2", "ncss", "ncstream", "radarServer", "remoteCatalogService", "view", "wcs", "wms"};
    }
}

