/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.geoloc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import ucar.nc2.ui.geoloc.NavigatedPanel;
import ucar.nc2.ui.geoloc.NewMapAreaEvent;
import ucar.nc2.ui.geoloc.NewMapAreaListener;
import ucar.nc2.ui.geoloc.NewProjectionEvent;
import ucar.nc2.ui.geoloc.NewProjectionListener;
import ucar.nc2.ui.gis.MapBean;
import ucar.nc2.ui.gis.worldmap.WorldMap;
import ucar.nc2.ui.util.Renderer;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.unidata.geoloc.ProjectionImpl;

public class NPController
extends JPanel {
    protected NavigatedPanel np;
    protected ArrayList renderers = new ArrayList();
    protected ProjectionImpl project;
    protected AffineTransform atI = new AffineTransform();
    protected boolean eventOk = true;
    protected JPanel toolPanel;
    private boolean debug = false;

    public NPController() {
        this.np = new NavigatedPanel();
        WorldMap render = new WorldMap();
        this.project = this.np.getProjectionImpl();
        render.setProjection(this.project);
        this.addRenderer(render);
        this.np.addNewProjectionListener(new NewProjectionListener(){

            @Override
            public void actionPerformed(NewProjectionEvent e) {
                ProjectionImpl p = e.getProjection();
                for (Object renderer : NPController.this.renderers) {
                    Renderer r = (Renderer)renderer;
                    r.setProjection(p);
                }
                NPController.this.redraw(true);
            }
        });
        this.np.addNewMapAreaListener(new NewMapAreaListener(){

            @Override
            public void actionPerformed(NewMapAreaEvent e) {
                NPController.this.redraw(true);
            }
        });
        PopupMenu mapBeanMenu = MapBean.getStandardMapSelectButton(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Renderer")) {
                    Renderer mapRender = (Renderer)e.getNewValue();
                    mapRender.setProjection(NPController.this.np.getProjectionImpl());
                    NPController.this.renderers.set(0, mapRender);
                    NPController.this.redraw(true);
                }
            }
        });
        this.toolPanel = new JPanel(new FlowLayout(0));
        this.toolPanel.add(mapBeanMenu.getParentComponent());
        this.toolPanel.add(this.np.getNavToolBar());
        this.toolPanel.add(this.np.getMoveToolBar());
        BAMutil.addActionToContainer(this.toolPanel, this.np.setReferenceAction);
        this.makeUI();
    }

    protected void makeUI() {
        this.setLayout(new BorderLayout());
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setBorder(new EtchedBorder());
        JLabel positionLabel = new JLabel("position");
        statusPanel.add((Component)positionLabel, "Center");
        this.np.setPositionLabel(positionLabel);
        this.add((Component)this.toolPanel, "North");
        this.add((Component)this.np, "Center");
        this.add((Component)statusPanel, "South");
    }

    public NavigatedPanel getNavigatedPanel() {
        return this.np;
    }

    public void addRenderer(Renderer r) {
        this.renderers.add(r);
        r.setProjection(this.project);
    }

    public void setProjection(ProjectionImpl p) {
        this.project = p;
        for (Object renderer : this.renderers) {
            Renderer r = (Renderer)renderer;
            r.setProjection(p);
        }
        this.eventOk = false;
        this.np.setProjectionImpl(p);
        this.eventOk = true;
        this.redraw(true);
    }

    protected void redraw(boolean complete) {
        if (this.project == null) {
            return;
        }
        long tstart = System.currentTimeMillis();
        Graphics2D gNP = this.np.getBufferedImageGraphics();
        if (gNP == null) {
            return;
        }
        gNP.setBackground(this.np.getBackgroundColor());
        gNP.fill(gNP.getClipBounds());
        for (Object renderer : this.renderers) {
            Renderer r = (Renderer)renderer;
            r.draw(gNP, this.atI);
        }
        gNP.dispose();
        if (this.debug) {
            long tend = System.currentTimeMillis();
            System.out.println("NPController draw time = " + (double)(tend - tstart) / 1000.0 + " secs");
        }
        this.np.repaint();
    }
}

