/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.menu;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import thredds.inventory.bdb.MetadataManager;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.PLAF;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.unidata.io.RandomAccessFile;

public class SystemMenu
extends JMenu {
    private ToolsUI toolsui;
    static boolean isCacheInit;

    public SystemMenu(ToolsUI tui) {
        super("System");
        this.setMnemonic('S');
        this.toolsui = tui;
        AbstractAction act = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetadataManager.closeAll();
            }
        };
        BAMutil.setActionProperties(act, null, "Close BDB database", false, 83, -1);
        BAMutil.addActionToMenu(this, act);
        AbstractAction clearHttpStateAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        BAMutil.setActionProperties(clearHttpStateAction, null, "Clear Http State", false, 83, -1);
        BAMutil.addActionToMenu(this, clearHttpStateAction);
        AbstractAction showCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                f.format("RandomAccessFileCache contents%n", new Object[0]);
                FileCacheIF rafCache = RandomAccessFile.getGlobalFileCache();
                if (null != rafCache) {
                    rafCache.showCache(f);
                }
                f.format("%nNetcdfFileCache contents%n", new Object[0]);
                FileCacheIF cache = NetcdfDataset.getNetcdfFileCache();
                if (null != cache) {
                    cache.showCache(f);
                }
                SystemMenu.this.toolsui.getDatasetViewerPanel().setText(f.toString());
                SystemMenu.this.toolsui.getDatasetViewerPanel().getDetailWindow().show();
            }
        };
        BAMutil.setActionProperties(showCacheAction, null, "Show Caches", false, 83, -1);
        BAMutil.addActionToMenu(this, showCacheAction);
        AbstractAction clearRafCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCacheIF rafCache = RandomAccessFile.getGlobalFileCache();
                if (rafCache != null) {
                    rafCache.clearCache(true);
                }
            }
        };
        BAMutil.setActionProperties(clearRafCacheAction, null, "Clear RandomAccessFileCache", false, 67, -1);
        BAMutil.addActionToMenu(this, clearRafCacheAction);
        AbstractAction clearCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCacheIF cache = NetcdfDataset.getNetcdfFileCache();
                if (cache != null) {
                    cache.clearCache(true);
                }
            }
        };
        BAMutil.setActionProperties(clearCacheAction, null, "Clear NetcdfDatasetCache", false, 67, -1);
        BAMutil.addActionToMenu(this, clearCacheAction);
        AbstractAction enableCache = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                if (state == isCacheInit) {
                    return;
                }
                isCacheInit = state;
                if (isCacheInit) {
                    FileCacheIF cache = NetcdfDataset.getNetcdfFileCache();
                    if (cache != null) {
                        cache.enable();
                    } else {
                        NetcdfDataset.initNetcdfFileCache((int)10, (int)20, (int)600);
                    }
                } else {
                    FileCacheIF cache = NetcdfDataset.getNetcdfFileCache();
                    if (cache != null) {
                        cache.disable();
                    }
                }
            }
        };
        BAMutil.setActionPropertiesToggle(enableCache, null, "Enable NetcdfDatasetCache", isCacheInit, 78, -1);
        BAMutil.addActionToMenu(this, enableCache);
        AbstractAction showPropertiesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemMenu.this.toolsui.getDatasetViewerPanel().setText("System Properties\n");
                Properties sysp = System.getProperties();
                Enumeration<?> eprops = sysp.propertyNames();
                ArrayList<?> list = Collections.list(eprops);
                Collections.sort(list);
                for (Object aList : list) {
                    String name = (String)aList;
                    String value = System.getProperty(name);
                    SystemMenu.this.toolsui.getDatasetViewerPanel().appendLine("  " + name + " = " + value);
                }
                SystemMenu.this.toolsui.getDatasetViewerPanel().getDetailWindow().show();
            }
        };
        BAMutil.setActionProperties(showPropertiesAction, null, "System Properties", false, 80, -1);
        BAMutil.addActionToMenu(this, showPropertiesAction);
        this.addPlafSubmenu();
        AbstractAction exitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemMenu.this.toolsui;
                ToolsUI.exit();
            }
        };
        BAMutil.setActionProperties(exitAction, "Exit", "Exit", false, 88, -1);
        BAMutil.addActionToMenu(this, exitAction);
    }

    private void addPlafSubmenu() {
        JMenu plafMenu = new JMenu("Look and Feel");
        plafMenu.setMnemonic('L');
        PLAF plaf = new PLAF(this.toolsui);
        plaf.addToMenu(plafMenu);
        this.add(plafMenu);
    }
}

