/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.ui.op.FeatureScanPanel;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.util.prefs.PreferencesExt;

public class FeatureScanOpPanel
extends OpPanel {
    private FeatureScanPanel ftTable;
    final FileManager dirChooser;

    public FeatureScanOpPanel(PreferencesExt prefs) {
        super(prefs, "dir:", false, false);
        this.dirChooser = new FileManager(ToolsUI.getToolsFrame(), null, null, (PreferencesExt)prefs.node("FeatureScanFileManager"));
        this.ftTable = new FeatureScanPanel(prefs);
        this.add((Component)this.ftTable, "Center");
        this.ftTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (!(e.getNewValue() instanceof String)) {
                    return;
                }
                String datasetName = (String)e.getNewValue();
                switch (e.getPropertyName()) {
                    case "openPointFeatureDataset": {
                        ToolsUI.getToolsUI().openPointFeatureDataset(datasetName);
                        break;
                    }
                    case "openNetcdfFile": {
                        ToolsUI.getToolsUI().openNetcdfFile(datasetName);
                        break;
                    }
                    case "openCoordSystems": {
                        ToolsUI.getToolsUI().openCoordSystems(datasetName);
                        break;
                    }
                    case "openNcML": {
                        ToolsUI.getToolsUI().openNcML(datasetName);
                        break;
                    }
                    case "openGridDataset": {
                        ToolsUI.getToolsUI().openGridDataset(datasetName);
                        break;
                    }
                    case "openCoverageDataset": {
                        ToolsUI.getToolsUI().openCoverageDataset(datasetName);
                        break;
                    }
                    case "openRadialDataset": {
                        ToolsUI.getToolsUI().openRadialDataset(datasetName);
                    }
                }
            }
        });
        this.dirChooser.getFileChooser().setFileSelectionMode(2);
        this.dirChooser.setCurrentDirectory(prefs.get("currDir", "."));
        AbstractAction fileAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename = FeatureScanOpPanel.this.dirChooser.chooseFilename();
                if (filename == null) {
                    return;
                }
                FeatureScanOpPanel.this.cb.setSelectedItem(filename);
            }
        };
        BAMutil.setActionProperties(fileAction, "FileChooser", "open Local dataset...", false, 76, -1);
        BAMutil.addActionToContainer(this.buttPanel, fileAction);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        return this.ftTable.setScanDirectory(command);
    }

    @Override
    public void closeOpenFiles() {
        this.ftTable.clear();
    }

    @Override
    public void save() {
        this.dirChooser.save();
        this.ftTable.save();
        this.prefs.put("currDir", this.dirChooser.getCurrentDirectory());
        super.save();
    }
}

