/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.awt.Rectangle;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.Formatter;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.ui.gis.shapefile.ShapeFileBean;
import ucar.nc2.ui.gis.worldmap.WorldMapBean;
import ucar.nc2.ui.grid.GeoGridTable;
import ucar.nc2.ui.grid.GridUI;
import ucar.nc2.ui.image.ImageViewPanel;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.util.prefs.PreferencesExt;

public class GeoGridPanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private GeoGridTable dsTable;
    private JSplitPane split;
    private IndependentWindow viewerWindow;
    private IndependentWindow imageWindow;
    private GridUI gridUI;
    private ImageViewPanel imageViewer;
    private NetcdfDataset ds;

    public GeoGridPanel(PreferencesExt prefs) {
        super(prefs, "dataset:", true, false);
        this.dsTable = new GeoGridTable(prefs, true);
        this.add((Component)this.dsTable, "Center");
        AbstractButton viewButton = BAMutil.makeButtcon("alien", "Grid Viewer", false);
        viewButton.addActionListener(e -> {
            if (this.ds != null) {
                GridDataset gridDataset = this.dsTable.getGridDataset();
                if (this.gridUI == null) {
                    this.makeGridUI();
                }
                this.gridUI.setDataset(gridDataset);
                this.viewerWindow.show();
            }
        });
        this.buttPanel.add(viewButton);
        AbstractButton imageButton = BAMutil.makeButtcon("VCRMovieLoop", "Image Viewer", false);
        imageButton.addActionListener(e -> {
            if (this.ds != null) {
                GridDatatype grid = this.dsTable.getGrid();
                if (grid == null) {
                    return;
                }
                if (this.imageWindow == null) {
                    this.makeImageWindow();
                }
                this.imageViewer.setImageFromGrid(grid);
                this.imageWindow.show();
            }
        });
        this.buttPanel.add(imageButton);
        this.dsTable.addExtra(this.buttPanel, fileChooser);
    }

    private void makeGridUI() {
        this.viewerWindow = new IndependentWindow("Grid Viewer", BAMutil.getImage("netcdfUI"));
        this.gridUI = new GridUI((PreferencesExt)this.prefs.node("GridUI"), this.viewerWindow, fileChooser, 800);
        this.gridUI.addMapBean(new WorldMapBean());
        this.gridUI.addMapBean(new ShapeFileBean("WorldDetailMap", "Global Detailed Map", "WorldDetailMap", "/resources/nj22/ui/maps/Countries.shp"));
        this.gridUI.addMapBean(new ShapeFileBean("USDetailMap", "US Detailed Map", "USMap", "/resources/nj22/ui/maps/us_state.shp"));
        this.viewerWindow.setComponent(this.gridUI);
        Rectangle bounds = (Rectangle)ToolsUI.getPrefsBean("GridUIWindowSize", new Rectangle(77, 22, 700, 900));
        if (bounds.x < 0) {
            bounds.x = 0;
        }
        if (bounds.y < 0) {
            bounds.x = 0;
        }
        this.viewerWindow.setBounds(bounds);
    }

    private void makeImageWindow() {
        this.imageWindow = new IndependentWindow("Grid Image Viewer", BAMutil.getImage("netcdfUI"));
        this.imageViewer = new ImageViewPanel(null);
        this.imageWindow.setComponent(this.imageViewer);
        this.imageWindow.setBounds((Rectangle)ToolsUI.getPrefsBean("GridImageWindowSize", new Rectangle(77, 22, 700, 900)));
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            NetcdfDataset newds = NetcdfDataset.openDataset((String)command, (boolean)true, null);
            if (newds == null) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cannot open " + command);
                return false;
            }
            this.setDataset(newds);
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cannot open " + command + "\n" + ioe.getMessage());
            err = true;
        }
        catch (Throwable ioe) {
            ioe.printStackTrace();
            StringWriter sw = new StringWriter(5000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.ds != null) {
            this.ds.close();
        }
        this.ds = null;
        this.dsTable.clear();
        if (this.gridUI != null) {
            this.gridUI.clear();
        }
    }

    public void setDataset(NetcdfDataset newds) {
        if (newds == null) {
            return;
        }
        try {
            if (this.ds != null) {
                this.ds.close();
            }
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        Formatter parseInfo = new Formatter();
        this.ds = newds;
        try {
            this.dsTable.setDataset(newds, parseInfo);
        }
        catch (IOException e) {
            String info = parseInfo.toString();
            if (info.length() > 0) {
                this.detailTA.setText(info);
                this.detailWindow.show();
            }
            e.printStackTrace();
            return;
        }
        this.setSelectedItem(newds.getLocation());
    }

    public void setDataset(GridDataset gds) {
        if (gds == null) {
            return;
        }
        try {
            if (this.ds != null) {
                this.ds.close();
            }
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        this.ds = (NetcdfDataset)gds.getNetcdfFile();
        try {
            this.dsTable.setDataset(gds);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.setSelectedItem(gds.getLocation());
    }

    @Override
    public void save() {
        super.save();
        this.dsTable.save();
        if (this.gridUI != null) {
            this.gridUI.storePersistentData();
        }
        if (this.viewerWindow != null) {
            ToolsUI.putPrefsBeanObject("GridUIWindowSize", this.viewerWindow.getBounds());
        }
        if (this.imageWindow != null) {
            ToolsUI.putPrefsBeanObject("GridImageWindowSize", this.imageWindow.getBounds());
        }
    }
}

