/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.geotiff.GeoTiff;
import ucar.nc2.geotiff.GeotiffWriter;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class GeotiffPanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TextHistoryPane ta = new TextHistoryPane(true);

    public GeotiffPanel(PreferencesExt p) {
        super(p, "netcdf:", true, false);
        this.add((Component)this.ta, "Center");
        JButton readButton = new JButton("read geotiff");
        readButton.addActionListener(e -> {
            if (this.cb.getSelectedItem() != null) {
                String item = this.cb.getSelectedItem().toString();
                String fname = item.trim();
                this.read(fname);
            }
        });
        this.buttPanel.add(readButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Object o) {
        String filename = (String)o;
        GridDataset gridDs = null;
        try {
            gridDs = GridDataset.open((String)filename);
            List grids = gridDs.getGrids();
            if (grids.size() == 0) {
                logger.warn("No grids found.");
                boolean bl = false;
                return bl;
            }
            GridDatatype grid = (GridDatatype)grids.get(0);
            Array data = grid.readDataSlice(0, 0, -1, -1);
            String fileOut = fileChooser.chooseFilenameToSave(filename + ".tif");
            if (fileOut == null) {
                boolean bl = false;
                return bl;
            }
            GeotiffWriter writer = new GeotiffWriter(fileOut);
            writer.writeGrid((ucar.nc2.dt.GridDataset)gridDs, grid, data, false);
            this.read(fileOut);
            JOptionPane.showMessageDialog(null, "File written to " + fileOut);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (gridDs != null) {
                    gridDs.close();
                }
            }
            catch (IOException ioe) {
                logger.warn("Close failed");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String filename) {
        GeoTiff geotiff = null;
        try {
            geotiff = new GeoTiff(filename);
            geotiff.read();
            this.ta.setText(geotiff.showInfo());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (geotiff != null) {
                    geotiff.close();
                }
            }
            catch (IOException ioe) {
                logger.warn("Close failed");
            }
        }
    }

    @Override
    public void closeOpenFiles() throws IOException {
    }
}

