/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.Formatter;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.standard.PointConfigXML;
import ucar.nc2.ft.point.writer.FeatureDatasetCapabilitiesWriter;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.op.PointFeatureDatasetViewer;
import ucar.nc2.ui.widget.BAMutil;
import ucar.util.prefs.PreferencesExt;

public class PointFeaturePanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PointFeatureDatasetViewer pfViewer;
    private JSplitPane split;
    private FeatureDatasetPoint pfDataset;
    private JComboBox<FeatureType> types;

    public PointFeaturePanel(PreferencesExt dbPrefs) {
        super(dbPrefs, "dataset:", true, false);
        this.pfViewer = new PointFeatureDatasetViewer(dbPrefs, this.buttPanel);
        this.add((Component)this.pfViewer, "Center");
        this.types = new JComboBox();
        for (FeatureType ft : FeatureType.values()) {
            this.types.addItem(ft);
        }
        this.types.getModel().setSelectedItem(FeatureType.ANY_POINT);
        this.buttPanel.add(this.types);
        AbstractButton infoButton = BAMutil.makeButtcon("Information", "Dataset Info", false);
        infoButton.addActionListener(e -> {
            if (this.pfDataset == null) {
                return;
            }
            Formatter f = new Formatter();
            this.pfDataset.getDetailInfo(f);
            this.detailTA.setText(f.toString());
            this.detailTA.appendLine("-----------------------------");
            this.detailTA.appendLine(this.getCapabilities(this.pfDataset));
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(infoButton);
        AbstractButton calcButton = BAMutil.makeButtcon("V3", "Calculate the latlon/dateRange", false);
        calcButton.addActionListener(e -> {
            if (this.pfDataset == null) {
                return;
            }
            Formatter f = new Formatter();
            this.pfDataset.calcBounds(f);
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(calcButton);
        AbstractButton xmlButton = BAMutil.makeButtcon("XML", "pointConfig.xml", false);
        xmlButton.addActionListener(e -> {
            if (this.pfDataset == null) {
                return;
            }
            Formatter f = new Formatter();
            PointConfigXML.writeConfigXML((FeatureDatasetPoint)this.pfDataset, (Formatter)f);
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(xmlButton);
    }

    @Override
    public boolean process(Object o) {
        String location = (String)o;
        return this.setPointFeatureDataset((FeatureType)this.types.getSelectedItem(), location);
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.pfDataset != null) {
            this.pfDataset.close();
        }
        this.pfDataset = null;
        this.pfViewer.clear();
    }

    @Override
    public void save() {
        super.save();
        this.pfViewer.save();
    }

    public boolean setPointFeatureDataset(FeatureType type, String location) {
        if (location == null) {
            return false;
        }
        try {
            if (this.pfDataset != null) {
                this.pfDataset.close();
            }
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        this.detailTA.clear();
        Formatter log = new Formatter();
        try {
            FeatureDataset featureDataset = FeatureDatasetFactoryManager.open((FeatureType)type, (String)location, null, (Formatter)log);
            if (featureDataset == null) {
                JOptionPane.showMessageDialog(null, "Can't open " + location + ": " + log);
                return false;
            }
            if (!(featureDataset instanceof FeatureDatasetPoint)) {
                JOptionPane.showMessageDialog(null, location + " could not be opened as a PointFeatureDataset");
                return false;
            }
            this.pfDataset = (FeatureDatasetPoint)featureDataset;
            this.pfViewer.setDataset(this.pfDataset);
            this.setSelectedItem(location);
            return true;
        }
        catch (IOException e) {
            String message = e.getClass().getName() + ": " + e.getMessage();
            JOptionPane.showMessageDialog(this, message);
            return false;
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(log.toString());
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            JOptionPane.showMessageDialog(this, e.getMessage());
            return false;
        }
    }

    public boolean setPointFeatureDataset(FeatureDatasetPoint pfd) {
        try {
            if (this.pfDataset != null) {
                this.pfDataset.close();
            }
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        this.detailTA.clear();
        try {
            this.pfDataset = pfd;
            this.pfViewer.setDataset(this.pfDataset);
            this.setSelectedItem(this.pfDataset.getLocation());
            return true;
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            JOptionPane.showMessageDialog(this, e.getMessage());
            return false;
        }
    }

    private String getCapabilities(FeatureDatasetPoint fdp) {
        FeatureDatasetCapabilitiesWriter xmlWriter = new FeatureDatasetCapabilitiesWriter(fdp, null);
        return xmlWriter.getCapabilities();
    }
}

