/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.table;

import java.util.ArrayList;
import ucar.nc2.ui.table.JTreeTableSorted;
import ucar.nc2.ui.table.RowSorter;
import ucar.nc2.ui.table.TableRow;
import ucar.nc2.ui.table.TableRowAbstract;
import ucar.nc2.ui.table.TreeTableModelSorted;
import ucar.util.prefs.PreferencesExt;

public abstract class RowSorterAbstract
implements RowSorter {
    protected String[] columnNames;
    protected int ncolumns;
    protected TreeTableModelSorted model;
    protected JTreeTableSorted table;
    protected ArrayList rowList = new ArrayList();
    private int startSort = 0;
    protected int[] sortNext;
    private int[] sortBreak;
    private boolean debug = false;
    private PreferencesExt store;

    protected RowSorterAbstract(String[] colNames) {
        int i;
        this.columnNames = colNames;
        this.ncolumns = this.columnNames.length;
        this.sortNext = new int[this.ncolumns];
        for (i = 0; i < this.ncolumns - 1; ++i) {
            this.sortNext[i] = i + 1;
        }
        this.sortNext[this.ncolumns - 1] = -1;
        this.sortBreak = new int[this.ncolumns];
        for (i = 0; i < this.ncolumns; ++i) {
            this.sortBreak[i] = -1;
        }
        this.model = new TreeTableModelSorted(this.columnNames, this.rowList);
        this.model.setSorter(this);
        this.table = new JTreeTableSorted(this.model, true);
    }

    public void restoreState(PreferencesExt store) {
        this.store = store;
        this.table.restoreState(store);
    }

    public void saveState() {
        this.table.saveState(this.store);
    }

    public JTreeTableSorted getComponent() {
        return this.table;
    }

    public TreeTableModelSorted getModel() {
        return this.table.getModel();
    }

    protected void setRows(ArrayList list) {
        this.rowList = list;
        this.table.setRows(list);
    }

    @Override
    public ArrayList sort(int sortCol, boolean reverse, ArrayList docs) {
        this.setupSort(sortCol, reverse);
        if (this.startSort < 0) {
            return docs;
        }
        docs.sort(new TableRowAbstract.Sorter(this.startSort, false));
        return docs;
    }

    @Override
    public boolean isBreak(TableRow last, TableRow current) {
        TableRow lastRow = last;
        TableRow currentRow = current;
        currentRow.setNextSort(this.sortBreak);
        int ret = currentRow.compare(lastRow, this.startSort);
        currentRow.setNextSort(this.sortNext);
        return 0 != ret;
    }

    private void setupSort(int sortCol, boolean reverse) {
        int i;
        int[] col2Model = this.table.getModelIndex();
        if (this.debug) {
            System.out.println("RowSorter sort ");
            System.out.print(" col->model = ");
            for (int i1 : col2Model) {
                System.out.print(" " + i1);
            }
            System.out.println();
        }
        for (int i2 = 0; i2 < this.ncolumns; ++i2) {
            this.sortNext[i2] = -1;
        }
        int next = this.startSort = col2Model[0];
        for (i = 1; i < col2Model.length; ++i) {
            this.sortNext[next] = col2Model[i];
            next = col2Model[i];
        }
        if (this.debug) {
            System.out.print(" sortNext (" + this.startSort + ") = ");
            for (i = 0; i < this.ncolumns; ++i) {
                System.out.print(" " + this.sortNext[i]);
            }
            System.out.println();
        }
        if (this.ncolumns >= 0) {
            System.arraycopy(this.sortNext, 0, this.sortBreak, 0, this.ncolumns);
        }
        this.sortBreak[sortCol] = -1;
        if (this.debug) {
            System.out.print(" sortBreak = ");
            for (i = 0; i < this.ncolumns; ++i) {
                System.out.print(" " + this.sortBreak[i]);
            }
            System.out.println();
        }
    }
}

