/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import ucar.nc2.ui.util.ScreenUtils;
import ucar.util.prefs.ui.PrefPanel;

public class IndependentDialog
extends JDialog {
    protected JFrame parent;

    public IndependentDialog(JFrame parent, boolean modal, String title) {
        super(parent == null ? PrefPanel.findActiveFrame() : parent);
        this.parent = parent;
        this.setModal(modal);
        if (title != null) {
            this.setTitle(title);
        }
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("lookAndFeel")) {
                    SwingUtilities.updateComponentTreeUI(IndependentDialog.this);
                }
            }
        });
        Window owner = this.getOwner();
        if (owner != null) {
            Rectangle b = owner.getBounds();
            int x = (int)(b.getX() + b.getWidth() / 2.0);
            int y = (int)(b.getY() + b.getHeight() / 2.0);
            this.setLocation(x, y);
        }
    }

    public IndependentDialog(JFrame parent, boolean modal, String title, Component comp) {
        this(parent, modal, title);
        this.setComponent(comp);
    }

    public void setComponent(Component comp) {
        Container cp = this.getContentPane();
        cp.add(comp, "Center");
        this.pack();
    }

    @Override
    public void setBounds(Rectangle r) {
        Rectangle screenSize = ScreenUtils.getScreenVirtualSize();
        Rectangle result = r.intersection(screenSize);
        if (!result.isEmpty()) {
            super.setBounds(result);
        }
    }
}

