/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PLAF {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private JComponent jc;
    private boolean debug = false;

    public PLAF(JComponent jc) {
        this.jc = jc;
    }

    public void addToMenu(JMenu menu) {
        UIManager.LookAndFeelInfo[] plafInfo;
        for (UIManager.LookAndFeelInfo aPlafInfo : plafInfo = UIManager.getInstalledLookAndFeels()) {
            this.addToMenu(aPlafInfo.getName(), aPlafInfo.getClassName(), menu);
        }
        LookAndFeel current = UIManager.getLookAndFeel();
        System.out.printf("current L&F=%s%n", current.getName());
    }

    private void addToMenu(String name, String className, JMenu menu) {
        logger.debug("PLAF LookAndFeelInfo  {}", (Object)className);
        boolean isSupported = true;
        try {
            Class<?> cl = Class.forName(className);
            LookAndFeel lf = (LookAndFeel)cl.newInstance();
            if (!lf.isSupportedLookAndFeel()) {
                isSupported = false;
            }
        }
        catch (Throwable t) {
            isSupported = false;
        }
        PLAFAction act = new PLAFAction(name, className);
        JMenuItem mi = menu.add(act);
        if (!isSupported) {
            mi.setEnabled(false);
        }
    }

    private class PLAFAction
    extends AbstractAction {
        final String plafClassName;

        PLAFAction(String name, String plafClassName) {
            this.plafClassName = plafClassName;
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                UIManager.setLookAndFeel(this.plafClassName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            JFrame parentFrame = (JFrame)PLAF.this.jc.getTopLevelAncestor();
            SwingUtilities.updateComponentTreeUI(parentFrame);
        }
    }
}

