/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.monitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class MultipleAxisChart
extends JPanel {
    JFreeChart chart;
    private int axisNum = 1;
    private static final Color[] colors = new Color[]{Color.black, Color.red, Color.blue, Color.green};

    public MultipleAxisChart(String title1, String xaxis1, String yaxis1, TimeSeries series1) {
        TimeSeriesCollection dataset1 = new TimeSeriesCollection();
        dataset1.addSeries(series1);
        this.chart = ChartFactory.createTimeSeriesChart((String)title1, (String)xaxis1, (String)yaxis1, (XYDataset)dataset1, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setOrientation(PlotOrientation.VERTICAL);
        this.setLayout(new BorderLayout());
        this.add((Component)new ChartPanel(this.chart), "Center");
    }

    public void addSeries(String yaxisName, TimeSeries series) {
        NumberAxis axis2 = new NumberAxis(yaxisName);
        axis2.setAutoRangeIncludesZero(false);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setRangeAxis(this.axisNum, (ValueAxis)axis2);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_LEFT);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        plot.setDataset(this.axisNum, (XYDataset)dataset);
        plot.mapDatasetToRangeAxis(this.axisNum, this.axisNum);
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        plot.setRenderer(this.axisNum, (XYItemRenderer)renderer2);
        ++this.axisNum;
    }

    public void finish(Dimension preferredSize) {
        ChartUtilities.applyCurrentTheme((JFreeChart)this.chart);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        for (int i = 0; i < this.axisNum; ++i) {
            XYItemRenderer renderer = plot.getRenderer(i);
            if (renderer == null) continue;
            renderer.setSeriesPaint(0, (Paint)colors[i]);
            ValueAxis axis = plot.getRangeAxis(i);
            axis.setLabelPaint((Paint)colors[i]);
            axis.setTickLabelPaint((Paint)colors[i]);
        }
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(preferredSize);
        chartPanel.setDomainZoomable(true);
        chartPanel.setRangeZoomable(true);
    }
}

