/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.Formatter;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.RootPaneContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageDatasetFactory;
import ucar.nc2.ft2.coverage.FeatureDatasetCoverage;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.ui.coverage2.CoverageTable;
import ucar.nc2.ui.coverage2.CoverageViewer;
import ucar.nc2.ui.gis.shapefile.ShapeFileBean;
import ucar.nc2.ui.gis.worldmap.WorldMapBean;
import ucar.nc2.util.Optional;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.util.prefs.PreferencesExt;

public class CoveragePanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private CoverageTable dsTable;
    private CoverageViewer display;
    private JSplitPane split;
    private IndependentWindow viewerWindow;
    private FeatureDatasetCoverage covDatasetCollection;

    public CoveragePanel(PreferencesExt prefs) {
        super(prefs, "dataset:", true, false);
        this.dsTable = new CoverageTable(this.buttPanel, prefs);
        this.add((Component)this.dsTable, "Center");
        AbstractButton viewButton = BAMutil.makeButtcon((String)"alien", (String)"Grid Viewer", (boolean)false);
        viewButton.addActionListener(e -> {
            CoverageCollection gridDataset = this.dsTable.getCoverageDataset();
            if (gridDataset == null) {
                return;
            }
            if (this.display == null) {
                this.makeDisplay();
            }
            this.display.setDataset(this.dsTable);
            this.viewerWindow.show();
        });
        this.buttPanel.add(viewButton);
        AbstractButton infoButton = BAMutil.makeButtcon((String)"Information", (String)"Show Info", (boolean)false);
        infoButton.addActionListener(e -> {
            Formatter f = new Formatter();
            this.dsTable.showInfo(f);
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(infoButton);
    }

    private void makeDisplay() {
        this.viewerWindow = new IndependentWindow("Coverage Viewer", BAMutil.getImage((String)"nj22/NetcdfUI"));
        this.display = new CoverageViewer((PreferencesExt)this.prefs.node("CoverageDisplay"), (RootPaneContainer)this.viewerWindow, fileChooser, 800);
        this.display.addMapBean(new WorldMapBean());
        this.display.addMapBean(new ShapeFileBean("WorldDetailMap", "Global Detailed Map", "nj22/WorldDetailMap", "/resources/ui/maps/Countries.shp"));
        this.display.addMapBean(new ShapeFileBean("USDetailMap", "US Detailed Map", "nj22/USMap", "/resources/ui/maps/us_state.shp"));
        this.viewerWindow.setComponent((Component)this.display);
        Rectangle bounds = (Rectangle)ToolsUI.getPrefsBean("GridUIWindowSize", new Rectangle(77, 22, 700, 900));
        if (bounds.x < 0) {
            bounds.x = 0;
        }
        if (bounds.y < 0) {
            bounds.x = 0;
        }
        this.viewerWindow.setBounds(bounds);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            this.closeOpenFiles();
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        try {
            Optional opt = CoverageDatasetFactory.openCoverageDataset((String)command);
            if (!opt.isPresent()) {
                JOptionPane.showMessageDialog(null, opt.getErrorMessage());
                return false;
            }
            this.covDatasetCollection = (FeatureDatasetCoverage)opt.get();
            if (this.covDatasetCollection == null) {
                return false;
            }
            this.dsTable.setCollection(this.covDatasetCollection);
            this.setSelectedItem(command);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, String.format("CdmrFeatureDataset2.open cant open %s err=%s", command, e.getMessage()));
        }
        catch (Throwable ioe) {
            ioe.printStackTrace();
            StringWriter sw = new StringWriter(5000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    public void setDataset(FeatureDataset fd) {
        if (fd == null) {
            return;
        }
        if (!(fd instanceof FeatureDatasetCoverage)) {
            return;
        }
        try {
            this.closeOpenFiles();
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        this.dsTable.setCollection((FeatureDatasetCoverage)fd);
        this.setSelectedItem(fd.getLocation());
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.covDatasetCollection != null) {
            this.covDatasetCollection.close();
        }
        this.covDatasetCollection = null;
        this.dsTable.clear();
    }

    @Override
    public void save() {
        super.save();
        this.dsTable.save();
        if (this.viewerWindow != null) {
            ToolsUI.putPrefsBeanObject("GridUIWindowSize", this.viewerWindow.getBounds());
        }
    }
}

