/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.datatype.prefs;

import java.awt.Component;
import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.text.JTextComponent;
import ucar.nc2.units.DateType;
import ucar.ui.prefs.Field;
import ucar.ui.prefs.FldInputVerifier;
import ucar.ui.widget.MultilineTooltip;
import ucar.util.prefs.PersistenceManager;

public class DateField
extends Field {
    protected JTextComponent tf;

    public DateField(String name, String label, DateType defValue, PersistenceManager storeData) {
        super(name, label, storeData);
        this.validValue = this.getStoreValue(defValue);
        this.tf = new JTextField(){

            @Override
            public JToolTip createToolTip() {
                return new MultilineTooltip();
            }
        };
        this.tf.setToolTipText("Formats:\n 'present'\n CCYY-MM-DD\n CCYY-MM-DDThh:mm:ss\n udunits date string");
        this.tf.setInputVerifier((InputVerifier)new FldInputVerifier((Component)this.tf, (Field)this));
        if (this.validValue != null) {
            this.tf.setText(this.validValue.toString());
        }
        this.finish();
    }

    public JComponent getEditComponent() {
        return this.tf;
    }

    protected boolean _validate(StringBuffer buff) {
        try {
            new DateType(this.tf.getText(), null, null);
            return true;
        }
        catch (ParseException e) {
            if (null != buff) {
                buff.append(this.name).append(": ").append(e.getMessage());
            }
            return false;
        }
    }

    protected Object getEditValue() {
        try {
            return new DateType(this.tf.getText(), null, null);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public DateType getDate() {
        return (DateType)this.getValue();
    }

    protected void setEditValue(Object value) {
        if (value == null) {
            this.tf.setText("");
        } else {
            this.tf.setText(value.toString());
        }
    }

    protected void setStoreValue(Object value) {
        if (this.storeData != null && value != null) {
            this.storeData.putObject(this.name, (Object)new DateType((DateType)value));
        }
    }

    protected Object getStoreValue(Object defValue) {
        Object value2;
        Object value = defValue;
        if (this.storeData != null && (value2 = this.storeData.getObject(this.name)) != null) {
            value = value2;
        }
        if (value == null) {
            return null;
        }
        return new DateType((DateType)value);
    }
}

