/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.dialog;

import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import ucar.nc2.grib.grib1.tables.Grib1ParamTableReader;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;

public class Grib1TableDialog
extends JDialog {
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel label1;
    private JTextField center;
    private JLabel label2;
    private JLabel label3;
    private JTextField subcenter;
    private JTextField version;
    private JLabel label4;
    private JTextField result;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;
    private OkAction action1;
    private cancelAction action2;

    public Grib1TableDialog(Frame owner) {
        super(owner);
        this.initComponents();
    }

    public Grib1TableDialog(Dialog owner) {
        super(owner);
        this.initComponents();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.label1 = new JLabel();
        this.center = new JTextField();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.subcenter = new JTextField();
        this.version = new JTextField();
        this.label4 = new JLabel();
        this.result = new JTextField();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.action1 = new OkAction();
        this.action2 = new cancelAction();
        this.setTitle("Get Grib1 Table Used");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG_BORDER);
        this.dialogPane.setLayout(new BorderLayout());
        this.label1.setText("center:");
        this.label1.setHorizontalAlignment(4);
        this.center.setText("7");
        this.label2.setText("sub-center:");
        this.label2.setHorizontalAlignment(4);
        this.label3.setText("table version:");
        this.label3.setHorizontalAlignment(4);
        this.subcenter.setText("4");
        this.version.setText("128");
        this.label4.setText("Table Used:");
        GroupLayout contentPanelLayout = new GroupLayout(this.contentPanel);
        this.contentPanel.setLayout(contentPanelLayout);
        contentPanelLayout.setHorizontalGroup(contentPanelLayout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, contentPanelLayout.createSequentialGroup().addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, contentPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.label4).addGap(18, 18, 18).addComponent(this.result, -1, 279, Short.MAX_VALUE)).addGroup(contentPanelLayout.createSequentialGroup().addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.label3, GroupLayout.Alignment.LEADING, -1, 182, Short.MAX_VALUE).addComponent(this.label2, GroupLayout.Alignment.LEADING, -1, 182, Short.MAX_VALUE).addComponent(this.label1, GroupLayout.Alignment.LEADING, -1, 182, Short.MAX_VALUE)).addGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(contentPanelLayout.createParallelGroup().addComponent(this.version, -1, 170, Short.MAX_VALUE).addComponent(this.subcenter, -1, 170, Short.MAX_VALUE))).addGroup(contentPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.center, -1, 170, Short.MAX_VALUE))))).addContainerGap()));
        contentPanelLayout.setVerticalGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.center, -2, -1, -2).addComponent(this.label1)).addGap(9, 9, 9).addGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addComponent(this.label2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label3, -2, 20, -2)).addGroup(contentPanelLayout.createSequentialGroup().addComponent(this.subcenter, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.version, -2, -1, -2))).addGap(42, 42, 42).addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.result, -2, -1, -2).addComponent(this.label4)).addContainerGap(117, Short.MAX_VALUE)));
        this.dialogPane.add((Component)this.contentPanel, "East");
        this.buttonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.okButton.setAction(this.action1);
        this.cancelButton.setAction(this.action2);
        GroupLayout buttonBarLayout = new GroupLayout(this.buttonBar);
        this.buttonBar.setLayout(buttonBarLayout);
        buttonBarLayout.setHorizontalGroup(buttonBarLayout.createParallelGroup().addGroup(buttonBarLayout.createSequentialGroup().addGap(214, 214, 214).addComponent(this.okButton, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 75, -2).addContainerGap()));
        buttonBarLayout.setVerticalGroup(buttonBarLayout.createParallelGroup().addComponent(this.okButton).addGroup(buttonBarLayout.createSequentialGroup().addComponent(this.cancelButton, -1, 19, Short.MAX_VALUE).addContainerGap()));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class cancelAction
    extends AbstractAction {
        private cancelAction() {
            this.putValue("Name", "Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Grib1TableDialog.this.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        private OkAction() {
            this.putValue("Name", "OK");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int center_id = Integer.parseInt(Grib1TableDialog.this.center.getText());
                int subcenter_id = Integer.parseInt(Grib1TableDialog.this.subcenter.getText());
                int version_id = Integer.parseInt(Grib1TableDialog.this.version.getText());
                Grib1ParamTableReader t = new Grib1ParamTables().getParameterTable(center_id, subcenter_id, version_id);
                if (t == null) {
                    Grib1TableDialog.this.result.setText("NOT FOUND");
                } else {
                    Grib1TableDialog.this.result.setText(t.getCenter_id() + " " + t.getSubcenter_id() + " " + t.getVersion() + ": " + t.getPath());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

