/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import com.google.common.collect.ImmutableList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.coord.TimeCoordIntvDateValue;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.grib.grib2.Grib2Show;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.Grib2Variable;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.Misc;
import ucar.nc2.write.Ncdump;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class Grib2CollectionPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(Grib2CollectionPanel.class);
    private final PreferencesExt prefs;
    private BeanTable param2BeanTable;
    private BeanTable record2BeanTable;
    private BeanTable gds2Table;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoPopup;
    private TextHistoryPane infoPopup2;
    private TextHistoryPane infoPopup3;
    private IndependentWindow infoWindow;
    private IndependentWindow infoWindow2;
    private IndependentWindow infoWindow3;
    private FileManager fileChooser;
    private String spec;
    private MCollection dcm;
    private List<MFile> fileList;
    private Grib2Tables cust;

    public Grib2CollectionPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        AbstractButton xmlButt = BAMutil.makeButtcon((String)"Information", (String)"generate gds xml", (boolean)false);
        xmlButt.addActionListener(e -> {
            Formatter f = new Formatter();
            this.generateGdsXml(f);
            this.infoPopup2.setText(f.toString());
            this.infoPopup2.gotoTop();
            this.infoWindow2.show();
        });
        buttPanel.add(xmlButt);
        this.param2BeanTable = new BeanTable(Grib2ParameterBean.class, (PreferencesExt)prefs.node("Param2Bean"), false, "Grib2PDSVariables", "from Grib2Input.getRecords()", null);
        this.param2BeanTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Grib2ParameterBean pb = (Grib2ParameterBean)Grib2CollectionPanel.this.param2BeanTable.getSelectedBean();
                if (pb != null) {
                    Grib2CollectionPanel.this.makeRecordTable(pb.pds);
                    Grib2CollectionPanel.this.record2BeanTable.setBeans(pb.getRecordBeans());
                }
            }
        });
        PopupMenu varPopup = new PopupMenu((JComponent)this.param2BeanTable.getJTable(), "Options");
        varPopup.addAction("Show PDS", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2ParameterBean pb = (Grib2ParameterBean)Grib2CollectionPanel.this.param2BeanTable.getSelectedBean();
                if (pb != null) {
                    Formatter f = new Formatter();
                    Grib2Show.showPdsTemplate((Grib2SectionProductDefinition)pb.gr.getPDSsection(), (Formatter)f, (Grib2Tables)Grib2CollectionPanel.this.cust);
                    Grib2CollectionPanel.this.infoPopup2.setText(f.toString());
                    Grib2CollectionPanel.this.infoPopup2.gotoTop();
                    Grib2CollectionPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show processed PDS", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2ParameterBean pb = (Grib2ParameterBean)Grib2CollectionPanel.this.param2BeanTable.getSelectedBean();
                if (pb != null) {
                    Grib2CollectionPanel.this.infoPopup3.setText(pb.toProcessedString());
                    Grib2CollectionPanel.this.infoPopup3.gotoTop();
                    Grib2CollectionPanel.this.infoWindow3.show();
                }
            }
        });
        varPopup.addAction("Compare PDS", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib2CollectionPanel.this.param2BeanTable.getSelectedBeans();
                if (list.size() == 2) {
                    Grib2ParameterBean bean1 = (Grib2ParameterBean)list.get(0);
                    Grib2ParameterBean bean2 = (Grib2ParameterBean)list.get(1);
                    Formatter f = new Formatter();
                    Grib2CollectionPanel.compare(bean1.gr.getPDSsection(), bean2.gr.getPDSsection(), f);
                    Grib2CollectionPanel.this.infoPopup2.setText(f.toString());
                    Grib2CollectionPanel.this.infoPopup2.gotoTop();
                    Grib2CollectionPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Extract GribRecords to File", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<Grib2RecordBean> allRecords = new ArrayList<Grib2RecordBean>();
                List list = Grib2CollectionPanel.this.param2BeanTable.getSelectedBeans();
                for (Object bean : list) {
                    Grib2ParameterBean param = (Grib2ParameterBean)bean;
                    allRecords.addAll(param.records);
                }
                if (!allRecords.isEmpty()) {
                    Grib2CollectionPanel.this.writeToFile(allRecords);
                }
            }
        });
        Class<Grib2RecordBean> useClass = Grib2RecordBean.class;
        this.record2BeanTable = new BeanTable(useClass, (PreferencesExt)prefs.node(useClass.getName()), false, useClass.getName(), "from Grib2Input.getRecords()", null);
        this.gds2Table = new BeanTable(Gds2Bean.class, (PreferencesExt)prefs.node("Gds2Bean"), false, "Grib2GridDefinitionSection", "unique from Grib2Records", null);
        varPopup = new PopupMenu((JComponent)this.gds2Table.getJTable(), "Options");
        varPopup.addAction("Show GDS", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                for (Object o : Grib2CollectionPanel.this.gds2Table.getSelectedBeans()) {
                    Gds2Bean bean = (Gds2Bean)o;
                    Grib2Gds ggds = bean.gdss.getGDS();
                    f.format("GDS hash=%d crc=%d%n", ggds.hashCode(), bean.gdss.calcCRC());
                    Grib2Show.showGdsTemplate((Grib2SectionGridDefinition)bean.gdss, (Formatter)f, (Grib2Tables)Grib2CollectionPanel.this.cust);
                }
                Grib2CollectionPanel.this.infoPopup2.setText(f.toString());
                Grib2CollectionPanel.this.infoPopup2.gotoTop();
                Grib2CollectionPanel.this.infoWindow2.show();
            }
        });
        varPopup.addAction("Compare GDS", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib2CollectionPanel.this.gds2Table.getSelectedBeans();
                if (list.size() == 2) {
                    Gds2Bean bean1 = (Gds2Bean)list.get(0);
                    Gds2Bean bean2 = (Gds2Bean)list.get(1);
                    Formatter f = new Formatter();
                    Grib2CollectionPanel.compare(bean1.gdss, bean2.gdss, f);
                    Grib2CollectionPanel.this.infoPopup3.setText(f.toString());
                    Grib2CollectionPanel.this.infoPopup3.gotoTop();
                    Grib2CollectionPanel.this.infoWindow3.show();
                }
            }
        });
        varPopup.addAction("Show raw GDS bytes", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                List list = Grib2CollectionPanel.this.gds2Table.getSelectedBeans();
                for (Object aList : list) {
                    Gds2Bean bean = (Gds2Bean)aList;
                    bean.toRawGdsString(f);
                }
                Grib2CollectionPanel.this.infoPopup.setText(f.toString());
                Grib2CollectionPanel.this.infoPopup.gotoTop();
                Grib2CollectionPanel.this.infoWindow.show();
            }
        });
        varPopup.addAction("Show Files that use this GDS", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gds2Bean want = (Gds2Bean)Grib2CollectionPanel.this.gds2Table.getSelectedBean();
                if (want == null) {
                    return;
                }
                TreeSet<Integer> files = new TreeSet<Integer>();
                for (Object o : Grib2CollectionPanel.this.param2BeanTable.getBeans()) {
                    Grib2ParameterBean p = (Grib2ParameterBean)o;
                    if (p.getGDS() != want.getGDShash()) continue;
                    for (Grib2RecordBean r : p.getRecordBeans()) {
                        files.add(r.gr.getFile());
                    }
                }
                Formatter f = new Formatter();
                for (Integer fileno : files) {
                    f.format(" %d = %s%n", fileno, ((MFile)Grib2CollectionPanel.this.fileList.get(fileno)).getPath());
                }
                Grib2CollectionPanel.this.infoPopup2.setText(f.toString());
                Grib2CollectionPanel.this.infoPopup2.gotoTop();
                Grib2CollectionPanel.this.infoWindow2.show();
            }
        });
        varPopup.addAction("Restrict to this GDS", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gds2Bean want = (Gds2Bean)Grib2CollectionPanel.this.gds2Table.getSelectedBean();
                if (want == null) {
                    return;
                }
                ArrayList<Grib2ParameterBean> params = new ArrayList<Grib2ParameterBean>();
                for (Object o : Grib2CollectionPanel.this.param2BeanTable.getBeans()) {
                    Grib2ParameterBean p = (Grib2ParameterBean)o;
                    if (p.getGDS() != want.getGDShash()) continue;
                    params.add(p);
                }
                Grib2CollectionPanel.this.param2BeanTable.setBeans(params);
            }
        });
        varPopup.addAction("Test GDS Projection", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gds2Bean bean = (Gds2Bean)Grib2CollectionPanel.this.gds2Table.getSelectedBean();
                if (bean == null) {
                    return;
                }
                Formatter f = new Formatter();
                bean.gds.testHorizCoordSys(f);
                Grib2CollectionPanel.this.infoPopup2.setText(f.toString());
                Grib2CollectionPanel.this.infoPopup2.gotoTop();
                Grib2CollectionPanel.this.infoWindow2.show();
            }
        });
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.infoPopup2 = new TextHistoryPane();
        this.infoWindow2 = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoPopup2);
        this.infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", (Object)new Rectangle(300, 300, 500, 300)));
        this.infoPopup3 = new TextHistoryPane();
        this.infoWindow3 = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoPopup3);
        this.infoWindow3.setBounds((Rectangle)prefs.getBean("InfoWindowBounds3", (Object)new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split2 = new JSplitPane(0, false, (Component)this.param2BeanTable, (Component)this.record2BeanTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.split2, (Component)this.gds2Table);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.add((Component)this.split, "Center");
    }

    void makeRecordTable(Grib2Pds pds) {
        if (this.record2BeanTable != null) {
            this.record2BeanTable.saveState(false);
        }
        PdsBeanInfo info = new PdsBeanInfo(pds);
        String prefsName = pds.getClass().getName();
        this.record2BeanTable = new BeanTable(Grib2RecordBean.class, (PreferencesExt)this.prefs.node(prefsName), prefsName, "from Grib2Input.getRecords()", (BeanInfo)info);
        PopupMenu varPopup = new PopupMenu((JComponent)this.record2BeanTable.getJTable(), "Options");
        varPopup.addAction("Show complete GridRecord", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2RecordBean bean = (Grib2RecordBean)Grib2CollectionPanel.this.record2BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib2Show.showCompleteGribRecord((Formatter)f, (String)((MFile)Grib2CollectionPanel.this.fileList.get(bean.gr.getFile())).getPath(), (Grib2Record)bean.gr, (Grib2Tables)Grib2CollectionPanel.this.cust);
                    Grib2CollectionPanel.this.infoPopup.setText(f.toString());
                    Grib2CollectionPanel.this.infoPopup.gotoTop();
                    Grib2CollectionPanel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Show Processed GridRecord", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib2CollectionPanel.this.record2BeanTable.getSelectedBeans();
                Formatter f = new Formatter();
                for (Object o : list) {
                    Grib2RecordBean bean = (Grib2RecordBean)o;
                    bean.showProcessedGridRecord(f);
                }
                Grib2CollectionPanel.this.infoPopup2.setText(f.toString());
                Grib2CollectionPanel.this.infoPopup2.gotoTop();
                Grib2CollectionPanel.this.infoWindow2.show();
            }
        });
        varPopup.addAction("Compare GridRecord", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib2CollectionPanel.this.record2BeanTable.getSelectedBeans();
                if (list.size() == 2) {
                    Grib2RecordBean bean1 = (Grib2RecordBean)list.get(0);
                    Grib2RecordBean bean2 = (Grib2RecordBean)list.get(1);
                    Formatter f = new Formatter();
                    Grib2CollectionPanel.this.compare(bean1, bean2, f);
                    Grib2CollectionPanel.this.infoPopup2.setText(f.toString());
                    Grib2CollectionPanel.this.infoPopup2.gotoTop();
                    Grib2CollectionPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show raw PDS bytes", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                List list = Grib2CollectionPanel.this.record2BeanTable.getSelectedBeans();
                for (Object aList : list) {
                    Grib2RecordBean bean = (Grib2RecordBean)aList;
                    bean.toRawPdsString(f);
                }
                Grib2CollectionPanel.this.infoPopup.setText(f.toString());
                Grib2CollectionPanel.this.infoPopup.gotoTop();
                Grib2CollectionPanel.this.infoWindow.show();
            }
        });
        varPopup.addAction("Show raw Local Use Section bytes", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                List list = Grib2CollectionPanel.this.record2BeanTable.getSelectedBeans();
                for (Object aList : list) {
                    Grib2RecordBean bean = (Grib2RecordBean)aList;
                    bean.toRawLUString(f);
                }
                Grib2CollectionPanel.this.infoPopup.setText(f.toString());
                Grib2CollectionPanel.this.infoPopup.gotoTop();
                Grib2CollectionPanel.this.infoWindow.show();
            }
        });
        varPopup.addAction("Compare Data", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib2CollectionPanel.this.record2BeanTable.getSelectedBeans();
                if (list.size() == 2) {
                    Grib2RecordBean bean1 = (Grib2RecordBean)list.get(0);
                    Grib2RecordBean bean2 = (Grib2RecordBean)list.get(1);
                    Formatter f = new Formatter();
                    Grib2CollectionPanel.compareData(bean1, bean2, f);
                    Grib2CollectionPanel.this.infoPopup2.setText(f.toString());
                    Grib2CollectionPanel.this.infoPopup2.gotoTop();
                    Grib2CollectionPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show Data", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2RecordBean bean = (Grib2RecordBean)Grib2CollectionPanel.this.record2BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib2CollectionPanel.showData(bean, f);
                    Grib2CollectionPanel.this.infoPopup2.setText(f.toString());
                    Grib2CollectionPanel.this.infoPopup2.gotoTop();
                    Grib2CollectionPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Extract GribRecord to File", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = Grib2CollectionPanel.this.record2BeanTable.getSelectedBeans();
                if (!beans.isEmpty()) {
                    Grib2CollectionPanel.this.writeToFile(beans);
                }
            }
        });
        varPopup.addAction("Consistency checks on GribRecord", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2RecordBean bean = (Grib2RecordBean)Grib2CollectionPanel.this.record2BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib2CollectionPanel.this.check(bean, f);
                    Grib2CollectionPanel.this.infoPopup2.setText(f.toString());
                    Grib2CollectionPanel.this.infoPopup2.gotoTop();
                    Grib2CollectionPanel.this.infoWindow2.show();
                }
            }
        });
        if (this.split2 != null) {
            int d = this.split2.getDividerLocation();
            this.split2.setRightComponent((Component)this.record2BeanTable);
            this.split2.setDividerLocation(d);
        }
    }

    public void save() {
        this.gds2Table.saveState(false);
        this.param2BeanTable.saveState(false);
        this.record2BeanTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putBeanObject("InfoWindowBounds2", (Object)this.infoWindow2.getBounds());
        this.prefs.putBeanObject("InfoWindowBounds3", (Object)this.infoWindow3.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
    }

    public void closeOpenFiles() throws IOException {
        this.param2BeanTable.clearBeans();
        this.record2BeanTable.clearBeans();
        this.gds2Table.clearBeans();
    }

    public void generateGdsXml(Formatter f) {
        f.format("<gribConfig>%n", new Object[0]);
        ArrayList<Object> gdss = new ArrayList<Object>(this.gds2Table.getBeans());
        gdss.sort(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int h1 = ((Gds2Bean)o1).gds.hashCode();
                int h2 = ((Gds2Bean)o2).gds.hashCode();
                return Integer.compare(h1, h2);
            }
        });
        for (Object e : gdss) {
            Gds2Bean gbean = (Gds2Bean)e;
            f.format("  <gdsName hash='%d' groupName='%s'/>%n", gbean.gds.hashCode(), gbean.getGroupName());
        }
        f.format("</gribConfig>%n", new Object[0]);
    }

    public void setCollection(String spec) throws IOException {
        this.closeOpenFiles();
        this.spec = spec;
        this.cust = null;
        Formatter f = new Formatter();
        this.dcm = this.getCollection(spec, f);
        if (this.dcm == null) {
            JOptionPane.showMessageDialog(this, "Collection is null\n" + f);
            return;
        }
        HashMap<Grib2Variable, Grib2ParameterBean> pdsSet = new HashMap<Grib2Variable, Grib2ParameterBean>();
        HashMap<Integer, Grib2SectionGridDefinition> gdsSet = new HashMap<Integer, Grib2SectionGridDefinition>();
        ArrayList<Grib2ParameterBean> params = new ArrayList<Grib2ParameterBean>();
        ArrayList<Gds2Bean> gdsList = new ArrayList<Gds2Bean>();
        int fileno = 0;
        for (MFile mfile : this.fileList) {
            f.format("%n %s%n", mfile.getPath());
            this.processGribFile(mfile, fileno++, pdsSet, gdsSet, params, f);
        }
        this.param2BeanTable.setBeans(params);
        for (Grib2SectionGridDefinition gds : gdsSet.values()) {
            gdsList.add(new Gds2Bean(gds));
        }
        Collections.sort(gdsList);
        this.gds2Table.setBeans(gdsList);
    }

    private void processGribFile(MFile mfile, int fileno, Map<Grib2Variable, Grib2ParameterBean> pdsSet, Map<Integer, Grib2SectionGridDefinition> gdsSet, List<Grib2ParameterBean> params, Formatter f) throws IOException {
        Grib2Index index = new Grib2Index();
        if (!index.readIndex(mfile.getPath(), mfile.getLastModified())) {
            index.makeIndex(mfile.getPath(), null);
        }
        for (Grib2SectionGridDefinition gds : index.getGds()) {
            int hash = gds.getGDS().hashCode();
            gdsSet.putIfAbsent(hash, gds);
        }
        for (Grib2Record gr : index.getRecords()) {
            Grib2Variable gv;
            Grib2ParameterBean bean;
            gr.setFile(fileno);
            if (this.cust == null) {
                this.cust = Grib2Tables.factory((Grib2Record)gr);
            }
            if ((bean = pdsSet.get(gv = new Grib2Variable(this.cust, gr, 0, FeatureCollectionConfig.intvMergeDef, FeatureCollectionConfig.useGenTypeDef))) == null) {
                bean = new Grib2ParameterBean(gr, gv);
                pdsSet.put(gv, bean);
                params.add(bean);
            }
            bean.addRecord(gr);
        }
    }

    private MCollection getCollection(String spec, Formatter f) {
        MCollection dc = null;
        try {
            dc = CollectionAbstract.open((String)"Grib2Collection", (String)spec, null, (Formatter)f);
            this.fileList = ImmutableList.copyOf((Iterable)dc.getFilesSorted());
            return dc;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter(10000);
            e.printStackTrace(new PrintWriter(sw));
            f.format("%s", sw.toString());
            if (dc != null) {
                dc.close();
            }
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean writeIndex(Formatter errlog) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void showCollection(Formatter f) {
        Set group;
        if (this.dcm == null) {
            if (this.spec == null) {
                return;
            }
            this.dcm = this.getCollection(this.spec, f);
            if (this.dcm == null) {
                return;
            }
        }
        f.format("dcm = %s%n", this.dcm);
        try {
            for (MFile mfile : this.dcm.getFilesSorted()) {
                f.format("  %s%n", mfile.getPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap<Integer, Set> groups = new HashMap<Integer, Set>();
        for (Object o : this.param2BeanTable.getBeans()) {
            Grib2ParameterBean p = (Grib2ParameterBean)o;
            group = groups.computeIfAbsent(p.getGDS(), k -> new TreeSet());
            for (Grib2RecordBean r : p.getRecordBeans()) {
                group.add(r.gr.getFile());
            }
        }
        for (Object o : this.gds2Table.getBeans()) {
            Gds2Bean gds = (Gds2Bean)o;
            group = (Set)groups.get(gds.getGDShash());
            f.format("%nGroup %s %n", gds.getGroupName());
            if (group == null) continue;
            for (Integer fileno : group) {
                f.format(" %d = %s%n", fileno, this.fileList.get(fileno).getPath());
            }
            f.format("%n", new Object[0]);
        }
    }

    public void showGDSuse(Formatter f) {
        Set files;
        HashMap<Integer, Gds2Bean> gdsMap = new HashMap<Integer, Gds2Bean>();
        HashMap fileMap = new HashMap();
        List beans = this.gds2Table.getBeans();
        for (Gds2Bean gds2Bean : beans) {
            fileMap.put(gds2Bean.getGDShash(), new TreeSet());
            gdsMap.put(gds2Bean.getGDShash(), gds2Bean);
            f.format("<gdsName hash='%d' groupName='%s'/>%n", gds2Bean.getGDShash(), gds2Bean.getGroupName());
        }
        f.format("%n", new Object[0]);
        for (Object e : this.param2BeanTable.getBeans()) {
            Grib2ParameterBean p = (Grib2ParameterBean)e;
            files = (Set)fileMap.get(p.getGDS());
            for (Grib2RecordBean r : p.getRecordBeans()) {
                files.add(r.gr.getFile());
            }
        }
        for (Map.Entry entry : fileMap.entrySet()) {
            Gds2Bean gds = (Gds2Bean)gdsMap.get(entry.getKey());
            files = (Set)entry.getValue();
            Iterator iter = files.iterator();
            f.format("%nGDS %d == %s%n", entry.getKey(), gds);
            while (iter.hasNext()) {
                int fileno = (Integer)iter.next();
                f.format(" %3d = %s%n", fileno, this.fileList.get(fileno).getPath());
            }
        }
    }

    public void checkProblems(Formatter f) {
        this.checkDuplicates(f);
        this.checkLocalParams(f);
    }

    public void check(Grib2RecordBean bean, Formatter f) {
        int fileno = bean.gr.getFile();
        MFile mfile = this.fileList.get(fileno);
        try (RandomAccessFile raf = new RandomAccessFile(mfile.getPath(), "r");){
            bean.gr.check(raf, f);
        }
        catch (IOException ioe) {
            StringWriter sw = new StringWriter(10000);
            ioe.printStackTrace(new PrintWriter(sw));
            f.format("%n%s%n", sw.toString());
        }
        f.format("%ndone%n", new Object[0]);
    }

    private void checkDuplicates(Formatter f) {
        HashSet<Long> pdsMap = new HashSet<Long>();
        int dups = 0;
        int count = 0;
        HashMap<CalendarDate, DateCount> dateMap = new HashMap<CalendarDate, DateCount>();
        List params = this.param2BeanTable.getBeans();
        for (Grib2ParameterBean param : params) {
            for (Grib2RecordBean record : param.getRecordBeans()) {
                CalendarDate d = record.gr.getReferenceDate();
                DateCount dc = (DateCount)dateMap.get(d);
                if (dc == null) {
                    dc = new DateCount(d);
                    dateMap.put(d, dc);
                }
                ++dc.count;
                Grib2SectionProductDefinition pdss = record.gr.getPDSsection();
                long crc = pdss.calcCRC();
                if (pdsMap.contains(crc)) {
                    ++dups;
                } else {
                    pdsMap.add(crc);
                }
                ++count;
            }
        }
        f.format("PDS duplicates = %d / %d%n%n", dups, count);
        ArrayList dcList = new ArrayList(dateMap.values());
        Collections.sort(dcList);
        f.format("Run Dates%n", new Object[0]);
        int total = 0;
        for (DateCount dc : dcList) {
            f.format(" %s == %d%n", dc.d, dc.count);
            total += dc.count;
        }
        f.format("total records = %d%n", total);
    }

    private void checkLocalParams(Formatter f) {
        f.format("%nLocal Parameters%n", new Object[0]);
        List params = this.param2BeanTable.getBeans();
        for (Grib2ParameterBean pbean : params) {
            GribTables.Parameter p = pbean.getParameter();
            if (p == null) {
                f.format("   null parameter for %s%n", pbean);
                continue;
            }
            if (!Grib2Tables.isLocal((GribTables.Parameter)p)) continue;
            f.format("   %s%n", p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(List<Grib2RecordBean> beans) {
        if (this.fileChooser == null) {
            this.fileChooser = new FileManager(null, null, null, (PreferencesExt)this.prefs.node("FileManager"));
        }
        FileOutputStream fos = null;
        java.io.RandomAccessFile raf = null;
        try {
            String filename = null;
            boolean append = false;
            int n = 0;
            MFile curr = null;
            for (Grib2RecordBean bean : beans) {
                MFile mfile = this.fileList.get(bean.gr.getFile());
                if (curr == null || curr != mfile) {
                    if (raf != null) {
                        raf.close();
                    }
                    raf = new java.io.RandomAccessFile(mfile.getPath(), "r");
                    curr = mfile;
                }
                if (fos == null) {
                    String defloc = mfile.getPath();
                    filename = this.fileChooser.chooseFilenameToSave(defloc + ".grib2");
                    if (filename == null) {
                        return;
                    }
                    File f = new File(filename);
                    append = f.exists();
                    fos = new FileOutputStream(filename, append);
                }
                Grib2SectionIndicator is = bean.gr.getIs();
                int size = (int)is.getMessageLength();
                long startPos = is.getStartPos();
                if (startPos < 0L) {
                    JOptionPane.showMessageDialog(this, "Old index does not have message start - record not written");
                }
                byte[] rb = new byte[size];
                raf.seek(startPos);
                raf.readFully(rb);
                fos.write(rb);
                ++n;
            }
            JOptionPane.showMessageDialog(this, filename + ": " + n + " records successfully written, append=" + append);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void compare(Grib2RecordBean bean1, Grib2RecordBean bean2, Formatter f) {
        Grib2SectionIndicator is1 = bean1.gr.getIs();
        Grib2SectionIndicator is2 = bean2.gr.getIs();
        f.format("Indicator Section%n", new Object[0]);
        if (is1.getDiscipline() != is2.getDiscipline()) {
            f.format("getDiscipline differs %d != %d %n", is1.getDiscipline(), is2.getDiscipline());
        }
        if (is1.getMessageLength() != is2.getMessageLength()) {
            f.format("getGribLength differs %d != %d %n", is1.getMessageLength(), is2.getMessageLength());
        }
        f.format("%nId Section%n", new Object[0]);
        Grib2SectionIdentification id1 = bean1.gr.getId();
        Grib2SectionIdentification id2 = bean2.gr.getId();
        if (id1.getCenter_id() != id2.getCenter_id()) {
            f.format("Center_id differs %d != %d %n", id1.getCenter_id(), id2.getCenter_id());
        }
        if (id1.getSubcenter_id() != id2.getSubcenter_id()) {
            f.format("Subcenter_id differs %d != %d %n", id1.getSubcenter_id(), id2.getSubcenter_id());
        }
        if (id1.getMaster_table_version() != id2.getMaster_table_version()) {
            f.format("Master_table_version differs %d != %d %n", id1.getMaster_table_version(), id2.getMaster_table_version());
        }
        if (id1.getLocal_table_version() != id2.getLocal_table_version()) {
            f.format("Local_table_version differs %d != %d %n", id1.getLocal_table_version(), id2.getLocal_table_version());
        }
        if (id1.getProductionStatus() != id2.getProductionStatus()) {
            f.format("ProductionStatus differs %d != %d %n", id1.getProductionStatus(), id2.getProductionStatus());
        }
        if (id1.getTypeOfProcessedData() != id2.getTypeOfProcessedData()) {
            f.format("TypeOfProcessedData differs %d != %d %n", id1.getTypeOfProcessedData(), id2.getTypeOfProcessedData());
        }
        if (!id1.getReferenceDate().equals((Object)id2.getReferenceDate())) {
            f.format("ReferenceDate differs %s != %s %n", id1.getReferenceDate(), id2.getReferenceDate());
        }
        if (id1.getSignificanceOfRT() != id2.getSignificanceOfRT()) {
            f.format("getSignificanceOfRT differs %d != %d %n", id1.getSignificanceOfRT(), id2.getSignificanceOfRT());
        }
        Grib2SectionLocalUse lus1 = bean1.gr.getLocalUseSection();
        Grib2SectionLocalUse lus2 = bean2.gr.getLocalUseSection();
        if (lus1 == null || lus2 == null) {
            if (lus1 == lus2) {
                f.format("%nLus are both null%n", new Object[0]);
            } else {
                f.format("%nLus are different %s != %s %n", lus1, lus2);
            }
        } else {
            f.format("%nCompare LocalUseSection%n", new Object[0]);
            Misc.compare((byte[])lus1.getRawBytes(), (byte[])lus2.getRawBytes(), (Formatter)f);
        }
        Grib2CollectionPanel.compare(bean1.gr.getPDSsection(), bean2.gr.getPDSsection(), f);
        Grib2CollectionPanel.compare(bean1.gr.getGDSsection(), bean2.gr.getGDSsection(), f);
    }

    public static void compare(Grib2SectionGridDefinition gdss1, Grib2SectionGridDefinition gdss2, Formatter f) {
        f.format("1 GribGDS hash = %s%n", gdss1.getGDS().hashCode());
        f.format("2 GribGDS hash = %s%n", gdss2.getGDS().hashCode());
        f.format("%nCompare Gds%n", new Object[0]);
        byte[] raw1 = gdss1.getRawBytes();
        byte[] raw2 = gdss2.getRawBytes();
        boolean same = Misc.compare((byte[])raw1, (byte[])raw2, (Formatter)f);
        f.format(" exact byte compare= %s%n%n", same ? "True" : "False");
        Grib2Gds gds1 = gdss1.getGDS();
        Grib2Gds gds2 = gdss2.getGDS();
        GdsHorizCoordSys gdsh1 = gds1.makeHorizCoordSys();
        GdsHorizCoordSys gdsh2 = gds2.makeHorizCoordSys();
        f.format(" compare gds1 - gds22%n", new Object[0]);
        f.format("  Start x diff : %f%n", gdsh1.getStartX() - gdsh2.getStartX());
        f.format("  Start y diff : %f%n", gdsh1.getStartY() - gdsh2.getStartY());
        f.format("  End x diff : %f%n", gdsh1.getEndX() - gdsh2.getEndX());
        f.format("  End y diff : %f%n", gdsh1.getEndY() - gdsh2.getEndY());
        LatLonPoint pt1 = gdsh1.getCenterLatLon();
        LatLonPoint pt2 = gdsh2.getCenterLatLon();
        f.format("  Center lon diff : %f%n", pt1.getLongitude() - pt2.getLongitude());
        f.format("  Center lat diff : %f%n", pt1.getLatitude() - pt2.getLatitude());
    }

    public static void compare(Grib2SectionProductDefinition pds1, Grib2SectionProductDefinition pds2, Formatter f) {
        f.format("%nCompare Pds%n", new Object[0]);
        byte[] raw1 = pds1.getRawBytes();
        byte[] raw2 = pds2.getRawBytes();
        boolean same = Misc.compare((byte[])raw1, (byte[])raw2, (Formatter)f);
        f.format(" exact byte compare= %s%n%n", same ? "True" : "False");
    }

    public static void compareData(Grib2RecordBean bean1, Grib2RecordBean bean2, Formatter f) {
        float[] data2;
        float[] data1;
        try {
            data1 = bean1.readData();
            data2 = bean2.readData();
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        Misc.compare((float[])data1, (float[])data2, (Formatter)f);
    }

    public static void showData(Grib2RecordBean bean1, Formatter f) {
        float[] data;
        try {
            data = bean1.readData();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            f.format("Exception %s", sw.toString());
            return;
        }
        Grib2Gds gds = bean1.gr.getGDS();
        int[] shape = new int[]{gds.getNy(), gds.getNx()};
        Array arr = Array.factory((DataType)DataType.FLOAT, (int[])shape, (Object)data);
        f.format("%s", Ncdump.printArray((Array)arr));
    }

    private static class PdsBeanInfo
    extends SimpleBeanInfo {
        PropertyDescriptor[] properties;

        PdsBeanInfo(Grib2Pds pds) {
            ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>(40);
            Class<Grib2RecordBean> cl = Grib2RecordBean.class;
            try {
                props.add(new PropertyDescriptor("startPos", cl, "getStartPos", null));
                props.add(new PropertyDescriptor("file", cl, "getFile", null));
                props.add(new PropertyDescriptor("forecastDate", cl, "getForecastDate", null));
                props.add(new PropertyDescriptor("forecastTime", cl, "getForecastTime", null));
                props.add(new PropertyDescriptor("processType", cl, "getGenProcessType", null));
                props.add(new PropertyDescriptor("header", cl, "getHeader", null));
                props.add(new PropertyDescriptor("level", cl, "getLevel", null));
                props.add(new PropertyDescriptor("refDate", cl, "getRefDate", null));
                props.add(new PropertyDescriptor("timeUnit", cl, "getTimeUnit", null));
                if (pds instanceof Grib2Pds.PdsAerosol) {
                    props.add(new PropertyDescriptor("aerIntSizeType", cl, "getAerIntSizeType", null));
                    props.add(new PropertyDescriptor("aerIntWavelType", cl, "getAerIntWavelType", null));
                    props.add(new PropertyDescriptor("aerSize1", cl, "getAerSize1", null));
                    props.add(new PropertyDescriptor("aerSize2", cl, "getAerSize2", null));
                    props.add(new PropertyDescriptor("aerType", cl, "getAerType", null));
                    props.add(new PropertyDescriptor("aerWavel1", cl, "getAerWavel1", null));
                    props.add(new PropertyDescriptor("aerWavel2", cl, "getAerWavel2", null));
                }
                if (pds instanceof Grib2Pds.PdsEnsemble) {
                    props.add(new PropertyDescriptor("pertN", cl, "getPertN", null));
                    props.add(new PropertyDescriptor("pertType", cl, "getPertType", null));
                    props.add(new PropertyDescriptor("nForecastsInEns", cl, "getNForecastsInEns", null));
                }
                if (pds instanceof Grib2Pds.PdsInterval) {
                    props.add(new PropertyDescriptor("intv", cl, "getIntv", null));
                    props.add(new PropertyDescriptor("intv2", cl, "getIntv2", null));
                    props.add(new PropertyDescriptor("intvHash", cl, "getIntvHash", null));
                }
                if (pds instanceof Grib2Pds.PdsProbability) {
                    props.add(new PropertyDescriptor("probLimits", cl, "getProbLimits", null));
                }
                if (pds instanceof Grib2Pds.PdsSatellite) {
                    props.add(new PropertyDescriptor("numSatBands", cl, "getNumSatelliteBands", null));
                    props.add(new PropertyDescriptor("satBands", cl, "getSatelliteBands", null));
                }
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            this.properties = new PropertyDescriptor[props.size()];
            props.toArray(this.properties);
        }

        @Override
        public PropertyDescriptor[] getPropertyDescriptors() {
            return this.properties;
        }
    }

    public class Grib2RecordBean {
        Grib2Record gr;
        Grib2Pds pds;

        public Grib2RecordBean() {
        }

        public Grib2RecordBean(Grib2Record m) throws IOException {
            this.gr = m;
            this.pds = this.gr.getPDS();
        }

        public final String getRefDate() {
            return this.gr.getReferenceDate().toString();
        }

        public final String getForecastDate() {
            CalendarDate cd = Grib2CollectionPanel.this.cust.getForecastDate(this.gr);
            return cd == null ? null : cd.toString();
        }

        public String getHeader() {
            return Grib2Utils.cleanupHeader((byte[])this.gr.getHeader());
        }

        public final String getTimeUnit() {
            int unit = this.pds.getTimeUnit();
            return Grib2CollectionPanel.this.cust.getCodeTableValue("4.4", unit);
        }

        public final int getForecastTime() {
            return this.pds.getForecastTime();
        }

        public final int getGenProcessType() {
            return this.pds.getGenProcessType();
        }

        public final String getFile() {
            int fno = this.gr.getFile();
            return ((MFile)Grib2CollectionPanel.this.fileList.get(fno)).getName();
        }

        public String getLevel() {
            int v1 = this.pds.getLevelType1();
            int v2 = this.pds.getLevelType2();
            if (v1 == 255) {
                return "";
            }
            if (v2 == 255) {
                return "" + this.pds.getLevelValue1();
            }
            if (v1 != v2) {
                return this.pds.getLevelValue1() + "-" + this.pds.getLevelValue2() + " level2 type= " + v2;
            }
            return this.pds.getLevelValue1() + "-" + this.pds.getLevelValue2();
        }

        public long getStartPos() {
            return this.gr.getIs().getStartPos();
        }

        public void toRawPdsString(Formatter f) {
            byte[] bytes = this.gr.getPDSsection().getRawBytes();
            int count = 1;
            for (byte b : bytes) {
                short s = DataType.unsignedByteToShort((byte)b);
                f.format(" %d : %d%n", count++, s);
            }
        }

        public void toRawLUString(Formatter f) {
            if (this.gr.getLocalUseSection() == null) {
                f.format("No Local Use Section", new Object[0]);
                return;
            }
            byte[] bytes = this.gr.getLocalUseSection().getRawBytes();
            f.format("Local Use Section len=%d%n", bytes.length);
            Grib2Show.showBytes((Formatter)f, (byte[])bytes, (int)-1);
        }

        public void showProcessedGridRecord(Formatter f) {
            f.format("%nFile=%s (%d)%n", ((MFile)Grib2CollectionPanel.this.fileList.get(this.gr.getFile())).getPath(), this.gr.getFile());
            Grib2Show.showProcessedGridRecord((Grib2Tables)Grib2CollectionPanel.this.cust, (Grib2Record)this.gr, (Formatter)f);
        }

        float[] readData() throws IOException {
            int fileno = this.gr.getFile();
            MFile mfile = (MFile)Grib2CollectionPanel.this.fileList.get(fileno);
            try (RandomAccessFile raf = new RandomAccessFile(mfile.getPath(), "r");){
                raf.order(0);
                float[] fArray = this.gr.readData(raf);
                return fArray;
            }
        }

        public String getTInv() {
            Grib2Pds.PdsInterval pdsi = (Grib2Pds.PdsInterval)this.pds;
            Formatter f = new Formatter();
            int count = 0;
            for (Grib2Pds.TimeInterval ti : pdsi.getTimeIntervals()) {
                if (count++ > 0) {
                    f.format(", ", new Object[0]);
                }
                f.format("%d-%d-%d", ti.statProcessType, ti.timeRangeLength, ti.timeIncrement);
            }
            return f.toString();
        }

        public String getIntv() {
            TimeCoordIntvDateValue intv;
            if (Grib2CollectionPanel.this.cust != null && (intv = Grib2CollectionPanel.this.cust.getForecastTimeInterval(this.gr)) != null) {
                return intv.toString();
            }
            return "";
        }

        public String getIntv2() {
            int[] intv;
            if (Grib2CollectionPanel.this.cust != null && (intv = Grib2CollectionPanel.this.cust.getForecastTimeIntervalOffset(this.gr)) != null) {
                return intv[0] + "-" + intv[1];
            }
            return "";
        }

        public long getIntvHash() {
            Grib2Pds.PdsInterval pdsi = (Grib2Pds.PdsInterval)this.pds;
            return pdsi.getIntervalHash();
        }

        public int getAerType() {
            return ((Grib2Pds.PdsAerosol)this.pds).getAerosolType();
        }

        public double getAerIntSizeType() {
            return ((Grib2Pds.PdsAerosol)this.pds).getAerosolIntervalSizeType();
        }

        public double getAerSize1() {
            return ((Grib2Pds.PdsAerosol)this.pds).getAerosolSize1() * 1.0E7;
        }

        public double getAerSize2() {
            return ((Grib2Pds.PdsAerosol)this.pds).getAerosolSize2() * 1.0E7;
        }

        public double getAerIntWavelType() {
            return ((Grib2Pds.PdsAerosol)this.pds).getAerosolIntervalWavelengthType();
        }

        public double getAerWavel1() {
            return ((Grib2Pds.PdsAerosol)this.pds).getAerosolWavelength1();
        }

        public double getAerWavel2() {
            return ((Grib2Pds.PdsAerosol)this.pds).getAerosolWavelength2();
        }

        public int getPertN() {
            Grib2Pds.PdsEnsemble pdsi = (Grib2Pds.PdsEnsemble)this.pds;
            int v = pdsi.getPerturbationNumber();
            if (v == -9999) {
                v = -1;
            }
            return v;
        }

        public int getNForecastsInEns() {
            Grib2Pds.PdsEnsemble pdsi = (Grib2Pds.PdsEnsemble)this.pds;
            int v = pdsi.getNumberEnsembleForecasts();
            if (v == -9999) {
                v = -1;
            }
            return v;
        }

        public int getPertType() {
            Grib2Pds.PdsEnsemble pdsi = (Grib2Pds.PdsEnsemble)this.pds;
            int v = pdsi.getPerturbationType();
            return v == -9999 ? -1 : v;
        }

        public String getProbLimits() {
            Grib2Pds.PdsProbability pdsi = (Grib2Pds.PdsProbability)this.pds;
            double v = pdsi.getProbabilityLowerLimit();
            if (v == -9999.0) {
                return "";
            }
            return pdsi.getProbabilityLowerLimit() + "-" + pdsi.getProbabilityUpperLimit();
        }
    }

    public class Grib2ParameterBean {
        Grib2Record gr;
        Grib2SectionIdentification id;
        Grib2Pds pds;
        List<Grib2RecordBean> records;
        int discipline;
        Grib2Variable gv;

        public Grib2ParameterBean() {
        }

        public Grib2ParameterBean(Grib2Record r, Grib2Variable gv) throws IOException {
            this.gr = r;
            this.gv = gv;
            this.pds = r.getPDS();
            this.id = r.getId();
            this.discipline = r.getDiscipline();
            this.records = new ArrayList<Grib2RecordBean>();
        }

        void addRecord(Grib2Record r) throws IOException {
            this.records.add(new Grib2RecordBean(r));
        }

        List<Grib2RecordBean> getRecordBeans() {
            return this.records;
        }

        public String getParamNo() {
            return this.discipline + "-" + this.pds.getParameterCategory() + "-" + this.pds.getParameterNumber();
        }

        GribTables.Parameter getParameter() {
            return Grib2CollectionPanel.this.cust.getParameter(this.gr);
        }

        public int getPDS() {
            return this.gr.getPDSsection().getPDSTemplateNumber();
        }

        public int getN() {
            return this.records.size();
        }

        public int getLevelType() {
            return this.pds.getLevelType1();
        }

        public int getGenProcess() {
            return this.pds.getGenProcessId();
        }

        public String getLevelName() {
            return Grib2CollectionPanel.this.cust.getLevelNameShort(this.pds.getLevelType1());
        }

        public int getNExtra() {
            return this.pds.getExtraCoordinatesCount();
        }

        public boolean isLayer() {
            return Grib2CollectionPanel.this.cust.isLayer(this.pds);
        }

        public final String getStatType() {
            if (this.pds.isTimeInterval()) {
                Formatter f = new Formatter();
                Grib2Pds.PdsInterval pdsi = (Grib2Pds.PdsInterval)this.pds;
                int count = 0;
                for (Grib2Pds.TimeInterval ti : pdsi.getTimeIntervals()) {
                    if (count++ > 0) {
                        f.format(", ", new Object[0]);
                    }
                    f.format("%d %s", ti.statProcessType, Grib2CollectionPanel.this.cust.getStatisticNameShort(ti.statProcessType));
                }
                return f.toString();
            }
            return "";
        }

        public int getGDS() {
            return this.gr.getGDSsection().getGDS().hashCode();
        }

        public String getCdmHash() {
            return Integer.toHexString(this.gv.hashCode());
        }

        public double getIntvHours() {
            if (this.pds.isTimeInterval()) {
                return Grib2CollectionPanel.this.cust.getForecastTimeIntervalSizeInHours(this.pds);
            }
            return -1.0;
        }

        public String toString() {
            Formatter f = new Formatter();
            Grib2Show.showPdsTemplate((Grib2SectionProductDefinition)this.gr.getPDSsection(), (Formatter)f, (Grib2Tables)Grib2CollectionPanel.this.cust);
            return f.toString();
        }

        public String toProcessedString() {
            Formatter f = new Formatter();
            Grib2Show.showProcessedPds((Grib2Tables)Grib2CollectionPanel.this.cust, (Grib2Pds)this.pds, (int)this.discipline, (Formatter)f);
            return f.toString();
        }

        public String getName() {
            return GribUtils.makeNameFromDescription((String)Grib2CollectionPanel.this.cust.getVariableName(this.gr));
        }

        public String getUnits() {
            GribTables.Parameter p = Grib2CollectionPanel.this.cust.getParameter(this.discipline, this.pds);
            return p == null ? "?" : p.getUnit();
        }

        public final String getCenter() {
            return this.id.getCenter_id() + "/" + this.id.getSubcenter_id();
        }

        public final String getTable() {
            return this.id.getMaster_table_version() + "-" + this.id.getLocal_table_version();
        }

        @Nullable
        public String getEnsDerived() {
            if (this.pds.isEnsembleDerived()) {
                Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)this.pds;
                int type = pdsDerived.getDerivedForecastType();
                return Grib2CollectionPanel.this.cust.getProbabilityNameShort(type);
            }
            return null;
        }

        @Nullable
        public String getEnsProb() {
            if (this.pds.isProbability()) {
                Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)this.pds;
                return pdsProb.getProbabilityName();
            }
            return null;
        }

        public final boolean isEns() {
            return this.pds.isEnsemble();
        }
    }

    public class Gds2Bean
    implements Comparable<Gds2Bean> {
        Grib2SectionGridDefinition gdss;
        Grib2Gds gds;

        public Gds2Bean() {
        }

        public Gds2Bean(Grib2SectionGridDefinition m) {
            this.gdss = m;
            this.gds = this.gdss.getGDS();
        }

        public int getGDShash() {
            return this.gds.hashCode();
        }

        public int getTemplate() {
            return this.gdss.getGDSTemplateNumber();
        }

        public String getGridName() {
            return Grib2CollectionPanel.this.cust.getCodeTableValue("3.1", this.gdss.getGDSTemplateNumber());
        }

        public String getGroupName() {
            return this.getGridName() + "-" + this.getNy() + "X" + this.getNx();
        }

        public int getNPoints() {
            return this.gdss.getNumberPoints();
        }

        public int getNx() {
            return this.gds.getNx();
        }

        public int getNy() {
            return this.gds.getNy();
        }

        public String getScanMode() {
            int scanMode = this.gds.getScanMode();
            Formatter f = new Formatter();
            f.format("0x%s=", Long.toHexString(scanMode));
            if (!GribUtils.scanModeXisPositive((int)scanMode)) {
                f.format(" Xneg", new Object[0]);
            }
            if (GribUtils.scanModeYisPositive((int)scanMode)) {
                f.format(" Ypos", new Object[0]);
            }
            if (!GribUtils.scanModeXisConsecutive((int)scanMode)) {
                f.format(" !XisConsecutive", new Object[0]);
            }
            if (!GribUtils.scanModeSameDirection((int)scanMode)) {
                f.format(" !SameDirection", new Object[0]);
            }
            return f.toString();
        }

        public String toString() {
            return this.getGridName() + " " + this.getTemplate() + " " + this.getNx() + " X " + this.getNy();
        }

        public void toRawGdsString(Formatter f) {
            byte[] bytes = this.gds.getRawBytes();
            int count = 1;
            for (byte b : bytes) {
                short s = DataType.unsignedByteToShort((byte)b);
                f.format(" %d : %d%n", count++, s);
            }
        }

        @Override
        public int compareTo(Gds2Bean o) {
            return this.getGroupName().compareTo(o.getGroupName());
        }
    }

    private static class DateCount
    implements Comparable<DateCount> {
        CalendarDate d;
        int count;

        private DateCount(CalendarDate d) {
            this.d = d;
        }

        @Override
        public int compareTo(DateCount o) {
            return this.d.compareTo(o.d);
        }
    }
}

