/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formatter;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.ui.grib.Grib2DataPanel;
import ucar.ui.widget.BAMutil;
import ucar.util.prefs.PreferencesExt;

public class Grib2DataOpPanel
extends OpPanel {
    private Grib2DataPanel gribTable;

    public Grib2DataOpPanel(PreferencesExt p) {
        super(p, "collection:", true, false);
        this.gribTable = new Grib2DataPanel(this.prefs);
        this.add((Component)this.gribTable, "Center");
        this.gribTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("openGrib2Collection")) {
                    String collectionName = (String)e.getNewValue();
                    ToolsUI.getToolsUI().openGrib2Collection(collectionName);
                }
            }
        });
        AbstractButton infoButton = BAMutil.makeButtcon((String)"Information", (String)"Show Info", (boolean)false);
        infoButton.addActionListener(e -> {
            Formatter f = new Formatter();
            this.gribTable.showInfo(f);
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(infoButton);
        AbstractButton checkButton = BAMutil.makeButtcon((String)"Information", (String)"Check Problems", (boolean)false);
        checkButton.addActionListener(e -> {
            Formatter f = new Formatter();
            this.gribTable.checkProblems(f);
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(checkButton);
    }

    public void setCollection(String collection) {
        if (this.process(collection)) {
            this.cb.addItem((Object)collection);
        }
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            this.gribTable.setCollection(command);
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset cannot open " + command + "\n" + ioe.getMessage());
            err = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
    }

    @Override
    public void save() {
        this.gribTable.save();
        super.save();
    }
}

