/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.builder.CatalogBuilder;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.PopupMenu;

public class CatalogTreeView
extends JPanel {
    private static final boolean debugRef = false;
    private static final boolean debugTree = false;
    private Catalog catalog;
    private boolean accessOnly = true;
    private String catalogURL = "";
    private boolean openCatalogReferences = true;
    private final JTree tree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode(null, false)));
    private InvCatalogTreeModel model;

    public CatalogTreeView() {
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setToggleClickCount(1);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                int selRow = CatalogTreeView.this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    CatalogTreeView.this.checkForCatref();
                    InvCatalogTreeNode node = (InvCatalogTreeNode)CatalogTreeView.this.tree.getLastSelectedPathComponent();
                    if (node != null) {
                        CatalogTreeView.this.firePropertyChangeEvent(new PropertyChangeEvent(this, "Selection", null, node.ds));
                    }
                }
                if (selRow != -1 && e.getClickCount() == 2) {
                    CatalogTreeView.this.acceptSelected();
                }
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent evt) {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent evt) {
                CatalogRef catref;
                InvCatalogTreeNode node = (InvCatalogTreeNode)evt.getPath().getLastPathComponent();
                if (node.ds instanceof CatalogRef && !(catref = (CatalogRef)node.ds).isRead() && CatalogTreeView.this.openCatalogReferences) {
                    node.readCatref();
                }
            }
        });
        PopupMenu varPopup = new PopupMenu((JComponent)this.tree, "Options");
        varPopup.addAction("Open all children", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvCatalogTreeNode node = (InvCatalogTreeNode)CatalogTreeView.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    CatalogTreeView.this.open(node, true);
                }
            }
        });
        varPopup.addAction("Open one level of children", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvCatalogTreeNode node = (InvCatalogTreeNode)CatalogTreeView.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    node.makeChildren(true);
                    for (InvCatalogTreeNode child : node.children) {
                        CatalogTreeView.this.tree.expandPath(CatalogTreeView.this.makeTreePath(child));
                    }
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public void setOpenCatalogReferences(boolean openCatalogReferences) {
        this.openCatalogReferences = openCatalogReferences;
    }

    public void setOpenDatasetScans(boolean openDatasetScans) {
    }

    private void firePropertyChangeEvent(DatasetNode ds) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "Dataset", null, ds);
        this.firePropertyChangeEvent(event);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    public void setAccessOnly(boolean accessOnly) {
        this.accessOnly = accessOnly;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public String getCatalogURL() {
        return this.catalogURL;
    }

    private void setCatalogURL(String catalogURL) {
        this.catalogURL = catalogURL;
    }

    public DatasetNode getSelectedDataset() {
        InvCatalogTreeNode tnode = this.getSelectedNode();
        return tnode == null ? null : tnode.ds;
    }

    private InvCatalogTreeNode getSelectedNode() {
        Object node = this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if (!(node instanceof InvCatalogTreeNode)) {
            return null;
        }
        return (InvCatalogTreeNode)node;
    }

    public void setSelectedDataset(Dataset ds) {
        if (ds == null) {
            return;
        }
        TreePath path = this.makePath(ds);
        if (path == null) {
            return;
        }
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    TreePath makePath(Dataset ds) {
        return null;
    }

    TreePath makeTreePath(TreeNode node) {
        ArrayList<TreeNode> path = new ArrayList<TreeNode>();
        path.add(node);
        for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            path.add(0, parent);
        }
        Object[] paths = path.toArray();
        return new TreePath(paths);
    }

    public void openAll(boolean includeCatref) {
        if (this.catalog == null) {
            return;
        }
        this.open((InvCatalogTreeNode)this.model.getRoot(), includeCatref);
        this.tree.repaint();
    }

    private void open(InvCatalogTreeNode node, boolean includeCatref) {
        if (node == null) {
            return;
        }
        node.makeChildren(includeCatref);
        this.tree.expandPath(this.makeTreePath(node));
        Enumeration<InvCatalogTreeNode> e = node.children();
        while (e.hasMoreElements()) {
            InvCatalogTreeNode child = e.nextElement();
            this.open(child, includeCatref);
        }
    }

    void checkForCatref() {
        InvCatalogTreeNode tnode;
        CatalogRef catref;
        DatasetNode ds = this.getSelectedDataset();
        if (ds == null) {
            return;
        }
        if (ds instanceof CatalogRef && !(catref = (CatalogRef)ds).isRead() && this.openCatalogReferences && (tnode = this.getSelectedNode()) != null) {
            tnode.readCatref();
        }
    }

    void acceptSelected() {
        Dataset ds;
        DatasetNode dsn = this.getSelectedDataset();
        if (dsn == null) {
            return;
        }
        if (this.accessOnly && dsn instanceof Dataset && !(ds = (Dataset)dsn).hasAccess()) {
            return;
        }
        this.firePropertyChangeEvent(dsn);
    }

    public void setCatalog(String location) {
        CatalogBuilder builder = new CatalogBuilder();
        try {
            Catalog cat = builder.buildFromLocation(location, null);
            this.setCatalog(cat);
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "Error opening catalog location " + location + " err=" + builder.getErrorMessage());
        }
    }

    public void redisplay() {
        this.setCatalog(this.catalog);
    }

    public void setCatalog(Catalog catalog) {
        String id;
        Dataset dataset;
        if (catalog == null) {
            return;
        }
        String catalogName = catalog.getBaseURI().toString();
        this.catalog = catalog;
        this.setCatalogURL(catalogName);
        this.model = new InvCatalogTreeModel((DatasetNode)catalog);
        this.tree.setModel(this.model);
        int pos = catalogName.indexOf(35);
        if (pos >= 0 && (dataset = catalog.findDatasetByID(id = catalogName.substring(pos + 1))) != null) {
            this.setSelectedDataset(dataset);
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, "Selection", null, dataset));
        }
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "Catalog", null, catalogName));
    }

    private void showNode(TreeModel tree, Object node) {
        if (node == null) {
            return;
        }
        InvCatalogTreeNode tnode = (InvCatalogTreeNode)node;
        DatasetNode cp = tnode.ds;
        System.out.println(" node= " + cp.getName() + " leaf= " + tree.isLeaf(node));
        for (int i = 0; i < tree.getChildCount(node); ++i) {
            this.showNode(tree, tree.getChild(node, i));
        }
    }

    private static class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon refIcon = BAMutil.getIcon((String)"nj22/CatalogRef", (boolean)true);
        ImageIcon refReadIcon = BAMutil.getIcon((String)"nj22/CatalogRefRead", (boolean)true);
        ImageIcon gridIcon = BAMutil.getIcon((String)"nj22/GridData", (boolean)true);
        ImageIcon imageIcon = BAMutil.getIcon((String)"nj22/ImageData", (boolean)true);
        ImageIcon dqcIcon = BAMutil.getIcon((String)"nj22/DQCData", (boolean)true);
        ImageIcon dsScanIcon = BAMutil.getIcon((String)"nj22/DatasetScan", (boolean)true);

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof InvCatalogTreeNode) {
                InvCatalogTreeNode node = (InvCatalogTreeNode)value;
                DatasetNode ds = node.ds;
                String doc = ds.toString();
                if (doc != null) {
                    ((JComponent)c).setToolTipText(doc);
                }
                if (ds instanceof CatalogRef) {
                    if (((CatalogRef)ds).isRead()) {
                        this.setIcon(this.refReadIcon);
                    } else {
                        this.setIcon(this.refIcon);
                    }
                } else if (leaf) {
                    this.setIcon(this.gridIcon);
                }
            }
            return c;
        }
    }

    private class InvCatalogTreeNode
    implements TreeNode {
        DatasetNode ds;
        private final InvCatalogTreeNode parent;
        private ArrayList<InvCatalogTreeNode> children;
        private boolean isReading;

        InvCatalogTreeNode(InvCatalogTreeNode parent, DatasetNode ds) {
            this.parent = parent;
            this.ds = ds;
            CatalogTreeView.this.firePropertyChangeEvent(new PropertyChangeEvent(this, "TreeNode", null, ds));
        }

        public Enumeration<InvCatalogTreeNode> children() {
            if (this.children == null) {
                return Collections.enumeration(new ArrayList());
            }
            return Collections.enumeration(this.children);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int index) {
            return this.children.get(index);
        }

        @Override
        public int getChildCount() {
            if (this.children == null) {
                this.makeChildren(false);
            }
            if (this.children == null) {
                return 0;
            }
            return this.children.size();
        }

        void makeChildren(boolean force) {
            if (this.children == null) {
                CatalogRef catref;
                if (this.ds instanceof CatalogRef && !(catref = (CatalogRef)this.ds).isRead() && !force) {
                    return;
                }
                this.children = new ArrayList();
                for (Dataset nested : this.ds.getDatasets()) {
                    this.children.add(new InvCatalogTreeNode(this, (DatasetNode)nested));
                }
            }
        }

        void readCatref() {
            CatalogRef catref = (CatalogRef)this.ds;
            if (!this.isReading) {
                this.isReading = true;
                Formatter errLog = new Formatter();
                Optional opt = catref.readCatref(errLog);
                if (!opt.isPresent()) {
                    JOptionPane.showMessageDialog(CatalogTreeView.this, errLog.toString());
                    return;
                }
                this.setCatalog((DatasetNode)opt.get());
            }
        }

        @Override
        public int getIndex(TreeNode child) {
            return this.children.indexOf(child);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            if (this.ds instanceof CatalogRef) {
                return false;
            }
            return !this.ds.hasNestedDatasets();
        }

        public String toString() {
            return this.ds.getName();
        }

        public void setCatalog(DatasetNode catalog) {
            Dataset top;
            this.children = new ArrayList();
            List datasets = catalog.getDatasets();
            if (datasets.size() == 1 && (top = (Dataset)datasets.get(0)).getName().equalsIgnoreCase(this.ds.getName())) {
                this.ds = top;
                datasets = top.getDatasets();
            }
            int[] childIndices = new int[datasets.size()];
            for (int count = 0; count < datasets.size(); ++count) {
                this.children.add(new InvCatalogTreeNode(this, (DatasetNode)datasets.get(count)));
                childIndices[count] = count;
            }
            CatalogTreeView.this.model.nodesWereInserted(this, childIndices);
            CatalogTreeView.this.tree.expandPath(CatalogTreeView.this.makeTreePath(this));
            this.isReading = false;
        }

        public void failed() {
            this.isReading = false;
        }
    }

    private class InvCatalogTreeModel
    extends DefaultTreeModel {
        InvCatalogTreeModel(DatasetNode top) {
            super(new InvCatalogTreeNode(null, top), false);
        }
    }
}

