/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ServiceType;
import thredds.ui.catalog.CatalogChooser;
import thredds.ui.catalog.ThreddsDatasetChooser;
import ucar.nc2.constants.DataFormatType;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentDialog;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.TextGetPutPane;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.io.http.ReadFromUrl;
import ucar.util.prefs.PreferencesExt;

public class ThreddsUI
extends JPanel {
    private static final boolean debugSelection = false;
    private static final String VIEWER_SIZE = "ViewerSize";
    private static final String SOURCE_WINDOW_SIZE = "SourceWindowSize";
    private static final String XML_WINDOW_SIZE = "XmlWindowSize";
    private final PreferencesExt store;
    private ThreddsDatasetChooser datasetChooser;
    private TextGetPutPane sourcePane;
    private JTabbedPane tabbedPane;
    private TextHistoryPane xmlPane;
    private IndependentDialog xmlWindow;
    private IndependentWindow sourceWindow;
    FileManager fileChooser;

    public ThreddsUI(JFrame parent, PreferencesExt store) {
        this.store = store;
        this.enableEvents(64L);
        Dimension d = (Dimension)store.getBean(VIEWER_SIZE, null);
        int defaultWidth = 700;
        int defaultHeight = 350;
        this.setPreferredSize(d != null ? d : new Dimension(defaultWidth, defaultHeight));
        try {
            this.makeActionsSystem();
            this.makeActionsDataset();
            this.makeUI();
        }
        catch (Exception e) {
            System.out.println("UI creation Exception");
            e.printStackTrace();
        }
        PreferencesExt fcPrefs = (PreferencesExt)store.node("FileManager");
        FileFilter[] filters = new FileFilter[]{new FileManager.NetcdfExtFilter()};
        this.fileChooser = new FileManager(parent, null, filters, fcPrefs);
    }

    private void makeUI() {
        this.tabbedPane = new JTabbedPane(1);
        this.datasetChooser = this.makeDatasetChooser();
        this.sourcePane = new TextGetPutPane((PreferencesExt)this.store.node("getputPane"));
        this.sourceWindow = new IndependentWindow("Source", BAMutil.getImage((String)"nj22/ThreddsIcon.png"), (Component)((Object)this.sourcePane));
        this.sourceWindow.setBounds((Rectangle)this.store.getBean(SOURCE_WINDOW_SIZE, (Object)new Rectangle(50, 50, 725, 450)));
        this.xmlPane = new TextHistoryPane(false);
        this.xmlWindow = new IndependentDialog(null, false, "XML data", (Component)this.xmlPane);
        this.xmlWindow.setBounds((Rectangle)this.store.getBean(XML_WINDOW_SIZE, (Object)new Rectangle(50, 50, 725, 450)));
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    private ThreddsDatasetChooser makeDatasetChooser() {
        this.datasetChooser = new ThreddsDatasetChooser((PreferencesExt)this.store.node("ThreddsDatasetChooser"), this.tabbedPane);
        this.datasetChooser.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("InvAccess")) {
                this.firePropertyChangeEvent(e);
                return;
            }
            if (e.getPropertyName().equals("Dataset") || e.getPropertyName().equals("CoordSys") || e.getPropertyName().equals("File")) {
                DataFormatType format;
                Dataset ds = (Dataset)e.getNewValue();
                Access access = ds.getAccess(ServiceType.HTTPServer);
                if (access != null && ((format = access.getDataFormatType()) == DataFormatType.PLAIN || format == DataFormatType.XML)) {
                    String urlString = access.getWrappedUrlName();
                    try {
                        ReadFromUrl.readURLcontents((String)urlString);
                        this.xmlPane.setText(ReadFromUrl.readURLcontents((String)urlString));
                    }
                    catch (IOException ioe) {
                        this.xmlPane.setText(ioe.getMessage());
                    }
                    this.xmlPane.gotoTop();
                    this.xmlWindow.setVisible(true);
                    return;
                }
                this.firePropertyChangeEvent(e);
            }
        });
        JButton catSource = new JButton("Source");
        catSource.addActionListener(e -> {
            CatalogChooser cc = this.datasetChooser.getCatalogChooser();
            String catURL = cc.getCurrentURL();
            this.sourcePane.setURL(catURL);
            this.sourcePane.gotoTop();
            this.sourceWindow.show();
        });
        this.datasetChooser.getCatalogChooser().addButton(catSource);
        return this.datasetChooser;
    }

    public void storePersistentData() {
        this.store.putBeanObject(VIEWER_SIZE, (Object)this.getSize());
        this.store.putBeanObject(SOURCE_WINDOW_SIZE, (Object)this.sourceWindow.getBounds());
        if (this.fileChooser != null) {
            this.fileChooser.save();
        }
        if (this.datasetChooser != null) {
            this.datasetChooser.save();
        }
        if (this.sourcePane != null) {
            this.sourcePane.save();
        }
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    public void setDataset(String location) {
        this.datasetChooser.getCatalogChooser().setCatalog(location);
        this.tabbedPane.setSelectedComponent(this.datasetChooser.getCatalogChooser());
    }

    private void makeActionsSystem() {
        AbstractAction clearDebugFlagsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        BAMutil.setActionProperties((AbstractAction)clearDebugFlagsAction, null, (String)"Clear Debug Flags", (boolean)false, (int)68, (int)-1);
    }

    private void makeActionsDataset() {
    }
}

