/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.datatype.prefs;

import java.awt.Component;
import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.text.JTextComponent;
import thredds.client.catalog.TimeDuration;
import ucar.ui.prefs.Field;
import ucar.ui.prefs.FldInputVerifier;
import ucar.ui.widget.MultilineTooltip;
import ucar.util.prefs.PersistenceManager;

public class DurationField
extends Field {
    protected JTextComponent tf;

    public DurationField(String name, String label, TimeDuration defValue, PersistenceManager storeData) {
        super(name, label, storeData);
        this.validValue = this.getStoreValue(defValue);
        this.tf = new JTextField(){

            @Override
            public JToolTip createToolTip() {
                return new MultilineTooltip();
            }
        };
        this.tf.setToolTipText("Formats:\n udunits time duration string");
        this.tf.setInputVerifier((InputVerifier)new FldInputVerifier((Component)this.tf, (Field)this));
        if (this.validValue != null) {
            this.tf.setText(this.validValue.toString());
        }
        this.finish();
    }

    public JComponent getEditComponent() {
        return this.tf;
    }

    public TimeDuration getTimeDuration() {
        return (TimeDuration)this.getValue();
    }

    protected boolean _validate(StringBuffer buff) {
        String editValue = this.tf.getText().trim();
        if (editValue.isEmpty()) {
            return true;
        }
        try {
            TimeDuration.parse((String)this.tf.getText());
            return true;
        }
        catch (ParseException e) {
            buff.append(this.label).append(": ").append(e.getMessage());
            return false;
        }
    }

    protected Object getEditValue() {
        String editValue = this.tf.getText().trim();
        if (editValue.isEmpty()) {
            return null;
        }
        try {
            return TimeDuration.parse((String)editValue);
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected void setEditValue(Object value) {
        if (value == null) {
            this.tf.setText("");
        } else {
            this.tf.setText(value.toString());
        }
    }

    protected void setStoreValue(Object value) {
        if (this.storeData != null) {
            this.storeData.putObject(this.name, value);
        }
    }

    protected Object getStoreValue(Object defValue) {
        Object value2;
        Object value = defValue;
        if (this.storeData != null && (value2 = this.storeData.getObject(this.name)) != null) {
            value = value2;
        }
        return value;
    }
}

