/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.InvalidRangeException;
import ucar.array.Section;
import ucar.array.StructureData;
import ucar.array.StructureDataArray;
import ucar.array.StructureMembers;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.calendar.CalendarDate;
import ucar.nc2.write.NcdumpArray;
import ucar.ui.StructureTable;
import ucar.ui.table.ColumnWidthsResizer;
import ucar.ui.table.HidableTableColumnModel;
import ucar.ui.table.TableAligner;
import ucar.ui.table.TableAppearanceAction;
import ucar.ui.table.UndoableRowSorter;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class StructureArrayTable
extends JPanel {
    private static final HashMap<String, IndependentWindow> windows = new HashMap();
    private final PreferencesExt prefs;
    private AbstractSATableModel dataModel;
    private JTable jtable;
    private PopupMenu popup;
    private final FileManager fileChooser;
    private final TextHistoryPane dumpTA;
    private final IndependentWindow dumpWindow;
    private final EventListenerList listeners = new EventListenerList();

    public StructureArrayTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.jtable = new JTable();
        this.setLayout(new BorderLayout());
        this.jtable.setAutoResizeMode(0);
        ToolTipManager.sharedInstance().registerComponent(this.jtable);
        this.add((Component)new JScrollPane(this.jtable), "Center");
        this.dumpTA = new TextHistoryPane(false);
        this.dumpWindow = new IndependentWindow("Show Data", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.dumpTA);
        if (prefs != null) {
            this.dumpWindow.setBounds((Rectangle)prefs.getBean("DumpWindowBounds", (Object)new Rectangle(300, 300, 600, 600)));
        } else {
            this.dumpWindow.setBounds(new Rectangle(300, 300, 600, 600));
        }
        PreferencesExt fcPrefs = prefs == null ? null : (PreferencesExt)prefs.node("FileManager");
        this.fileChooser = new FileManager(null, null, "csv", "comma seperated values", fcPrefs);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.listeners.add(ListSelectionListener.class, l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listeners.remove(ListSelectionListener.class, l);
    }

    private void fireEvent(ListSelectionEvent event) {
        Object[] llist = this.listeners.getListenerList();
        for (int i = llist.length - 2; i >= 0; i -= 2) {
            ((ListSelectionListener)llist[i + 1]).valueChanged(event);
        }
    }

    public void addActionToPopupMenu(String title, AbstractAction act) {
        if (this.popup == null) {
            this.popup = new PopupMenu((JComponent)this.jtable, "Options");
        }
        this.popup.addAction(title, (Action)act);
    }

    public void clear() {
        if (this.dataModel != null) {
            this.dataModel.clear();
        }
    }

    public void saveState() {
        this.fileChooser.save();
        if (this.prefs != null) {
            this.prefs.getBean("DumpWindowBounds", (Object)this.dumpWindow.getBounds());
        }
    }

    public void setStructure(Structure s) {
        this.dataModel = s.getArrayType() == ArrayType.SEQUENCE ? new SequenceModel((Sequence)s, true) : new StructureModel(s);
        this.initTable(this.dataModel);
    }

    public void setStructureData(StructureDataArray as) {
        this.dataModel = new StructureDataArrayModel(as);
        this.initTable(this.dataModel);
    }

    private void initTable(AbstractSATableModel m) {
        HidableTableColumnModel tcm = new HidableTableColumnModel((TableModel)m);
        this.jtable = new JTable(m, (TableColumnModel)tcm);
        this.jtable.setRowSorter((RowSorter<? extends TableModel>)new UndoableRowSorter((TableModel)m));
        ((JComponent)((Object)this.jtable.getDefaultRenderer(Boolean.class))).setOpaque(true);
        ColumnWidthsResizer resizer = new ColumnWidthsResizer(this.jtable);
        this.jtable.getModel().addTableModelListener((TableModelListener)resizer);
        this.jtable.getColumnModel().addColumnModelListener((TableColumnModelListener)resizer);
        TableAligner aligner = new TableAligner(this.jtable, 10);
        this.jtable.getColumnModel().addColumnModelListener((TableColumnModelListener)aligner);
        this.jtable.setAutoResizeMode(0);
        ListSelectionModel rowSM = this.jtable.getSelectionModel();
        rowSM.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                this.fireEvent(e);
            }
        });
        if (m.wantDate) {
            this.jtable.getColumnModel().getColumn(0).setCellRenderer(new StructureTable.DateRenderer());
            this.jtable.getColumnModel().getColumn(1).setCellRenderer(new StructureTable.DateRenderer());
        }
        this.popup = null;
        this.addActionToPopupMenu("Show", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructureArrayTable.this.showData();
            }
        });
        this.addActionToPopupMenu("Export", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructureArrayTable.this.export();
            }
        });
        this.addActionToPopupMenu("Show Internal", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructureArrayTable.this.showDataInternal();
            }
        });
        for (String subtable : m.subtables) {
            this.addActionToPopupMenu("Data Table for " + subtable, new SubtableAction("", subtable));
        }
        this.removeAll();
        JButton cornerButton = new JButton((Action)new TableAppearanceAction(this.jtable));
        cornerButton.setHideActionText(true);
        cornerButton.setContentAreaFilled(false);
        JScrollPane scrollPane = new JScrollPane(this.jtable);
        scrollPane.setCorner("UPPER_RIGHT_CORNER", cornerButton);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setColumnHeaderView(new JViewport());
        scrollPane.getColumnHeader().setPreferredSize(this.jtable.getTableHeader().getPreferredSize());
        this.add((Component)scrollPane, "Center");
        this.revalidate();
    }

    private void export() {
        String filename = this.fileChooser.chooseFilename();
        if (filename == null) {
            return;
        }
        try {
            PrintWriter pw = new PrintWriter(new File(filename), StandardCharsets.UTF_8.name());
            TableModel model = this.jtable.getModel();
            for (int col = 0; col < model.getColumnCount(); ++col) {
                if (col > 0) {
                    pw.print(",");
                }
                pw.print(model.getColumnName(col));
            }
            pw.println();
            for (int row = 0; row < model.getRowCount(); ++row) {
                for (int col = 0; col < model.getColumnCount(); ++col) {
                    if (col > 0) {
                        pw.print(",");
                    }
                    pw.print(model.getValueAt(row, col));
                }
                pw.println();
            }
            pw.close();
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    private void showData() {
        StructureData sd = this.getSelectedStructureData();
        if (sd == null) {
            return;
        }
        this.dumpTA.setText(NcdumpArray.printStructureData((StructureData)sd));
        this.dumpWindow.setVisible(true);
    }

    private void showDataInternal() {
        StructureData sd = this.getSelectedStructureData();
        if (sd == null) {
            return;
        }
        Formatter f = new Formatter();
        f.format("Structure Data %s%n", sd.getName());
        StructureMembers members = sd.getStructureMembers();
        f.format(" Members %s%n", members.getName());
        f.format("   Type      Offset Storage ByteOrder Name%n", new Object[0]);
        for (StructureMembers.Member m : members) {
            f.format("   %9s %3d %6d %12s %s%n", m.getArrayType(), m.getOffset(), m.getStorageSizeBytes(), m.getByteOrder(), m.getName());
        }
        this.dumpTA.setText(f.toString());
        this.dumpWindow.setVisible(true);
    }

    private StructureData getSelectedStructureData() {
        int viewRowIdx = this.jtable.getSelectedRow();
        if (viewRowIdx < 0) {
            return null;
        }
        int modelRowIndex = this.jtable.convertRowIndexToModel(viewRowIdx);
        try {
            return this.dataModel.getStructureData(modelRowIndex);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "ERROR: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public Object getSelectedRow() {
        int viewRowIdx = this.jtable.getSelectedRow();
        if (viewRowIdx < 0) {
            return null;
        }
        int modelRowIndex = this.jtable.convertRowIndexToModel(viewRowIdx);
        try {
            return this.dataModel.getRow(modelRowIndex);
        }
        catch (IOException | InvalidRangeException e) {
            JOptionPane.showMessageDialog(this, "ERROR: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static class StructureDataArrayModel
    extends AbstractSATableModel {
        private StructureDataArray as;

        StructureDataArrayModel(StructureDataArray as) {
            this.as = as;
            this.members = as.getStructureMembers();
            for (StructureMembers.Member m : as.getStructureMembers()) {
                if (m.getArrayType() != ArrayType.SEQUENCE && m.getArrayType() != ArrayType.STRUCTURE) continue;
                this.subtables.add(m.getName());
            }
        }

        @Override
        public int getRowCount() {
            return this.as == null ? 0 : (int)this.as.length();
        }

        @Override
        public StructureData getStructureData(int row) {
            return this.as.get(new int[]{row});
        }

        @Override
        public void clear() {
            this.as = null;
            this.fireTableDataChanged();
        }
    }

    private static class SequenceModel
    extends StructureModel {
        protected List<StructureData> sdataList;

        SequenceModel(Sequence seq, boolean readData) {
            super((Structure)seq);
            if (readData) {
                this.sdataList = new ArrayList<StructureData>();
                try {
                    for (StructureData sdata : seq) {
                        this.sdataList.add(sdata);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.sdataList.size();
        }

        @Override
        public StructureData getStructureData(int row) {
            return this.sdataList.get(row);
        }

        @Override
        public Object getValueAt(int row, int column) {
            StructureMembers.Member member;
            StructureData sd = this.sdataList.get(row);
            Array value = sd.getMemberData(member = sd.getStructureMembers().getMember(column));
            return !(value instanceof StructureDataArray) ? value.getScalar() : "n=" + value.length();
        }

        @Override
        public void clear() {
            this.sdataList = new ArrayList<StructureData>();
            this.fireTableDataChanged();
        }
    }

    private static class StructureModel
    extends AbstractSATableModel {
        private Structure struct;

        StructureModel(Structure s) {
            this.struct = s;
            this.members = s.makeStructureMembersBuilder().build();
            for (Variable v : s.getVariables()) {
                if (!(v instanceof Structure)) continue;
                this.subtables.add(v.getShortName());
            }
        }

        @Override
        public int getRowCount() {
            if (this.struct == null) {
                return 0;
            }
            return (int)this.struct.getSize();
        }

        @Override
        public StructureData getStructureData(int row) throws InvalidRangeException, IOException {
            Array array = this.struct.readArray(Section.builder().appendRange(row, row).build());
            return (StructureData)array.getScalar();
        }

        @Override
        public void clear() {
            this.struct = null;
            this.fireTableDataChanged();
        }
    }

    private static abstract class AbstractSATableModel
    extends AbstractTableModel {
        protected StructureMembers members;
        protected boolean wantDate;
        protected List<String> subtables = new ArrayList<String>();
        private final LoadingCache<Integer, StructureData> cache = CacheBuilder.newBuilder().maximumSize(500L).build((CacheLoader)new CacheLoader<Integer, StructureData>(){

            public StructureData load(Integer row) {
                try {
                    return this.getStructureData(row);
                }
                catch (IOException | InvalidRangeException e) {
                    throw new IllegalStateException(e.getCause());
                }
            }
        });

        private AbstractSATableModel() {
        }

        public StructureData getStructureDataHash(int row) {
            try {
                return (StructureData)this.cache.get((Object)row);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e.getCause());
            }
        }

        public abstract StructureData getStructureData(int var1) throws InvalidRangeException, IOException;

        public abstract void clear();

        public CalendarDate getObsDate(int row) {
            return null;
        }

        public CalendarDate getNomDate(int row) {
            return null;
        }

        public Object getRow(int row) throws InvalidRangeException, IOException {
            return this.getStructureData(row);
        }

        @Override
        public int getColumnCount() {
            if (this.members == null) {
                return 0;
            }
            return this.members.getMembers().size() + (this.wantDate ? 2 : 0);
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (this.wantDate && columnIndex == 0) {
                return "obsDate";
            }
            if (this.wantDate && columnIndex == 1) {
                return "nomDate";
            }
            int memberCol = this.wantDate ? columnIndex - 2 : columnIndex;
            return this.members.getMember(memberCol).getName();
        }

        @Override
        public Object getValueAt(int row, int column) {
            String colName;
            if (this.wantDate && column == 0) {
                return this.getObsDate(row);
            }
            if (this.wantDate && column == 1) {
                return this.getNomDate(row);
            }
            StructureData sd = this.getStructureDataHash(row);
            Array data = sd.getMemberData(colName = this.getColumnName(column));
            if (data instanceof StructureDataArray) {
                return "len =" + data.length();
            }
            return data;
        }
    }

    private class SubtableAction
    extends AbstractAction {
        String memberName;
        StructureArrayTable dataTable;
        IndependentWindow dataWindow;

        SubtableAction(String parentName, String memberName) {
            this.memberName = memberName;
            String fullname = parentName + "/" + memberName;
            this.dataTable = new StructureArrayTable(null);
            this.dataWindow = windows.get(fullname);
            if (this.dataWindow == null) {
                this.dataWindow = new IndependentWindow("Data Array Table", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.dataTable);
                windows.put(fullname, this.dataWindow);
            } else {
                this.dataWindow.setComponent((Component)this.dataTable);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StructureData sd = StructureArrayTable.this.getSelectedStructureData();
            if (sd == null) {
                return;
            }
            StructureMembers members = sd.getStructureMembers();
            StructureMembers.Member m = members.findMember(this.memberName);
            if (m == null) {
                throw new IllegalStateException("cant find member = " + this.memberName);
            }
            if (m.getArrayType() != ArrayType.STRUCTURE && m.getArrayType() != ArrayType.SEQUENCE) {
                throw new IllegalStateException("data type = " + m.getArrayType());
            }
            StructureDataArray as = (StructureDataArray)sd.getMemberData(m);
            this.dataTable.setStructureData(as);
            this.dataWindow.show();
        }
    }
}

