/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Formatter;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.tools.DataFactory;
import thredds.ui.catalog.ThreddsUI;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.collection.Grib;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.internal.cache.FileCache;
import ucar.nc2.internal.cache.FileCacheIF;
import ucar.nc2.internal.iosp.hdf5.H5iosp;
import ucar.nc2.internal.ncml.Aggregation;
import ucar.nc2.internal.ncml.NcmlReader;
import ucar.nc2.internal.util.DiskCache2;
import ucar.nc2.internal.util.xml.RuntimeConfigParser;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.IO;
import ucar.nc2.write.NetcdfCopier;
import ucar.ui.DebugProxyHandler;
import ucar.ui.GetDataRunnable;
import ucar.ui.GetDataTask;
import ucar.ui.OpPanel;
import ucar.ui.ToolsSplashScreen;
import ucar.ui.bufr.BufrCdmIndexOpPanel;
import ucar.ui.bufr.BufrCodePanel;
import ucar.ui.bufr.BufrPanel;
import ucar.ui.bufr.BufrReportPanel;
import ucar.ui.bufr.BufrTableBPanel;
import ucar.ui.bufr.BufrTableDPanel;
import ucar.ui.dialog.DiskCache2Form;
import ucar.ui.grib.CdmIndexReportPanel;
import ucar.ui.grib.Grib1CollectionOpPanel;
import ucar.ui.grib.Grib1DataOpPanel;
import ucar.ui.grib.Grib1ReportPanel;
import ucar.ui.grib.Grib1TablePanel;
import ucar.ui.grib.Grib2CollectionOpPanel;
import ucar.ui.grib.Grib2DataOpPanel;
import ucar.ui.grib.Grib2ReportPanel;
import ucar.ui.grib.Grib2TablePanel;
import ucar.ui.grib.GribCodePanel;
import ucar.ui.grib.GribFilesOpPanel;
import ucar.ui.grib.GribIndexOpPanel;
import ucar.ui.grib.GribRewriteOpPanel;
import ucar.ui.grib.GribTemplatePanel;
import ucar.ui.grid.GridNewPanel;
import ucar.ui.menu.DebugMenu;
import ucar.ui.menu.HelpMenu;
import ucar.ui.menu.ModesMenu;
import ucar.ui.menu.SystemMenu;
import ucar.ui.op.AggPanel;
import ucar.ui.op.CdmIndexOpPanel;
import ucar.ui.op.CdmIndexScanOp;
import ucar.ui.op.CollectionSpecPanel;
import ucar.ui.op.CoordSysPanel;
import ucar.ui.op.DatasetViewerPanel;
import ucar.ui.op.DatasetWriterPanel;
import ucar.ui.op.DirectoryPartitionPanel;
import ucar.ui.op.FeatureScanOpPanel;
import ucar.ui.op.Hdf4Panel;
import ucar.ui.op.Hdf5DataPanel;
import ucar.ui.op.Hdf5ObjectPanel;
import ucar.ui.op.NCdumpPanel;
import ucar.ui.op.NcmlEditorPanel;
import ucar.ui.op.ReportOpPanel;
import ucar.ui.op.UnitsPanel;
import ucar.ui.op.WmoCCPanel;
import ucar.ui.op.WmsPanel;
import ucar.ui.prefs.Debug;
import ucar.ui.util.SocketMessage;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.ProgressMonitor;
import ucar.ui.widget.ProgressMonitorTask;
import ucar.ui.widget.URLDumpPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.http.ReadFromUrl;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;

public class ToolsUI
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DIALOG_VERSION = "7.0";
    public static final String WORLD_DETAIL_MAP = "/resources/ui/maps/Countries.shp";
    public static final String US_MAP = "/resources/ui/maps/us_state.shp";
    public static final String FRAME_SIZE = "FrameSize";
    private static ToolsUI ui;
    private static JFrame frame;
    private static PreferencesExt prefs;
    private static XMLStore store;
    private static boolean done;
    private static String wantDataset;
    private final JFrame parentFrame;
    private final FileManager fileChooser;
    private final FileManager dirChooser;
    private FileManager bufrFileChooser;
    private final JTabbedPane tabbedPane;
    private final JTabbedPane iospTabPane;
    private final JTabbedPane gribTabPane;
    private final JTabbedPane grib2TabPane;
    private final JTabbedPane grib1TabPane;
    private final JTabbedPane ftTabPane;
    private final JTabbedPane ncmlTabPane;
    private final PreferencesExt mainPrefs;
    private AggPanel aggPanel;
    private BufrPanel bufrPanel;
    private BufrTableBPanel bufrTableBPanel;
    private BufrTableDPanel bufrTableDPanel;
    private ReportOpPanel bufrReportPanel;
    private BufrCdmIndexOpPanel bufrCdmIndexPanel;
    private BufrCodePanel bufrCodePanel;
    private CdmIndexOpPanel cdmIndexPanel;
    private CdmIndexScanOp cdmIndexScanOp;
    private ReportOpPanel cdmIndexReportPanel;
    private CollectionSpecPanel fcPanel;
    private CoordSysPanel coordSysPanel;
    private final DatasetViewerPanel viewerPanel;
    private DatasetViewerPanel nc4viewer;
    private DatasetWriterPanel writerPanel;
    private DirectoryPartitionPanel dirPartPanel;
    private FeatureScanOpPanel ftPanel;
    private GribCodePanel gribCodePanel;
    private GribFilesOpPanel gribFilesPanel;
    private GribIndexOpPanel gribIdxPanel;
    private GribRewriteOpPanel gribRewritePanel;
    private GribTemplatePanel gribTemplatePanel;
    private Grib1CollectionOpPanel grib1CollectionPanel;
    private GridNewPanel gridNewPanel;
    private ReportOpPanel grib1ReportPanel;
    private Grib1TablePanel grib1TablePanel;
    private Grib2CollectionOpPanel grib2CollectionPanel;
    private Grib2TablePanel grib2TablePanel;
    private ReportOpPanel grib2ReportPanel;
    private Grib1DataOpPanel grib1DataPanel;
    private Grib2DataOpPanel grib2DataPanel;
    private Hdf5ObjectPanel hdf5ObjectPanel;
    private Hdf5DataPanel hdf5DataPanel;
    private Hdf4Panel hdf4Panel;
    private NCdumpPanel ncdumpPanel;
    private NcmlEditorPanel ncmlEditorPanel;
    private ThreddsUI threddsUI;
    private UnitsPanel unitsPanel;
    private URLDumpPane urlPanel;
    private WmoCCPanel wmoCommonCodePanel;
    private WmsPanel wmsPanel;
    private final DataFactory threddsDataFactory = new DataFactory();
    private boolean useRecordStructure;
    private boolean useBuilders = true;
    private DiskCache2Form diskCache2Form;
    private final DebugFlags debugFlags;
    private static final boolean debugListen = false;
    private String downloadStatus;

    private ToolsUI(PreferencesExt prefs, JFrame parentFrame) {
        this.mainPrefs = prefs;
        this.parentFrame = parentFrame;
        FileFilter[] filters = new FileFilter[]{new FileManager.HDF5ExtFilter(), new FileManager.NetcdfExtFilter()};
        this.fileChooser = new FileManager(parentFrame, null, filters, (PreferencesExt)prefs.node("FileManager"));
        this.dirChooser = new FileManager(parentFrame, null, null, (PreferencesExt)prefs.node("FeatureScanFileManager"));
        OpPanel.setFileChooser(this.fileChooser);
        this.tabbedPane = new JTabbedPane(1);
        this.iospTabPane = new JTabbedPane(1);
        this.gribTabPane = new JTabbedPane(1);
        this.grib2TabPane = new JTabbedPane(1);
        this.grib1TabPane = new JTabbedPane(1);
        JTabbedPane bufrTabPane = new JTabbedPane(1);
        this.ftTabPane = new JTabbedPane(1);
        JTabbedPane fcTabPane = new JTabbedPane(1);
        JTabbedPane hdf5TabPane = new JTabbedPane(1);
        this.ncmlTabPane = new JTabbedPane(1);
        this.viewerPanel = new DatasetViewerPanel((PreferencesExt)this.mainPrefs.node("varTable"));
        this.tabbedPane.addTab("Viewer", this.viewerPanel);
        this.tabbedPane.addTab("Writer", new JLabel("Writer"));
        this.tabbedPane.addTab("NCDump", new JLabel("NCDump"));
        this.tabbedPane.addTab("Iosp", this.iospTabPane);
        this.tabbedPane.addTab("CoordSys", new JLabel("CoordSys"));
        this.tabbedPane.addTab("FeatureTypes", this.ftTabPane);
        this.tabbedPane.addTab("THREDDS", new JLabel("THREDDS"));
        this.tabbedPane.addTab("Units", new JLabel("Units"));
        this.tabbedPane.addTab("NcML", this.ncmlTabPane);
        this.tabbedPane.addTab("URLdump", new JLabel("URLdump"));
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addChangeListener(e -> {
            Component c = this.tabbedPane.getSelectedComponent();
            if (c instanceof JLabel) {
                int idx = this.tabbedPane.getSelectedIndex();
                String title = this.tabbedPane.getTitleAt(idx);
                this.makeComponent(this.tabbedPane, title);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.iospTabPane.addTab("BUFR", bufrTabPane);
        this.iospTabPane.addTab("GRIB", this.gribTabPane);
        this.iospTabPane.addTab("GRIB2", this.grib2TabPane);
        this.iospTabPane.addTab("GRIB1", this.grib1TabPane);
        this.iospTabPane.addTab("HDF5", hdf5TabPane);
        this.iospTabPane.addTab("HDF4", new JLabel("HDF4"));
        this.addListeners(this.iospTabPane);
        bufrTabPane.addTab("BUFR", new JLabel("BUFR"));
        bufrTabPane.addTab("BufrCdmIndex", new JLabel("BufrCdmIndex"));
        bufrTabPane.addTab("BUFRTableB", new JLabel("BUFRTableB"));
        bufrTabPane.addTab("BUFRTableD", new JLabel("BUFRTableD"));
        bufrTabPane.addTab("BUFR-CODES", new JLabel("BUFR-CODES"));
        bufrTabPane.addTab("BufrReports", new JLabel("BufrReports"));
        this.addListeners(bufrTabPane);
        this.gribTabPane.addTab("CdmIndexScan", new JLabel("CdmIndexScan"));
        this.gribTabPane.addTab("CdmIndex4", new JLabel("CdmIndex4"));
        this.gribTabPane.addTab("CdmIndexReport", new JLabel("CdmIndexReport"));
        this.gribTabPane.addTab("GribIndex", new JLabel("GribIndex"));
        this.gribTabPane.addTab("WMO-COMMON", new JLabel("WMO-COMMON"));
        this.gribTabPane.addTab("WMO-CODES", new JLabel("WMO-CODES"));
        this.gribTabPane.addTab("WMO-TEMPLATES", new JLabel("WMO-TEMPLATES"));
        this.gribTabPane.addTab("GRIB-Rewrite", new JLabel("GRIB-Rewrite"));
        this.addListeners(this.gribTabPane);
        this.grib2TabPane.addTab("GRIB2collection", new JLabel("GRIB2collection"));
        this.grib2TabPane.addTab("GRIB2-REPORT", new JLabel("GRIB2-REPORT"));
        this.grib2TabPane.addTab("GRIB2data", new JLabel("GRIB2data"));
        this.grib2TabPane.addTab("GRIB2-TABLES", new JLabel("GRIB2-TABLES"));
        this.addListeners(this.grib2TabPane);
        this.grib1TabPane.addTab("GRIB1collection", new JLabel("GRIB1collection"));
        this.grib1TabPane.addTab("GRIB-FILES", new JLabel("GRIB-FILES"));
        this.grib1TabPane.addTab("GRIB1-REPORT", new JLabel("GRIB1-REPORT"));
        this.grib1TabPane.addTab("GRIB1data", new JLabel("GRIB1data"));
        this.grib1TabPane.addTab("GRIB1-TABLES", new JLabel("GRIB1-TABLES"));
        this.addListeners(this.grib1TabPane);
        hdf5TabPane.addTab("HDF5-Objects", new JLabel("HDF5-Objects"));
        hdf5TabPane.addTab("HDF5-Data", new JLabel("HDF5-Data"));
        hdf5TabPane.addTab("Netcdf4-JNI", new JLabel("Netcdf4-JNI"));
        this.addListeners(hdf5TabPane);
        this.ftTabPane.addTab("FeatureScan", new JLabel("FeatureScan"));
        this.ftTabPane.addTab("GridNew", new JLabel("GridNew"));
        this.ftTabPane.addTab("WMS", new JLabel("WMS"));
        this.ftTabPane.addTab("PointFeature", new JLabel("PointFeature"));
        this.ftTabPane.addTab("FeatureCollection", fcTabPane);
        this.addListeners(this.ftTabPane);
        fcTabPane.addTab("DirectoryPartition", new JLabel("DirectoryPartition"));
        fcTabPane.addTab("CollectionSpec", new JLabel("CollectionSpec"));
        this.addListeners(fcTabPane);
        this.ncmlTabPane.addTab("NcmlEditor", new JLabel("NcmlEditor"));
        this.ncmlTabPane.addTab("Aggregation", new JLabel("Aggregation"));
        this.addListeners(this.ncmlTabPane);
        this.debugFlags = (DebugFlags)Proxy.newProxyInstance(DebugFlags.class.getClassLoader(), new Class[]{DebugFlags.class}, (InvocationHandler)new DebugProxyHandler());
        JMenuBar mb = this.makeMenuBar();
        parentFrame.setJMenuBar(mb);
        this.setDebugFlags();
    }

    private void addListeners(final JTabbedPane tabPane) {
        tabPane.addChangeListener(e -> {
            Component c = tabPane.getSelectedComponent();
            if (c instanceof JLabel) {
                int idx = tabPane.getSelectedIndex();
                String title = tabPane.getTitleAt(idx);
                this.makeComponent(tabPane, title);
            }
        });
        tabPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Component c = tabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = tabPane.getSelectedIndex();
                    String title = tabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(tabPane, title);
                }
            }
        });
    }

    private void makeComponent(JTabbedPane parent, String title) {
        Object c;
        String cTitle;
        int idx;
        if (parent == null) {
            parent = this.tabbedPane;
        }
        int n = parent.getTabCount();
        for (idx = 0; idx < n && !(cTitle = parent.getTitleAt(idx)).equals(title); ++idx) {
        }
        if (idx >= n) {
            log.debug("Cant find {} in {}", (Object)title, (Object)parent);
            return;
        }
        switch (title) {
            case "Aggregation": {
                this.aggPanel = new AggPanel((PreferencesExt)this.mainPrefs.node("NcMLAggregation"));
                c = this.aggPanel;
                break;
            }
            case "BUFR": {
                this.bufrPanel = new BufrPanel((PreferencesExt)this.mainPrefs.node("bufr"));
                c = this.bufrPanel;
                break;
            }
            case "BUFRTableB": {
                this.bufrTableBPanel = new BufrTableBPanel((PreferencesExt)this.mainPrefs.node("bufr2"));
                c = this.bufrTableBPanel;
                break;
            }
            case "BUFRTableD": {
                this.bufrTableDPanel = new BufrTableDPanel((PreferencesExt)this.mainPrefs.node("bufrD"));
                c = this.bufrTableDPanel;
                break;
            }
            case "BufrReports": {
                PreferencesExt prefs = (PreferencesExt)this.mainPrefs.node("bufrReports");
                BufrReportPanel rp = new BufrReportPanel(prefs);
                this.bufrReportPanel = new ReportOpPanel(prefs, rp);
                c = this.bufrReportPanel;
                break;
            }
            case "BUFR-CODES": {
                this.bufrCodePanel = new BufrCodePanel((PreferencesExt)this.mainPrefs.node("bufr-codes"));
                c = this.bufrCodePanel;
                break;
            }
            case "CollectionSpec": {
                this.fcPanel = new CollectionSpecPanel((PreferencesExt)this.mainPrefs.node("collSpec"));
                c = this.fcPanel;
                break;
            }
            case "DirectoryPartition": {
                this.dirPartPanel = new DirectoryPartitionPanel((PreferencesExt)this.mainPrefs.node("dirPartition"));
                c = this.dirPartPanel;
                break;
            }
            case "GRIB1collection": {
                this.grib1CollectionPanel = new Grib1CollectionOpPanel((PreferencesExt)this.mainPrefs.node("grib1raw"));
                c = this.grib1CollectionPanel;
                break;
            }
            case "GRIB1data": {
                this.grib1DataPanel = new Grib1DataOpPanel((PreferencesExt)this.mainPrefs.node("grib1Data"));
                c = this.grib1DataPanel;
                break;
            }
            case "GRIB-FILES": {
                this.gribFilesPanel = new GribFilesOpPanel((PreferencesExt)this.mainPrefs.node("gribFiles"));
                c = this.gribFilesPanel;
                break;
            }
            case "GRIB2collection": {
                this.grib2CollectionPanel = new Grib2CollectionOpPanel((PreferencesExt)this.mainPrefs.node("gribNew"));
                c = this.grib2CollectionPanel;
                break;
            }
            case "GRIB2data": {
                this.grib2DataPanel = new Grib2DataOpPanel((PreferencesExt)this.mainPrefs.node("grib2Data"));
                c = this.grib2DataPanel;
                break;
            }
            case "BufrCdmIndex": {
                this.bufrCdmIndexPanel = new BufrCdmIndexOpPanel((PreferencesExt)this.mainPrefs.node("bufrCdmIdx"));
                c = this.bufrCdmIndexPanel;
                break;
            }
            case "CdmIndex4": {
                this.cdmIndexPanel = new CdmIndexOpPanel((PreferencesExt)this.mainPrefs.node("cdmIdx3"));
                c = this.cdmIndexPanel;
                break;
            }
            case "CdmIndexScan": {
                this.cdmIndexScanOp = new CdmIndexScanOp((PreferencesExt)this.mainPrefs.node("cdmIndexScan"), this.dirChooser);
                c = this.cdmIndexScanOp;
                break;
            }
            case "CdmIndexReport": {
                PreferencesExt prefs = (PreferencesExt)this.mainPrefs.node("CdmIndexReport");
                CdmIndexReportPanel rp = new CdmIndexReportPanel(prefs);
                this.cdmIndexReportPanel = new ReportOpPanel(prefs, rp);
                c = this.cdmIndexReportPanel;
                break;
            }
            case "GribIndex": {
                this.gribIdxPanel = new GribIndexOpPanel((PreferencesExt)this.mainPrefs.node("gribIdx"));
                c = this.gribIdxPanel;
                break;
            }
            case "GRIB1-REPORT": {
                PreferencesExt prefs = (PreferencesExt)this.mainPrefs.node("grib1Report");
                Grib1ReportPanel rp = new Grib1ReportPanel(prefs);
                this.grib1ReportPanel = new ReportOpPanel(prefs, rp);
                c = this.grib1ReportPanel;
                break;
            }
            case "GRIB2-REPORT": {
                PreferencesExt prefs = (PreferencesExt)this.mainPrefs.node("gribReport");
                Grib2ReportPanel rp = new Grib2ReportPanel(prefs);
                this.grib2ReportPanel = new ReportOpPanel(prefs, rp);
                c = this.grib2ReportPanel;
                break;
            }
            case "WMO-COMMON": {
                this.wmoCommonCodePanel = new WmoCCPanel((PreferencesExt)this.mainPrefs.node("wmo-common"));
                c = this.wmoCommonCodePanel;
                break;
            }
            case "WMO-CODES": {
                this.gribCodePanel = new GribCodePanel((PreferencesExt)this.mainPrefs.node("wmo-codes"));
                c = this.gribCodePanel;
                break;
            }
            case "WMO-TEMPLATES": {
                this.gribTemplatePanel = new GribTemplatePanel((PreferencesExt)this.mainPrefs.node("wmo-templates"));
                c = this.gribTemplatePanel;
                break;
            }
            case "GRIB1-TABLES": {
                this.grib1TablePanel = new Grib1TablePanel((PreferencesExt)this.mainPrefs.node("grib1-tables"));
                c = this.grib1TablePanel;
                break;
            }
            case "GRIB2-TABLES": {
                this.grib2TablePanel = new Grib2TablePanel((PreferencesExt)this.mainPrefs.node("grib2-tables"));
                c = this.grib2TablePanel;
                break;
            }
            case "GRIB-Rewrite": {
                this.gribRewritePanel = new GribRewriteOpPanel((PreferencesExt)this.mainPrefs.node("grib-rewrite"));
                c = this.gribRewritePanel;
                break;
            }
            case "CoordSys": {
                this.coordSysPanel = new CoordSysPanel((PreferencesExt)this.mainPrefs.node("CoordSys"));
                c = this.coordSysPanel;
                break;
            }
            case "FeatureScan": {
                this.ftPanel = new FeatureScanOpPanel((PreferencesExt)this.mainPrefs.node("ftPanel"), this.dirChooser);
                c = this.ftPanel;
                break;
            }
            case "GridNew": {
                this.gridNewPanel = new GridNewPanel((PreferencesExt)this.mainPrefs.node("grid2Panel"));
                c = this.gridNewPanel;
                break;
            }
            case "HDF5-Objects": {
                this.hdf5ObjectPanel = new Hdf5ObjectPanel((PreferencesExt)this.mainPrefs.node("hdf5"), this.useBuilders);
                c = this.hdf5ObjectPanel;
                break;
            }
            case "HDF5-Data": {
                this.hdf5DataPanel = new Hdf5DataPanel((PreferencesExt)this.mainPrefs.node("hdf5data"));
                c = this.hdf5DataPanel;
                break;
            }
            case "Netcdf4-JNI": {
                c = this.nc4viewer = new DatasetViewerPanel((PreferencesExt)this.mainPrefs.node("nc4viewer"));
                break;
            }
            case "HDF4": {
                this.hdf4Panel = new Hdf4Panel((PreferencesExt)this.mainPrefs.node("hdf4"), this.useBuilders);
                c = this.hdf4Panel;
                break;
            }
            case "NCDump": {
                this.ncdumpPanel = new NCdumpPanel((PreferencesExt)this.mainPrefs.node("NCDump"));
                c = this.ncdumpPanel;
                break;
            }
            case "NcmlEditor": {
                this.ncmlEditorPanel = new NcmlEditorPanel((PreferencesExt)this.mainPrefs.node("NcmlEditor"));
                c = this.ncmlEditorPanel;
                break;
            }
            case "THREDDS": {
                this.threddsUI = new ThreddsUI(this.parentFrame, (PreferencesExt)this.mainPrefs.node("thredds"));
                this.threddsUI.addPropertyChangeListener(e -> {
                    if (e.getPropertyName().equals("InvAccess")) {
                        Access access = (Access)e.getNewValue();
                        this.jumptoThreddsDatatype(access);
                    }
                    if (e.getPropertyName().equals("Dataset") || e.getPropertyName().equals("CoordSys") || e.getPropertyName().equals("File")) {
                        Dataset ds = (Dataset)e.getNewValue();
                        this.setThreddsDatatype(ds, e.getPropertyName());
                    }
                });
                c = this.threddsUI;
                break;
            }
            case "Units": {
                this.unitsPanel = new UnitsPanel((PreferencesExt)this.mainPrefs.node("units"));
                c = this.unitsPanel;
                break;
            }
            case "URLdump": {
                this.urlPanel = new URLDumpPane((PreferencesExt)this.mainPrefs.node("urlDump"));
                c = this.urlPanel;
                break;
            }
            case "Viewer": {
                c = this.viewerPanel;
                break;
            }
            case "Writer": {
                this.writerPanel = new DatasetWriterPanel((PreferencesExt)this.mainPrefs.node("writer"));
                c = this.writerPanel;
                break;
            }
            case "WMS": {
                this.wmsPanel = new WmsPanel((PreferencesExt)this.mainPrefs.node("wms"));
                c = this.wmsPanel;
                break;
            }
            default: {
                log.warn("tabbedPane unknown component {}", (Object)title);
                return;
            }
        }
        parent.setComponentAt(idx, (Component)c);
        log.trace("tabbedPane changed {} added ", (Object)title);
    }

    private JMenuBar makeMenuBar() {
        JMenuBar mb = new JMenuBar();
        SystemMenu sysMenu = new SystemMenu(this);
        mb.add(sysMenu);
        ModesMenu modeMenu = new ModesMenu(this);
        mb.add(modeMenu);
        DebugMenu debugMenu = new DebugMenu(this);
        mb.add(debugMenu);
        HelpMenu helpMenu = new HelpMenu(this);
        mb.add(helpMenu);
        return mb;
    }

    public DatasetViewerPanel getDatasetViewerPanel() {
        return this.viewerPanel;
    }

    public void setDebugFlags() {
        log.debug("setDebugFlags");
        NetcdfFile.setDebugFlags((DebugFlags)this.debugFlags);
        H5iosp.setDebugFlags((DebugFlags)this.debugFlags);
        NcmlReader.setDebugFlags((DebugFlags)this.debugFlags);
        DataFactory.setDebugFlags((DebugFlags)this.debugFlags);
        NetcdfCopier.setDebugFlags((DebugFlags)this.debugFlags);
        Grib.setDebugFlags((DebugFlags)this.debugFlags);
    }

    public void setUseRecordStructure(boolean use) {
        this.useRecordStructure = use;
    }

    public void setUseBuilders(boolean use) {
        this.useBuilders = use;
    }

    public boolean getUseBuilders() {
        return this.useBuilders;
    }

    public void setGribDiskCache() {
        if (this.diskCache2Form == null) {
            this.diskCache2Form = new DiskCache2Form((Frame)this.parentFrame, GribIndexCache.getDiskCache2());
        }
        this.diskCache2Form.setVisible(true);
    }

    private void save() {
        this.fileChooser.save();
        if (this.aggPanel != null) {
            this.aggPanel.save();
        }
        if (this.bufrFileChooser != null) {
            this.bufrFileChooser.save();
        }
        if (this.bufrPanel != null) {
            this.bufrPanel.save();
        }
        if (this.bufrTableBPanel != null) {
            this.bufrTableBPanel.save();
        }
        if (this.bufrTableDPanel != null) {
            this.bufrTableDPanel.save();
        }
        if (this.bufrReportPanel != null) {
            this.bufrReportPanel.save();
        }
        if (this.bufrCodePanel != null) {
            this.bufrCodePanel.save();
        }
        if (this.coordSysPanel != null) {
            this.coordSysPanel.save();
        }
        if (this.cdmIndexPanel != null) {
            this.cdmIndexPanel.save();
        }
        if (this.cdmIndexScanOp != null) {
            this.cdmIndexScanOp.save();
        }
        if (this.cdmIndexReportPanel != null) {
            this.cdmIndexReportPanel.save();
        }
        if (this.dirPartPanel != null) {
            this.dirPartPanel.save();
        }
        if (this.bufrCdmIndexPanel != null) {
            this.bufrCdmIndexPanel.save();
        }
        if (this.fcPanel != null) {
            this.fcPanel.save();
        }
        if (this.ftPanel != null) {
            this.ftPanel.save();
        }
        if (this.gribFilesPanel != null) {
            this.gribFilesPanel.save();
        }
        if (this.grib2CollectionPanel != null) {
            this.grib2CollectionPanel.save();
        }
        if (this.grib2DataPanel != null) {
            this.grib2DataPanel.save();
        }
        if (this.grib1DataPanel != null) {
            this.grib1DataPanel.save();
        }
        if (this.gribCodePanel != null) {
            this.gribCodePanel.save();
        }
        if (this.gribIdxPanel != null) {
            this.gribIdxPanel.save();
        }
        if (this.gribTemplatePanel != null) {
            this.gribTemplatePanel.save();
        }
        if (this.grib1CollectionPanel != null) {
            this.grib1CollectionPanel.save();
        }
        if (this.grib1ReportPanel != null) {
            this.grib1ReportPanel.save();
        }
        if (this.grib2ReportPanel != null) {
            this.grib2ReportPanel.save();
        }
        if (this.grib1TablePanel != null) {
            this.grib1TablePanel.save();
        }
        if (this.grib2TablePanel != null) {
            this.grib2TablePanel.save();
        }
        if (this.gribRewritePanel != null) {
            this.gribRewritePanel.save();
        }
        if (this.gridNewPanel != null) {
            this.gridNewPanel.save();
        }
        if (this.hdf5ObjectPanel != null) {
            this.hdf5ObjectPanel.save();
        }
        if (this.hdf5DataPanel != null) {
            this.hdf5DataPanel.save();
        }
        if (this.hdf4Panel != null) {
            this.hdf4Panel.save();
        }
        if (this.ncdumpPanel != null) {
            this.ncdumpPanel.save();
        }
        if (this.nc4viewer != null) {
            this.nc4viewer.save();
        }
        if (this.ncmlEditorPanel != null) {
            this.ncmlEditorPanel.save();
        }
        if (this.threddsUI != null) {
            this.threddsUI.storePersistentData();
        }
        if (this.unitsPanel != null) {
            this.unitsPanel.save();
        }
        if (this.urlPanel != null) {
            this.urlPanel.save();
        }
        if (this.viewerPanel != null) {
            this.viewerPanel.save();
        }
        if (this.writerPanel != null) {
            this.writerPanel.save();
        }
        if (this.wmoCommonCodePanel != null) {
            this.wmoCommonCodePanel.save();
        }
        if (this.wmsPanel != null) {
            this.wmsPanel.save();
        }
    }

    public static ToolsUI getToolsUI() {
        return ui;
    }

    public static JFrame getToolsFrame() {
        return ui.getFramePriv();
    }

    private JFrame getFramePriv() {
        return this.parentFrame;
    }

    public static FileManager getBufrFileChooser() {
        return ui.getBufrFileChooserPriv();
    }

    private FileManager getBufrFileChooserPriv() {
        if (this.bufrFileChooser == null) {
            this.bufrFileChooser = new FileManager(this.parentFrame, null, null, (PreferencesExt)this.mainPrefs.node("bufrFileManager"));
        }
        return this.bufrFileChooser;
    }

    public static void setNCdumpPanel(NetcdfFile ds) {
        ui.setNCdumpPanelPriv(ds);
    }

    private void setNCdumpPanelPriv(NetcdfFile ds) {
        if (this.ncdumpPanel == null) {
            log.debug("make ncdumpPanel");
            this.makeComponent(this.tabbedPane, "NCDump");
        }
        this.ncdumpPanel.setNetcdfFile(ds);
        this.tabbedPane.setSelectedComponent(this.ncdumpPanel);
    }

    public void openNetcdfFile(String datasetName) {
        this.makeComponent(this.tabbedPane, "Viewer");
        this.viewerPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.viewerPanel);
    }

    public void openNetcdfFile(NetcdfFile ncfile) {
        this.makeComponent(this.tabbedPane, "Viewer");
        this.viewerPanel.setDataset(ncfile);
        this.tabbedPane.setSelectedComponent(this.viewerPanel);
    }

    public void openCoordSystems(String datasetName) {
        this.makeComponent(this.tabbedPane, "CoordSys");
        this.coordSysPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.coordSysPanel);
    }

    public void openCoordSystems(NetcdfDataset dataset) {
        this.makeComponent(this.tabbedPane, "CoordSys");
        this.coordSysPanel.setDataset(dataset);
        this.tabbedPane.setSelectedComponent(this.coordSysPanel);
    }

    public void openNcML(String datasetName) {
        this.makeComponent(this.ncmlTabPane, "NcmlEditor");
        this.ncmlEditorPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ncmlTabPane);
        this.ncmlTabPane.setSelectedComponent(this.ncmlEditorPanel);
    }

    public void openGrib1Collection(String collection) {
        this.makeComponent(this.grib1TabPane, "GRIB1collection");
        this.grib1CollectionPanel.setCollection(collection);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib1TabPane);
        this.grib1TabPane.setSelectedComponent(this.grib1CollectionPanel);
    }

    public void openGrib2Collection(String collection) {
        this.makeComponent(this.grib2TabPane, "GRIB2collection");
        this.grib2CollectionPanel.setCollection(collection);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib2TabPane);
        this.grib2TabPane.setSelectedComponent(this.grib2CollectionPanel);
    }

    public void openGrib2Data(String datasetName) {
        this.makeComponent(this.grib2TabPane, "GRIB2data");
        this.grib2DataPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib2TabPane);
        this.grib2TabPane.setSelectedComponent(this.grib2DataPanel);
    }

    public void openGrib1Data(String datasetName) {
        this.makeComponent(this.grib1TabPane, "GRIB1data");
        this.grib1DataPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib1TabPane);
        this.grib1TabPane.setSelectedComponent(this.grib1DataPanel);
    }

    public void openNewGrid(String datasetName) {
        this.makeComponent(this.ftTabPane, "GridNew");
        this.gridNewPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.gridNewPanel);
    }

    public void openGridDataset(NetcdfDataset dataset) {
        this.makeComponent(this.ftTabPane, "Grids");
        this.gridNewPanel.setNetcdfDataset(dataset);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.gridNewPanel);
    }

    private void openWMSDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "WMS");
        this.wmsPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.wmsPanel);
    }

    public void openIndexFile(String datasetName) {
        this.makeComponent(this.gribTabPane, "CdmIndex4");
        this.cdmIndexPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.gribTabPane);
        this.gribTabPane.setSelectedComponent(this.cdmIndexPanel);
    }

    private void setThreddsDatatype(Dataset invDataset, String wants) {
        if (invDataset == null) {
            return;
        }
        boolean wantsViewer = wants.equals("File");
        boolean wantsCoordSys = wants.equals("CoordSys");
        try {
            if (wantsViewer) {
                this.openNetcdfFile((NetcdfFile)this.threddsDataFactory.openDataset(invDataset, true, null, null));
                return;
            }
            if (wantsCoordSys) {
                NetcdfDataset ncd = this.threddsDataFactory.openDataset(invDataset, true, null, null);
                ncd = NetcdfDatasets.enhance((NetcdfFile)ncd, (Set)NetcdfDataset.getDefaultEnhanceMode(), null);
                this.openCoordSystems(ncd);
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Error on setThreddsDatatype = " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    private void jumptoThreddsDatatype(Access invAccess) {
        if (invAccess == null) {
            return;
        }
        Service s = invAccess.getService();
        if (s.getType() == ServiceType.HTTPServer) {
            this.downloadFile(invAccess.getStandardUrlName());
            return;
        }
        if (s.getType() == ServiceType.WMS) {
            this.openWMSDataset(invAccess.getStandardUrlName());
            return;
        }
        Dataset ds = invAccess.getDataset();
        if (ds.getFeatureType() == null) {
            try {
                this.openNetcdfFile((NetcdfFile)this.threddsDataFactory.openDataset(invAccess, true, null, null));
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, "Error on setThreddsDatatype = " + ioe.getMessage());
            }
            return;
        }
        try {
            DataFactory.Result threddsDataset = this.threddsDataFactory.openThreddsDataset(ds, null);
            if (threddsDataset.fatalError) {
                JOptionPane.showMessageDialog(null, "Failed to open err=" + threddsDataset.errLog);
                return;
            }
            this.jumptoThreddsDatatype(threddsDataset);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error on setThreddsDatatype = " + ioe.getMessage());
        }
    }

    private void jumptoThreddsDatatype(DataFactory.Result threddsData) {
        if (threddsData.fatalError) {
            JOptionPane.showMessageDialog(this, "Cant open dataset=" + threddsData.errLog);
            try {
                threddsData.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        if (threddsData.featureType.isCoverageFeatureType()) {
            this.makeComponent(this.ftTabPane, "Grids");
            this.gridNewPanel.setDataset(threddsData.featureDataset);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.gridNewPanel);
        }
    }

    public NetcdfFile openFile(String location, boolean addCoords, CancelTask task) {
        Object ncfile = null;
        String iospMessage = this.useRecordStructure ? "AddRecordStructure" : null;
        try {
            DatasetUrl durl = DatasetUrl.findDatasetUrl((String)location);
            ncfile = addCoords ? NetcdfDatasets.acquireDataset(null, (DatasetUrl)durl, (Set)NetcdfDataset.getDefaultEnhanceMode(), (int)-1, (CancelTask)task, (Object)iospMessage) : NetcdfDatasets.acquireFile((DatasetUrl)durl, (CancelTask)task);
            if (ncfile == null) {
                JOptionPane.showMessageDialog(null, "NetcdfDatasets.open cannot open " + location);
            } else if (this.useRecordStructure) {
                ncfile.sendIospMessage((Object)"AddRecordStructure");
            }
        }
        catch (IOException ioe) {
            String message = ioe.getMessage();
            if (null == message && ioe instanceof EOFException) {
                message = "Premature End of File";
            }
            JOptionPane.showMessageDialog(null, "NetcdfDatasets.open cannot open " + location + "\n" + message);
            if (!(ioe instanceof FileNotFoundException)) {
                ioe.printStackTrace();
            }
            ncfile = null;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter(5000);
            if (e.getCause() != null) {
                e.getCause().printStackTrace(new PrintWriter(sw));
            } else {
                e.printStackTrace(new PrintWriter(sw));
            }
            JOptionPane.showMessageDialog(null, "NetcdfDatasets.open cannot open " + location + "\n" + sw.toString());
            log.error("NetcdfDatasets.open cannot open " + location, (Throwable)e);
            try {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
            catch (IOException ee) {
                System.out.printf("close failed%n", new Object[0]);
            }
            ncfile = null;
        }
        return ncfile;
    }

    private void downloadFile(String urlString) {
        int pos = urlString.lastIndexOf(47);
        String defFilename = pos >= 0 ? urlString.substring(pos) : urlString;
        String fileOutName = this.fileChooser.chooseFilename(defFilename);
        if (fileOutName == null) {
            return;
        }
        String[] values = new String[]{fileOutName, urlString};
        GetDataRunnable runner = new GetDataRunnable(){

            @Override
            public void run(Object o) {
                String[] values = (String[])o;
                try (FileOutputStream fos = new FileOutputStream(values[0]);){
                    BufferedOutputStream out = new BufferedOutputStream(fos, 60000);
                    ReadFromUrl.copyUrlB((String)values[1], (OutputStream)out, (int)60000);
                    ToolsUI.this.downloadStatus = values[1] + " written to " + values[0];
                }
                catch (IOException ioe) {
                    ToolsUI.this.downloadStatus = "Error opening " + values[0] + " and reading " + values[1] + "%n" + ioe.getMessage();
                }
            }
        };
        GetDataTask task = new GetDataTask(runner, urlString, values);
        ProgressMonitor pm = new ProgressMonitor((ProgressMonitorTask)task);
        pm.addActionListener(e -> {
            JOptionPane.showMessageDialog(null, e.getActionCommand() + "%n" + this.downloadStatus);
            this.downloadStatus = null;
        });
        pm.start((Component)this, "Download", 30);
    }

    public static void exit() {
        ToolsUI.doSavePrefsAndUI();
        System.exit(0);
    }

    private static void doSavePrefsAndUI() {
        ui.save();
        Rectangle bounds = frame.getBounds();
        prefs.putBeanObject(FRAME_SIZE, (Object)bounds);
        try {
            store.save();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        done = true;
        FileCacheIF cache = NetcdfDatasets.getNetcdfFileCache();
        if (cache != null) {
            cache.clearCache(true);
        }
        FileCache.shutdown();
        DiskCache2.exit();
    }

    private static void setDataset() {
        SwingUtilities.invokeLater(() -> {
            int pos = wantDataset.indexOf(35);
            if (pos > 0) {
                String catName = wantDataset.substring(0, pos);
                if (catName.endsWith(".xml")) {
                    ui.makeComponent(null, "THREDDS");
                    ToolsUI.ui.threddsUI.setDataset(wantDataset);
                    ToolsUI.ui.tabbedPane.setSelectedComponent(ToolsUI.ui.threddsUI);
                }
                return;
            }
            ui.openNetcdfFile(wantDataset);
        });
    }

    private static void prepareGui() {
        block5: {
            String osName = System.getProperty("os.name").toLowerCase();
            boolean isMacOs = osName.startsWith("mac os x");
            if (isMacOs) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                Runtime.getRuntime().addShutdownHook(new Thread(ToolsUI::doSavePrefsAndUI));
            } else {
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Nimbus".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                }
                catch (Exception exc) {
                    log.warn("Unable to apply Nimbus look-and-feel due to {}", (Object)exc.toString());
                    if (!log.isTraceEnabled()) break block5;
                    exc.printStackTrace();
                }
            }
        }
        SwingUtilities.invokeLater(() -> {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Font f = new Font("SansSerif", 0, 12);
            FontMetrics fm = tk.getFontMetrics(f);
        });
    }

    private static void createToolsFrame() {
        frame = new JFrame("NetCDF (7.0) Tools");
        ui = new ToolsUI(prefs, frame);
        frame.setIconImage(BAMutil.getImage((String)"nj22/NetcdfUI"));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                ToolsSplashScreen.getSharedInstance().setVisible(false);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (!done) {
                    ToolsUI.exit();
                }
            }
        });
        frame.getContentPane().add(ui);
        Rectangle have = frame.getGraphicsConfiguration().getBounds();
        Rectangle def = new Rectangle(50, 50, 800, 800);
        Rectangle want = (Rectangle)prefs.getBean(FRAME_SIZE, (Object)def);
        if (want.getX() > have.getWidth() - 25.0) {
            want = def;
        }
        frame.setBounds(want);
        frame.pack();
        frame.setBounds(want);
        if (wantDataset != null) {
            ToolsUI.setDataset();
        }
    }

    public static void main(String[] args) {
        String filename;
        File f;
        Formatter errlog;
        if (args.length > 0) {
            StringBuilder sbuff = new StringBuilder();
            for (String arg : args) {
                sbuff.append(arg);
                sbuff.append(" ");
            }
            String arguments = sbuff.toString();
            System.out.println("ToolsUI arguments=" + arguments);
            SocketMessage sm = new SocketMessage(14444, wantDataset);
            if (sm.isAlreadyRunning()) {
                log.error("ToolsUI already running - pass argument='{}' and exit", (Object)arguments);
                System.exit(0);
            }
        } else {
            SocketMessage sm = new SocketMessage(14444, null);
            if (sm.isAlreadyRunning()) {
                System.out.println("ToolsUI already running - start up another copy");
            } else {
                sm.addEventListener(event -> {
                    wantDataset = event.getMessage();
                    ToolsUI.setDataset();
                });
            }
        }
        boolean configRead = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-nj22Config") || i >= args.length - 1) continue;
            String runtimeConfig = args[i + 1];
            ++i;
            try (FileInputStream fis = new FileInputStream(runtimeConfig);){
                errlog = new Formatter();
                RuntimeConfigParser.read((InputStream)fis, (Formatter)errlog);
                configRead = true;
                System.out.println(errlog);
                continue;
            }
            catch (IOException ioe) {
                log.warn("Error reading {} = {}", (Object)runtimeConfig, (Object)ioe.getMessage());
            }
        }
        if (!configRead && (f = new File(filename = XMLStore.makeStandardFilename((String)".unidata", (String)"nj22Config.xml"))).exists()) {
            try (FileInputStream fis = new FileInputStream(filename);){
                errlog = new Formatter();
                RuntimeConfigParser.read((InputStream)fis, (Formatter)errlog);
                System.out.println(errlog);
            }
            catch (IOException ioe) {
                log.warn("Error reading {} = {}", (Object)filename, (Object)ioe.getMessage());
            }
        }
        try {
            String prefStoreBack;
            File prefs43;
            String prefStore = XMLStore.makeStandardFilename((String)".unidata", (String)"ToolsUI.xml");
            File prefs44 = new File(prefStore);
            if (!prefs44.exists() && (prefs43 = new File(prefStoreBack = XMLStore.makeStandardFilename((String)".unidata", (String)"NetcdfUI22.xml"))).exists()) {
                IO.copyFile((File)prefs43, (File)prefs44);
            }
            store = XMLStore.createFromFile((String)prefStore, null);
            prefs = store.getPreferences();
            Debug.setStore((Preferences)prefs.node("Debug"));
        }
        catch (IOException e) {
            log.warn("XMLStore creation failed - {}", (Object)e.toString());
        }
        ToolsUI.prepareGui();
        SwingUtilities.invokeLater(() -> ToolsSplashScreen.getSharedInstance().setVisible(true));
        Aggregation.setPersistenceCache((DiskCache2)new DiskCache2("/.unidata/aggCache", true, 43200, 60));
        RandomAccessFile.enableDefaultGlobalFileCache();
        GribCdmIndex.initDefaultCollectionCache((int)100, (int)200, (int)-1);
        try {
            Thread.sleep(2500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(() -> {
            ToolsUI.createToolsFrame();
            frame.setVisible(true);
        });
    }
}

