/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.bufr;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import ucar.ui.OpPanel;
import ucar.ui.bufr.BufrMessageViewer;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class BufrPanel
extends OpPanel {
    private RandomAccessFile raf;
    private final BufrMessageViewer bufrTable;

    public BufrPanel(PreferencesExt p) {
        super(p, "file:", true, false);
        this.bufrTable = new BufrMessageViewer(this.prefs, this.buttPanel);
        this.add((Component)this.bufrTable, "Center");
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            if (this.raf != null) {
                this.raf.close();
            }
            this.raf = new RandomAccessFile(command, "r");
            this.bufrTable.setBufrFile(this.raf);
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset cannot open " + command + "\n" + ioe.getMessage());
            err = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = null;
    }

    @Override
    public void save() {
        this.bufrTable.save();
        super.save();
    }
}

