/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.bufr;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.ui.OpPanel;
import ucar.ui.ToolsUI;
import ucar.ui.bufr.BufrTableDViewer;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.util.prefs.PreferencesExt;

public class BufrTableDPanel
extends OpPanel {
    private final BufrTableDViewer bufrTable;
    private final JComboBox<BufrTables.Format> modes;
    private final JComboBox<BufrTables.TableConfig> tables;

    public BufrTableDPanel(PreferencesExt p) {
        super(p, "tableD:", false, false);
        AbstractAction fileAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileManager bufrFileChooser = ToolsUI.getBufrFileChooser();
                String filename = bufrFileChooser.chooseFilename();
                if (filename == null) {
                    return;
                }
                BufrTableDPanel.this.cb.setSelectedItem((Object)filename);
            }
        };
        BAMutil.setActionProperties((AbstractAction)fileAction, (String)"FileChooser", (String)"open Local table...", (boolean)false, (int)76, (int)-1);
        BAMutil.addActionToContainer((Container)this.buttPanel, (Action)fileAction);
        this.modes = new JComboBox<BufrTables.Format>(BufrTables.Format.values());
        this.buttPanel.add(this.modes);
        JButton acceptButton = new JButton("Accept");
        this.buttPanel.add(acceptButton);
        acceptButton.addActionListener(e -> this.accept());
        this.tables = new JComboBox<BufrTables.TableConfig>(BufrTables.getTableConfigsAsArray());
        this.buttPanel.add(this.tables);
        this.tables.addActionListener(e -> this.acceptTable((BufrTables.TableConfig)this.tables.getSelectedItem()));
        this.bufrTable = new BufrTableDViewer(this.prefs, this.buttPanel);
        this.add((Component)this.bufrTable, "Center");
    }

    @Override
    public boolean process(Object command) {
        return true;
    }

    @Override
    public void closeOpenFiles() {
    }

    private void accept() {
        String command = (String)this.cb.getSelectedItem();
        if (command == null) {
            return;
        }
        try {
            Object mode = this.modes.getSelectedItem();
            this.bufrTable.setBufrTableD(command, (BufrTables.Format)mode);
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "BufrTableViewer cannot open " + command + "\n" + ioe.getMessage());
            this.detailTA.setText("Failed to open <" + command + ">\n" + ioe.getMessage());
            this.detailTA.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailTA.setVisible(true);
        }
    }

    private void acceptTable(BufrTables.TableConfig tc) {
        try {
            this.bufrTable.setBufrTableD(tc.getTableDname(), tc.getTableDformat());
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "BufrTableViewer cannot open " + tc + "\n" + ioe.getMessage());
            this.detailTA.setText("Failed to open <" + tc + ">\n" + ioe.getMessage());
            this.detailTA.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailTA.setVisible(true);
        }
    }

    @Override
    public void save() {
        this.bufrTable.save();
        super.save();
    }
}

