/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.bufr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.array.ArrayType;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.bufr.tables.TableD;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class BufrTableDViewer
extends JPanel {
    private final PreferencesExt prefs;
    private final BeanTable<DdsBean> ddsTable;
    private final BeanTable<DdsBean> variantTable;
    private final JSplitPane split;
    private final TextHistoryPane compareTA;
    private final IndependentWindow infoWindow;
    private TableD currTable;
    private HashMap<Short, List<String>> usedDds;
    private HashMap<Short, List<DdsBean>> allVariants;
    private Set<String> variantKeys;
    private boolean standardVariantsLoaded;

    public BufrTableDViewer(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.compareTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.compareTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 800, 600)));
        this.ddsTable = new BeanTable(DdsBean.class, (PreferencesExt)prefs.node("DdsBean"), false);
        this.ddsTable.addListSelectionListener(e -> {
            DdsBean csb = (DdsBean)this.ddsTable.getSelectedBean();
            this.showVariants(csb);
        });
        this.variantTable = new BeanTable(DdsBean.class, (PreferencesExt)prefs.node("VariantBean"), false);
        PopupMenu varPopup = new PopupMenu((JComponent)this.ddsTable.getJTable(), "Options");
        varPopup.addAction("Show uses", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list;
                Formatter out = new Formatter();
                DdsBean csb = (DdsBean)BufrTableDViewer.this.ddsTable.getSelectedBean();
                if (BufrTableDViewer.this.usedDds != null && csb != null && (list = BufrTableDViewer.this.usedDds.get(csb.dds.getId())) != null) {
                    for (String use : list) {
                        out.format(" %s%n", use);
                    }
                }
                BufrTableDViewer.this.compareTA.setText(out.toString());
                BufrTableDViewer.this.compareTA.gotoTop();
                BufrTableDViewer.this.infoWindow.setVisible(true);
            }
        });
        varPopup = new PopupMenu((JComponent)this.variantTable.getJTable(), "Options");
        varPopup.addAction("Show", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter out = new Formatter();
                DdsBean ddsBean = (DdsBean)BufrTableDViewer.this.variantTable.getSelectedBean();
                if (ddsBean != null) {
                    ddsBean.dds.show(out, false);
                }
                BufrTableDViewer.this.compareTA.setText(out.toString());
                BufrTableDViewer.this.compareTA.gotoTop();
                BufrTableDViewer.this.infoWindow.setVisible(true);
            }
        });
        AbstractButton compareButton = BAMutil.makeButtcon((String)"Select", (String)"Compare to standard table", (boolean)false);
        compareButton.addActionListener(e -> {
            try {
                Formatter out = new Formatter();
                TableD wmoTable = BufrTables.getWmoTableD((int)13);
                if (wmoTable != null) {
                    this.compare(this.currTable, wmoTable, out);
                }
                this.compareTA.setText(out.toString());
                this.compareTA.gotoTop();
                this.infoWindow.setVisible(true);
            }
            catch (Throwable ioe) {
                StringWriter sw = new StringWriter(10000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.compareTA.setText(sw.toString());
                this.compareTA.gotoTop();
                this.infoWindow.setVisible(true);
                ioe.printStackTrace();
            }
        });
        buttPanel.add(compareButton);
        this.split = new JSplitPane(0, false, (Component)this.ddsTable, (Component)this.variantTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.ddsTable.saveState(false);
        this.variantTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void setBufrTableD(String filename, BufrTables.Format format) throws IOException {
        TableD tableD = BufrTables.readTableD((String)filename, (BufrTables.Format)format, (boolean)true);
        int pos = filename.lastIndexOf("/");
        String src = pos > 0 ? filename.substring(pos + 1) : filename;
        ArrayList listDesc = new ArrayList(tableD.getDescriptors());
        Collections.sort(listDesc);
        ArrayList<DdsBean> dds = new ArrayList<DdsBean>(listDesc.size());
        for (TableD.Descriptor d : listDesc) {
            dds.add(new DdsBean(src, d));
        }
        this.ddsTable.setBeans(dds);
        this.currTable = tableD;
    }

    private void compare(TableD t1, TableD t2, Formatter out) {
        TableD.Descriptor d1;
        out.format("Compare Table D%n %s %n %s %n", t1.getName(), t2.getName());
        boolean err = false;
        ArrayList listDesc = new ArrayList(t1.getDescriptors());
        Collections.sort(listDesc);
        for (DdsBean dbean : this.ddsTable.getBeans()) {
            dbean.diff = null;
            d1 = dbean.dds;
            TableD.Descriptor d2 = t2.getDescriptor(d1.getId());
            if (d2 == null) {
                err = true;
                out.format(" **No key %s in second table %n", d1.getFxy());
                dbean.diff = "new";
                continue;
            }
            List seq1 = d1.getSequence();
            List seq2 = d2.getSequence();
            if (seq1.size() != seq2.size()) {
                err = true;
                out.format(" **key %s size %d != %d %n  ", d1.getFxy(), seq1.size(), seq2.size());
                for (Short f1 : seq1) {
                    out.format(" %s,", this.fxy(f1));
                }
                out.format("%n  ", new Object[0]);
                for (Short f2 : seq2) {
                    out.format(" %s,", this.fxy(f2));
                }
                out.format("%n", new Object[0]);
                dbean.diff = "seq";
                continue;
            }
            for (int i = 0; i < seq1.size(); ++i) {
                short fxy2;
                short fxy1 = (Short)seq1.get(i);
                if (fxy1 == (fxy2 = ((Short)seq2.get(i)).shortValue())) continue;
                err = true;
                out.format(" **MISMATCH key %s feature %s != %s %n", d1.getFxy(), this.fxy(fxy1), this.fxy(fxy2));
                for (Short f1 : seq1) {
                    out.format(" %s,", this.fxy(f1));
                }
                out.format("%n", new Object[0]);
                for (Short f2 : seq2) {
                    out.format(" %s,", this.fxy(f2));
                }
                out.format("%n", new Object[0]);
                dbean.diff = "seq";
            }
        }
        if (!err) {
            out.format("All OK%n", new Object[0]);
        }
        for (TableD.Descriptor d2 : t2.getDescriptors()) {
            d1 = t1.getDescriptor(d2.getId());
            if (d1 != null) continue;
            out.format(" **No key %s in first table %n", d2.getFxy());
        }
    }

    String fxy(short id) {
        return Descriptor.makeString((short)id);
    }

    private void loadStandardVariants() {
        for (BufrTables.TableConfig tc : BufrTables.getTables()) {
            try {
                if (tc.getTableDname() == null) continue;
                this.loadVariant(tc.getName(), BufrTables.readTableD((String)tc.getTableDname(), (BufrTables.Format)tc.getTableDformat(), (boolean)false));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.standardVariantsLoaded = true;
    }

    private void loadVariant(String key, TableD table) {
        if (table == null) {
            System.out.printf("File to open TableD = %s%n", key);
            return;
        }
        if (this.allVariants == null) {
            this.allVariants = new HashMap();
        }
        if (this.variantKeys == null) {
            this.variantKeys = new HashSet<String>();
        }
        if (this.variantKeys.contains(key)) {
            return;
        }
        ArrayList listDesc = new ArrayList(table.getDescriptors());
        for (TableD.Descriptor d : listDesc) {
            List list = this.allVariants.computeIfAbsent(d.getId(), k -> new ArrayList(10));
            list.add(new DdsBean(key, d));
        }
    }

    private void showVariants(DdsBean bean) {
        if (!this.standardVariantsLoaded) {
            this.loadStandardVariants();
        }
        List<DdsBean> all = this.allVariants.get(bean.dds.getId());
        ArrayList<DdsBean> dds = new ArrayList<DdsBean>(10);
        dds.add(bean);
        if (all != null) {
            dds.addAll(all);
        }
        this.variantTable.setBeans(dds);
    }

    public class DdsBean {
        TableD.Descriptor dds;
        String source;
        String diff;

        public DdsBean(String source, TableD.Descriptor dds) {
            this.source = source;
            this.dds = dds;
        }

        public String getFxy() {
            return this.dds.getFxy();
        }

        public int getId() {
            return ArrayType.unsignedShortToInt((short)this.dds.getId());
        }

        public String getSource() {
            return this.source;
        }

        public String getName() {
            return this.dds.getName();
        }

        public String getSequence() {
            Formatter out = new Formatter();
            Iterator iterator = this.dds.getSequence().iterator();
            while (iterator.hasNext()) {
                short s = (Short)iterator.next();
                out.format(" %s,", Descriptor.makeString((short)s));
            }
            return out.toString();
        }

        public int getUsed() {
            if (BufrTableDViewer.this.usedDds == null) {
                return 0;
            }
            List<String> list = BufrTableDViewer.this.usedDds.get(this.dds.getId());
            if (list == null) {
                return 0;
            }
            return list.size();
        }

        public boolean isLocal() {
            return this.dds.isLocal();
        }

        public String getDiff() {
            return this.diff;
        }
    }
}

