/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import ucar.nc2.iosp.NetcdfFileFormat;
import ucar.nc2.write.Nc4Chunking;
import ucar.ui.util.ListenerManager;

public class NetcdfOutputChooser
extends JDialog {
    private ListenerManager lm = new ListenerManager("java.awt.event.ItemListener", "java.awt.event.ItemEvent", "itemStateChanged");
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel label1;
    private JTextField outputFilename;
    private JLabel label2;
    private JComboBox netcdfVersion;
    private JPanel panel1;
    private JLabel label3;
    private JComboBox chunking;
    private JCheckBox deflate;
    private JCheckBox shuffle;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public NetcdfOutputChooser(Frame owner) {
        super(owner);
        this.initComponents();
    }

    public NetcdfOutputChooser(Dialog owner) {
        super(owner);
        this.initComponents();
    }

    public void setOutputFilename(String filename) {
        NetcdfFileFormat version;
        String suffix;
        int pos;
        Object location;
        if (filename == null) {
            filename = "test";
        }
        if (((String)(location = filename)).startsWith("file:")) {
            location = ((String)location).substring(5);
        }
        if ((pos = ((String)location).lastIndexOf(".")) > 0) {
            location = ((String)location).substring(0, pos);
        }
        String string = suffix = (version = (NetcdfFileFormat)this.netcdfVersion.getSelectedItem()) == NetcdfFileFormat.NETCDF4 ? ".nc4" : ".nc";
        if (filename.endsWith(".nc") && suffix.equals(".nc")) {
            suffix = ".sub.nc";
        }
        location = (String)location + suffix;
        this.outputFilename.setText((String)location);
    }

    private void okButtonActionPerformed(ActionEvent e) {
        Data data = new Data(this.outputFilename.getText(), (NetcdfFileFormat)this.netcdfVersion.getSelectedItem(), (Nc4Chunking.Strategy)this.chunking.getSelectedItem(), this.deflate.isSelected(), this.shuffle.isSelected());
        this.firePropertyChange("OK", null, data);
        this.setVisible(false);
    }

    private void createUIComponents() {
    }

    public void addEventListener(ItemListener l) {
        this.lm.addListener((Object)l);
    }

    public void removeEventListener(ItemListener l) {
        this.lm.removeListener((Object)l);
    }

    private void chunkingItemStateChanged(ItemEvent e) {
        this.lm.sendEvent((EventObject)e);
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.label1 = new JLabel();
        this.outputFilename = new JTextField();
        this.label2 = new JLabel();
        this.netcdfVersion = new JComboBox<NetcdfFileFormat>(NetcdfFileFormat.values());
        this.panel1 = new JPanel();
        this.label3 = new JLabel();
        this.chunking = new JComboBox<Nc4Chunking.Strategy>(Nc4Chunking.Strategy.values());
        this.deflate = new JCheckBox();
        this.shuffle = new JCheckBox();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.label1.setText("Output Filename:");
        this.label2.setText("NetCDF Format:");
        this.panel1.setBorder(new TitledBorder(null, "netCDF4 options", 2, 0));
        this.panel1.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panel1.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.panel1.getLayout()).rowHeights = new int[]{0, 0, 0, 0};
        ((GridBagLayout)this.panel1.getLayout()).columnWeights = new double[]{0.0, 1.0, 1.0E-4};
        ((GridBagLayout)this.panel1.getLayout()).rowWeights = new double[]{0.0, 0.0, 1.0, 1.0E-4};
        this.label3.setText("Chunking:");
        this.panel1.add((Component)this.label3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.chunking.addItemListener(this::chunkingItemStateChanged);
        this.panel1.add((Component)this.chunking, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.deflate.setText("deflate");
        this.panel1.add((Component)this.deflate, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.shuffle.setText("shuffle");
        this.panel1.add((Component)this.shuffle, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        GroupLayout contentPanelLayout = new GroupLayout(this.contentPanel);
        this.contentPanel.setLayout(contentPanelLayout);
        contentPanelLayout.setHorizontalGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addComponent(this.label1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputFilename, -1, 450, Short.MAX_VALUE)).addGroup(contentPanelLayout.createSequentialGroup().addGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.label2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.netcdfVersion, -2, 243, -2)).addGroup(contentPanelLayout.createSequentialGroup().addGap(33, 33, 33).addComponent(this.panel1, -2, 383, -2))).addGap(0, 143, Short.MAX_VALUE))).addContainerGap()));
        contentPanelLayout.setVerticalGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addContainerGap().addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label1).addComponent(this.outputFilename, -2, -1, -2)).addGap(18, 18, 18).addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label2).addComponent(this.netcdfVersion, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.panel1, -2, 86, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new FlowLayout(0));
        this.okButton.setText("Write File");
        this.okButton.addActionListener(this::okButtonActionPerformed);
        this.buttonBar.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        this.buttonBar.add(this.cancelButton);
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public static class Data {
        public String outputFilename;
        public NetcdfFileFormat format;
        public Nc4Chunking.Strategy chunkerType;
        public int deflate;
        public boolean shuffle;

        private Data(String outputFilename, NetcdfFileFormat format, Nc4Chunking.Strategy chunkerType, boolean deflate, boolean shuffle) {
            this.outputFilename = outputFilename;
            this.format = format;
            this.chunkerType = chunkerType;
            this.deflate = deflate ? 5 : 0;
            this.shuffle = shuffle;
        }
    }
}

