/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.geoloc;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import ucar.ui.geoloc.CursorMoveEvent;
import ucar.ui.geoloc.CursorMoveEventListener;
import ucar.ui.geoloc.GeoSelectionEvent;
import ucar.ui.geoloc.GeoSelectionListener;
import ucar.ui.geoloc.Navigation;
import ucar.ui.geoloc.NewMapAreaEvent;
import ucar.ui.geoloc.NewMapAreaListener;
import ucar.ui.geoloc.NewProjectionEvent;
import ucar.ui.geoloc.NewProjectionListener;
import ucar.ui.geoloc.PickEvent;
import ucar.ui.geoloc.PickEventListener;
import ucar.ui.geoloc.Rubberband;
import ucar.ui.geoloc.RubberbandRectangle;
import ucar.ui.geoloc.RubberbandRectangleHandles;
import ucar.ui.prefs.Debug;
import ucar.ui.util.ListenerManager;
import ucar.ui.widget.BAMutil;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.Format;

public class NavigatedPanel
extends JPanel {
    public AbstractAction setReferenceAction;
    private final Navigation navigate;
    private Projection project;
    private BufferedImage bImage;
    private final Color backColor = Color.white;
    private JLabel statusLabel;
    private final myImageObserver imageObs = new myImageObserver();
    private NToolBar toolbar;
    private Timer redrawTimer;
    private boolean changeable = true;
    private int startx;
    private int starty;
    private int deltax;
    private int deltay;
    private boolean panningMode;
    private boolean zoomingMode;
    private final Rubberband zoomRB;
    private boolean isReferenceMode;
    private boolean hasReference;
    private ProjectionPoint refWorld = ProjectionPoint.create((double)0.0, (double)0.0);
    private LatLonPoint refLatLon = LatLonPoint.create((double)0.0, (double)0.0);
    private Point2D refScreen = new Point2D.Double();
    private Cursor referenceCursor;
    private static final int REFERENCE_CURSOR = -100;
    private ProjectionRect geoSelection;
    private boolean geoSelectionMode;
    private boolean moveSelectionMode;
    private final RubberbandRectangleHandles selectionRB;
    private ProjectionRect homeMapArea;
    private final ListenerManager lmPick;
    private final ListenerManager lmMove;
    private final ListenerManager lmMapArea;
    private final ListenerManager lmProject;
    private final ListenerManager lmGeoSelect;
    private StringBuffer sbuff = new StringBuffer(100);
    private ProjectionPoint workW = ProjectionPoint.create((double)0.0, (double)0.0);
    private Point2D workS = new Point2D.Double();
    private Rectangle myBounds = new Rectangle();
    private ProjectionRect boundingBox = new ProjectionRect();
    private final DropTarget dropTarget;
    private int repaintCount;
    private static final boolean debugDraw = false;
    private static final boolean debugEvent = false;
    private static final boolean debugThread = false;
    private static final boolean debugScreensize = false;
    private static final boolean debugMaparea = false;
    private static final boolean debugNewProjection = false;
    private static final boolean debugZoom = false;
    private static final boolean debugSelection = false;
    private AbstractAction zoomIn;
    private AbstractAction zoomOut;
    private AbstractAction zoomDefault;
    private AbstractAction zoomBack;
    private AbstractAction moveUp;
    private AbstractAction moveDown;
    private AbstractAction moveLeft;
    private AbstractAction moveRight;

    public NavigatedPanel() {
        this.setDoubleBuffered(false);
        this.navigate = new Navigation(this);
        this.project = new LatLonProjection("Cyl.Eq");
        this.makeActions();
        this.addMouseListener(new myMouseListener());
        this.addMouseMotionListener(new myMouseMotionListener());
        this.addMouseWheelListener(new myMouseWheelListener());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                NavigatedPanel.this.newScreenSize(NavigatedPanel.this.getBounds());
            }
        });
        this.zoomRB = new RubberbandRectangle(this, false);
        this.selectionRB = new RubberbandRectangleHandles(this, false);
        this.dropTarget = new DropTarget(this, 1, new myDropTargetListener());
        this.lmPick = new ListenerManager("ucar.ui.geoloc.PickEventListener", "ucar.ui.geoloc.PickEvent", "actionPerformed");
        this.lmMove = new ListenerManager("ucar.ui.geoloc.CursorMoveEventListener", "ucar.ui.geoloc.CursorMoveEvent", "actionPerformed");
        this.lmMapArea = new ListenerManager("ucar.ui.geoloc.NewMapAreaListener", "ucar.ui.geoloc.NewMapAreaEvent", "actionPerformed");
        this.lmProject = new ListenerManager("ucar.ui.geoloc.NewProjectionListener", "ucar.ui.geoloc.NewProjectionEvent", "actionPerformed");
        this.lmGeoSelect = new ListenerManager("ucar.ui.geoloc.GeoSelectionListener", "ucar.ui.geoloc.GeoSelectionEvent", "actionPerformed");
    }

    public LatLonRect getGeoSelectionLL() {
        return this.geoSelection == null ? null : this.project.projToLatLonBB(this.geoSelection);
    }

    public ProjectionRect getGeoSelection() {
        return this.geoSelection;
    }

    public void setGeoSelection(ProjectionRect bb) {
        this.geoSelection = bb;
    }

    public void setGeoSelection(LatLonRect llbb) {
        this.setGeoSelection(this.project.latLonToProjBB(llbb));
    }

    public void setGeoSelectionMode(boolean b) {
        this.geoSelectionMode = b;
    }

    public void addNewMapAreaListener(NewMapAreaListener l) {
        this.lmMapArea.addListener((Object)l);
    }

    public void removeNewMapAreaListener(NewMapAreaListener l) {
        this.lmMapArea.removeListener((Object)l);
    }

    public void addNewProjectionListener(NewProjectionListener l) {
        this.lmProject.addListener((Object)l);
    }

    public void removeNewProjectionListener(NewProjectionListener l) {
        this.lmProject.removeListener((Object)l);
    }

    public void addCursorMoveEventListener(CursorMoveEventListener l) {
        this.lmMove.addListener((Object)l);
    }

    public void removeCursorMoveEventListener(CursorMoveEventListener l) {
        this.lmMove.removeListener((Object)l);
    }

    public void addPickEventListener(PickEventListener l) {
        this.lmPick.addListener((Object)l);
    }

    public void removePickEventListener(PickEventListener l) {
        this.lmPick.removeListener((Object)l);
    }

    public void addGeoSelectionListener(GeoSelectionListener l) {
        this.lmGeoSelect.addListener((Object)l);
    }

    public void removeGeoSelectionListener(GeoSelectionListener l) {
        this.lmGeoSelect.removeListener((Object)l);
    }

    void fireMapAreaEvent() {
        if (this.project.isLatLon()) {
            boolean showShift;
            LatLonProjection llproj = (LatLonProjection)this.project;
            ProjectionRect box = this.getMapArea();
            double center = llproj.getCenterLon();
            double lonBeg = LatLonPoints.lonNormal((double)box.getMinX(), (double)center);
            double lonEnd = lonBeg + box.getMaxX() - box.getMinX();
            boolean bl = Debug.isSet((String)"projection/LatLonShift") ? true : (showShift = false);
            if (showShift) {
                System.out.println("projection/LatLonShift: min,max = " + box.getMinX() + " " + box.getMaxX() + " beg,end= " + lonBeg + " " + lonEnd + " center = " + center);
            }
            if (lonBeg < center - 180.0 || lonEnd > center + 180.0) {
                double wx0 = box.getMinX() + box.getWidth() / 2.0;
                double newWx0 = llproj.getCenterLon();
                this.setWorldCenterX(newWx0);
                if (showShift) {
                    System.out.println("projection/LatLonShift: shift center to " + wx0 + "->" + newWx0);
                }
                this.lmProject.sendEvent((EventObject)new NewProjectionEvent(this, (Projection)llproj));
                return;
            }
        }
        this.lmMapArea.sendEvent((EventObject)new NewMapAreaEvent(this, this.getMapArea()));
    }

    public Navigation getNavigation() {
        return this.navigate;
    }

    public Color getBackgroundColor() {
        return this.backColor;
    }

    public void setMapArea(ProjectionRect ma) {
        this.navigate.setMapArea(ma);
    }

    public void setMapAreaHome(ProjectionRect ma) {
        this.homeMapArea = ma;
        this.navigate.setMapArea(ma);
    }

    public void setMapArea(LatLonRect llbb) {
        this.navigate.setMapArea(this.project.latLonToProjBB(llbb));
    }

    public ProjectionRect getMapArea() {
        this.boundingBox = this.navigate.getMapArea();
        return this.boundingBox;
    }

    public LatLonRect getMapAreaLL() {
        return this.project.projToLatLonBB(this.getMapArea());
    }

    public void setWorldCenterX(double wx_center) {
        this.navigate.setWorldCenterX(wx_center);
    }

    public void setLatLonCenterMapArea(double lat, double lon) {
        ProjectionPoint center = this.project.latLonToProj(lat, lon);
        ProjectionRect.Builder ma = this.getMapArea().toBuilder();
        ma.setX(center.getX() - ma.getWidth() / 2.0);
        ma.setY(center.getY() - ma.getHeight() / 2.0);
        this.setMapArea(ma.build());
    }

    public Projection getProjectionImpl() {
        return this.project;
    }

    public void setProjectionImpl(Projection p) {
        if (this.geoSelection != null) {
            LatLonRect geoLL = this.project.projToLatLonBB(this.geoSelection);
            this.setGeoSelection(p.latLonToProjBB(geoLL));
        }
        this.project = p;
        if (Debug.isSet((String)"projection/set")) {
            System.out.println("projection/set NP=" + this.project);
        }
        if (this.hasReference) {
            this.refWorld = this.project.latLonToProj(this.refLatLon);
        }
    }

    public void setPositionLabel(JLabel statusLabel) {
        this.statusLabel = statusLabel;
    }

    public JToolBar getNavToolBar() {
        return new NToolBar();
    }

    public JToolBar getMoveToolBar() {
        return new MoveToolBar();
    }

    public void addActionsToMenu(JMenu menu) {
        BAMutil.addActionToMenu((JMenu)menu, (Action)this.zoomIn);
        BAMutil.addActionToMenu((JMenu)menu, (Action)this.zoomOut);
        BAMutil.addActionToMenu((JMenu)menu, (Action)this.zoomBack);
        BAMutil.addActionToMenu((JMenu)menu, (Action)this.zoomDefault);
        menu.addSeparator();
        BAMutil.addActionToMenu((JMenu)menu, (Action)this.moveUp);
        BAMutil.addActionToMenu((JMenu)menu, (Action)this.moveDown);
        BAMutil.addActionToMenu((JMenu)menu, (Action)this.moveRight);
        BAMutil.addActionToMenu((JMenu)menu, (Action)this.moveLeft);
        menu.addSeparator();
        BAMutil.addActionToMenu((JMenu)menu, (Action)this.setReferenceAction);
    }

    public void setEnabledActions(boolean b) {
        this.zoomIn.setEnabled(b);
        this.zoomOut.setEnabled(b);
        this.zoomBack.setEnabled(b);
        this.zoomDefault.setEnabled(b);
        this.moveUp.setEnabled(b);
        this.moveDown.setEnabled(b);
        this.moveRight.setEnabled(b);
        this.moveLeft.setEnabled(b);
    }

    private void redrawLater(int delay) {
        boolean already;
        boolean bl = already = this.redrawTimer != null && this.redrawTimer.isRunning();
        if (already) {
            return;
        }
        if (this.redrawTimer == null) {
            this.redrawTimer = new Timer(0, e -> {
                this.drawG();
                this.redrawTimer.stop();
            });
        }
        this.redrawTimer.setDelay(delay);
        this.redrawTimer.start();
    }

    public void setChangeable(boolean mode) {
        if (mode == this.changeable) {
            return;
        }
        this.changeable = mode;
        if (this.toolbar != null) {
            this.toolbar.setEnabled(mode);
        }
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        ++this.repaintCount;
        super.repaint(tm, x, y, width, height);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.draw((Graphics2D)g);
    }

    public BufferedImage getBufferedImage() {
        return this.bImage;
    }

    public Graphics2D getBufferedImageGraphics() {
        if (this.bImage == null) {
            return null;
        }
        Graphics2D g2 = this.bImage.createGraphics();
        this.boundingBox = this.navigate.getMapArea();
        g2.setTransform(this.navigate.getTransform());
        g2.setStroke(new BasicStroke(0.0f));
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        Rectangle2D.Double hr = new Rectangle2D.Double();
        ((Rectangle2D)hr).setRect(this.boundingBox.getMinX(), this.boundingBox.getMinY(), this.boundingBox.getWidth(), this.boundingBox.getHeight());
        g2.setClip(hr);
        g2.setBackground(this.backColor);
        return g2;
    }

    public boolean wantRotate(double pwidth, double pheight) {
        return this.navigate.wantRotate(pwidth, pheight);
    }

    public AffineTransform calcTransform(boolean rotate, double displayX, double displayY, double displayWidth, double displayHeight) {
        return this.navigate.calcTransform(rotate, displayX, displayY, displayWidth, displayHeight);
    }

    private void newScreenSize(Rectangle b) {
        boolean sameSize;
        boolean bl = sameSize = b.width == this.myBounds.width && b.height == this.myBounds.height;
        if (sameSize && b.x == this.myBounds.x && b.y == this.myBounds.y) {
            return;
        }
        this.myBounds.setBounds(b);
        if (sameSize) {
            return;
        }
        this.bImage = b.width > 0 && b.height > 0 ? new BufferedImage(b.width, b.height, 1) : null;
        this.navigate.setScreenSize(b.width, b.height);
    }

    public void drawG() {
        Graphics g = this.getGraphics();
        if (null != g) {
            this.draw((Graphics2D)g);
            g.dispose();
        }
    }

    private void draw(Graphics2D g) {
        if (this.bImage == null) {
            return;
        }
        boolean redrawReference = true;
        Rectangle bounds = this.getBounds();
        if (this.panningMode) {
            g.setBackground(this.backColor);
            g.clearRect(0, 0, bounds.width, bounds.height);
            g.drawImage(this.bImage, this.deltax, this.deltay, this.backColor, this.imageObs);
            redrawReference = false;
        } else {
            g.drawImage(this.bImage, 0, 0, this.backColor, this.imageObs);
        }
        if (this.hasReference && redrawReference) {
            this.refWorld = this.project.latLonToProj(this.refLatLon);
            this.refScreen = this.navigate.worldToScreen(this.refWorld);
            int px = (int)this.refScreen.getX();
            int py = (int)this.refScreen.getY();
            g.setColor(Color.red);
            g.setStroke(new BasicStroke(2.0f));
            int referenceSize = 12;
            g.drawLine(px, py - referenceSize, px, py + referenceSize);
            g.drawLine(px - referenceSize, py, px + referenceSize, py);
        }
    }

    private void setCursor(int what) {
        if (what == -100) {
            if (null == this.referenceCursor) {
                this.referenceCursor = BAMutil.makeCursor((String)"nj22/ReferencePoint");
                if (null == this.referenceCursor) {
                    return;
                }
            }
            super.setCursor(this.referenceCursor);
        } else {
            super.setCursor(Cursor.getPredefinedCursor(what));
        }
    }

    private void showStatus(int mousex, int mousey) {
        if (this.statusLabel == null && !this.lmMove.hasListeners()) {
            return;
        }
        this.workS.setLocation(mousex, mousey);
        this.workW = this.navigate.screenToWorld(this.workS);
        LatLonPoint workL = this.project.projToLatLon(this.workW);
        if (workL == null) {
            return;
        }
        if (this.lmMove.hasListeners()) {
            this.lmMove.sendEvent((EventObject)new CursorMoveEvent((Object)this, this.workW));
        }
        if (this.statusLabel == null) {
            return;
        }
        this.sbuff.setLength(0);
        if (Debug.isSet((String)"projection/showPosition")) {
            this.sbuff.append(this.workW).append(" -> ");
        }
        this.sbuff.append(LatLonPoints.toString((LatLonPoint)workL, (int)5));
        if (this.hasReference) {
            Bearing bearing = Bearing.calculateBearing((LatLonPoint)this.refLatLon, (LatLonPoint)workL);
            this.sbuff.append("  (");
            this.sbuff.append(Format.dfrac((double)bearing.getAzimuth(), (int)0));
            this.sbuff.append(" deg ");
            this.sbuff.append(Format.d((double)bearing.getDistance(), (int)4, (int)5));
            this.sbuff.append(" km)");
        }
        this.statusLabel.setText(this.sbuff.toString());
    }

    private void setReferenceMode() {
        if (this.isReferenceMode) {
            this.isReferenceMode = false;
            this.setCursor(0);
            this.statusLabel.setToolTipText("position at cursor");
            this.drawG();
        } else {
            this.hasReference = false;
            this.isReferenceMode = true;
            this.setCursor(1);
            this.statusLabel.setToolTipText("position (bearing)");
        }
    }

    private void makeActions() {
        this.zoomIn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.navigate.zoomIn();
                NavigatedPanel.this.drawG();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.zoomIn, (String)"MagnifyPlus", (String)"zoom In", (boolean)false, (int)73, (int)107);
        this.zoomOut = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.navigate.zoomOut();
                NavigatedPanel.this.drawG();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.zoomOut, (String)"MagnifyMinus", (String)"zoom Out", (boolean)false, (int)79, (int)109);
        this.zoomBack = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.navigate.zoomPrevious();
                NavigatedPanel.this.drawG();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.zoomBack, (String)"Undo", (String)"Previous map area", (boolean)false, (int)80, (int)8);
        this.zoomDefault = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NavigatedPanel.this.homeMapArea != null) {
                    NavigatedPanel.this.navigate.setMapArea(NavigatedPanel.this.homeMapArea);
                    NavigatedPanel.this.drawG();
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.zoomDefault, (String)"Home", (String)"Home map area", (boolean)false, (int)72, (int)36);
        this.moveUp = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.navigate.moveUp();
                NavigatedPanel.this.drawG();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.moveUp, (String)"Up", (String)"move view Up", (boolean)false, (int)85, (int)38);
        this.moveDown = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.navigate.moveDown();
                NavigatedPanel.this.drawG();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.moveDown, (String)"Down", (String)"move view Down", (boolean)false, (int)68, (int)40);
        this.moveLeft = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.navigate.moveLeft();
                NavigatedPanel.this.drawG();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.moveLeft, (String)"Left", (String)"move view Left", (boolean)false, (int)76, (int)37);
        this.moveRight = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.navigate.moveRight();
                NavigatedPanel.this.drawG();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.moveRight, (String)"Right", (String)"move view Right", (boolean)false, (int)82, (int)39);
        this.setReferenceAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatedPanel.this.setReferenceMode();
                NavigatedPanel.this.drawG();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.setReferenceAction, (String)"nj22/ReferencePoint", (String)"set reference Point", (boolean)true, (int)80, (int)0);
    }

    @Override
    public String toString() {
        return "NavigatedPanel{panningMode=" + this.panningMode + ", zoomingMode=" + this.zoomingMode + ", isReferenceMode=" + this.isReferenceMode + ", geoSelectionMode=" + this.geoSelectionMode + ", moveSelectionMode=" + this.moveSelectionMode + "}";
    }

    class MoveToolBar
    extends JToolBar {
        MoveToolBar() {
            AbstractButton b = BAMutil.addActionToContainer((Container)this, (Action)NavigatedPanel.this.moveUp);
            b.setName("moveUp");
            b = BAMutil.addActionToContainer((Container)this, (Action)NavigatedPanel.this.moveDown);
            b.setName("moveDown");
            b = BAMutil.addActionToContainer((Container)this, (Action)NavigatedPanel.this.moveLeft);
            b.setName("moveLeft");
            b = BAMutil.addActionToContainer((Container)this, (Action)NavigatedPanel.this.moveRight);
            b.setName("moveRight");
        }
    }

    class NToolBar
    extends JToolBar {
        NToolBar() {
            AbstractButton b = BAMutil.addActionToContainer((Container)this, (Action)NavigatedPanel.this.zoomIn);
            b.setName("zoomIn");
            b = BAMutil.addActionToContainer((Container)this, (Action)NavigatedPanel.this.zoomOut);
            b.setName("zoomOut");
            b = BAMutil.addActionToContainer((Container)this, (Action)NavigatedPanel.this.zoomBack);
            b.setName("zoomBack");
            b = BAMutil.addActionToContainer((Container)this, (Action)NavigatedPanel.this.zoomDefault);
            b.setName("zoomHome");
        }
    }

    private class myDropTargetListener
    implements DropTargetListener {
        private myDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            System.out.println(" NP dragEnter active = " + NavigatedPanel.this.dropTarget.isActive());
            e.acceptDrag(1);
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            try {
                if (e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    Transferable tr = e.getTransferable();
                    e.acceptDrop(3);
                    String s = (String)tr.getTransferData(DataFlavor.stringFlavor);
                    System.out.println(" NP myDropTargetListener got " + s);
                    e.dropComplete(true);
                } else {
                    e.rejectDrop();
                }
            }
            catch (UnsupportedFlavorException | IOException io) {
                io.printStackTrace();
                e.rejectDrop();
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }

    private static class myImageObserver
    implements ImageObserver {
        private myImageObserver() {
        }

        @Override
        public boolean imageUpdate(Image image, int flags, int x, int y, int width, int height) {
            return true;
        }
    }

    private class myMouseWheelListener
    extends MouseAdapter {
        private myMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getWheelRotation() < 0) {
                for (int rotation = e.getWheelRotation(); rotation < 0; ++rotation) {
                    NavigatedPanel.this.navigate.zoomIn(e.getX(), e.getY());
                    NavigatedPanel.this.drawG();
                }
            } else {
                for (int rotation = e.getWheelRotation(); rotation > 0; --rotation) {
                    NavigatedPanel.this.navigate.zoomOut(e.getX(), e.getY());
                    NavigatedPanel.this.drawG();
                }
            }
        }
    }

    private class myMouseMotionListener
    implements MouseMotionListener {
        private myMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!NavigatedPanel.this.changeable) {
                return;
            }
            NavigatedPanel.this.deltax = e.getX() - NavigatedPanel.this.startx;
            NavigatedPanel.this.deltay = e.getY() - NavigatedPanel.this.starty;
            if (NavigatedPanel.this.zoomingMode) {
                NavigatedPanel.this.zoomRB.stretch(e.getPoint());
                return;
            }
            if (NavigatedPanel.this.moveSelectionMode) {
                NavigatedPanel.this.selectionRB.move(NavigatedPanel.this.deltax, NavigatedPanel.this.deltay);
                return;
            }
            if (NavigatedPanel.this.geoSelectionMode && !SwingUtilities.isRightMouseButton(e) && NavigatedPanel.this.selectionRB.isActive()) {
                NavigatedPanel.this.selectionRB.stretch(e.getPoint());
                return;
            }
            NavigatedPanel.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            NavigatedPanel.this.showStatus(e.getX(), e.getY());
        }
    }

    private class myMouseListener
    extends MouseAdapter {
        private myMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (NavigatedPanel.this.isReferenceMode) {
                NavigatedPanel.this.hasReference = true;
                NavigatedPanel.this.refScreen.setLocation(e.getX(), e.getY());
                NavigatedPanel.this.refWorld = NavigatedPanel.this.navigate.screenToWorld(NavigatedPanel.this.refScreen);
                NavigatedPanel.this.refLatLon = NavigatedPanel.this.project.projToLatLon(NavigatedPanel.this.refWorld);
                NavigatedPanel.this.setCursor(-100);
                NavigatedPanel.this.drawG();
            } else {
                NavigatedPanel.this.workS.setLocation(e.getX(), e.getY());
                NavigatedPanel.this.workW = NavigatedPanel.this.navigate.screenToWorld(NavigatedPanel.this.workS);
                NavigatedPanel.this.lmPick.sendEvent((EventObject)new PickEvent((Object)NavigatedPanel.this, NavigatedPanel.this.workW));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!NavigatedPanel.this.changeable) {
                return;
            }
            NavigatedPanel.this.startx = e.getX();
            NavigatedPanel.this.starty = e.getY();
            if (NavigatedPanel.this.geoSelectionMode && SwingUtilities.isLeftMouseButton(e)) {
                ProjectionPoint pp = NavigatedPanel.this.navigate.screenToWorld(e.getPoint());
                NavigatedPanel.this.geoSelection = new ProjectionRect(pp, 0.0, 0.0);
                Rectangle sw = NavigatedPanel.this.navigate.worldToScreen(NavigatedPanel.this.geoSelection);
                NavigatedPanel.this.selectionRB.setRectangle(sw);
                if (NavigatedPanel.this.selectionRB.anchor2(e.getPoint(), 10, 10)) {
                    NavigatedPanel.this.selectionRB.setActive(true);
                }
                return;
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                NavigatedPanel.this.panningMode = true;
                NavigatedPanel.this.setCursor(13);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!NavigatedPanel.this.changeable) {
                return;
            }
            NavigatedPanel.this.deltax = e.getX() - NavigatedPanel.this.startx;
            NavigatedPanel.this.deltay = e.getY() - NavigatedPanel.this.starty;
            if (NavigatedPanel.this.geoSelectionMode && NavigatedPanel.this.selectionRB.isActive()) {
                NavigatedPanel.this.selectionRB.setActive(false);
                NavigatedPanel.this.selectionRB.done();
                NavigatedPanel.this.moveSelectionMode = false;
                NavigatedPanel.this.setCursor(0);
                if (!NavigatedPanel.this.contains(e.getPoint())) {
                    return;
                }
                NavigatedPanel.this.geoSelection = NavigatedPanel.this.navigate.screenToWorld(NavigatedPanel.this.selectionRB.getAnchor(), NavigatedPanel.this.selectionRB.getLast());
                NavigatedPanel.this.lmGeoSelect.sendEvent((EventObject)new GeoSelectionEvent(this, NavigatedPanel.this.geoSelection));
                return;
            }
            if (NavigatedPanel.this.panningMode) {
                NavigatedPanel.this.navigate.pan(-NavigatedPanel.this.deltax, -NavigatedPanel.this.deltay);
                NavigatedPanel.this.panningMode = false;
                NavigatedPanel.this.setCursor(0);
            }
        }
    }
}

