/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.geoloc;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import ucar.ui.geoloc.NavigatedPanel;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;

public class Navigation {
    private static final boolean debug = false;
    private static final boolean debugZoom = false;
    private static final boolean debugRecalc = false;
    private final NavigatedPanel np;
    private double pwidth;
    private double pheight;
    private double pix_per_world = 1.0;
    private double pix_x0;
    private double pix_y0;
    private ProjectionRect bb;
    private final AffineTransform at;
    private boolean mapAreaIsSet;
    private boolean screenSizeIsSet;
    private final ZoomStack zoom = new ZoomStack();

    Navigation(NavigatedPanel np) {
        this.np = np;
        this.bb = new ProjectionRect();
        this.at = new AffineTransform();
    }

    public double getScreenWidth() {
        return this.pwidth;
    }

    public double getScreenHeight() {
        return this.pheight;
    }

    void setScreenSize(double pwidth, double pheight) {
        if (pwidth == 0.0 || pheight == 0.0) {
            return;
        }
        if (this.mapAreaIsSet && this.screenSizeIsSet) {
            this.bb = ProjectionRect.builder().setRect(this.getMapArea()).build();
        }
        this.pwidth = pwidth;
        this.pheight = pheight;
        this.screenSizeIsSet = true;
        if (this.mapAreaIsSet) {
            this.recalcFromBoundingBox();
        }
        this.fireMapAreaEvent();
    }

    public AffineTransform getTransform() {
        this.at.setTransform(this.pix_per_world, 0.0, 0.0, -this.pix_per_world, this.pix_x0, this.pix_y0);
        return this.at;
    }

    boolean wantRotate(double displayWidth, double displayHeight) {
        this.bb = this.getMapArea();
        boolean aspectDisplay = displayHeight < displayWidth;
        boolean aspectWorldBB = this.bb.getHeight() < this.bb.getWidth();
        return aspectDisplay ^ aspectWorldBB;
    }

    AffineTransform calcTransform(boolean rotate, double displayX, double displayY, double displayWidth, double displayHeight) {
        double pypsy;
        double pxpsx;
        this.bb = this.getMapArea();
        if (rotate) {
            pxpsx = displayHeight / this.bb.getWidth();
            pypsy = displayWidth / this.bb.getHeight();
        } else {
            pxpsx = displayWidth / this.bb.getWidth();
            pypsy = displayHeight / this.bb.getHeight();
        }
        double pps = Math.min(pxpsx, pypsy);
        double wx0 = this.bb.getMinX() + this.bb.getWidth() / 2.0;
        double wy0 = this.bb.getMinY() + this.bb.getHeight() / 2.0;
        double x0 = displayX + displayWidth / 2.0 - pps * wx0;
        double y0 = displayY + displayHeight / 2.0 + pps * wy0;
        AffineTransform cat = new AffineTransform(pps, 0.0, 0.0, -pps, x0, y0);
        if (rotate) {
            cat.rotate(1.5707963267948966, wx0, wy0);
        }
        return cat;
    }

    public ProjectionRect getMapArea() {
        double width = this.pwidth / this.pix_per_world;
        double height = this.pheight / this.pix_per_world;
        double wx0 = (this.pwidth / 2.0 - this.pix_x0) / this.pix_per_world;
        double wy0 = (this.pix_y0 - this.pheight / 2.0) / this.pix_per_world;
        return ProjectionRect.builder().setRect(wx0 - width / 2.0, wy0 - height / 2.0, width, height).build();
    }

    void setMapArea(ProjectionRect ma) {
        this.bb = ma;
        this.zoom.push();
        this.mapAreaIsSet = true;
        if (this.screenSizeIsSet) {
            this.recalcFromBoundingBox();
            this.fireMapAreaEvent();
        }
    }

    void setWorldCenterX(double wx_center) {
        this.pix_x0 = this.pwidth / 2.0 - this.pix_per_world * wx_center;
    }

    Point2D worldToScreen(ProjectionPoint w) {
        Point2D.Double p = new Point2D.Double();
        ((Point2D)p).setLocation(this.pix_per_world * w.getX() + this.pix_x0, -this.pix_per_world * w.getY() + this.pix_y0);
        return p;
    }

    ProjectionPoint screenToWorld(Point2D p) {
        return ProjectionPoint.create((double)((p.getX() - this.pix_x0) / this.pix_per_world), (double)((this.pix_y0 - p.getY()) / this.pix_per_world));
    }

    public double getPixPerWorld() {
        return this.pix_per_world;
    }

    ProjectionRect screenToWorld(Point2D start, Point2D end) {
        ProjectionPoint p1 = this.screenToWorld(start);
        ProjectionPoint p2 = this.screenToWorld(end);
        return new ProjectionRect(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    Rectangle worldToScreen(ProjectionRect projRect) {
        Point2D p1 = this.worldToScreen(projRect.getMaxPoint());
        Point2D p2 = this.worldToScreen(projRect.getMinPoint());
        return new Rectangle((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
    }

    void pan(double deltax, double deltay) {
        this.zoom.push();
        this.pix_x0 -= deltax;
        this.pix_y0 -= deltay;
        this.fireMapAreaEvent();
    }

    void zoom(double startx, double starty, double width, double height) {
        if (width < 5.0 || height < 5.0) {
            return;
        }
        this.zoom.push();
        this.pix_x0 -= startx + width / 2.0 - this.pwidth / 2.0;
        this.pix_y0 -= starty + height / 2.0 - this.pheight / 2.0;
        this.zoom(this.pwidth / width);
    }

    public void zoomIn(double x, double y) {
        this.zoom(1.1, x, y);
    }

    public void zoomOut(double x, double y) {
        this.zoom(0.9, x, y);
    }

    void zoomIn() {
        this.zoom(2.0);
    }

    void zoomOut() {
        this.zoom(0.5);
    }

    private void zoom(double scale) {
        this.zoom.push();
        double fac = 1.0 - scale;
        this.pix_x0 = scale * this.pix_x0 + fac * this.pwidth / 2.0;
        this.pix_y0 = scale * this.pix_y0 + fac * this.pheight / 2.0;
        this.pix_per_world *= scale;
        this.fireMapAreaEvent();
    }

    private void zoom(double scale, double x, double y) {
        this.zoom.push();
        double fac = 1.0 - scale;
        this.pix_x0 = scale * this.pix_x0 + fac * x;
        this.pix_y0 = scale * this.pix_y0 + fac * y;
        this.pix_per_world *= scale;
        this.fireMapAreaEvent();
    }

    void moveDown() {
        this.zoom.push();
        this.pix_y0 -= this.pheight / 2.0;
        this.fireMapAreaEvent();
    }

    void moveUp() {
        this.zoom.push();
        this.pix_y0 += this.pheight / 2.0;
        this.fireMapAreaEvent();
    }

    void moveRight() {
        this.zoom.push();
        this.pix_x0 -= this.pwidth / 2.0;
        this.fireMapAreaEvent();
    }

    void moveLeft() {
        this.zoom.push();
        this.pix_x0 += this.pwidth / 2.0;
        this.fireMapAreaEvent();
    }

    void zoomPrevious() {
        this.zoom.pop();
        this.fireMapAreaEvent();
    }

    private void recalcFromBoundingBox() {
        double pixx_per_wx = this.bb.getWidth() == 0.0 ? 1.0 : this.pwidth / this.bb.getWidth();
        double pixy_per_wy = this.bb.getHeight() == 0.0 ? 1.0 : this.pheight / this.bb.getHeight();
        this.pix_per_world = Math.min(pixx_per_wx, pixy_per_wy);
        double wx0 = this.bb.getMinX() + this.bb.getWidth() / 2.0;
        double wy0 = this.bb.getMinY() + this.bb.getHeight() / 2.0;
        this.pix_x0 = this.pwidth / 2.0 - this.pix_per_world * wx0;
        this.pix_y0 = this.pheight / 2.0 + this.pix_per_world * wy0;
    }

    private synchronized void fireMapAreaEvent() {
        this.np.fireMapAreaEvent();
    }

    private class ZoomStack
    extends ArrayList<Zoom> {
        private int current;

        ZoomStack() {
            super(20);
            this.current = -1;
        }

        void push() {
            ++this.current;
            this.add(this.current, new Zoom(Navigation.this.pix_per_world, Navigation.this.pix_x0, Navigation.this.pix_y0));
        }

        void pop() {
            if (this.current < 0) {
                return;
            }
            Zoom zoom = (Zoom)this.get(this.current);
            Navigation.this.pix_per_world = zoom.pix_per_world;
            Navigation.this.pix_x0 = zoom.pix_x0;
            Navigation.this.pix_y0 = zoom.pix_y0;
            --this.current;
        }

        private class Zoom {
            double pix_per_world;
            double pix_x0;
            double pix_y0;

            Zoom(double p1, double p2, double p3) {
                this.pix_per_world = p1;
                this.pix_x0 = p2;
                this.pix_y0 = p3;
            }
        }
    }
}

