/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.gis;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.ui.gis.AbstractGisFeature;
import ucar.ui.gis.GisFeature;
import ucar.ui.gis.GisFeatureRenderer;
import ucar.ui.gis.GisPart;
import ucar.ui.prefs.Debug;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;

public abstract class GisFeatureRendererMulti
extends GisFeatureRenderer {
    private static boolean useDiscretization;
    private static double pixelMatch;
    private ArrayList<FeatureSet> featSetList;

    public static void setDiscretization(boolean b) {
        useDiscretization = b;
    }

    public static void setPixelMatch(double d) {
        pixelMatch = d;
    }

    @Override
    public abstract LatLonRect getPreferredArea();

    @Override
    protected abstract List<GisFeature> getFeatures();

    @Override
    protected abstract Projection getDataProjection();

    @Override
    public void setProjection(Projection project) {
        this.displayProject = project;
        if (this.featSetList == null) {
            return;
        }
        for (FeatureSet fs : this.featSetList) {
            fs.newProjection = true;
        }
    }

    public void createFeatureSet(double minDist) {
        FeatureSet fs = new FeatureSet(null, minDist);
        if (this.featSetList == null) {
            this.initFeatSetList();
        }
        this.featSetList.add(fs);
    }

    protected Iterator<Shape> iterator(Graphics2D g, AffineTransform normal2device) {
        long startTime = System.currentTimeMillis();
        if (this.featSetList == null) {
            this.initFeatSetList();
            assert (!this.featSetList.isEmpty());
        }
        FeatureSet fs = this.featSetList.get(0);
        if (this.featSetList.size() > 1) {
            double scale = 1.0;
            try {
                AffineTransform world2device = g.getTransform();
                AffineTransform world2normal = normal2device.createInverse();
                world2normal.concatenate(world2device);
                scale = Math.max(Math.abs(world2normal.getScaleX()), Math.abs(world2normal.getShearX()));
                if (Debug.isSet((String)"GisFeature/showTransform")) {
                    System.out.println("GisFeature/showTransform: " + world2normal + "\n scale = " + scale);
                }
            }
            catch (NoninvertibleTransformException e) {
                System.out.println(" GisRenderFeature: NoninvertibleTransformException on " + normal2device);
            }
            if (!this.displayProject.isLatLon()) {
                scale *= 111.0;
            }
            double minD = Double.MAX_VALUE;
            Iterator<FeatureSet> iterator = this.featSetList.iterator();
            while (iterator.hasNext()) {
                FeatureSet aFeatSetList;
                FeatureSet tryfs = aFeatSetList = iterator.next();
                double d = Math.abs(scale * tryfs.minDist - pixelMatch);
                if (!(d < minD)) continue;
                minD = d;
                fs = tryfs;
            }
            if (Debug.isSet((String)"GisFeature/MapResolution")) {
                System.out.println("GisFeature/MapResolution: scale = " + scale + " minDist = " + fs.minDist);
            }
        }
        if (fs.featureList == null) {
            fs.createFeatures();
        }
        if (!this.displayProject.equals(fs.project)) {
            fs.setProjection(this.displayProject);
        } else if (fs.newProjection && this.displayProject.isLatLon()) {
            fs.setProjection(this.displayProject);
        }
        fs.newProjection = false;
        if (Debug.isSet((String)"GisFeature/timing/getShapes")) {
            long tookTime = System.currentTimeMillis() - startTime;
            System.out.println("timing.getShapes: " + (double)tookTime * 0.001 + " seconds");
        }
        return fs.iterator();
    }

    private ArrayList<Shape> makeShapes(Iterator<GisFeature> featList) {
        ArrayList<Shape> shapeList = new ArrayList<Shape>();
        Projection dataProject = this.getDataProjection();
        if (Debug.isSet((String)"GisFeature/MapDraw")) {
            System.out.println("GisFeature/MapDraw: makeShapes with " + this.displayProject);
        }
        while (featList.hasNext()) {
            AbstractGisFeature feature = (AbstractGisFeature)featList.next();
            Shape shape = dataProject.isLatLon() ? feature.getProjectedShape(this.displayProject) : (dataProject == this.displayProject ? feature.getShape() : feature.getProjectedShape(dataProject, this.displayProject));
            shapeList.add(shape);
        }
        return shapeList;
    }

    private void initFeatSetList() {
        this.featSetList = new ArrayList();
        this.featSetList.add(new FeatureSet(this.getFeatures(), 0.0));
    }

    protected double getStats(Iterator featList) {
        int total_pts = 0;
        int total_parts = 0;
        int total_feats = 0;
        int cross_pts = 0;
        double avgD = 0.0;
        double minD = Double.MAX_VALUE;
        double maxD = -1.7976931348623157E308;
        Projection dataProject = this.getDataProjection();
        while (featList.hasNext()) {
            AbstractGisFeature feature = (AbstractGisFeature)featList.next();
            ++total_feats;
            for (GisPart gp : feature) {
                ++total_parts;
                double[] xx = gp.getX();
                double[] yy = gp.getY();
                int np = gp.getNumPoints();
                ProjectionPoint lastW = ProjectionPoint.create((double)xx[0], (double)yy[0]);
                for (int i = 1; i < np; ++i) {
                    ProjectionPoint thisW = ProjectionPoint.create((double)xx[i], (double)yy[i]);
                    if (!dataProject.crossSeam(thisW, lastW)) {
                        double dx = xx[i] - xx[i - 1];
                        double dy = yy[i] - yy[i - 1];
                        double dist = Math.sqrt(dx * dx + dy * dy);
                        ++total_pts;
                        avgD += dist;
                        minD = Math.min(minD, dist);
                        maxD = Math.max(maxD, dist);
                    } else {
                        ++cross_pts;
                    }
                    lastW = ProjectionPoint.create((double)xx[i], (double)yy[i]);
                }
            }
        }
        double d = avgD = total_pts == 0 ? 0.0 : avgD / (double)total_pts;
        if (Debug.isSet((String)"GisFeature/MapResolution")) {
            System.out.println("Map.resolution: total_feats = " + total_feats);
            System.out.println(" total_parts = " + total_parts);
            System.out.println(" total_pts = " + total_pts);
            System.out.println(" cross_pts = " + cross_pts);
            System.out.println(" avg distance = " + avgD);
            System.out.println(" min distance = " + minD);
            System.out.println(" max distance = " + maxD);
        }
        return avgD;
    }

    static {
        pixelMatch = 2.0;
    }

    static class FeatureMD
    extends AbstractGisFeature {
        private final ArrayList<GisPart> parts = new ArrayList();
        private int total_pts;
        private final double minDist;
        private double minDist2;

        FeatureMD(double minDist) {
            this.minDist = minDist;
            this.minDist2 = minDist * minDist;
        }

        void add(Part part) {
            this.total_pts += part.getNumPoints();
            this.parts.add(part);
        }

        Part newPart(int maxPts) {
            return new Part(maxPts);
        }

        private double discretize(double d) {
            if (!useDiscretization || this.minDist == 0.0) {
                return d;
            }
            return Math.rint(d / this.minDist) * this.minDist + this.minDist / 2.0;
        }

        @Override
        public Rectangle2D getBounds2D() {
            return null;
        }

        @Override
        public int getNumPoints() {
            return this.total_pts;
        }

        @Override
        public int getNumParts() {
            return this.parts.size();
        }

        @Override
        public Iterator<GisPart> iterator() {
            return this.parts.iterator();
        }

        class Part
        implements GisPart {
            private int size;
            private double[] wx;
            private double[] wy;

            Part(int maxPts) {
                this.wx = new double[maxPts];
                this.wy = new double[maxPts];
                this.size = 0;
                FeatureMD.this.minDist2 = FeatureMD.this.minDist * FeatureMD.this.minDist;
            }

            void set(double x, double y) {
                this.wx[this.size] = FeatureMD.this.discretize(x);
                this.wy[this.size] = FeatureMD.this.discretize(y);
                ++this.size;
            }

            private void setNoD(double x, double y) {
                this.wx[this.size] = x;
                this.wy[this.size] = y;
                ++this.size;
            }

            void setIfDistant(double x, double y) {
                double dy;
                double dx = (x = FeatureMD.this.discretize(x)) - this.wx[this.size - 1];
                double dist2 = dx * dx + (dy = (y = FeatureMD.this.discretize(y)) - this.wy[this.size - 1]) * dy;
                if (dist2 >= FeatureMD.this.minDist2) {
                    this.setNoD(x, y);
                }
            }

            void truncateArray() {
                double[] x = new double[this.size];
                double[] y = new double[this.size];
                for (int i = 0; i < this.size; ++i) {
                    x[i] = this.wx[i];
                    y[i] = this.wy[i];
                }
                this.wx = x;
                this.wy = y;
            }

            @Override
            public int getNumPoints() {
                return this.size;
            }

            @Override
            public double[] getX() {
                return this.wx;
            }

            @Override
            public double[] getY() {
                return this.wy;
            }
        }
    }

    private class FeatureSet
    implements Iterable<Shape> {
        List<GisFeature> featureList;
        double minDist;
        Projection project;
        ArrayList<Shape> shapeList;
        boolean newProjection = true;

        FeatureSet(List<GisFeature> featureList, double minDist) {
            this.featureList = featureList;
            this.minDist = minDist;
        }

        void setProjection(Projection project) {
            this.project = project;
            this.shapeList = GisFeatureRendererMulti.this.makeShapes(this.featureList.iterator());
        }

        @Override
        public Iterator<Shape> iterator() {
            return this.shapeList.iterator();
        }

        void createFeatures() {
            this.featureList = new ArrayList<GisFeature>();
            for (GisFeature o : GisFeatureRendererMulti.this.getFeatures()) {
                AbstractGisFeature feature = (AbstractGisFeature)o;
                FeatureMD featMD = new FeatureMD(this.minDist);
                for (GisPart gp : feature) {
                    FeatureMD.Part part = featMD.newPart(gp.getNumPoints());
                    int np = gp.getNumPoints();
                    double[] xx = gp.getX();
                    double[] yy = gp.getY();
                    part.set(xx[0], yy[0]);
                    for (int i = 1; i < np - 1; ++i) {
                        part.setIfDistant(xx[i], yy[i]);
                    }
                    if (part.getNumPoints() <= 1) continue;
                    part.set(xx[np - 1], yy[np - 1]);
                    part.truncateArray();
                    featMD.add(part);
                }
                if (GisFeatureRendererMulti.this.featSetList == null) {
                    GisFeatureRendererMulti.this.initFeatSetList();
                }
                if (featMD.getNumParts() <= 0) continue;
                this.featureList.add(featMD);
            }
            GisFeatureRendererMulti.this.getStats(this.featureList.iterator());
        }

        private void discretizeArray(double[] d, int n) {
            if (this.minDist == 0.0) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                d[i] = Math.rint(d[i] / this.minDist) * this.minDist + this.minDist / 2.0;
            }
        }
    }
}

