/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.gis.shapefile;

import java.io.InputStream;
import javax.swing.ImageIcon;
import ucar.ui.gis.MapBean;
import ucar.ui.gis.shapefile.EsriShapefileRenderer;
import ucar.ui.prefs.Debug;
import ucar.ui.util.Renderer;
import ucar.ui.util.Resource;
import ucar.ui.widget.BAMutil;

public class ShapeFileBean
extends MapBean {
    private final String name;
    private final String desc;
    private final String iconName;
    private final String shapefileName;
    private Renderer rend;

    public ShapeFileBean(String name, String desc, String iconName, String shapefileName) {
        this.name = name;
        this.desc = desc;
        this.iconName = iconName;
        this.shapefileName = shapefileName;
    }

    @Override
    public Renderer getRenderer() {
        if (this.rend == null) {
            this.fetchMap();
        }
        return this.rend;
    }

    private void fetchMap() {
        long startTime = System.currentTimeMillis();
        InputStream is = Resource.getFileResource((String)this.shapefileName);
        if (is == null) {
            System.err.println("ShapeFileBean read failed on resource " + this.shapefileName);
        } else {
            this.rend = EsriShapefileRenderer.factory(this.shapefileName, is);
        }
        if (Debug.isSet((String)"timing.readShapefile")) {
            long tookTime = System.currentTimeMillis() - startTime;
            System.out.println("timing.readShapefile: " + (double)tookTime * 0.001 + " seconds");
        }
    }

    @Override
    public ImageIcon getIcon() {
        return BAMutil.getIcon((String)this.iconName, (boolean)true);
    }

    @Override
    public String getActionName() {
        return this.name;
    }

    @Override
    public String getActionDesc() {
        return this.desc;
    }
}

