/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.gis.worldmap;

import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.ui.gis.AbstractGisFeature;
import ucar.ui.gis.GisFeature;
import ucar.ui.gis.GisFeatureRenderer;
import ucar.ui.gis.GisPart;
import ucar.ui.util.Resource;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.projection.LatLonProjection;

public class WorldMap
extends GisFeatureRenderer {
    private static final String WORLD_MAP = "/resources/ui/maps/cil_100km.mapr";
    private static final double SECS_PER_DEG = 3600.0;
    private static final boolean debugTime = false;
    private static WorldMapFeature worldMapFeature;
    private static ArrayList<GisFeature> gisList;
    private static ArrayList<GisPart> partList;
    private static int total_pts;
    private final Projection dataProjection;
    private final LatLonRect defaultLLBB = new LatLonRect(LatLonPoint.create((double)-180.0, (double)-90.0), 360.0, 180.0);

    private static boolean readWorldMap() {
        long secs = System.currentTimeMillis();
        try (InputStream is = Resource.getFileResource((String)WORLD_MAP);
             DataInputStream dis = new DataInputStream(is);){
            worldMapFeature = new WorldMapFeature();
            gisList = new ArrayList();
            gisList.add(worldMapFeature);
            partList = new ArrayList();
            try {
                while (true) {
                    int npts = dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    MapRun run = new MapRun(npts);
                    for (int i = 0; i < npts; ++i) {
                        run.wx[i] = (double)dis.readInt() / 3600.0;
                        run.wy[i] = (double)dis.readInt() / 3600.0;
                    }
                    partList.add(run);
                    total_pts += npts;
                }
            }
            catch (EOFException ex) {
            }
            catch (Exception ex) {
                System.err.println("WorldMap exception " + ex);
            }
        }
        catch (IOException e) {
            System.err.println("WorldMap read failed on resource /resources/ui/maps/cil_100km.mapr");
        }
        return true;
    }

    public static AbstractGisFeature getWorldMap() {
        if (worldMapFeature == null) {
            WorldMap.readWorldMap();
        }
        return worldMapFeature;
    }

    public WorldMap() {
        if (partList == null) {
            WorldMap.readWorldMap();
        }
        this.dataProjection = new LatLonProjection("Cylindrical Equidistant");
    }

    @Override
    public LatLonRect getPreferredArea() {
        return this.defaultLLBB;
    }

    @Override
    protected List<GisFeature> getFeatures() {
        return gisList;
    }

    @Override
    protected Projection getDataProjection() {
        return this.dataProjection;
    }

    private static class MapRun
    implements GisPart {
        int npts;
        double[] wx;
        double[] wy;

        MapRun(int npts) {
            this.npts = npts;
            this.wx = new double[npts];
            this.wy = new double[npts];
        }

        @Override
        public int getNumPoints() {
            return this.npts;
        }

        @Override
        public double[] getX() {
            return this.wx;
        }

        @Override
        public double[] getY() {
            return this.wy;
        }
    }

    private static class WorldMapFeature
    extends AbstractGisFeature {
        private WorldMapFeature() {
        }

        @Override
        public Rectangle2D getBounds2D() {
            return null;
        }

        @Override
        public int getNumPoints() {
            return total_pts;
        }

        @Override
        public int getNumParts() {
            return partList.size();
        }

        @Override
        public Iterator<GisPart> iterator() {
            return partList.iterator();
        }
    }
}

