/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.grib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class CdmIndexScan
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(CdmIndexScan.class);
    private final PreferencesExt prefs;
    private final BeanTable<IndexScanBean> indexBeanTable;
    private final JSplitPane split;
    private final TextHistoryPane dumpTA = new TextHistoryPane();
    private final TextHistoryPane infoTA = new TextHistoryPane();
    private final IndependentWindow infoWindow;
    private final AbstractButton filterButt;
    private Formatter scanInfo = new Formatter();
    private boolean filterSRC = true;
    private String topdir;

    public CdmIndexScan(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.indexBeanTable = new BeanTable(IndexScanBean.class, (PreferencesExt)prefs.node("IndexScanBeans"), false);
        this.indexBeanTable.addListSelectionListener(e -> this.setSelectedBean((IndexScanBean)this.indexBeanTable.getSelectedBean()));
        PopupMenu varPopup = new PopupMenu((JComponent)this.indexBeanTable.getJTable(), "Options");
        varPopup.addAction("Open Index File", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexScanBean ftb = (IndexScanBean)CdmIndexScan.this.indexBeanTable.getSelectedBean();
                if (ftb != null) {
                    CdmIndexScan.this.firePropertyChange("openIndexFile", null, ftb.path);
                }
            }
        });
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.split = new JSplitPane(0, false, (Component)this.indexBeanTable, (Component)this.dumpTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CdmIndexScan.this.filterSRC = (Boolean)this.getValue("state");
                String tooltip = CdmIndexScan.this.filterSRC ? "dont include SRC/MRUTC" : "include SRC/MRUTC";
                CdmIndexScan.this.filterButt.setToolTipText(tooltip);
            }
        };
        String tooltip = this.filterSRC ? "dont include type SRC/MRUTC" : "include SRC/MRUTC";
        BAMutil.setActionProperties((AbstractAction)filterAction, (String)"nj22/AddCoords", (String)tooltip, (boolean)true, (int)67, (int)-1);
        filterAction.putValue("state", this.filterSRC);
        this.filterButt = BAMutil.addActionToContainer((Container)buttPanel, (Action)filterAction);
        buttPanel.add(this.filterButt);
        AbstractAction infoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CdmIndexScan.this.infoTA.setText(CdmIndexScan.this.scanInfo.toString());
                CdmIndexScan.this.infoWindow.show();
            }
        };
        BAMutil.setActionProperties((AbstractAction)infoAction, (String)"Information", (String)"scan info", (boolean)false, (int)73, (int)-1);
        BAMutil.addActionToContainer((Container)buttPanel, (Action)infoAction);
        AbstractAction doitButt = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CdmIndexScan.this.infoTA.setText(CdmIndexScan.this.makeReport());
                CdmIndexScan.this.infoWindow.show();
            }
        };
        BAMutil.setActionProperties((AbstractAction)doitButt, (String)"alien", (String)"make report", (boolean)false, (int)67, (int)-1);
        BAMutil.addActionToContainer((Container)buttPanel, (Action)doitButt);
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.indexBeanTable.saveState(false);
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
    }

    public void clear() {
        this.indexBeanTable.setBeans(new ArrayList());
    }

    public boolean setScanDirectory(String dirName) {
        List<IndexScanBean> beans;
        this.clear();
        this.topdir = dirName;
        try {
            beans = this.scan(dirName);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.dumpTA.setText(e.getMessage());
            return false;
        }
        if (beans.isEmpty()) {
            this.dumpTA.setText("No .ncx4 files were found");
            return false;
        }
        this.indexBeanTable.setBeans(beans);
        return true;
    }

    private void setSelectedBean(IndexScanBean ftb) {
        if (ftb == null) {
            return;
        }
        this.dumpTA.setText(ftb.toString());
        this.dumpTA.gotoTop();
    }

    private List<IndexScanBean> scan(String topDir) throws IOException {
        ArrayList<IndexScanBean> result = new ArrayList<IndexScanBean>();
        File topFile = new File(topDir);
        if (!topFile.exists()) {
            this.dumpTA.appendLine(String.format("File %s does not exist", topDir));
            return result;
        }
        Formatter info = new Formatter();
        if (topFile.isDirectory()) {
            this.scanDirectory(topFile, result, info);
        } else {
            Accum accum = this.openCdmIndex(topFile.getPath(), result, info);
            info.format("%s%n", accum);
        }
        this.dumpTA.setText(info.toString());
        this.scanInfo = info;
        return result;
    }

    private String makeReport() {
        Formatter result = new Formatter();
        result.format("# %s%n", this.topdir);
        for (IndexScanBean bean : this.indexBeanTable.getBeans()) {
            result.format("%s%n", bean.report);
        }
        return result.toString();
    }

    public void scanDirectory(File dir, List<IndexScanBean> result, Formatter info) throws IOException {
        if (dir.getName().equals("exclude") || dir.getName().equals("problem")) {
            return;
        }
        File[] fila = dir.listFiles();
        if (fila == null) {
            return;
        }
        for (File f : fila) {
            if (f.isDirectory() || !f.getName().endsWith(".ncx4")) continue;
            Accum totalAccum = this.openCdmIndex(f.getPath(), result, info);
            info.format("%s%n", totalAccum);
        }
        for (File f : fila) {
            if (!f.isDirectory() || f.getName().equals("exclude")) continue;
            this.scanDirectory(f, result, info);
        }
    }

    public Accum openCdmIndex(String path, List<IndexScanBean> result, Formatter info) throws IOException {
        FeatureCollectionConfig config = new FeatureCollectionConfig();
        Accum totalAccum = new Accum();
        System.out.printf("%s%n", path);
        String relpath = path.substring(this.topdir.length());
        try (GribCollectionImmutable gc = GribCdmIndex.openCdmIndex((String)path, (FeatureCollectionConfig)config, (boolean)false, (Logger)logger);){
            if (gc == null) {
                info.format("Not a grib collection index file=%s%n", path);
                Accum accum = totalAccum;
                return accum;
            }
            info.format("%nGribCollection %s%n", path);
            for (GribCollectionImmutable.Dataset ds : gc.getDatasets()) {
                info.format(" Dataset %s%n", ds.getType());
                int groupno = 0;
                for (GribCollectionImmutable.GroupGC g : ds.getGroups()) {
                    if (g.getType() == GribCollectionImmutable.Type.Best || this.filterSRC && (g.getType() == GribCollectionImmutable.Type.SRC || g.getType() == GribCollectionImmutable.Type.MRUTC)) continue;
                    Formatter localInfo = new Formatter();
                    Formatter report = new Formatter();
                    localInfo.format(" %s%n", relpath);
                    if (groupno == 0) {
                        report.format("### %s%n", relpath);
                    }
                    Accum groupAccum = new Accum();
                    localInfo.format("  Group %s%n", g.getDescription());
                    report.format("  **%s** %sGroup %s%n", g.getType(), groupno == 0 ? "" : "***", g.getDescription());
                    for (GribCollectionImmutable.VariableIndex vi : g.getVariables()) {
                        localInfo.format("   %s%n", vi.toStringFrom());
                        groupAccum.add(vi);
                        totalAccum.add(vi);
                    }
                    info.format("  groupTotal %s%n", groupAccum);
                    localInfo.format("   groupAccum %s%n", groupAccum);
                    report.format("   %s%n", groupAccum);
                    result.add(new IndexScanBean(path, relpath, ds, g, groupno++, groupAccum, localInfo.toString(), report.toString()));
                }
            }
        }
        return totalAccum;
    }

    public static class Accum {
        int nrecords;
        int ndups;
        int nmissing;
        int rectMiss;

        void add(GribCollectionImmutable.VariableIndex v) {
            this.nrecords += v.getNrecords();
            this.ndups += v.getNdups();
            this.nmissing += v.getNmissing();
            this.rectMiss += v.getSize() - v.getNrecords();
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("Accum{nrecords=%d, ", this.nrecords);
            double fn = (double)this.nrecords / 100.0;
            f.format("ndups=%d (%3.1f %%), ", this.ndups, (double)this.ndups / fn);
            f.format("nmissing=%d (%3.1f %%), ", this.nmissing, (double)this.nmissing / fn);
            f.format("rectMiss=%d (%3.1f %%)}", this.rectMiss, (double)this.rectMiss / fn);
            return f.toString();
        }
    }

    public static class IndexScanBean {
        public String path;
        public String name;
        public Accum accum;
        public String info;
        public String report;
        public String time2D;
        public GribCollectionImmutable.Dataset ds;
        public int groupno;

        public IndexScanBean() {
        }

        public IndexScanBean(String path, String name, GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, int groupno, Accum accum, String info, String report) {
            this.path = path;
            this.name = name;
            this.accum = accum;
            this.ds = ds;
            this.groupno = groupno;
            this.info = info;
            this.report = report;
            TreeSet<String> typeSet = new TreeSet<String>();
            for (Coordinate coord : group.getCoordinates()) {
                if (coord.getType() != Coordinate.Type.time2D) continue;
                CoordinateTime2D c2d = (CoordinateTime2D)coord;
                if (c2d.isOrthogonal()) {
                    typeSet.add("orth");
                    continue;
                }
                if (c2d.isRegular()) {
                    typeSet.add("reg");
                    continue;
                }
                typeSet.add("time2D");
            }
            ArrayList types = new ArrayList(typeSet);
            this.time2D = String.join((CharSequence)",", types);
        }

        public String getName() {
            return this.name;
        }

        public int getNrecords() {
            return this.accum.nrecords;
        }

        public int getNdups() {
            return this.accum.ndups;
        }

        public float getNdupPct() {
            return this.accum.nrecords == 0 ? 0.0f : 100.0f * (float)this.accum.ndups / (float)this.accum.nrecords;
        }

        public int getNmissing() {
            return this.accum.nmissing;
        }

        public float getNmissingPct() {
            return this.accum.nrecords == 0 ? 0.0f : 100.0f * (float)this.accum.nmissing / (float)this.accum.nrecords;
        }

        public int getRectMissing() {
            return this.accum.rectMiss;
        }

        public float getRectMissingPct() {
            return this.accum.nrecords == 0 ? 0.0f : 100.0f * (float)this.accum.rectMiss / (float)this.accum.nrecords;
        }

        public String getType() {
            return this.ds.getType().toString();
        }

        public int getGroupNo() {
            return this.groupno;
        }

        public String getTime2D() {
            return this.time2D;
        }

        public String toString() {
            return this.info;
        }
    }
}

