/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.grib;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formatter;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import ucar.ui.OpPanel;
import ucar.ui.grib.Grib1CollectionPanel;
import ucar.ui.widget.BAMutil;
import ucar.util.prefs.PreferencesExt;

public class Grib1CollectionOpPanel
extends OpPanel {
    private final Grib1CollectionPanel gribTable;

    public Grib1CollectionOpPanel(PreferencesExt p) {
        super(p, "collection:", true, false);
        this.gribTable = new Grib1CollectionPanel(this.buttPanel, this.prefs);
        this.add((Component)this.gribTable, "Center");
        AbstractButton showButt = BAMutil.makeButtcon((String)"Information", (String)"Show Collection", (boolean)false);
        showButt.addActionListener(e -> {
            Formatter f = new Formatter();
            this.gribTable.showCollection(f);
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(showButt);
        AbstractButton writeButton = BAMutil.makeButtcon((String)"nj22/Netcdf", (String)"Write index", (boolean)false);
        writeButton.addActionListener(e -> {
            Formatter f = new Formatter();
            try {
                if (!this.gribTable.writeIndex(f)) {
                    return;
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(writeButton);
    }

    public void setCollection(String collection) {
        if (this.process(collection)) {
            this.cb.addItem((Object)collection);
        }
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            this.gribTable.setCollection(command);
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset cannot open " + command + "\n" + ioe.getMessage());
            err = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        this.gribTable.closeOpenFiles();
    }

    @Override
    public void save() {
        this.gribTable.save();
        super.save();
    }
}

