/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.grib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTableReader;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.internal.wmo.CommonCodeTable;
import ucar.nc2.internal.wmo.Util;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.IO;
import ucar.ui.dialog.Grib1TableCompareDialog;
import ucar.ui.dialog.Grib1TableDialog;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class Grib1TablesViewer
extends JPanel {
    private final PreferencesExt prefs;
    private final BeanTable<TableBean> codeTable;
    private final BeanTable<EntryBean> entryTable;
    private final JSplitPane split;
    private final TextHistoryPane infoTA;
    private final IndependentWindow infoWindow;
    private Grib1TableDialog showTableDialog;
    private Grib1TableCompareDialog compareTableDialog;

    public Grib1TablesViewer(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.codeTable = new BeanTable(TableBean.class, (PreferencesExt)prefs.node("CodeTableBean"), false);
        this.codeTable.addListSelectionListener(e -> {
            TableBean csb = (TableBean)this.codeTable.getSelectedBean();
            if (csb != null) {
                this.setEntries(csb.table);
            }
        });
        PopupMenu varPopup = new PopupMenu((JComponent)this.codeTable.getJTable(), "Options");
        varPopup.addAction("Show File contents", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBean bean = (TableBean)Grib1TablesViewer.this.codeTable.getSelectedBean();
                if (bean != null) {
                    Grib1TablesViewer.this.showFile(bean);
                }
            }
        });
        varPopup.addAction("Compare to default WMO table", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBean bean = (TableBean)Grib1TablesViewer.this.codeTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                Grib1TablesViewer.this.initTableDialog();
                Grib1ParamTableReader wmo = new Grib1ParamTables().getParameterTable(0, 0, bean.getVersion());
                if (wmo == null) {
                    Grib1TablesViewer.this.infoTA.setText("Cant find WMO version " + bean.getVersion());
                    Grib1TablesViewer.this.infoWindow.show();
                    return;
                }
                Grib1TablesViewer.this.compareTableDialog.setTable1(new TableBean(wmo));
                Grib1TablesViewer.this.compareTableDialog.setTable2(bean);
                Grib1TablesViewer.this.compareTableDialog.setVisible(true);
            }
        });
        varPopup.addAction("Compare two tables", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBean bean = (TableBean)Grib1TablesViewer.this.codeTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                Grib1TablesViewer.this.initTableDialog();
                List list = Grib1TablesViewer.this.codeTable.getSelectedBeans();
                if (list.size() == 2) {
                    TableBean bean1 = (TableBean)list.get(0);
                    TableBean bean2 = (TableBean)list.get(1);
                    Grib1TablesViewer.this.compareTableDialog.setTable1(bean1);
                    Grib1TablesViewer.this.compareTableDialog.setTable2(bean2);
                    Grib1TablesViewer.this.compareTableDialog.setVisible(true);
                }
            }
        });
        varPopup.addAction("Compare to all non-local tables", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBean bean = (TableBean)Grib1TablesViewer.this.codeTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                Grib1TablesViewer.this.initTableDialog();
                Grib1TablesViewer.this.compareTableDialog.setTable1(bean);
                Grib1TablesViewer.this.compareTableDialog.setTable2(null);
                Grib1TablesViewer.this.compareTableDialog.setVisible(true);
            }
        });
        this.entryTable = new BeanTable(EntryBean.class, (PreferencesExt)prefs.node("EntryBean"), false);
        varPopup = new PopupMenu((JComponent)this.entryTable.getJTable(), "Options");
        varPopup.addAction("Show in all tables", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryBean bean = (EntryBean)Grib1TablesViewer.this.entryTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                Grib1TablesViewer.this.showAll(bean);
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, (Component)this.codeTable, (Component)this.entryTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        AbstractButton infoButton = BAMutil.makeButtcon((String)"Information", (String)"Show Table Used", (boolean)false);
        infoButton.addActionListener(e -> {
            if (this.showTableDialog == null) {
                this.showTableDialog = new Grib1TableDialog((Frame)null);
                this.showTableDialog.pack();
            }
            this.showTableDialog.setVisible(true);
        });
        buttPanel.add(infoButton);
        try {
            List tables = Grib1ParamTables.getStandardParameterTables();
            ArrayList<TableBean> beans = new ArrayList<TableBean>(tables.size());
            for (Grib1ParamTableReader t : tables) {
                beans.add(new TableBean(t));
            }
            this.codeTable.setBeans(beans);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void initTableDialog() {
        if (this.compareTableDialog == null) {
            this.compareTableDialog = new Grib1TableCompareDialog((Frame)null);
            this.compareTableDialog.pack();
            this.compareTableDialog.addPropertyChangeListener("OK", evt -> this.compareTables((Grib1TableCompareDialog.Data)evt.getNewValue()));
        }
    }

    public void save() {
        this.codeTable.saveState(false);
        this.entryTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void setTable(String filename) {
        Grib1ParamTableReader table = new Grib1ParamTableReader(filename);
        TableBean bean = new TableBean(table);
        this.codeTable.addBean((Object)bean);
        this.codeTable.setSelectedBean((Object)bean);
    }

    private void setEntries(Grib1ParamTableReader table) {
        Map map = table.getParameters();
        if (map == null) {
            return;
        }
        ArrayList params = new ArrayList(map.keySet());
        Collections.sort(params);
        ArrayList<EntryBean> beans = new ArrayList<EntryBean>(params.size());
        for (Integer key : params) {
            beans.add(new EntryBean((Grib1Parameter)map.get(key)));
        }
        this.entryTable.setBeans(beans);
    }

    private void showFile(TableBean bean) {
        this.infoTA.setText("Table:" + bean.getPath() + "\n");
        try (InputStream is = GribResourceReader.getInputStream((String)bean.getPath());){
            this.infoTA.appendLine(IO.readContents((InputStream)is));
            this.infoWindow.setVisible(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void showAll(EntryBean ebean) {
        Formatter f = new Formatter();
        this.infoTA.setText("Entry:" + ebean.getNumber() + "\n");
        for (Object bean : this.codeTable.getBeans()) {
            TableBean tbean = (TableBean)bean;
            Grib1Parameter p = tbean.table.getLocalParameter(ebean.getNumber());
            if (p == null) continue;
            f.format(" %s from %s (%d)%n", p, tbean.table.getName(), tbean.table.getParameters().hashCode());
        }
        this.infoTA.appendLine(f.toString());
        this.infoWindow.setVisible(true);
    }

    private void compareTables(Grib1TableCompareDialog.Data data) {
        Formatter f = new Formatter();
        if (data.table2bean == null) {
            this.compareAll(data.table1bean.table, data, f);
        } else {
            this.compare(data.table1bean.table, data.table2bean.table, data, f);
        }
        this.infoTA.setText(f.toString());
        this.infoTA.gotoTop();
        this.infoWindow.show();
    }

    private void compare(Grib1ParamTableReader t1, Grib1ParamTableReader t2, Grib1TableCompareDialog.Data data, Formatter out) {
        Grib1Parameter d2;
        Grib1Parameter d1;
        out.format("Compare%n %s%n %s%n", t1.toString(), t2.toString());
        Map h1 = t1.getParameters();
        Map h2 = t2.getParameters();
        ArrayList keys = new ArrayList(h1.keySet());
        Collections.sort(keys);
        for (Integer key : keys) {
            String cu2;
            String cu1;
            d1 = (Grib1Parameter)h1.get(key);
            d2 = (Grib1Parameter)h2.get(key);
            if (d2 == null) {
                if (!data.showMissing) continue;
                out.format("**No key %s (%s) in second table%n", key, d1);
                continue;
            }
            if (data.compareDesc && !this.equiv(d1.getDescription(), d2.getDescription())) {
                out.format(" %s desc%n   %s%n   %s%n", d1.getNumber(), d1.getDescription(), d2.getDescription());
            }
            if (data.compareNames && !this.equiv(d1.getName(), d2.getName())) {
                out.format(" %d name%n   %s%n   %s%n", d1.getNumber(), d1.getName(), d2.getName());
            }
            if (data.compareUnits && !this.equiv(d1.getUnit(), d2.getUnit())) {
                out.format(" %s units%n   %s%n   %s%n", d1.getNumber(), d1.getUnit(), d2.getUnit());
            }
            if (data.cleanUnits && !this.equiv(cu1 = Util.cleanUnit((String)d1.getUnit()), cu2 = Util.cleanUnit((String)d2.getUnit()))) {
                out.format(" %s cleanUnits%n   %s%n   %s%n", d1.getNumber(), cu1, cu2);
            }
            if (!data.udunits) continue;
            cu1 = Util.cleanUnit((String)d1.getUnit());
            cu2 = Util.cleanUnit((String)d2.getUnit());
            try {
                SimpleUnit su1 = SimpleUnit.factoryWithExceptions((String)cu1);
                if (su1.isCompatible(cu2)) continue;
                out.format(" %s udunits%n   %s%n   %s%n", d1.getNumber(), cu1, cu2);
            }
            catch (Exception e) {
                out.format(" %s udunits%n   cant parse = %s%n   %s%n", d1.getNumber(), cu1, cu2);
            }
        }
        if (data.showMissing) {
            out.format("%n***Check if entries are missing in first table%n", new Object[0]);
            keys = new ArrayList(h2.keySet());
            Collections.sort(keys);
            for (Integer key : keys) {
                d1 = (Grib1Parameter)h1.get(key);
                d2 = (Grib1Parameter)h2.get(key);
                if (d1 != null) continue;
                out.format("**No key %s (%s) in first table%n", key, d2);
            }
        }
    }

    private boolean equiv(String org1, String org2) {
        if (org1 == org2) {
            return true;
        }
        if (org1 == null) {
            return false;
        }
        if (org2 == null) {
            return false;
        }
        return org1.equalsIgnoreCase(org2);
    }

    private void compareAll(Grib1ParamTableReader t1, Grib1TableCompareDialog.Data data, Formatter out) {
        out.format("Compare All non-local Tables%s%n", t1.toString());
        Map h1 = t1.getParameters();
        ArrayList keys = new ArrayList(h1.keySet());
        Collections.sort(keys);
        for (Integer key : keys) {
            Grib1Parameter d1 = (Grib1Parameter)h1.get(key);
            out.format("%n--- %s%n", d1);
            for (Object bean : this.codeTable.getBeans()) {
                Grib1Parameter d2;
                TableBean tbean = (TableBean)bean;
                if (tbean.getVersion() > 127 || (d2 = tbean.table.getLocalParameter(d1.getNumber())) == null) continue;
                boolean descDiff = data.compareDesc && !this.equiv(d1.getDescription(), d2.getDescription());
                boolean namesDiff = data.compareNames && !this.equiv(d1.getName(), d2.getName());
                boolean unitsDiff = data.compareUnits && !this.equiv(d1.getUnit(), d2.getUnit());
                boolean cunitsDiff = data.cleanUnits && !this.equiv(Util.cleanUnit((String)d1.getUnit()), Util.cleanUnit((String)d2.getUnit()));
                boolean udunitsDiff = false;
                if (data.udunits) {
                    String cu1 = Util.cleanUnit((String)d1.getUnit());
                    String cu2 = Util.cleanUnit((String)d2.getUnit());
                    try {
                        SimpleUnit su1 = SimpleUnit.factoryWithExceptions((String)cu1);
                        udunitsDiff = !su1.isCompatible(cu2);
                    }
                    catch (Exception e) {
                        udunitsDiff = false;
                    }
                }
                if (descDiff) {
                    out.format("    desc=%s from %s%n", d2.getDescription(), tbean.table.getPath());
                }
                if (namesDiff) {
                    out.format("    name=%s from %s%n", d2.getName(), tbean.table.getPath());
                }
                if (!unitsDiff && !cunitsDiff && !udunitsDiff) continue;
                out.format("    units=%s from %s%n", d2.getUnit(), tbean.table.getPath());
            }
        }
    }

    public static class EntryBean {
        Grib1Parameter param;

        public EntryBean() {
        }

        public EntryBean(Grib1Parameter param) {
            this.param = param;
        }

        public String getName() {
            return this.param.getName();
        }

        public String getCFname() {
            return this.param.getCFname();
        }

        public String getWMOdesc() {
            Grib1ParamTableReader wmo = Grib1ParamTables.getDefaultWmoTable();
            Grib1Parameter p = wmo.getParameter(this.param.getNumber());
            return p == null ? "" : p.getDescription();
        }

        public String getDescription() {
            return this.param.getDescription();
        }

        public String getUnit() {
            return this.param.getUnit();
        }

        public String getCleanUnit() {
            return Util.cleanUnit((String)this.param.getUnit());
        }

        public String getUdunit() {
            String cu = Util.cleanUnit((String)this.param.getUnit());
            try {
                SimpleUnit su1 = SimpleUnit.factoryWithExceptions((String)cu);
                return su1.isUnknownUnit() ? "UNKNOWN" : su1.toString();
            }
            catch (Exception e) {
                return "FAIL " + e.getMessage();
            }
        }

        public int getNumber() {
            return this.param.getNumber();
        }
    }

    public static class TableBean
    implements Comparable<TableBean> {
        Grib1ParamTableReader table;

        public TableBean() {
        }

        public TableBean(Grib1ParamTableReader table) {
            this.table = table;
        }

        public int getCenter_id() {
            return this.table.getCenter_id();
        }

        public String getCenter() {
            return CommonCodeTable.getCenterName((int)this.table.getCenter_id(), (int)1);
        }

        public String getSubCenter() {
            return Grib1Customizer.getSubCenterNameStatic((int)this.table.getCenter_id(), (int)this.table.getSubcenter_id());
        }

        public int getSubcenter_id() {
            return this.table.getSubcenter_id();
        }

        public int getVersion() {
            return this.table.getVersion();
        }

        public String getPath() {
            return this.table.getPath();
        }

        public String getName() {
            return this.table.getName();
        }

        public int getKey() {
            return this.table.getKey();
        }

        @Override
        public int compareTo(TableBean o) {
            int ret = this.getCenter_id() - o.getCenter_id();
            if (ret == 0) {
                ret = this.getSubcenter_id() - o.getSubcenter_id();
            }
            if (ret == 0) {
                ret = this.getVersion() - o.getVersion();
            }
            return ret;
        }
    }
}

