/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.grib;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formatter;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import ucar.ui.OpPanel;
import ucar.ui.ToolsUI;
import ucar.ui.grib.GribFilesPanel;
import ucar.ui.widget.BAMutil;
import ucar.util.prefs.PreferencesExt;

public class GribFilesOpPanel
extends OpPanel {
    private final GribFilesPanel gribTable;

    public GribFilesOpPanel(PreferencesExt p) {
        super(p, "collection:", true, false);
        this.gribTable = new GribFilesPanel(this.prefs);
        this.add((Component)this.gribTable, "Center");
        this.gribTable.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("openGrib1Collection")) {
                String filename = (String)e.getNewValue();
                ToolsUI.getToolsUI().openGrib1Collection(filename);
            }
        });
        AbstractButton showButt = BAMutil.makeButtcon((String)"Information", (String)"Show Collection", (boolean)false);
        showButt.addActionListener(e -> {
            Formatter f = new Formatter();
            this.gribTable.showCollection(f);
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(showButt);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            this.gribTable.setCollection(command);
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset cannot open " + command + "\n" + ioe.getMessage());
            err = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
    }

    @Override
    public void save() {
        this.gribTable.save();
        super.save();
    }
}

