/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.grib;

import com.google.common.base.MoreObjects;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.util.StringUtil2;
import ucar.util.prefs.PreferencesExt;

public class GribRewritePanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(GribRewritePanel.class);
    private final PreferencesExt prefs;
    private final BeanTable<FileBean> ftTable;
    private final JSplitPane split;
    private final TextHistoryPane dumpTA;
    private final IndependentWindow infoWindow;
    private static final boolean debug = true;

    public GribRewritePanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.ftTable = new BeanTable(FileBean.class, (PreferencesExt)prefs.node("FeatureDatasetBeans"), false);
        AbstractAction calcAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GribRewritePanel.this.calcAverage();
            }
        };
        BAMutil.setActionProperties((AbstractAction)calcAction, (String)"nj22/Dataset", (String)"calc storage", (boolean)false, (int)67, (int)-1);
        BAMutil.addActionToContainer((Container)buttPanel, (Action)calcAction);
        PopupMenu varPopup = new PopupMenu((JComponent)this.ftTable.getJTable(), "Options");
        varPopup.addAction("Open as NetcdfFile", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBean ftb = (FileBean)GribRewritePanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                GribRewritePanel.this.firePropertyChange("openNetcdfFile", null, ftb.getPath());
            }
        });
        varPopup.addAction("Open as GridDataset", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBean ftb = (FileBean)GribRewritePanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                GribRewritePanel.this.firePropertyChange("openGridDataset", null, ftb.getPath());
            }
        });
        varPopup.addAction("Open in Grib2Data", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBean ftb = (FileBean)GribRewritePanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                GribRewritePanel.this.firePropertyChange("openGrib2Data", null, ftb.getPath());
            }
        });
        varPopup.addAction("Open in Grib1Data", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBean ftb = (FileBean)GribRewritePanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                GribRewritePanel.this.firePropertyChange("openGrib1Data", null, ftb.getPath());
            }
        });
        TextHistoryPane infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.dumpTA = new TextHistoryPane();
        this.split = new JSplitPane(0, false, (Component)this.ftTable, (Component)this.dumpTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.ftTable.saveState(false);
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
    }

    public void clear() {
        this.ftTable.setBeans(new ArrayList());
    }

    public boolean setScanDirectory(String dirName) {
        this.clear();
        Formatter errlog = new Formatter();
        List<FileBean> beans = this.scan(dirName, errlog);
        if (beans.isEmpty()) {
            this.dumpTA.setText(errlog.toString());
            return false;
        }
        this.ftTable.setBeans(beans);
        return true;
    }

    private void setSelectedFeatureDataset(FileBean ftb) {
        this.dumpTA.setText(ftb.toString());
        this.dumpTA.gotoTop();
    }

    private void calcAverage() {
        Formatter f = new Formatter();
        this.calcAverage(null, f);
        this.calcAverage("grib1", f);
        this.calcAverage("grib2", f);
        this.dumpTA.setText(f.toString());
        this.dumpTA.gotoTop();
    }

    private void calcAverage(String what, Formatter f) {
        double totalRecords = 0.0;
        List beans = this.ftTable.getBeans();
        for (FileBean bean : beans) {
            if (bean.getNdups() > 0 || what != null && !bean.getPath().contains(what)) continue;
            totalRecords += (double)bean.getNrecords();
        }
        if (what != null) {
            f.format("%n%s%n", what);
        }
        f.format("Total # grib records = %f%n", totalRecords);
    }

    public List<FileBean> scan(String top, Formatter errlog) {
        ArrayList<FileBean> result = new ArrayList<FileBean>();
        File topFile = new File(top);
        if (!topFile.exists()) {
            errlog.format("File %s does not exist", top);
            return result;
        }
        if (topFile.isDirectory()) {
            this.scanDirectory(topFile, false, result, errlog);
        } else {
            FileBean fdb = null;
            try {
                fdb = new FileBean(topFile);
            }
            catch (IOException e) {
                System.out.printf("FAIL, skip %s%n", topFile.getPath());
            }
            result.add(fdb);
        }
        return result;
    }

    private void scanDirectory(File dir, boolean subdirs, List<FileBean> result, Formatter errlog) {
        if (dir.getName().equals("exclude") || dir.getName().equals("problem")) {
            return;
        }
        File[] gribFilesInDir = dir.listFiles(new FileFilterFromSuffixes("grib1 grib2"));
        if (gribFilesInDir == null) {
            throw new RuntimeException(String.format("Either an I/O error occurred, or \"%s\" is not a directory.", dir));
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File gribFile : gribFilesInDir) {
            if (gribFile.isDirectory()) continue;
            files.add(gribFile);
        }
        if (!files.isEmpty()) {
            Collections.sort(files);
            ArrayList files2 = new ArrayList(files);
            File prev = null;
            for (File f : files) {
                String name = f.getName();
                String stem = this.stem(name);
                if (prev != null && name.endsWith(".ncml") && (prev.getName().equals(stem) || prev.getName().equals(stem + ".grib2"))) {
                    files2.remove(prev);
                }
                prev = f;
            }
            for (File f : files2) {
                try {
                    result.add(new FileBean(f));
                }
                catch (IOException e) {
                    System.out.printf("FAIL, skip %s%n", f.getPath());
                }
            }
        }
        if (subdirs) {
            for (File f : dir.listFiles()) {
                if (!f.isDirectory() || f.getName().equals("exclude")) continue;
                this.scanDirectory(f, subdirs, result, errlog);
            }
        }
    }

    private String stem(String name) {
        int pos = name.lastIndexOf(46);
        return pos > 0 ? name.substring(0, pos) : name;
    }

    public static class FileBean {
        private File f;
        String fileType;
        int nrecords;
        int nvars;
        int ndups;

        public FileBean() {
        }

        public FileBean(File f) throws IOException {
            this.f = f;
            System.out.printf(" fileScan=%s%n", this.getPath());
            try (NetcdfDataset ncd = NetcdfDatasets.openDataset((String)this.getPath());){
                this.fileType = ncd.getFileTypeId();
                this.countGribData2D(f);
            }
        }

        public String getPath() {
            String p = this.f.getPath();
            return StringUtil2.replace((String)p, (String)"\\", (String)"/");
        }

        public String getFileType() {
            return this.fileType;
        }

        public double getGribSizeM() {
            return (double)this.f.length() / 1000.0 / 1000.0;
        }

        public int getNrecords() {
            return this.nrecords;
        }

        public int getNvars() {
            return this.nvars;
        }

        public int getNdups() {
            return this.ndups;
        }

        public void countGribData2D(File f) throws IOException {
            String indexFilename = f.getPath() + ".ncx4";
            FeatureCollectionConfig config = new FeatureCollectionConfig();
            try (GribCollectionImmutable gc = GribCdmIndex.openCdmIndex((String)indexFilename, (FeatureCollectionConfig)config, (boolean)false, (Logger)logger);){
                if (gc == null) {
                    throw new IOException("Not a grib collection index file");
                }
                for (GribCollectionImmutable.Dataset ds : gc.getDatasets()) {
                    for (GribCollectionImmutable.GroupGC group : ds.getGroups()) {
                        for (GribCollectionImmutable.VariableIndex vi : group.getVariables()) {
                            ++this.nvars;
                        }
                    }
                }
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("f", (Object)this.f).add("fileType", (Object)this.fileType).add("nrecords", this.nrecords).add("nvars", this.nvars).add("ndups", this.ndups).toString();
        }
    }

    public static class FileFilterFromSuffixes
    implements FileFilter {
        String[] suffixes;

        public FileFilterFromSuffixes(String suffixes) {
            this.suffixes = suffixes.split(" ");
        }

        @Override
        public boolean accept(File file) {
            for (String s : this.suffixes) {
                if (!file.getPath().endsWith(s)) continue;
                return true;
            }
            return false;
        }
    }
}

