/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.grib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.nc2.grib.grib2.table.WmoTemplateTables;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class GribWmoTemplatesPanel
extends JPanel {
    private final PreferencesExt prefs;
    private final BeanTable<TemplateBean> codeTable;
    private final BeanTable<EntryBean> entryTable;
    private final JSplitPane split;
    private final TextHistoryPane compareTA;
    private final IndependentWindow infoWindow;

    public GribWmoTemplatesPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.codeTable = new BeanTable(TemplateBean.class, (PreferencesExt)prefs.node("CodeTableBean"), false);
        this.codeTable.addListSelectionListener(e -> {
            TemplateBean csb = (TemplateBean)this.codeTable.getSelectedBean();
            this.setEntries(csb.template);
        });
        PopupMenu varPopup = new PopupMenu((JComponent)this.codeTable.getJTable(), "Options");
        varPopup.addAction("Show table", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter out = new Formatter();
                TemplateBean csb = (TemplateBean)GribWmoTemplatesPanel.this.codeTable.getSelectedBean();
                csb.showTable(out);
                GribWmoTemplatesPanel.this.compareTA.setText(out.toString());
                GribWmoTemplatesPanel.this.compareTA.gotoTop();
                GribWmoTemplatesPanel.this.infoWindow.setVisible(true);
            }
        });
        this.entryTable = new BeanTable(EntryBean.class, (PreferencesExt)prefs.node("EntryBean"), false);
        this.compareTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.compareTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, (Component)this.codeTable, (Component)this.entryTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        this.setTable(WmoTemplateTables.standard);
    }

    public void save() {
        this.codeTable.saveState(false);
        this.entryTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void setTable(WmoTemplateTables.Version v) {
        try {
            WmoTemplateTables tables = WmoTemplateTables.getInstance();
            ArrayList<TemplateBean> dds = new ArrayList<TemplateBean>();
            for (WmoTemplateTables.TemplateTable templateTable : tables.getTemplateTables()) {
                dds.add(new TemplateBean(templateTable));
            }
            this.codeTable.setBeans(dds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEntries(WmoTemplateTables.TemplateTable template) {
        ArrayList<EntryBean> beans = new ArrayList<EntryBean>();
        for (WmoTemplateTables.Field d : template.getFlds()) {
            beans.add(new EntryBean(d));
        }
        this.entryTable.setBeans(beans);
    }

    public static class EntryBean {
        WmoTemplateTables.Field te;

        public EntryBean() {
        }

        public EntryBean(WmoTemplateTables.Field te) {
            this.te = te;
        }

        public String getOctet() {
            return this.te.getOctet();
        }

        public String getContent() {
            return this.te.getContent();
        }

        public int getNbytes() {
            return this.te.getNbytes();
        }

        public int getStart() {
            return this.te.getStart();
        }

        public String getStatus() {
            return this.te.getStatus();
        }

        public String getNotes() {
            return this.te.getNote();
        }
    }

    public class TemplateBean {
        WmoTemplateTables.TemplateTable template;

        public TemplateBean() {
        }

        public TemplateBean(WmoTemplateTables.TemplateTable template) {
            this.template = template;
        }

        public String getName() {
            return this.template.getName();
        }

        public String getDescription() {
            return this.template.getDesc();
        }

        public int getM1() {
            return this.template.getM1();
        }

        public int getM2() {
            return this.template.getM2();
        }

        void showTable(Formatter f) {
            f.format("Template %s (%s)%n", this.template.getName(), this.template.getDesc());
            for (WmoTemplateTables.Field entry : this.template.getFlds()) {
                f.format("  %6s (%s): %s", entry.getOctet(), entry.getNote(), entry.getContent());
                if (entry.getNote() != null) {
                    f.format(" - %s", entry.getNote());
                }
                f.format("%n", new Object[0]);
            }
        }
    }
}

